/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.projectWizard;

import com.intellij.CommonBundle;
import com.intellij.ide.actions.OpenProjectFileChooserDescriptor;
import com.intellij.ide.wizard.StepAdapter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileElement;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.TaskInfo;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeModelAdapter;
import com.intellij.util.ui.tree.TreeUtil;
import com.jetbrains.cidr.cpp.CLionCMakeBundle;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.projectWizard.CLionProjectWizardUtils;
import com.jetbrains.cidr.cpp.cmake.projectWizard.generators.settings.CMakeCPPProjectSettings;
import com.jetbrains.cidr.cpp.cmake.projectWizard.generators.settings.CMakeCProjectSettings;
import com.jetbrains.cidr.cpp.cmake.projectWizard.generators.settings.CMakeProjectSettings;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cmake.psi.CMakeArgumentManipulator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CMakeCreateListsStepAdapter
extends StepAdapter
implements Disposable {
    private static final String SPLITTER_TOP_DIMENSION_KEY = "CreateCMakeListWizard.topPanel";
    private static final String SPLITTER_BOTTOM_DIMENSION_KEY = "CreateCMakeListWizard.bottomPanel";
    private static final String SPLITTER_PROPORTION_KEY = "CreateCMakeListWizard.splitterProportion";
    private static final float SPLITTER_DEFAULT_PROPORTION = 0.7f;
    public static final String INCLUDE_DIRECTORY_NAME = "include";
    private final FileChooserDescriptor myIconProvider;
    private final Splitter mySplitter;
    private final JPanel myProgressPanel;
    private final JProgressBar myProgressBar;
    private final ProgressIndicatorBase myProgressIndicator;
    private final JLabel myTreeLabel;
    private final Runnable myValidateCallback;
    private final CheckboxTree myTree;
    private final CheckboxTree myIncludeDirTree;
    private VirtualFile myProjectDir;
    private boolean myScanFinish;

    public CMakeCreateListsStepAdapter(@NotNull Disposable parent, @NotNull Runnable validateCallback) {
        if (parent == null) {
            CMakeCreateListsStepAdapter.$$$reportNull$$$0(0);
        }
        if (validateCallback == null) {
            CMakeCreateListsStepAdapter.$$$reportNull$$$0(1);
        }
        this.myIconProvider = new OpenProjectFileChooserDescriptor(true);
        this.mySplitter = new JBSplitter(true, SPLITTER_PROPORTION_KEY, 0.7f);
        this.myProgressPanel = new JPanel(new GridBagLayout());
        this.myProgressBar = new JProgressBar();
        this.myProgressIndicator = new MyProgressIndicator();
        this.myTreeLabel = new JLabel(CLionCMakeBundle.message("cmake.create.lists.select.files", new Object[0]));
        this.myValidateCallback = validateCallback;
        Disposer.register((Disposable)parent, (Disposable)this);
        GridBag gbc = new GridBag().setDefaultAnchor(17).setDefaultFill(2).setDefaultWeightX(1.0);
        JPanel topPanel = new JPanel(new GridBagLayout());
        this.myProgressPanel.add((Component)new JLabel(CLionCMakeBundle.message("cmake.create.lists.scanning.folders", new Object[0])), gbc.nextLine().next().weightx(0.0));
        this.myProgressPanel.add((Component)this.myProgressBar, gbc.next());
        this.myProgressPanel.setVisible(false);
        gbc.nextLine().insets.bottom = 5;
        topPanel.add((Component)this.myProgressPanel, gbc);
        gbc.reset();
        topPanel.add((Component)this.myTreeLabel, gbc.nextLine());
        this.myTree = new CheckboxTree((CheckboxTree.CheckboxTreeCellRenderer)new MyTreeCellRenderer(true), new CheckedTreeNode(), new CheckboxTreeBase.CheckPolicy(true, true, true, false));
        this.myTree.getSelectionModel().setSelectionMode(4);
        this.myTree.getEmptyText().setText(CommonBundle.getLoadingTreeNodeText());
        topPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myTree), gbc.nextLine().weighty(1.0).fillCell());
        JPanel bottomPanel = new JPanel(new GridBagLayout());
        gbc.reset();
        JLabel includeDirTreeLabel = new JLabel(CLionCMakeBundle.message("cmake.create.lists.user.include.directories", new Object[0]));
        bottomPanel.add((Component)includeDirTreeLabel, gbc.nextLine());
        this.myIncludeDirTree = new CheckboxTree((CheckboxTree.CheckboxTreeCellRenderer)new MyTreeCellRenderer(false), new CheckedTreeNode(), new CheckboxTreeBase.CheckPolicy(false, false, false, false));
        this.myIncludeDirTree.getSelectionModel().setSelectionMode(4);
        this.myIncludeDirTree.getEmptyText().setText(CommonBundle.getLoadingTreeNodeText());
        this.myIncludeDirTree.setModel((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
        bottomPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myIncludeDirTree), gbc.nextLine().weighty(1.0).fillCell());
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.mySplitter.setFirstComponent((JComponent)topPanel);
        this.mySplitter.setSecondComponent((JComponent)bottomPanel);
        Dimension size = DimensionService.getInstance().getSize(SPLITTER_TOP_DIMENSION_KEY);
        topPanel.setPreferredSize((Dimension)(size == null ? JBUI.size((int)640, (int)480) : size));
        size = DimensionService.getInstance().getSize(SPLITTER_BOTTOM_DIMENSION_KEY);
        bottomPanel.setPreferredSize((Dimension)(size == null ? JBUI.size((int)640, (int)200) : size));
    }

    public JComponent getComponent() {
        return this.mySplitter;
    }

    public void dispose() {
        this.myProgressIndicator.cancel();
        DimensionService.getInstance().setSize(SPLITTER_TOP_DIMENSION_KEY, this.mySplitter.getFirstComponent().getSize());
        DimensionService.getInstance().setSize(SPLITTER_BOTTOM_DIMENSION_KEY, this.mySplitter.getSecondComponent().getSize());
    }

    @NotNull
    public Boolean validate() {
        Boolean bl = this.myScanFinish && CMakeCreateListsStepAdapter.areFilesChecked(this.getRootNode());
        if (bl == null) {
            CMakeCreateListsStepAdapter.$$$reportNull$$$0(2);
        }
        return bl;
    }

    public void prepareDirectories(@NotNull VirtualFile projectDir) {
        if (projectDir == null) {
            CMakeCreateListsStepAdapter.$$$reportNull$$$0(3);
        }
        this.myProjectDir = projectDir;
        ApplicationManager.getApplication().executeOnPooledThread(() -> ProgressManager.getInstance().runProcess(() -> {
            CheckedTreeNode root = this.createRootNode();
            if (this.myProgressIndicator.isCanceled()) {
                return;
            }
            UIUtil.invokeLaterIfNeeded(() -> this.updateTreeComponents(root));
        }, (ProgressIndicator)this.myProgressIndicator));
    }

    public void testPrepareDirectories(@NotNull VirtualFile projectDir) {
        if (projectDir == null) {
            CMakeCreateListsStepAdapter.$$$reportNull$$$0(4);
        }
        this.myProjectDir = projectDir;
        this.updateTreeComponents(this.createRootNode());
    }

    public CheckedTreeNode getRootNode() {
        return (CheckedTreeNode)this.myTree.getModel().getRoot();
    }

    public CheckedTreeNode getIncludesRootNode() {
        return (CheckedTreeNode)this.myIncludeDirTree.getModel().getRoot();
    }

    public void createProject() throws IOException {
        String projectName = FileUtil.sanitizeFileName((String)this.myProjectDir.getName());
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        CMakeCreateListsStepAdapter.getCheckedFiles(this.getRootNode(), files);
        CMakeCreateListsStepAdapter.removeSymLinkDuplicates(files);
        CPPLog.LOG.assertTrue(!files.isEmpty());
        boolean isC = !files.isEmpty() && ContainerUtil.all(files, file -> OCFileTypeHelpers.isKnownFileType((String)file.getName()) && !OCFileTypeHelpers.isCppFile((String)file.getName()));
        StringBuilder makeContent = new StringBuilder();
        CMakeProjectSettings settings = isC ? new CMakeCProjectSettings() : new CMakeCPPProjectSettings();
        settings.setLanguageVersion(isC ? "11" : "14");
        makeContent.append(CLionProjectWizardUtils.getCMakeFileHeader(projectName, settings));
        makeContent.append('\n');
        ArrayList<VirtualFile> includes = new ArrayList<VirtualFile>();
        CMakeCreateListsStepAdapter.getCheckedNodes(this.getIncludesRootNode(), includes);
        boolean includesAdded = false;
        for (VirtualFile virtualFile : includes) {
            String localPath = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)this.myProjectDir);
            if (localPath == null) {
                CPPLog.LOG.error("getRelativePath(" + virtualFile.getPresentableUrl() + ", " + this.myProjectDir.getPresentableUrl() + ") is null");
                continue;
            }
            if (localPath.length() == 0) {
                localPath = ".";
            }
            @NonNls String includeDirectories = "include_directories(";
            makeContent.append(includeDirectories).append(CMakeArgumentManipulator.getCMakeLiteralFromValue(localPath)).append(")\n");
            includesAdded = true;
        }
        if (includesAdded) {
            makeContent.append("\n");
        }
        @NonNls String addExecutable = "add_executable(";
        makeContent.append(addExecutable).append(projectName).append("\n");
        for (VirtualFile file2 : files) {
            String localPath = VfsUtilCore.getRelativePath((VirtualFile)file2, (VirtualFile)this.myProjectDir);
            if (localPath == null) {
                CPPLog.LOG.error("getRelativePath(" + file2.getPresentableUrl() + ", " + this.myProjectDir.getPresentableUrl() + ") is null");
                continue;
            }
            makeContent.append("    ").append(CMakeArgumentManipulator.getCMakeLiteralFromValue(localPath)).append("\n");
        }
        makeContent.setLength(makeContent.length() - 1);
        makeContent.append(")\n");
        File file2 = new File(VfsUtilCore.virtualToIoFile((VirtualFile)this.myProjectDir), "CMakeLists.txt");
        byte[] makeBytes = makeContent.toString().getBytes(CPPEnvironment.getCharset());
        FileUtil.writeToFile((File)file2, (byte[])makeBytes);
    }

    private CheckedTreeNode createRootNode() {
        ApplicationManager.getApplication().invokeAndWait(() -> CLionProjectWizardUtils.refreshProjectDir(this.myProjectDir, true), ModalityState.stateForComponent((Component)this.mySplitter));
        CheckedTreeNode root = new CheckedTreeNode((Object)this.myProjectDir);
        VirtualFileVisitor<CheckedTreeNode> visitor = new VirtualFileVisitor<CheckedTreeNode>(new VirtualFileVisitor.Option[0]){

            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (CMakeCreateListsStepAdapter.this.myProgressIndicator.isCanceled()) {
                    VirtualFileVisitor.Result result = 1.skipTo((VirtualFile)CMakeCreateListsStepAdapter.this.myProjectDir);
                    if (result == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    return result;
                }
                if (CMakeCreateListsStepAdapter.this.myProjectDir.equals(file)) {
                    VirtualFileVisitor.Result result = CONTINUE;
                    if (result == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    return result;
                }
                if (FileTypeManager.getInstance().isFileIgnored(file) || FileElement.isFileHidden((VirtualFile)file)) {
                    VirtualFileVisitor.Result result = 1.skipTo((VirtualFile)file);
                    if (result == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    return result;
                }
                if (file.isDirectory() && file.getName().equals("CMakeFiles")) {
                    VirtualFileVisitor.Result result = 1.skipTo((VirtualFile)file);
                    if (result == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    return result;
                }
                CheckedTreeNode node = new CheckedTreeNode((Object)file);
                if (!file.isDirectory()) {
                    String fileName = file.getName();
                    node.setChecked(file.getExtension() != null && (OCFileTypeHelpers.isSourceFile((String)fileName) || OCFileTypeHelpers.isHeaderFile((String)fileName)));
                }
                ((CheckedTreeNode)this.getCurrentValue()).add((MutableTreeNode)node);
                this.setValueForChildren(node);
                VirtualFileVisitor.Result result = CONTINUE;
                if (result == null) {
                    1.$$$reportNull$$$0(5);
                }
                return result;
            }

            @NotNull
            public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(6);
                }
                VirtualFile[] children = file.getChildren();
                Arrays.sort(children, (file1, file2) -> {
                    if (file1.isDirectory() != file2.isDirectory()) {
                        return file1.isDirectory() ? -1 : 1;
                    }
                    return file1.getName().compareToIgnoreCase(file2.getName());
                });
                List<VirtualFile> list2 = List.of(children);
                if (list2 == null) {
                    1.$$$reportNull$$$0(7);
                }
                return list2;
            }

            public void afterChildrenVisited(@NotNull VirtualFile file) {
                if (file == null) {
                    1.$$$reportNull$$$0(8);
                }
                if (!file.isDirectory()) {
                    return;
                }
                CheckedTreeNode node = (CheckedTreeNode)this.getCurrentValue();
                int count = node.getChildCount();
                boolean checked = false;
                for (int i = 0; i < count; ++i) {
                    CheckedTreeNode childNode = (CheckedTreeNode)node.getChildAt(i);
                    if (!childNode.isChecked()) continue;
                    checked = true;
                    break;
                }
                node.setChecked(checked);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2, 3, 4, 5, 7 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "file";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/projectWizard/CMakeCreateListsStepAdapter$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/projectWizard/CMakeCreateListsStepAdapter$1";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: {
                        objectArray = objectArray2;
                        objectArray2[1] = "visitFileEx";
                        break;
                    }
                    case 7: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getChildrenIterable";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "visitFileEx";
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 7: {
                        break;
                    }
                    case 6: {
                        objectArray = objectArray;
                        objectArray[2] = "getChildrenIterable";
                        break;
                    }
                    case 8: {
                        objectArray = objectArray;
                        objectArray[2] = "afterChildrenVisited";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2, 3, 4, 5, 7 -> new IllegalStateException(string);
                };
            }
        };
        visitor.setValueForChildren((Object)root);
        VfsUtilCore.visitChildrenRecursively((VirtualFile)this.myProjectDir, (VirtualFileVisitor)visitor);
        return root;
    }

    private void updateTreeComponents(CheckedTreeNode root) {
        this.myTree.setRootVisible(true);
        this.myTree.setModel((TreeModel)new DefaultTreeModel((TreeNode)root));
        TreePath path = new TreePath(root);
        this.myTree.expandPath(path);
        Enumeration children = root.children();
        while (children.hasMoreElements()) {
            CheckedTreeNode childNode = (CheckedTreeNode)children.nextElement();
            if (!childNode.isChecked()) continue;
            this.myTree.expandPath(path.pathByAddingChild(childNode));
        }
        this.updateIncludes();
        this.myScanFinish = true;
        this.myValidateCallback.run();
        this.myTree.getModel().addTreeModelListener((TreeModelListener)new TreeModelAdapter(){

            public void treeNodesChanged(TreeModelEvent e) {
                CMakeCreateListsStepAdapter.this.updateIncludes();
                CMakeCreateListsStepAdapter.this.myValidateCallback.run();
            }
        });
    }

    private void updateIncludes() {
        CheckedTreeNode rootNode = this.getRootNode();
        if (rootNode.isChecked()) {
            Object oldIncludeRoot = this.myIncludeDirTree.getModel().getRoot();
            if (oldIncludeRoot instanceof CheckedTreeNode) {
                CMakeCreateListsStepAdapter.synchronizeNodes(rootNode, (CheckedTreeNode)oldIncludeRoot);
                CMakeCreateListsStepAdapter.checkHeaderDirectories(rootNode, (CheckedTreeNode)oldIncludeRoot);
                ((DefaultTreeModel)this.myIncludeDirTree.getModel()).reload();
            } else {
                CheckedTreeNode includeRootNode = new CheckedTreeNode((Object)this.myProjectDir);
                CMakeCreateListsStepAdapter.convertNodes(rootNode, includeRootNode);
                CMakeCreateListsStepAdapter.checkHeaderDirectories(rootNode, includeRootNode);
                this.myIncludeDirTree.setRootVisible(true);
                this.myIncludeDirTree.setModel((TreeModel)new DefaultTreeModel((TreeNode)includeRootNode));
            }
            this.expandIncludeDirTree();
        } else {
            this.myIncludeDirTree.setRootVisible(false);
            this.myIncludeDirTree.setModel((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
        }
    }

    private static void convertNodes(CheckedTreeNode node, CheckedTreeNode includeNode) {
        includeNode.setUserObject(node.getUserObject());
        includeNode.setChecked(false);
        int count = node.getChildCount();
        for (int i = 0; i < count; ++i) {
            CheckedTreeNode childNode = (CheckedTreeNode)node.getChildAt(i);
            if (!childNode.isChecked() || !((VirtualFile)childNode.getUserObject()).isDirectory()) continue;
            CheckedTreeNode includeChildNode = new CheckedTreeNode();
            includeNode.add((MutableTreeNode)includeChildNode);
            CMakeCreateListsStepAdapter.convertNodes(childNode, includeChildNode);
        }
    }

    private static void synchronizeNodes(CheckedTreeNode node, CheckedTreeNode includeNode) {
        int count = node.getChildCount();
        CheckedTreeNode lastInsertedIncludeNode = null;
        for (int i = count - 1; i >= 0; --i) {
            CheckedTreeNode childNode = (CheckedTreeNode)node.getChildAt(i);
            VirtualFile file = (VirtualFile)childNode.getUserObject();
            if (!file.isDirectory()) continue;
            CheckedTreeNode includeChildNode = CMakeCreateListsStepAdapter.findNodeByUserData(file, includeNode);
            if (childNode.isChecked()) {
                if (includeChildNode == null) {
                    includeChildNode = new CheckedTreeNode();
                    if (lastInsertedIncludeNode == null) {
                        includeNode.add((MutableTreeNode)includeChildNode);
                    } else {
                        includeNode.insert((MutableTreeNode)includeChildNode, includeNode.getIndex((TreeNode)lastInsertedIncludeNode));
                    }
                    CMakeCreateListsStepAdapter.convertNodes(childNode, includeChildNode);
                } else {
                    CMakeCreateListsStepAdapter.synchronizeNodes(childNode, includeChildNode);
                }
                lastInsertedIncludeNode = includeChildNode;
                continue;
            }
            if (includeChildNode == null) continue;
            includeNode.remove((MutableTreeNode)includeChildNode);
        }
    }

    private static CheckHeaderStatus checkHeaderDirectories(@NotNull CheckedTreeNode node, @Nullable CheckedTreeNode includeNode) {
        if (node == null) {
            CMakeCreateListsStepAdapter.$$$reportNull$$$0(5);
        }
        if (!node.isChecked()) {
            return CheckHeaderStatus.IGNORE;
        }
        VirtualFile file = (VirtualFile)node.getUserObject();
        if (file.isDirectory()) {
            if (includeNode == null) {
                return CheckHeaderStatus.IGNORE;
            }
            boolean shouldCheckThis = false;
            if (file.getName().equalsIgnoreCase(INCLUDE_DIRECTORY_NAME)) {
                shouldCheckThis = true;
            }
            int childCount = node.getChildCount();
            ArrayList<CheckHeaderStatus> statuses = new ArrayList<CheckHeaderStatus>(childCount);
            for (int i = 0; i <= childCount - 1; ++i) {
                CheckedTreeNode childNode = (CheckedTreeNode)node.getChildAt(i);
                CheckedTreeNode childIncludeNode = CMakeCreateListsStepAdapter.findNodeByUserData(childNode.getUserObject(), includeNode);
                statuses.add(CMakeCreateListsStepAdapter.checkHeaderDirectories(childNode, childIncludeNode));
            }
            CheckHeaderStatus overallStatus = statuses.stream().reduce(CheckHeaderStatus.IGNORE, (status1, status2) -> status1.merge((CheckHeaderStatus)((Object)status2))).singleFileToDirectory();
            if (shouldCheckThis |= overallStatus != CheckHeaderStatus.IGNORE && (ContainerUtil.exists(statuses, status -> status == CheckHeaderStatus.HEADER) || ContainerUtil.all(statuses, status -> status == CheckHeaderStatus.IGNORE || status == CheckHeaderStatus.ALL_HEADERS))) {
                includeNode.setChecked(true);
            }
            return overallStatus;
        }
        return file.getExtension() != null && OCFileTypeHelpers.isHeaderFile((String)file.getName()) ? CheckHeaderStatus.HEADER : CheckHeaderStatus.NOT_HEADER;
    }

    private void expandIncludeDirTree() {
        TreeUtil.expand((JTree)this.myIncludeDirTree, (int)1);
        Object includeRoot = this.myIncludeDirTree.getModel().getRoot();
        if (!(includeRoot instanceof CheckedTreeNode)) {
            return;
        }
        this.expandIncludeDirTree((CheckedTreeNode)includeRoot, null, false);
    }

    private void expandIncludeDirTree(@NotNull CheckedTreeNode node, @Nullable TreePath pathToParent, boolean parentChecked) {
        if (node == null) {
            CMakeCreateListsStepAdapter.$$$reportNull$$$0(6);
        }
        boolean checked = node.isChecked();
        TreePath pathToHere = pathToParent == null ? new TreePath(node) : pathToParent.pathByAddingChild(node);
        if (checked && !parentChecked) {
            this.myIncludeDirTree.makeVisible(pathToHere);
        }
        for (int i = node.getChildCount() - 1; i >= 0; --i) {
            CheckedTreeNode child = (CheckedTreeNode)node.getChildAt(i);
            this.expandIncludeDirTree(child, pathToHere, checked);
        }
    }

    private static void removeSymLinkDuplicates(List<VirtualFile> files) {
        Iterator<VirtualFile> I2 = files.iterator();
        while (I2.hasNext()) {
            VirtualFile target;
            VirtualFile linkFile = I2.next();
            if (linkFile.is(VFileProperty.SYMLINK)) {
                CMakeCreateListsStepAdapter.removeTarget(files, I2, linkFile.getCanonicalFile());
                continue;
            }
            VirtualFile linkDir = linkFile.getParent();
            if (!linkDir.is(VFileProperty.SYMLINK) || (target = linkDir.getCanonicalFile()) == null) continue;
            CMakeCreateListsStepAdapter.removeTarget(files, I2, target.findChild(linkFile.getName()));
        }
    }

    private static void removeTarget(List<VirtualFile> files, Iterator<VirtualFile> I2, VirtualFile targetFile) {
        if (targetFile != null) {
            for (VirtualFile file : files) {
                if (!targetFile.equals(file)) continue;
                I2.remove();
                break;
            }
        }
    }

    private static CheckedTreeNode findNodeByUserData(Object userData, CheckedTreeNode node) {
        int count = node.getChildCount();
        for (int i = count - 1; i >= 0; --i) {
            CheckedTreeNode childNode = (CheckedTreeNode)node.getChildAt(i);
            if (!userData.equals(childNode.getUserObject())) continue;
            return childNode;
        }
        return null;
    }

    private static void getCheckedFiles(Object object, List<VirtualFile> files) {
        CheckedTreeNode node = (CheckedTreeNode)object;
        if (!node.isChecked()) {
            return;
        }
        VirtualFile file = (VirtualFile)node.getUserObject();
        if (node.isLeaf() && !file.isDirectory()) {
            files.add(file);
            return;
        }
        int count = node.getChildCount();
        for (int i = 0; i < count; ++i) {
            CMakeCreateListsStepAdapter.getCheckedFiles(node.getChildAt(i), files);
        }
    }

    private static void getCheckedNodes(Object object, List<VirtualFile> files) {
        CheckedTreeNode node = (CheckedTreeNode)object;
        VirtualFile file = (VirtualFile)node.getUserObject();
        if (node.isChecked()) {
            files.add(file);
        }
        int count = node.getChildCount();
        for (int i = 0; i < count; ++i) {
            CMakeCreateListsStepAdapter.getCheckedNodes(node.getChildAt(i), files);
        }
    }

    private static boolean areFilesChecked(Object object) {
        CheckedTreeNode node = (CheckedTreeNode)object;
        if (!node.isChecked()) {
            return false;
        }
        if (node.isLeaf() && !((VirtualFile)node.getUserObject()).isDirectory()) {
            return true;
        }
        int count = node.getChildCount();
        for (int i = 0; i < count; ++i) {
            if (!CMakeCreateListsStepAdapter.areFilesChecked(node.getChildAt(i))) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validateCallback";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/projectWizard/CMakeCreateListsStepAdapter";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDir";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/projectWizard/CMakeCreateListsStepAdapter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "validate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "prepareDirectories";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "testPrepareDirectories";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkHeaderDirectories";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "expandIncludeDirTree";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    private class MyProgressIndicator
    extends ProgressIndicatorBase {
        MyProgressIndicator() {
            this.addStateDelegate((ProgressIndicatorEx)new AbstractProgressIndicatorExBase(){

                public void cancel() {
                    super.cancel();
                    MyProgressIndicator.this.uiStop();
                }
            });
        }

        public void start() {
            super.start();
            UIUtil.invokeAndWaitIfNeeded(() -> {
                CMakeCreateListsStepAdapter.this.myProgressBar.setIndeterminate(true);
                CMakeCreateListsStepAdapter.this.myProgressPanel.setVisible(true);
                CMakeCreateListsStepAdapter.this.myTreeLabel.setVisible(false);
            });
        }

        private void uiStop() {
            UIUtil.invokeAndWaitIfNeeded(() -> {
                CMakeCreateListsStepAdapter.this.myProgressBar.setIndeterminate(false);
                CMakeCreateListsStepAdapter.this.myProgressPanel.setVisible(false);
                CMakeCreateListsStepAdapter.this.myTreeLabel.setVisible(true);
            });
        }

        public void stop() {
            super.stop();
            this.uiStop();
        }

        public void finish(@NotNull TaskInfo task2) {
            if (task2 == null) {
                MyProgressIndicator.$$$reportNull$$$0(0);
            }
            super.finish(task2);
            this.uiStop();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/jetbrains/cidr/cpp/cmake/projectWizard/CMakeCreateListsStepAdapter$MyProgressIndicator", "finish"));
        }
    }

    private class MyTreeCellRenderer
    extends CheckboxTree.CheckboxTreeCellRenderer {
        private final boolean myRootFullName;

        MyTreeCellRenderer(boolean rootFullName) {
            super(true, false);
            this.myRootFullName = rootFullName;
        }

        public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Object userObject;
            if (value instanceof CheckedTreeNode && (userObject = ((CheckedTreeNode)value).getUserObject()) instanceof VirtualFile) {
                VirtualFile file = (VirtualFile)userObject;
                ColoredTreeCellRenderer textRenderer = this.getTextRenderer();
                textRenderer.append(this.myRootFullName && CMakeCreateListsStepAdapter.this.myProjectDir.equals(file) ? file.getPresentableUrl() : file.getPresentableName());
                textRenderer.setIcon(CMakeCreateListsStepAdapter.this.myIconProvider.getIcon(file));
            }
        }
    }

    private static enum CheckHeaderStatus {
        HEADER,
        NOT_HEADER,
        IGNORE,
        ALL_HEADERS,
        SOME_HEADERS,
        NO_HEADERS;


        @NotNull
        CheckHeaderStatus merge(@NotNull CheckHeaderStatus other) {
            if (other == null) {
                CheckHeaderStatus.$$$reportNull$$$0(0);
            }
            CheckHeaderStatus checkHeaderStatus = switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case HEADER -> {
                    switch (other) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case HEADER: {
                            yield ALL_HEADERS;
                        }
                        case NOT_HEADER: {
                            yield SOME_HEADERS;
                        }
                        case ALL_HEADERS: {
                            yield ALL_HEADERS;
                        }
                        case SOME_HEADERS: {
                            yield SOME_HEADERS;
                        }
                        case NO_HEADERS: {
                            yield SOME_HEADERS;
                        }
                        case IGNORE: 
                    }
                    yield this;
                }
                case NOT_HEADER -> {
                    switch (other) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case HEADER: {
                            yield SOME_HEADERS;
                        }
                        case NOT_HEADER: {
                            yield NO_HEADERS;
                        }
                        case ALL_HEADERS: {
                            yield SOME_HEADERS;
                        }
                        case SOME_HEADERS: {
                            yield SOME_HEADERS;
                        }
                        case NO_HEADERS: {
                            yield NO_HEADERS;
                        }
                        case IGNORE: 
                    }
                    yield this;
                }
                case ALL_HEADERS -> {
                    switch (other) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case HEADER: {
                            yield ALL_HEADERS;
                        }
                        case NOT_HEADER: {
                            yield SOME_HEADERS;
                        }
                        case ALL_HEADERS: {
                            yield ALL_HEADERS;
                        }
                        case SOME_HEADERS: {
                            yield SOME_HEADERS;
                        }
                        case NO_HEADERS: {
                            yield SOME_HEADERS;
                        }
                        case IGNORE: 
                    }
                    yield this;
                }
                case SOME_HEADERS -> SOME_HEADERS;
                case NO_HEADERS -> {
                    switch (other) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case HEADER: {
                            yield SOME_HEADERS;
                        }
                        case NOT_HEADER: {
                            yield NO_HEADERS;
                        }
                        case ALL_HEADERS: {
                            yield SOME_HEADERS;
                        }
                        case SOME_HEADERS: {
                            yield SOME_HEADERS;
                        }
                        case NO_HEADERS: {
                            yield NO_HEADERS;
                        }
                        case IGNORE: 
                    }
                    yield this;
                }
                case IGNORE -> other;
            };
            if (checkHeaderStatus == null) {
                CheckHeaderStatus.$$$reportNull$$$0(1);
            }
            return checkHeaderStatus;
        }

        @NotNull
        CheckHeaderStatus singleFileToDirectory() {
            if (this == HEADER) {
                CheckHeaderStatus checkHeaderStatus = ALL_HEADERS;
                if (checkHeaderStatus == null) {
                    CheckHeaderStatus.$$$reportNull$$$0(2);
                }
                return checkHeaderStatus;
            }
            if (this == NOT_HEADER) {
                CheckHeaderStatus checkHeaderStatus = NO_HEADERS;
                if (checkHeaderStatus == null) {
                    CheckHeaderStatus.$$$reportNull$$$0(3);
                }
                return checkHeaderStatus;
            }
            CheckHeaderStatus checkHeaderStatus = this;
            if (checkHeaderStatus == null) {
                CheckHeaderStatus.$$$reportNull$$$0(4);
            }
            return checkHeaderStatus;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1, 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "other";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/projectWizard/CMakeCreateListsStepAdapter$CheckHeaderStatus";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/projectWizard/CMakeCreateListsStepAdapter$CheckHeaderStatus";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "merge";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "singleFileToDirectory";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "merge";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1, 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

