/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.projectWizard;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.cidr.cpp.CLionCMakeBundle;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.projectWizard.generators.settings.CMakeProjectSettings;
import com.jetbrains.cidr.cpp.toolchains.CMakeExecutableTool;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.lang.formatting.CidrProjectWizardFilesFormatter;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CLionProjectWizardUtils {
    private static final Logger LOG = Logger.getInstance(CLionProjectWizardUtils.class);

    public static void reformatProjectFiles(@NotNull Project project, @Nullable VirtualFile cmakeFile, VirtualFile ... cppFiles) {
        if (project == null) {
            CLionProjectWizardUtils.$$$reportNull$$$0(0);
        }
        WriteAction.run(() -> {
            if (project.isDisposed()) {
                return;
            }
            StartupManager.getInstance((Project)project).runWhenProjectIsInitialized((Runnable)((DumbAwareRunnable)() -> {
                List formatters = CidrProjectWizardFilesFormatter.EP_NAME.getExtensionList();
                LOG.assertTrue(formatters.size() <= 1);
                if (!formatters.isEmpty()) {
                    ArrayList<VirtualFile> filesToFormat = new ArrayList<VirtualFile>(List.of(cppFiles));
                    if (cmakeFile != null) {
                        filesToFormat.add(cmakeFile);
                    }
                    ((CidrProjectWizardFilesFormatter)formatters.get(0)).reformatProjectFiles(filesToFormat, project);
                }
            }));
        });
    }

    public static void refreshProjectDir(VirtualFile projectDir) {
        CLionProjectWizardUtils.refreshProjectDir(projectDir, false);
    }

    public static void refreshProjectDir(VirtualFile projectDir, boolean recursive) {
        CPPLog.LOG.assertTrue(projectDir != null);
        VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)recursive, (boolean)true, (VirtualFile[])new VirtualFile[]{projectDir});
    }

    @NotNull
    @NonNls
    public static String getCMakeMinimumRequiredLine(String versionString) {
        Object cmake_minimum_required;
        Version version;
        Version version2 = version = versionString == null ? null : Version.parseVersion((String)versionString);
        if (version != null) {
            String versionToSet = version.lessThan(Integer.valueOf(3)) ? "2.8.4" : version.major + "." + version.minor;
            cmake_minimum_required = "cmake_minimum_required(VERSION " + versionToSet + ")\n";
        } else {
            cmake_minimum_required = "# cmake_minimum_required(VERSION <specify CMake version here>)\n";
        }
        String string = cmake_minimum_required;
        if (string == null) {
            CLionProjectWizardUtils.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    @NonNls
    public static String getCMakeFileHeader(@NotNull String projectName, @Nullable CMakeProjectSettings settings) {
        if (projectName == null) {
            CLionProjectWizardUtils.$$$reportNull$$$0(2);
        }
        CPPToolchains.Toolchain toolchain = CPPToolchains.getInstance().getDefaultToolchain();
        String languageVersionLineForCMake = "";
        if (settings != null) {
            languageVersionLineForCMake = settings.getLanguageVersionLineForCMake();
        }
        String enabledLanguages = settings == null ? "" : settings.getEnabledProjectLanguages();
        String version = CLionProjectWizardUtils.getCMakeVersionUnderProgress(toolchain);
        String string = CLionProjectWizardUtils.getCMakeMinimumRequiredLine(version) + "project(" + projectName + (String)(StringUtil.isEmptyOrSpaces((String)enabledLanguages) ? "" : " " + enabledLanguages) + ")\n\n" + languageVersionLineForCMake;
        if (string == null) {
            CLionProjectWizardUtils.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public static String getCMakeVersionUnderProgress(@Nullable CPPToolchains.Toolchain toolchain) {
        return (String)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            try {
                return CMakeExecutableTool.readCMakeVersion(toolchain);
            }
            catch (ExecutionException e) {
                return null;
            }
        }, CLionCMakeBundle.message("cmake.checking.version", new Object[0]), true, null);
    }

    @Nullable
    public static Version getCMakeVersionForDefaultToolchain() {
        String versionString = (String)ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> {
            try {
                return CMakeExecutableTool.readCMakeVersion(CPPToolchains.getInstance().getDefaultToolchain());
            }
            catch (ExecutionException e) {
                return null;
            }
        }, CLionCMakeBundle.message("cmake.checking.version", new Object[0]), false, null);
        return versionString == null ? null : Version.parseVersion((String)versionString);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 3 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/projectWizard/CLionProjectWizardUtils";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/projectWizard/CLionProjectWizardUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getCMakeMinimumRequiredLine";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCMakeFileHeader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reformatProjectFiles";
                break;
            }
            case 1: 
            case 3: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getCMakeFileHeader";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 3 -> new IllegalStateException(string);
        };
    }
}

