/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.presets;

import com.google.gson.JsonParseException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.jetbrains.cidr.cpp.cmake.presets.PresetParsingException;
import com.jetbrains.cidr.cpp.cmake.presets.problems.PresetProblem;
import com.jetbrains.cidr.gson.GsonMalformedJsonError;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0018\u0010\u0004\u001a\u00060\u0005j\u0002`\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/presets/FileParsingException;", "Lcom/jetbrains/cidr/cpp/cmake/presets/PresetParsingException;", "file", "Ljava/nio/file/Path;", "cause", "Ljava/lang/Exception;", "Lkotlin/Exception;", "<init>", "(Ljava/nio/file/Path;Ljava/lang/Exception;)V", "getFile", "()Ljava/nio/file/Path;", "getCause", "()Ljava/lang/Exception;", "asProblem", "Lcom/jetbrains/cidr/cpp/cmake/presets/problems/PresetProblem;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.clion.cmake"})
public final class FileParsingException
extends PresetParsingException {
    @NotNull
    private final Path file;
    @NotNull
    private final Exception cause;

    public FileParsingException(@NotNull Path file, @NotNull Exception cause) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
        this.file = file;
        this.cause = cause;
    }

    @NotNull
    public final Path getFile() {
        return this.file;
    }

    @Override
    @NotNull
    public Exception getCause() {
        return this.cause;
    }

    @NotNull
    public final PresetProblem asProblem(@NotNull Project project) {
        PresetProblem presetProblem;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByNioPath(this.file);
        if (virtualFile == null) {
            throw new IllegalStateException("Path " + this.file + " cannot be found in VFS");
        }
        if (this.getCause() instanceof JsonParseException) {
            Object object = this.getCause().getCause();
            if (object == null || (object = ((Throwable)object).getLocalizedMessage()) == null) {
                object = ((JsonParseException)this.getCause()).getLocalizedMessage();
            }
            Object object2 = object;
            presetProblem = new PresetProblem(project, virtualFile, (String)object2){
                private final GsonMalformedJsonError error;
                {
                    Intrinsics.checkNotNull((Object)$super_call_param$1);
                    super($project, $virtualFile, $super_call_param$1, null, 8, null);
                    this.error = new GsonMalformedJsonError(this.getText());
                }

                public int getLine() {
                    return this.error.getLine() - 1;
                }

                public int getColumn() {
                    return this.error.getColumn() - 1;
                }
            };
        } else {
            String string = this.getCause().getLocalizedMessage();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLocalizedMessage(...)");
            presetProblem = new PresetProblem(project, virtualFile, string, null, 8, null);
        }
        return presetProblem;
    }
}

