/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.model;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.options.advanced.AdvancedSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Version;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.PathKt;
import com.jetbrains.cidr.ToolVersion;
import com.jetbrains.cidr.cpp.cmake.CMakeException;
import com.jetbrains.cidr.cpp.cmake.CMakeRunner;
import com.jetbrains.cidr.cpp.cmake.CMakeRunnerStep;
import com.jetbrains.cidr.cpp.cmake.model.CMakeFileSettings;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorSpec;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorType;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspaceListener;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchainsUtil;
import com.jetbrains.cidr.system.SystemUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CMakeGeneratorUtils {
    public static final Version API_MIN_CMAKE_VERSION = new Version(3, 15, -1);
    public static final Version API_DEFAULT_CMAKE_VERSION = new Version(3, 20, -1);
    public static final Version NINJA_NEW_PROJECT_IDE_VERSION = new Version(2021, 3, 0);
    public static final Version BUILD_TOOL_AS_GENERATOR_IDE_VERSION = new Version(2022, 1, 0);
    @NlsSafe
    public static final String GENERATOR_FLAG = "-G";
    @NlsSafe
    public static final String DEFINE_FLAG = "-D";
    @NlsSafe
    public static final String BUILD_DIR_FLAG = "-B";
    @NlsSafe
    public static final String SOURCE_DIR_FLAG = "-S";
    @NlsSafe
    public static final String TOOLCHAIN_FLAG = "--toolchain";
    public static final String CMAKE_FILES_FOLDER = "CMakeFiles";
    @NlsSafe
    private static final String ALL_TARGET_MULTI_CONF = "ALL_BUILD";
    private static ForceGenerator ourForceGenerator = ForceGenerator.DEFAULT;

    @NotNull
    public static String getAllTargetName(@NotNull CMakeGeneratorSpec generator) {
        if (generator == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(0);
        }
        return CMakeGeneratorType.isSingleConfigurationGenerator(generator.getGenerator()) || CMakeGeneratorType.isNinja(generator.getGenerator()) ? "all" : ALL_TARGET_MULTI_CONF;
    }

    public static boolean hasUserSpecifiedMakeProgram(@NotNull List<String> options) {
        if (options == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(1);
        }
        return CMakeGeneratorUtils.hasUserSpecifiedCMakeVariable(options, "CMAKE_MAKE_PROGRAM");
    }

    public static boolean hasUserSpecifiedCMakeVariable(@NotNull List<String> options, @NotNull @NonNls String variable) {
        if (options == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(2);
        }
        if (variable == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(3);
        }
        for (int i = 0; i < options.size(); ++i) {
            String option = options.get(i);
            if (option.startsWith(DEFINE_FLAG + variable)) {
                return true;
            }
            if (!option.startsWith(variable) || i <= 0 || !options.get(i - 1).equals(DEFINE_FLAG)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static String getUserSpecifiedGenerator(@NotNull List<String> options) {
        if (options == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(4);
        }
        String generator = null;
        int genFlagIdx = CMakeGeneratorUtils.getGeneratorFlagIndex(options);
        if (genFlagIdx >= 0) {
            String flag = options.get(genFlagIdx);
            if (flag.length() > GENERATOR_FLAG.length()) {
                generator = flag.substring(GENERATOR_FLAG.length());
            } else if (genFlagIdx + 1 < options.size()) {
                generator = options.get(genFlagIdx + 1);
            }
        }
        return generator;
    }

    @Nullable
    public static CMakeGeneratorSpec getUserSpecifiedGeneratorSpec(@NotNull List<String> options) {
        String generatorOption;
        if (options == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(5);
        }
        return (generatorOption = CMakeGeneratorUtils.getUserSpecifiedGenerator(options)) == null ? null : CMakeGeneratorSpec.createFromCommandLineOption(generatorOption);
    }

    public static boolean hasUserSpecifiedGenerator(@NotNull List<String> options) {
        if (options == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(6);
        }
        return CMakeGeneratorUtils.getGeneratorFlagIndex(options) >= 0;
    }

    private static int getGeneratorFlagIndex(@NotNull List<String> options) {
        if (options == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(7);
        }
        return ContainerUtil.lastIndexOf(options, o -> o.startsWith(GENERATOR_FLAG));
    }

    public static void setForceAPI(@NotNull ForceGenerator force) {
        if (force == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(8);
        }
        ourForceGenerator = force;
    }

    public static boolean isAPIForced() {
        return ourForceGenerator == ForceGenerator.FORCE_API;
    }

    public static boolean isLegacyForced() {
        return ourForceGenerator == ForceGenerator.FORCE_LEGACY;
    }

    public static boolean shouldUseAPI(@NotNull List<String> additionalCmakeOptions, @Nullable ToolVersion cmakeVersion, boolean noGenerator, @NotNull CPPEnvironment environment) {
        if (additionalCmakeOptions == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(9);
        }
        if (environment == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(10);
        }
        if (CMakeGeneratorUtils.isLegacyForced()) {
            return false;
        }
        if (CMakeGeneratorUtils.isAPIForced()) {
            return true;
        }
        if (noGenerator) {
            return true;
        }
        if (CMakeGeneratorUtils.checkAPICompatibleCMake(cmakeVersion) != APICompatibilityResult.OK) {
            return false;
        }
        return CMakeGeneratorUtils.hasUserSpecifiedGenerator(additionalCmakeOptions) || CMakeGeneratorUtils.hasNinjaInEnvironmentAndCMakeSupportsAPI(environment, cmakeVersion) || CMakeGeneratorUtils.shouldUseAPIByDefault(cmakeVersion);
    }

    private static boolean shouldUseAPIByDefault(@Nullable ToolVersion cMakeVersion) {
        if (AdvancedSettings.getBoolean((String)"cmake.use.legacy.generator.by.default")) {
            return false;
        }
        if (cMakeVersion == null) {
            return false;
        }
        return CPPToolchainsUtil.compareVersions(API_DEFAULT_CMAKE_VERSION, cMakeVersion.versionNumber) >= 0;
    }

    private static boolean hasNinjaInEnvironmentAndCMakeSupportsAPI(@NotNull CPPEnvironment environment, @Nullable ToolVersion cmakeVersion) {
        if (environment == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(11);
        }
        return environment.getNinja() != null && cmakeVersion != null && CPPToolchainsUtil.compareVersions(API_MIN_CMAKE_VERSION, cmakeVersion.versionNumber) >= 0;
    }

    @NotNull
    public static APICompatibilityResult checkAPICompatibleCMake(@Nullable ToolVersion cMakeVersion) {
        if (cMakeVersion == null) {
            APICompatibilityResult aPICompatibilityResult = APICompatibilityResult.NOT_DETERMINED;
            if (aPICompatibilityResult == null) {
                CMakeGeneratorUtils.$$$reportNull$$$0(12);
            }
            return aPICompatibilityResult;
        }
        if (CPPToolchainsUtil.compareVersions(API_MIN_CMAKE_VERSION, cMakeVersion.versionNumber) < 0) {
            APICompatibilityResult aPICompatibilityResult = APICompatibilityResult.UNSUPPORTED;
            if (aPICompatibilityResult == null) {
                CMakeGeneratorUtils.$$$reportNull$$$0(13);
            }
            return aPICompatibilityResult;
        }
        APICompatibilityResult aPICompatibilityResult = APICompatibilityResult.OK;
        if (aPICompatibilityResult == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(14);
        }
        return aPICompatibilityResult;
    }

    public static void ensurePathExists(Path path, boolean isDirectory) throws IOException {
        boolean exists;
        BasicFileAttributes attributes = PathKt.basicAttributesIfExists((Path)path);
        boolean bl = exists = attributes != null;
        if (exists && attributes.isDirectory() != isDirectory) {
            throw new IOException("Specified path is " + (isDirectory ? "not " : "") + "a directory");
        }
        if (exists) {
            return;
        }
        try {
            if (isDirectory) {
                NioFiles.createDirectories((Path)path);
            } else {
                Files.createFile(NioFiles.createParentDirectories((Path)path), new FileAttribute[0]);
            }
        }
        catch (Exception e) {
            String message = "Cannot create " + (isDirectory ? "directory " : "file ") + path;
            throw new IOException(SystemUtil.patchMessage(message, path, e.getMessage()), e);
        }
    }

    public static void cleanGeneratedCMakeFiles(@NotNull Project project, @NotNull Path generationDir) throws IOException {
        if (project == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(15);
        }
        if (generationDir == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(16);
        }
        try {
            NioFiles.deleteRecursively((Path)generationDir.resolve(CMAKE_FILES_FOLDER));
            NioFiles.deleteRecursively((Path)generationDir.resolve("CMakeCache.txt"));
            NioFiles.deleteRecursively((Path)generationDir.resolve(".cmake/api/v1").resolve("reply"));
        }
        finally {
            ((CMakeWorkspaceListener)project.getMessageBus().syncPublisher(CMakeWorkspaceListener.TOPIC)).generationDirCleared(generationDir);
        }
    }

    @NotNull
    public static File getCMakeFilesIDEFile(@NotNull File generationDir, @NotNull String fileName) {
        if (generationDir == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(17);
        }
        if (fileName == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(18);
        }
        File file = CMakeGeneratorUtils.getCMakeFilesIDEFile(generationDir.toPath(), fileName).toFile();
        if (file == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(19);
        }
        return file;
    }

    @NotNull
    static Path getCMakeFilesIDEFile(@NotNull Path generationDir, @NotNull String fileName) {
        if (generationDir == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(20);
        }
        if (fileName == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(21);
        }
        String productName = FileUtil.sanitizeFileName((String)StringUtil.toLowerCase((String)ApplicationNamesInfo.getInstance().getProductName()));
        Path path = generationDir.resolve("CMakeFiles/" + productName + "-" + fileName);
        if (path == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(22);
        }
        return path;
    }

    @NotNull
    static File getCMakeListsFile(@NotNull File dir) {
        if (dir == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(23);
        }
        return new File(FileUtil.toCanonicalPath((String)new File(dir, "CMakeLists.txt").getPath()));
    }

    @NotNull
    static File toLocalFile(@NotNull CPPEnvironment environment, @NlsSafe @NotNull String absolutePath) {
        if (environment == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(24);
        }
        if (absolutePath == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(25);
        }
        return CMakeGeneratorUtils.toLocalFile(environment, null, absolutePath);
    }

    @NotNull
    static File toLocalFile(@NotNull CPPEnvironment environment, @Nullable File basedir, @NotNull String absoluteOrRelativePath) {
        if (environment == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(26);
        }
        if (absoluteOrRelativePath == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(27);
        }
        return new File(environment.toLocalPath(basedir, absoluteOrRelativePath));
    }

    @Nullable
    static String toEnvFile(@NotNull CPPEnvironment environment, @Nullable File localFile) {
        if (environment == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(28);
        }
        if (localFile == null) {
            return null;
        }
        return environment.toEnvPath(localFile.getPath());
    }

    static <T> Map<String, T> createOrderedTargetKeysMap() {
        return new ConcurrentHashMap();
    }

    @NotNull
    public static String getBuildTypeOption(@NotNull String buildType) {
        if (buildType == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(29);
        }
        Object object = buildType.equals("Default") ? "" : "-DCMAKE_BUILD_TYPE=" + buildType;
        if (object == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(30);
        }
        return object;
    }

    @NotNull
    public static CMakeRunner.CMakeOutput runCMakeGenerator(@NotNull CPPEnvironment environment, @NotNull Path projectDir, @NotNull Path outputDir, @NotNull List<String> commandLineOptions) throws CMakeException {
        if (environment == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(31);
        }
        if (projectDir == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(32);
        }
        if (outputDir == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(33);
        }
        if (commandLineOptions == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(34);
        }
        return CMakeGeneratorUtils.runCMakeGenerator(environment, projectDir, outputDir, commandLineOptions, Collections.emptyMap(), handler2 -> {});
    }

    @NotNull
    public static CMakeRunner.CMakeOutput runCMakeGenerator(@NotNull CPPEnvironment environment, @NotNull Path projectDir, @NotNull Path outputDir, @NotNull List<String> commandLineOptions, @NotNull Map<String, String> additionalEnvironment) throws CMakeException {
        if (environment == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(35);
        }
        if (projectDir == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(36);
        }
        if (outputDir == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(37);
        }
        if (commandLineOptions == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(38);
        }
        if (additionalEnvironment == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(39);
        }
        return CMakeGeneratorUtils.runCMakeGenerator(environment, projectDir, outputDir, commandLineOptions, additionalEnvironment, handler2 -> {});
    }

    @NotNull
    private static CMakeRunner.CMakeOutput runCMakeGenerator(@NotNull CPPEnvironment environment, @NotNull Path projectDir, @NotNull Path outputDir, List<String> commandLineOptions, @NotNull Map<String, String> additionalEnvironment, @NotNull CMakeRunner.Listener listener2) throws CMakeException {
        if (environment == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(40);
        }
        if (projectDir == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(41);
        }
        if (outputDir == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(42);
        }
        if (additionalEnvironment == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(43);
        }
        if (listener2 == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(44);
        }
        String generator = null;
        if (CMakeGeneratorUtils.getUserSpecifiedGenerator(commandLineOptions) == null) {
            generator = CMakeGeneratorSpec.createDefaultLegacyGeneratorSpec(environment.getToolSet(), false).asCommandLineOption();
        }
        return CMakeGeneratorUtils.runCMakeGenerator(new CMakeRunnerStep.Parameters(environment, projectDir, outputDir, commandLineOptions, true, additionalEnvironment, listener2, false), generator);
    }

    @NotNull
    public static CMakeRunner.CMakeOutput runCMakeGenerator(@NotNull CPPEnvironment environment, @NotNull Path projectDir, @NotNull Path outputDir, @NotNull List<String> commandLineOptions, @NotNull String generator) throws CMakeException {
        if (environment == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(45);
        }
        if (projectDir == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(46);
        }
        if (outputDir == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(47);
        }
        if (commandLineOptions == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(48);
        }
        if (generator == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(49);
        }
        return CMakeGeneratorUtils.runCMakeGenerator(new CMakeRunnerStep.Parameters(environment, projectDir, outputDir, commandLineOptions, true, Collections.emptyMap(), handler2 -> {}, false), generator);
    }

    @NotNull
    private static CMakeRunner.CMakeOutput runCMakeGenerator(@NotNull CMakeRunnerStep.Parameters parameters2, @Nullable String generatorSpec) throws CMakeException {
        if (parameters2 == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(50);
        }
        ArrayList<String> allParams = new ArrayList<String>(parameters2.getParameters());
        CMakeGeneratorUtils.addGeneratorParametersIfNeeded(allParams, generatorSpec);
        CMakeRunnerStep.Parameters newParameters = parameters2.withParameters(allParams);
        CMakeRunner.CMakeOutput cMakeOutput = CMakeRunner.runCMake(newParameters);
        if (cMakeOutput == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(51);
        }
        return cMakeOutput;
    }

    public static void addGeneratorParametersIfNeeded(@NotNull List<String> parameters2, @Nullable String generatorSpec) {
        if (parameters2 == null) {
            CMakeGeneratorUtils.$$$reportNull$$$0(52);
        }
        if (!StringUtil.isEmptyOrSpaces((String)generatorSpec) && !CMakeGeneratorUtils.hasUserSpecifiedGenerator(parameters2)) {
            parameters2.add(GENERATOR_FLAG);
            parameters2.add(generatorSpec);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 12, 13, 14, 19, 22, 30, 51 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "force";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalCmakeOptions";
                break;
            }
            case 10: 
            case 11: 
            case 24: 
            case 26: 
            case 28: 
            case 31: 
            case 35: 
            case 40: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 22: 
            case 30: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeGeneratorUtils";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generationDir";
                break;
            }
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absolutePath";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "absoluteOrRelativePath";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildType";
                break;
            }
            case 32: 
            case 36: 
            case 41: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDir";
                break;
            }
            case 33: 
            case 37: 
            case 42: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDir";
                break;
            }
            case 34: 
            case 38: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineOptions";
                break;
            }
            case 39: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalEnvironment";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 50: 
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeGeneratorUtils";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "checkAPICompatibleCMake";
                break;
            }
            case 19: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getCMakeFilesIDEFile";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildTypeOption";
                break;
            }
            case 51: {
                objectArray = objectArray2;
                objectArray2[1] = "runCMakeGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getAllTargetName";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "hasUserSpecifiedMakeProgram";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "hasUserSpecifiedCMakeVariable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getUserSpecifiedGenerator";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getUserSpecifiedGeneratorSpec";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasUserSpecifiedGenerator";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getGeneratorFlagIndex";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "setForceAPI";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "shouldUseAPI";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "hasNinjaInEnvironmentAndCMakeSupportsAPI";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 19: 
            case 22: 
            case 30: 
            case 51: {
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "cleanGeneratedCMakeFiles";
                break;
            }
            case 17: 
            case 18: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getCMakeFilesIDEFile";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getCMakeListsFile";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "toLocalFile";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "toEnvFile";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getBuildTypeOption";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "runCMakeGenerator";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "addGeneratorParametersIfNeeded";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 12, 13, 14, 19, 22, 30, 51 -> new IllegalStateException(string);
        };
    }

    public static enum ForceGenerator {
        FORCE_API,
        DEFAULT,
        FORCE_LEGACY;

    }

    public static enum APICompatibilityResult {
        OK,
        NOT_DETERMINED,
        UNSUPPORTED;

    }

    static final class CudaTargetInfo {
        @Nullable
        private final File compilerPath;
        @NotNull
        private final Map<File, CMakeFileSettings> sources;

        CudaTargetInfo(@Nullable File compilerPath, @NotNull Map<File, CMakeFileSettings> sources) {
            if (sources == null) {
                CudaTargetInfo.$$$reportNull$$$0(0);
            }
            this.compilerPath = compilerPath;
            this.sources = sources;
        }

        @Nullable
        File getCompilerPath() {
            return this.compilerPath;
        }

        @NotNull
        Map<File, CMakeFileSettings> getSources() {
            Map<File, CMakeFileSettings> map = this.sources;
            if (map == null) {
                CudaTargetInfo.$$$reportNull$$$0(1);
            }
            return map;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sources";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeGeneratorUtils$CudaTargetInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeGeneratorUtils$CudaTargetInfo";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSources";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

