/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.FileCollectionFactory;
import com.jetbrains.cidr.cpp.CLionCMakeBundle;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.CMakeCoroutinesHelper;
import com.jetbrains.cidr.cpp.cmake.CMakeException;
import com.jetbrains.cidr.cpp.cmake.actions.OpenCMakeSettingsAction;
import com.jetbrains.cidr.cpp.cmake.flavor.plain.CMakePlainProjectFlavorKt;
import com.jetbrains.cidr.cpp.cmake.model.CMakeApiTargetReader;
import com.jetbrains.cidr.cpp.cmake.model.CMakeCacheFileParser;
import com.jetbrains.cidr.cpp.cmake.model.CMakeCompiler;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfiguration;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfigurationSettings;
import com.jetbrains.cidr.cpp.cmake.model.CMakeFileSettings;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGenerator;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorCommonInfo;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorParameters;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorSpec;
import com.jetbrains.cidr.cpp.cmake.model.CMakeGeneratorUtils;
import com.jetbrains.cidr.cpp.cmake.model.CMakeMessage;
import com.jetbrains.cidr.cpp.cmake.model.CMakeModel;
import com.jetbrains.cidr.cpp.cmake.model.CMakeProfileGenerationResult;
import com.jetbrains.cidr.cpp.cmake.model.CMakeProfileTargetInfo;
import com.jetbrains.cidr.cpp.cmake.model.CMakeTarget;
import com.jetbrains.cidr.cpp.cmake.model.CMakeVariable;
import com.jetbrains.cidr.cpp.cmake.model.api.CMakeApiException;
import com.jetbrains.cidr.cpp.cmake.model.api.CMakeApiFailLogger;
import com.jetbrains.cidr.cpp.cmake.model.api.CMakeApiJsonUtils;
import com.jetbrains.cidr.cpp.cmake.model.api.model.CacheV2;
import com.jetbrains.cidr.cpp.cmake.model.api.model.CacheV2Kt;
import com.jetbrains.cidr.cpp.cmake.model.api.model.FileV1;
import com.jetbrains.cidr.cpp.cmake.model.api.model.FilesV1;
import com.jetbrains.cidr.cpp.cmake.model.api.model.FilesV1Kt;
import com.jetbrains.cidr.cpp.cmake.model.api.model.ToolchainV1;
import com.jetbrains.cidr.cpp.cmake.model.api.model.ToolchainsV1;
import com.jetbrains.cidr.cpp.cmake.model.api.model.ToolchainsV1Kt;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeOutputConsole;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeStatisticsCollector;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.cidr.execution.CidrCoroutineHelper;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.workspace.compiler.AppleClangCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.GCCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.MSVCCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import com.jetbrains.cmake.interpreter.CMakeInterpreter;
import com.jetbrains.cmake.psi.CMakeFile;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.Future;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CMakeApiProfileGenerationResult
extends CMakeProfileGenerationResult {
    @NlsSafe
    public static final String API_DIR_V_1 = ".cmake/api/v1";
    @NlsSafe
    public static final String QUERY = "query";
    @NlsSafe
    public static final String REPLY = "reply";
    @NlsSafe
    private static final String CODE_MODEL_V_2 = "codemodel-v2";
    @NlsSafe
    private static final String CACHE_V_2 = "cache-v2";
    @NlsSafe
    private static final String CMAKE_FILES_V_1 = "cmakeFiles-v1";
    @NlsSafe
    private static final String TOOLCHAINS_V_1 = "toolchains-v1";
    private static final Pattern COMPILER_FILE_PATTERN = Pattern.compile("^CMake(\\w+)Compiler.cmake$");
    @Nullable
    final CMakeModel myPreviousModel;
    @Nullable
    private String myProjectName;
    private Collection<CMakeProfileTargetInfo> myTargetInfos;
    @Nullable
    private String cudaHostCompiler;
    @NotNull
    private final CMakeApiFailLogger myFailLogger;

    public CMakeApiProfileGenerationResult(@NotNull CMakeGenerator generator, @NotNull CMakeGeneratorParameters parameters2, @Nullable CMakeModel previousModel) {
        if (generator == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(0);
        }
        if (parameters2 == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(1);
        }
        super(generator, parameters2);
        this.myFailLogger = new CMakeApiFailLogger();
        this.myPreviousModel = previousModel;
    }

    @Override
    protected void beforeGenerate(@NotNull Path generationDir) {
        if (generationDir == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(2);
        }
        super.beforeGenerate(generationDir);
        Path queryPath = generationDir.resolve(".cmake/api/v1/query");
        try {
            CMakeGeneratorUtils.ensurePathExists(queryPath, true);
            ArrayList<String> files = new ArrayList<String>(Arrays.asList(CODE_MODEL_V_2, CACHE_V_2, CMAKE_FILES_V_1));
            if (Registry.is((String)"cmake.api.toolchains.v1")) {
                files.add(TOOLCHAINS_V_1);
            }
            this.createQueriesIfMissing(queryPath, files);
        }
        catch (CMakeApiException | IOException e) {
            this.hasGenerationError = true;
            this.reportError(e);
        }
    }

    private void createQueriesIfMissing(Path queryDir, List<String> queries) throws CMakeApiException {
        CMakeCoroutinesHelper.ensurePathExists(queryDir, queries, (ThrowableConsumer<String, CMakeApiException>)((ThrowableConsumer)message -> this.fail((String)message)));
    }

    @Override
    protected void loadInfo(@NotNull File generationDir, @NotNull CMakeGeneratorCommonInfo commonInfo) {
        if (generationDir == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(3);
        }
        if (commonInfo == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(4);
        }
        try {
            this.doLoadInfo(generationDir, commonInfo);
        }
        catch (ProcessCanceledException pce) {
            throw pce;
        }
        catch (Throwable e) {
            CMakeStatisticsCollector.LOAD_MODEL_FAILED.log(this.myGenerator.myProject);
            if (!this.hasGenerationError) {
                this.reportError(e);
            }
            ArrayList<CMakeProfileTargetInfo> infos = new ArrayList<CMakeProfileTargetInfo>();
            this.fillFromPreviousModel(infos, commonInfo);
            this.myTargetInfos = infos;
        }
    }

    private void fillFromPreviousModel(@NotNull List<CMakeProfileTargetInfo> infos, @NotNull CMakeGeneratorCommonInfo commonInfo) {
        if (infos == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(5);
        }
        if (commonInfo == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(6);
        }
        if (this.myPreviousModel == null) {
            return;
        }
        this.myPreviousModel.getCMakeDependencyFiles().forEach(commonInfo::addDependencyFile);
        this.myPreviousModel.getHeaderAndResourceFiles().forEach(commonInfo::addSourceFile);
        this.myPreviousModel.getFileExtensions().forEach(commonInfo::addExtension);
        this.myProjectName = this.myPreviousModel.getProjectName();
        for (CMakeTarget target : this.myPreviousModel.getTargets()) {
            List<CMakeConfiguration> configurations = target.getBuildConfigurations();
            for (CMakeConfiguration configuration : configurations) {
                if (configuration.getProfileId() != this.parameters.getProfileId() || !FileUtil.filesEqual((File)configuration.getConfigurationGenerationDir(), (File)this.parameters.getGenerationDir())) continue;
                CMakeProfileTargetInfo info = new CMakeProfileTargetInfo(this.parameters.getEnvironment(), this.myGenerator.getCMakeListsFile(), configuration.getConfigurationGenerationDir(), configuration.getConfigurationAndTargetGenerationDir(), target.getName(), configuration.getTargetType(), configuration.getGenerator(), configuration.getBuildType(), configuration.getBuildWorkingDir());
                info.sources = new HashMap<File, CMakeFileSettings>(configuration.getSourcesMap());
                info.productFile = configuration.getProductFile();
                info.linkerFlags = new ArrayList<String>(configuration.getLinkerFlags());
                info.perLanguageSettings = new HashMap<OCLanguageKind, CMakeConfigurationSettings>(configuration.getPerLanguageSettingsMap());
                infos.add(info);
            }
        }
    }

    private void doLoadInfo(@NotNull File generationDir, @NotNull CMakeGeneratorCommonInfo commonInfo) throws CMakeApiException {
        CMakeVariable cudaHostCompilerVariable;
        File[] inds;
        if (generationDir == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(7);
        }
        if (commonInfo == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(8);
        }
        this.myFailLogger.pushScope(generationDir.getPath());
        File replyDir = new File(generationDir, ".cmake/api/v1/reply");
        if (!replyDir.exists()) {
            this.fail(CLionCMakeBundle.message("cmake.api.no.reply.dir", new Object[0]));
        }
        if ((inds = replyDir.listFiles((dir, name) -> name.startsWith("index-"))) == null || inds.length == 0) {
            this.fail(CLionCMakeBundle.message("cmake.api.no.index.file", new Object[0]));
        }
        Arrays.sort(inds, (o1, o2) -> Comparing.compare((Comparable)((Object)o2.getName()), (Comparable)((Object)o1.getName())));
        File indexFile = inds[0];
        JsonObject indexObj = this.loadJsonObject(indexFile);
        JsonObject cmakeObj = this.getJsonObject(indexObj, "cmake");
        JsonObject reply = this.getJsonObject(indexObj, REPLY);
        JsonObject cmInfoObj = this.getJsonObject(reply, CODE_MODEL_V_2);
        JsonObject codeModelObj = this.loadReplyFile(replyDir, cmInfoObj);
        JsonObject cmPaths = this.getJsonObject(codeModelObj, "paths");
        String topLevelSourceDirPath = cmPaths.get("source").getAsString();
        File topLevelSourceDir = new File(this.parameters.getEnvironment().toLocalPath(topLevelSourceDirPath));
        String topLevelBuildDirPath = cmPaths.get("build").getAsString();
        File topLevelBuildDir = new File(this.parameters.getEnvironment().toLocalPath(topLevelBuildDirPath));
        JsonObject cmakeFilesObject = this.loadReplyFile(replyDir, this.getJsonObject(reply, CMAKE_FILES_V_1));
        FilesV1 cmakeFiles = FilesV1Kt.readFilesV1(cmakeFilesObject, this.myFailLogger);
        Set cudaFolders = FileCollectionFactory.createCanonicalFileSet();
        for (FileV1 cmakeFile : cmakeFiles.getDescriptors()) {
            if (cmakeFile.isCMake()) continue;
            String path = cmakeFile.getPath();
            if (cmakeFile.isGenerated()) {
                if (!path.endsWith(".o.cmake.pre-gen") && !path.endsWith(".obj.cmake.pre-gen")) continue;
                File file = CMakeGeneratorUtils.toLocalFile(this.parameters.getEnvironment(), topLevelSourceDir, path).getParentFile();
                cudaFolders.add(file);
                continue;
            }
            File file = CMakeGeneratorUtils.toLocalFile(this.parameters.getEnvironment(), topLevelSourceDir, path);
            commonInfo.addDependencyFile(file);
        }
        JsonObject toolchainsObj = Registry.is((String)"cmake.api.toolchains.v1") ? this.loadOptionalReplyFile(replyDir, this.getJsonObject(reply, TOOLCHAINS_V_1)) : null;
        Map<OCLanguageKind, CompilerInfo> compilers = this.readCompilerInfoMap(cmakeFiles, toolchainsObj, topLevelSourceDir);
        for (Map.Entry entry : compilers.entrySet()) {
            OCLanguageKind languageKind = (OCLanguageKind)entry.getKey();
            for (String extension : ((CompilerInfo)entry.getValue()).extensions) {
                commonInfo.addExtension(extension, languageKind);
            }
        }
        JsonElement cacheElm = reply.get(CACHE_V_2);
        if (cacheElm == null) {
            this.fail(CLionCMakeBundle.message("cmake.api.cache.not.found", CACHE_V_2));
        }
        JsonObject jsonObject = this.loadReplyFile(replyDir, cacheElm.getAsJsonObject());
        CacheV2 cache = CacheV2Kt.readCacheV2(jsonObject, this.myFailLogger);
        List<String> types = null;
        CMakeVariable typesVariable = cache.getVariables().get("CMAKE_CONFIGURATION_TYPES");
        if (typesVariable != null && typesVariable.getValue() != null) {
            types = CMakeCacheFileParser.parseListValue(typesVariable.getValue());
        }
        if (types != null) {
            this.setBuildTypes(types);
        }
        if ((cudaHostCompilerVariable = cache.getVariables().get("CMAKE_CUDA_HOST_COMPILER")) != null && cudaHostCompilerVariable.getValue() != null) {
            this.cudaHostCompiler = cudaHostCompilerVariable.getValue();
        }
        String extraGeneratorName = null;
        CMakeVariable extraGeneratorVariable = cache.getVariables().get("CMAKE_EXTRA_GENERATOR");
        if (extraGeneratorVariable != null && extraGeneratorVariable.getValue() != null) {
            extraGeneratorName = extraGeneratorVariable.getValue();
        }
        JsonObject generatorObj = this.getJsonObject(cmakeObj, "generator");
        CMakeConfiguration.Generator generator = new CMakeConfiguration.Generator(CMakeGeneratorSpec.createFromGeneratorName(CMakeApiProfileGenerationResult.getName(generatorObj), extraGeneratorName), true);
        this.loadOsxRoot(cache);
        Map<String, CMakeProfileTargetInfo> targetInfos = CMakeGeneratorUtils.createOrderedTargetKeysMap();
        JsonArray cfgArray = this.getJsonArray(codeModelObj, "configurations");
        if (cfgArray.size() == 0) {
            this.fail(CLionCMakeBundle.message("cmake.api.no.configurations.in", CODE_MODEL_V_2));
        }
        ConcurrentHashMap<String, CPPEnvironment.ExecutablePathResult> resolvedExecutableCache = new ConcurrentHashMap<String, CPPEnvironment.ExecutablePathResult>(2);
        boolean forceFirstConfig = cfgArray.size() == 1 || "Default".equals(this.parameters.getBuildType());
        for (JsonElement cfgElm : cfgArray) {
            JsonObject cfgObj = cfgElm.getAsJsonObject();
            JsonElement builtTypeName = cfgObj.get("name");
            if (builtTypeName == null) {
                this.fail(CLionCMakeBundle.message("cmake.api.no.configuration.name", new Object[0]));
            }
            String buildType = builtTypeName.getAsString();
            if (!forceFirstConfig && !this.parameters.getBuildType().equals(buildType)) continue;
            String string = buildType = StringUtil.isEmpty((String)buildType) ? "Default" : buildType;
            if (this.myProjectName == null) {
                JsonObject projObj;
                JsonElement projNameElm;
                JsonArray projArray = this.getJsonArray(cfgObj, "projects");
                if (projArray.size() == 0) {
                    this.fail(CLionCMakeBundle.message("cmake.api.no.projects.in", CODE_MODEL_V_2));
                }
                if ((projNameElm = (projObj = (JsonObject)projArray.get(0)).get("name")) == null) {
                    this.fail(CLionCMakeBundle.message("cmake.api.no.project.name", new Object[0]));
                }
                this.myProjectName = projNameElm.getAsString();
            }
            long targetsReadingStartTime = System.currentTimeMillis();
            if (Registry.is((String)"cmake.read.targets.in.parallel")) {
                this.loadCMakeTargetsInParallel(commonInfo, replyDir, topLevelSourceDir, topLevelBuildDir, cudaFolders, compilers, cache, cmakeFiles, generator, targetInfos, resolvedExecutableCache, cfgObj, buildType);
            } else {
                this.loadCMakeTargetsSingleThread(commonInfo, replyDir, topLevelSourceDir, topLevelBuildDir, cudaFolders, compilers, cache, cmakeFiles, generator, targetInfos, resolvedExecutableCache, cfgObj, buildType);
            }
            CPPLog.LOG.info("CMake API targets for " + builtTypeName + " read in " + (System.currentTimeMillis() - targetsReadingStartTime) + " ms");
            if (!forceFirstConfig) continue;
            break;
        }
        this.myTargetInfos = targetInfos.values();
        this.myFailLogger.popScope();
    }

    private void loadCMakeTargetsSingleThread(@NotNull CMakeGeneratorCommonInfo commonInfo, File replyDir, File topLevelSourceDir, File topLevelBuildDir, Set<File> cudaFolders, Map<OCLanguageKind, CompilerInfo> compilers, CacheV2 cache, FilesV1 cmakeFiles, CMakeConfiguration.Generator generator, Map<String, CMakeProfileTargetInfo> targetInfos, Map<String, CPPEnvironment.ExecutablePathResult> resolvedExecutableCache, JsonObject cfgObj, String buildType) throws CMakeApiException {
        if (commonInfo == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(9);
        }
        Map<File, CMakeGeneratorUtils.CudaTargetInfo> cudaInfo = null;
        for (JsonElement targetElm : this.getJsonArray(cfgObj, "targets")) {
            String tgtFileName = this.getJsonFilePath(targetElm.getAsJsonObject());
            JsonObject tgtObject = this.loadReplyFile(replyDir, tgtFileName);
            if (CMakeApiProfileGenerationResult.getBool(tgtObject, "isGeneratorProvided")) continue;
            this.myFailLogger.pushScope(tgtFileName);
            if (cudaInfo == null) {
                cudaInfo = this.loadCudaInfo(cudaFolders);
            }
            CMakeApiTargetReader.Context context = new CMakeApiTargetReader.Context(this, this.myFailLogger, this.parameters.getEnvironment(), buildType, generator, topLevelSourceDir, topLevelBuildDir, cache, cmakeFiles, compilers, commonInfo, cudaInfo, resolvedExecutableCache);
            CMakeApiTargetReader reader = new CMakeApiTargetReader(context);
            CMakeProfileTargetInfo target = reader.loadTargetInfo(tgtObject);
            targetInfos.put(target.targetName, target);
            this.myFailLogger.popScope();
        }
    }

    private void loadCMakeTargetsInParallel(@NotNull CMakeGeneratorCommonInfo commonInfo, File replyDir, File topLevelSourceDir, File topLevelBuildDir, Set<File> cudaFolders, Map<OCLanguageKind, CompilerInfo> compilers, CacheV2 cache, FilesV1 cmakeFiles, CMakeConfiguration.Generator generator, Map<String, CMakeProfileTargetInfo> targetInfos, Map<String, CPPEnvironment.ExecutablePathResult> resolvedExecutableCache, JsonObject cfgObj, String buildType) throws CMakeApiException {
        if (commonInfo == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(10);
        }
        Map<File, CMakeGeneratorUtils.CudaTargetInfo> cudaInfo = this.loadCudaInfo(cudaFolders);
        ExecutorCompletionService completionService = new ExecutorCompletionService(this.myGenerator.getTasksExecutorService());
        ArrayList readers = new ArrayList();
        CidrCoroutineHelper.runWithContextPropagationAndIndicator(() -> {
            try {
                for (JsonElement targetElm : this.getJsonArray(cfgObj, "targets")) {
                    Future<Object> future2 = completionService.submit(() -> {
                        CMakeApiFailLogger logger = new CMakeApiFailLogger(this.myFailLogger);
                        String tgtFileName = this.getJsonFilePath(targetElm.getAsJsonObject());
                        logger.pushScope(tgtFileName);
                        JsonObject tgtObject = this.loadReplyFile(replyDir, tgtFileName);
                        if (!CMakeApiProfileGenerationResult.getBool(tgtObject, "isGeneratorProvided")) {
                            CMakeApiTargetReader.Context context = new CMakeApiTargetReader.Context(this, logger, this.parameters.getEnvironment(), buildType, generator, topLevelSourceDir, topLevelBuildDir, cache, cmakeFiles, compilers, commonInfo, cudaInfo, resolvedExecutableCache);
                            CMakeApiTargetReader reader = new CMakeApiTargetReader(context);
                            CMakeProfileTargetInfo target = reader.loadTargetInfo(tgtObject);
                            targetInfos.put(target.targetName, target);
                        }
                        return null;
                    });
                    readers.add(future2);
                }
            }
            catch (CMakeApiException e) {
                throw new RuntimeException(e);
            }
            return null;
        });
        for (Future reader : readers) {
            try {
                reader.get();
            }
            catch (ExecutionException e) {
                Throwable executionExceptionCause = e.getCause();
                if (executionExceptionCause instanceof RuntimeException) {
                    RuntimeException runtimeException = (RuntimeException)executionExceptionCause;
                    Throwable runtimeExceptionCause = runtimeException.getCause();
                    if (runtimeExceptionCause instanceof CMakeApiException) {
                        CMakeApiException cmakeException = (CMakeApiException)runtimeExceptionCause;
                        throw cmakeException;
                    }
                    throw runtimeException;
                }
                throw new RuntimeException(e);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Nullable
    String getCudaHostCompiler() {
        return this.cudaHostCompiler;
    }

    @NotNull
    private JsonArray getJsonArray(@NonNls @NotNull JsonObject parentObj, @NonNls @NotNull String arrayName) throws CMakeApiException {
        if (parentObj == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(11);
        }
        if (arrayName == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(12);
        }
        JsonArray jsonArray = CMakeApiJsonUtils.getJsonArray(parentObj, arrayName, this.myFailLogger);
        if (jsonArray == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(13);
        }
        return jsonArray;
    }

    @NotNull
    @NonNls
    private JsonObject getJsonObject(@NonNls @NotNull JsonObject parentObj, @NonNls @NotNull String objectName) throws CMakeApiException {
        if (parentObj == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(14);
        }
        if (objectName == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(15);
        }
        JsonObject jsonObject = CMakeApiJsonUtils.getJsonObject(parentObj, objectName, this.myFailLogger);
        if (jsonObject == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(16);
        }
        return jsonObject;
    }

    @Nullable
    private JsonObject loadOptionalReplyFile(@NotNull File replyDir, @NotNull JsonObject infoObj) {
        if (replyDir == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(17);
        }
        if (infoObj == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(18);
        }
        try {
            return this.loadReplyFile(replyDir, infoObj);
        }
        catch (CMakeApiException ex) {
            return null;
        }
    }

    @NotNull
    private JsonObject loadReplyFile(@NotNull File replyDir, @NotNull JsonObject infoObj) throws CMakeApiException {
        if (replyDir == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(19);
        }
        if (infoObj == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(20);
        }
        String cmFileName = this.getJsonFilePath(infoObj);
        return this.loadReplyFile(replyDir, cmFileName);
    }

    @NotNull
    private JsonObject loadReplyFile(@NotNull File replyDir, String cmFileName) throws CMakeApiException {
        if (replyDir == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(21);
        }
        ProgressManager.checkCanceled();
        File cmFile = new File(replyDir, cmFileName);
        JsonObject cmObject = this.loadJsonObject(cmFile);
        ProgressManager.checkCanceled();
        JsonObject jsonObject = cmObject;
        if (jsonObject == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(22);
        }
        return jsonObject;
    }

    @NlsSafe
    @NotNull
    private String getJsonFilePath(@NotNull JsonObject infoObj) throws CMakeApiException {
        JsonElement fileElm;
        if (infoObj == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(23);
        }
        if ((fileElm = infoObj.get("jsonFile")) == null) {
            this.fail(CLionCMakeBundle.message("cmake.api.no.path.for.a.file.in", infoObj));
        }
        String string = fileElm.getAsString();
        if (string == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(24);
        }
        return string;
    }

    private static boolean isIncompatible(@NotNull CPPToolSet.Kind toolSetKind, @NotNull OCCompilerKind compilerKind) {
        if (toolSetKind == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(25);
        }
        if (compilerKind == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(26);
        }
        switch (toolSetKind) {
            case MINGW: 
            case CYGWIN: 
            case WSL: {
                return compilerKind == MSVCCompilerKind.INSTANCE;
            }
            case MSVC: {
                return compilerKind == GCCCompilerKind.INSTANCE || compilerKind == AppleClangCompilerKind.INSTANCE;
            }
        }
        return false;
    }

    @NotNull
    private Map<OCLanguageKind, CompilerInfo> readCompilerInfoMap(@NotNull FilesV1 cmakeFiles, @Nullable JsonObject toolchainsObj, @NotNull File topLevelSourceDir) throws CMakeApiException {
        if (cmakeFiles == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(27);
        }
        if (topLevelSourceDir == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(28);
        }
        Map<Object, Object> result = new HashMap();
        if (toolchainsObj != null && Registry.is((String)"cmake.api.toolchains.v1")) {
            result = this.readToolchainsCompilerInfoMap(toolchainsObj, cmakeFiles, topLevelSourceDir);
        }
        HashSet<OCLanguageKind> missingLanguages = new HashSet<OCLanguageKind>();
        if (!result.isEmpty()) {
            CPPToolchains.Toolchain configuredToolchain = this.parameters.getEnvironment().getToolchain();
            for (Map.Entry<Object, Object> toolchainEntry : result.entrySet()) {
                if (toolchainEntry.getValue() == null) {
                    missingLanguages.add((OCLanguageKind)toolchainEntry.getKey());
                    continue;
                }
                if (!CMakeApiProfileGenerationResult.isIncompatible(configuredToolchain.getToolSetKind(), ((CompilerInfo)toolchainEntry.getValue()).compiler.getCompilerKind()) || CMakeWorkspace.getInstance(this.myGenerator.myProject).isInitialized() && !CMakePlainProjectFlavorKt.isInitializedPlainCMakeProject(this.myGenerator.myProject)) continue;
                this.parameters.getListener().messageWithFix(new CMakeMessage(CMakeMessage.MessageLevel.ERROR, null, null, CLionCMakeBundle.message("cmake.toolchain.incompatible", ((OCLanguageKind)toolchainEntry.getKey()).getDisplayName(), ((CompilerInfo)toolchainEntry.getValue()).compiler.getCompilerKind().getDisplayName(), configuredToolchain.getToolSetKind().getDisplayName())), new CMakeOutputConsole.Fix(CLionCMakeBundle.message("cmake.toolchain.incompatible.fix", new Object[0]), () -> OpenCMakeSettingsAction.openProfile(this.myGenerator.myProject, this.parameters.getProfileName())));
            }
            if (missingLanguages.isEmpty()) {
                Map<Object, Object> map = result;
                if (map == null) {
                    CMakeApiProfileGenerationResult.$$$reportNull$$$0(29);
                }
                return map;
            }
        }
        for (Map.Entry<OCLanguageKind, Pair<File, String>> compilerFile : this.findCompilerFiles(cmakeFiles, topLevelSourceDir).entrySet()) {
            File file = (File)compilerFile.getValue().getFirst();
            String langID = (String)compilerFile.getValue().getSecond();
            OCLanguageKind kind = compilerFile.getKey();
            if (!missingLanguages.isEmpty() && !missingLanguages.contains(kind)) continue;
            try {
                CompilerInfo info = this.readCompilerInfo(file, langID);
                result.put(kind, info);
            }
            catch (CMakeException e) {
                this.fail(CLionCMakeBundle.message("cmake.api.cant.be.parsed", file.getPath()));
            }
        }
        Map<Object, Object> map = result;
        if (map == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(30);
        }
        return map;
    }

    @NotNull
    private @NotNull Map<@NotNull OCLanguageKind, @Nullable CompilerInfo> readToolchainsCompilerInfoMap(@NotNull JsonObject toolchainsObj, @NotNull FilesV1 cmakeFiles, @NotNull File topLevelSourceDir) throws CMakeApiException {
        if (toolchainsObj == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(31);
        }
        if (cmakeFiles == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(32);
        }
        if (topLevelSourceDir == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(33);
        }
        ToolchainsV1 toolchains = ToolchainsV1Kt.readToolchainsV1(toolchainsObj, this.myFailLogger);
        HashMap<OCLanguageKind, CompilerInfo> result = new HashMap<OCLanguageKind, CompilerInfo>();
        for (ToolchainV1 toolchain : toolchains.getToolchains()) {
            OCLanguageKind languageKind = CMakeApiProfileGenerationResult.toLanguageKind(toolchain.getLanguage());
            if (languageKind == null) continue;
            String path = toolchain.getCompiler().getPath();
            String id = toolchain.getCompiler().getId();
            if (path == null || id == null) {
                result.put(languageKind, null);
                continue;
            }
            CMakeCompiler compiler = this.getCMakeCompiler(path, id);
            CompilerInfo compilerInfo = new CompilerInfo(compiler, path, toolchain.getSourceFileExtensions(), toolchain.getCompiler().getImplicitLinkFrameworkDirectories(), toolchain.getCompiler().getTarget());
            if (id.equals("NVIDIA")) {
                this.readCudaHostCompiler(cmakeFiles, topLevelSourceDir);
            }
            result.put(languageKind, compilerInfo);
        }
        HashMap<OCLanguageKind, CompilerInfo> hashMap = result;
        if (hashMap == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(34);
        }
        return hashMap;
    }

    @NotNull
    private Map<OCLanguageKind, Pair<File, String>> findCompilerFiles(@NotNull FilesV1 cmakeFiles, @NotNull File topLevelSourceDir) throws CMakeApiException {
        if (cmakeFiles == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(35);
        }
        if (topLevelSourceDir == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(36);
        }
        HashMap<OCLanguageKind, Pair<File, String>> result = new HashMap<OCLanguageKind, Pair<File, String>>();
        for (String path : cmakeFiles.getFiles()) {
            String langID;
            OCLanguageKind kind;
            String name = new File(path).getName();
            Matcher matcher = COMPILER_FILE_PATTERN.matcher(name);
            if (!matcher.find() || (kind = CMakeApiProfileGenerationResult.toLanguageKind(langID = matcher.group(1))) == null) continue;
            File file = CMakeGeneratorUtils.toLocalFile(this.parameters.getEnvironment(), topLevelSourceDir, path);
            result.put(kind, (Pair<File, String>)new Pair((Object)file, (Object)langID));
        }
        HashMap<OCLanguageKind, Pair<File, String>> hashMap = result;
        if (hashMap == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(37);
        }
        return hashMap;
    }

    @NotNull
    private CompilerInfo readCompilerInfo(@NotNull File file, @NotNull String langID) throws CMakeException, CMakeApiException {
        CMakeFile cmakeFile;
        List<String> exePaths;
        if (file == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(38);
        }
        if (langID == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(39);
        }
        if ((exePaths = this.getCMakeVariableValues(cmakeFile = this.parseCMakeFile(file), "CMAKE_" + langID + "_COMPILER")).isEmpty()) {
            this.fail(CLionCMakeBundle.message("cmake.api.no.compiler.executable.for", langID));
        }
        @NlsSafe String path = exePaths.get(0);
        List<String> ids = this.getCMakeVariableValues(cmakeFile, "CMAKE_" + langID + "_COMPILER_ID");
        if (ids.isEmpty()) {
            this.fail(CLionCMakeBundle.message("cmake.api.no.compiler.id.for", langID));
        }
        @NlsSafe String id = ids.get(0);
        List<String> extensions = this.getCMakeVariableValues(cmakeFile, "CMAKE_" + langID + "_SOURCE_FILE_EXTENSIONS");
        if (extensions.isEmpty()) {
            this.fail(CLionCMakeBundle.message("cmake.api.no.extensions.for", langID));
        }
        List<String> implicitFrameworkDirs = this.readImplicitFrameworkDirs(langID, cmakeFile);
        if (id.equals("NVIDIA")) {
            this.readCudaHostCompiler(cmakeFile);
        }
        CMakeCompiler compiler = this.getCMakeCompiler(path, id);
        return new CompilerInfo(compiler, path, extensions, implicitFrameworkDirs);
    }

    private void readCudaHostCompiler(@NotNull FilesV1 cmakeFiles, @NotNull File topLevelSourceDir) throws CMakeApiException {
        if (cmakeFiles == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(40);
        }
        if (topLevelSourceDir == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(41);
        }
        for (Map.Entry<OCLanguageKind, Pair<File, String>> compilerFile : this.findCompilerFiles(cmakeFiles, topLevelSourceDir).entrySet()) {
            File file = (File)compilerFile.getValue().getFirst();
            OCLanguageKind kind = compilerFile.getKey();
            if (!kind.isCuda()) continue;
            try {
                CMakeFile cmakeFile = this.parseCMakeFile(file);
                this.readCudaHostCompiler(cmakeFile);
            }
            catch (CMakeException e) {
                this.fail(CLionCMakeBundle.message("cmake.api.cant.be.parsed", file.getPath()));
            }
        }
    }

    private void readCudaHostCompiler(@NotNull CMakeFile cmakeFile) {
        List<String> hostCompiler;
        if (cmakeFile == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(42);
        }
        if ((hostCompiler = this.getCMakeVariableValues(cmakeFile, "CMAKE_CUDA_HOST_COMPILER")) != null && hostCompiler.size() > 0) {
            this.cudaHostCompiler = hostCompiler.get(0);
        }
    }

    @NotNull
    private List<String> readImplicitFrameworkDirs(@NotNull String langID, @NotNull CMakeFile cmakeFile) throws CMakeApiException {
        List<String> values;
        if (langID == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(43);
        }
        if (cmakeFile == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(44);
        }
        if ((values = this.getCMakeVariableValues(cmakeFile, "CMAKE_" + langID + "_IMPLICIT_LINK_FRAMEWORK_DIRECTORIES")).size() > 1) {
            this.fail(CLionCMakeBundle.message("cmake.api.unexpected.value.for.the.implicit.framework.dirs", values));
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String value : values) {
            CMakeInterpreter.expandListArgument(value.trim(), result);
        }
        result.removeIf(s -> StringUtil.isEmptyOrSpaces((String)s));
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(45);
        }
        return arrayList;
    }

    static boolean getBool(@NotNull JsonObject depObj, @NotNull String flag) {
        JsonElement flagElm;
        if (depObj == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(46);
        }
        if (flag == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(47);
        }
        return (flagElm = depObj.get(flag)) != null && flagElm.getAsBoolean();
    }

    @NotNull
    private Map<File, CMakeGeneratorUtils.CudaTargetInfo> loadCudaInfo(@NotNull Set<File> cudaFolders) throws CMakeApiException {
        if (cudaFolders == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(48);
        }
        Map cudaInfo = FileCollectionFactory.createCanonicalFileMap();
        for (File cudaFile : cudaFolders) {
            try {
                cudaInfo.put(cudaFile, this.loadCudaTargetInfo(cudaFile));
            }
            catch (CMakeException e) {
                this.fail(e);
            }
        }
        Map map = cudaInfo;
        if (map == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(49);
        }
        return map;
    }

    private void loadOsxRoot(@NotNull CacheV2 cache) {
        CMakeVariable osxSysrootVariable;
        if (cache == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(50);
        }
        if ((osxSysrootVariable = cache.getVariables().get("CMAKE_OSX_SYSROOT")) != null && osxSysrootVariable.getValue() != null) {
            this.environmentStateBuilder.withOsxRoot(osxSysrootVariable.getValue());
        }
    }

    @Contract(value="_ -> fail")
    private <T> T fail(@Nls @NotNull String reason) throws CMakeApiException {
        if (reason == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(51);
        }
        return this.myFailLogger.fail(reason);
    }

    @Contract(value="_ -> fail")
    private void fail(@NotNull Throwable cause) throws CMakeApiException {
        if (cause == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(52);
        }
        this.myFailLogger.fail(cause);
    }

    private void reportError(@NotNull Throwable error) {
        if (error == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(53);
        }
        CPPLog.LOG.info(error);
        this.parameters.getListener().message(new CMakeMessage(CMakeMessage.MessageLevel.ERROR, null, null, "CMake File API: " + error.getLocalizedMessage()));
    }

    @NotNull
    private JsonObject loadJsonObject(@NotNull File file) throws CMakeApiException {
        if (file == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(54);
        }
        JsonObject indexObj = null;
        try {
            String indexContents = FileUtil.loadFile((File)file, (Charset)StandardCharsets.UTF_8);
            indexObj = (JsonObject)new Gson().fromJson(indexContents, JsonObject.class);
            if (indexObj == null) {
                this.fail(CLionCMakeBundle.message("cmake.api.failed.to.load.from", file.getPath()));
            }
        }
        catch (JsonSyntaxException e) {
            this.fail(CLionCMakeBundle.message("cmake.api.failed.to.load.from", file.getPath()));
            CPPLog.LOG.warn((Throwable)e);
        }
        catch (IOException e) {
            this.fail(e.getLocalizedMessage());
        }
        JsonObject jsonObject = indexObj;
        if (jsonObject == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(55);
        }
        return jsonObject;
    }

    @NotNull
    static String getName(@NotNull JsonObject target) {
        if (target == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(56);
        }
        String string = target.get("name").getAsString();
        if (string == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(57);
        }
        return string;
    }

    @Override
    @Nullable
    public String getProjectName() {
        return this.myProjectName;
    }

    @Override
    @NotNull
    public Collection<? extends CMakeProfileTargetInfo> getTargetInfos() {
        Collection<CMakeProfileTargetInfo> collection = this.myTargetInfos;
        if (collection == null) {
            CMakeApiProfileGenerationResult.$$$reportNull$$$0(58);
        }
        return collection;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 13, 16, 22, 24, 29, 30, 34, 37, 45, 49, 55, 57, 58 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "generationDir";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonInfo";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentObj";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayName";
                break;
            }
            case 13: 
            case 16: 
            case 22: 
            case 24: 
            case 29: 
            case 30: 
            case 34: 
            case 37: 
            case 45: 
            case 49: 
            case 55: 
            case 57: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/model/CMakeApiProfileGenerationResult";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "objectName";
                break;
            }
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replyDir";
                break;
            }
            case 18: 
            case 20: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infoObj";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolSetKind";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compilerKind";
                break;
            }
            case 27: 
            case 32: 
            case 35: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmakeFiles";
                break;
            }
            case 28: 
            case 33: 
            case 36: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topLevelSourceDir";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolchainsObj";
                break;
            }
            case 38: 
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 39: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "langID";
                break;
            }
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmakeFile";
                break;
            }
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "depObj";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "flag";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cudaFolders";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cache";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeApiProfileGenerationResult";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getJsonArray";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getJsonObject";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "loadReplyFile";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getJsonFilePath";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "readCompilerInfoMap";
                break;
            }
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "readToolchainsCompilerInfoMap";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "findCompilerFiles";
                break;
            }
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "readImplicitFrameworkDirs";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[1] = "loadCudaInfo";
                break;
            }
            case 55: {
                objectArray = objectArray2;
                objectArray2[1] = "loadJsonObject";
                break;
            }
            case 57: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetInfos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "beforeGenerate";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "loadInfo";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "fillFromPreviousModel";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "doLoadInfo";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "loadCMakeTargetsSingleThread";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "loadCMakeTargetsInParallel";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getJsonArray";
                break;
            }
            case 13: 
            case 16: 
            case 22: 
            case 24: 
            case 29: 
            case 30: 
            case 34: 
            case 37: 
            case 45: 
            case 49: 
            case 55: 
            case 57: 
            case 58: {
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getJsonObject";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "loadOptionalReplyFile";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "loadReplyFile";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getJsonFilePath";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isIncompatible";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "readCompilerInfoMap";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "readToolchainsCompilerInfoMap";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "findCompilerFiles";
                break;
            }
            case 38: 
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "readCompilerInfo";
                break;
            }
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "readCudaHostCompiler";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "readImplicitFrameworkDirs";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "getBool";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "loadCudaInfo";
                break;
            }
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "loadOsxRoot";
                break;
            }
            case 51: 
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "fail";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "reportError";
                break;
            }
            case 54: {
                objectArray = objectArray;
                objectArray[2] = "loadJsonObject";
                break;
            }
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 13, 16, 22, 24, 29, 30, 34, 37, 45, 49, 55, 57, 58 -> new IllegalStateException(string);
        };
    }

    static final class CompilerInfo {
        @NotNull
        final CMakeCompiler compiler;
        @NotNull
        final String path;
        @NotNull
        final List<String> extensions;
        @NotNull
        final List<String> implicitFrameworkDirs;
        @Nullable
        final String target;

        private CompilerInfo(@NotNull CMakeCompiler compiler, @NotNull String path, @NotNull List<String> extensions, @NotNull List<String> implicitFrameworkDirs, @Nullable String target) {
            if (compiler == null) {
                CompilerInfo.$$$reportNull$$$0(0);
            }
            if (path == null) {
                CompilerInfo.$$$reportNull$$$0(1);
            }
            if (extensions == null) {
                CompilerInfo.$$$reportNull$$$0(2);
            }
            if (implicitFrameworkDirs == null) {
                CompilerInfo.$$$reportNull$$$0(3);
            }
            this.compiler = compiler;
            this.path = path;
            this.extensions = extensions;
            this.implicitFrameworkDirs = implicitFrameworkDirs;
            this.target = target;
        }

        private CompilerInfo(@NotNull CMakeCompiler compiler, @NotNull String path, @NotNull List<String> extensions, @NotNull List<String> implicitFrameworkDirs) {
            if (compiler == null) {
                CompilerInfo.$$$reportNull$$$0(4);
            }
            if (path == null) {
                CompilerInfo.$$$reportNull$$$0(5);
            }
            if (extensions == null) {
                CompilerInfo.$$$reportNull$$$0(6);
            }
            if (implicitFrameworkDirs == null) {
                CompilerInfo.$$$reportNull$$$0(7);
            }
            this(compiler, path, extensions, implicitFrameworkDirs, null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "compiler";
                    break;
                }
                case 1: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[0] = "path";
                    break;
                }
                case 2: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[0] = "extensions";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[0] = "implicitFrameworkDirs";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/cpp/cmake/model/CMakeApiProfileGenerationResult$CompilerInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

