/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.actions.newFile;

import com.intellij.codeInsight.hint.EditorFragmentComponent;
import com.intellij.core.CoreBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ComponentValidator;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FastUtilHashingStrategies;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Stack;
import com.jetbrains.cidr.cpp.CLionCMakeBundle;
import com.jetbrains.cidr.cpp.CPPLog;
import com.jetbrains.cidr.cpp.cmake.actions.CMakeActionsUtilKt;
import com.jetbrains.cidr.cpp.cmake.actions.newFile.NewFileHandler;
import com.jetbrains.cidr.cpp.cmake.actions.newFile.NewFileTarget;
import com.jetbrains.cidr.cpp.cmake.model.CMakeConfiguration;
import com.jetbrains.cidr.cpp.cmake.model.CMakeTarget;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspaceReloadTask;
import com.jetbrains.cidr.execution.CidrBuildTarget;
import com.jetbrains.cidr.lang.CidrLangBundle;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileCreationException;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileLangBackendHandlerProvider;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCWorkspace;
import com.jetbrains.cmake.CMakeListsFileType;
import com.jetbrains.cmake.interpreter.CMakeInterpreter;
import com.jetbrains.cmake.interpreter.CMakeScope;
import com.jetbrains.cmake.psi.CMakeArgument;
import com.jetbrains.cmake.psi.CMakeCommand;
import com.jetbrains.cmake.psi.CMakeElementFactory;
import com.jetbrains.cmake.psi.CMakeFile;
import com.jetbrains.cmake.psi.util.CMakeFileLocationUtil;
import com.jetbrains.cmake.psi.util.CMakeTargetUtils;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import kotlin.io.path.PathsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class CMakeNewFileHandler
implements NewFileHandler<CMakeNewFileTarget> {
    @NotNull
    private final OCWorkspace myWorkspace;
    @NotNull
    private final CMakeWorkspace myCMakeWorkspace;
    @NotNull
    private final List<File> myConfigurationGenerationDirs;
    @NotNull
    private final List<CMakeNewFileTarget> myTargets;
    @Nullable
    private final PsiFile myBestCMakeList;
    @Nullable
    private NewFileHandler.NewTargetFieldListener<? super CMakeNewFileTarget> myNewTargetListener;

    public CMakeNewFileHandler(@NotNull Project project) {
        if (project == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(0);
        }
        this.myWorkspace = OCWorkspace.getInstance((Project)project);
        this.myCMakeWorkspace = CMakeWorkspace.getInstance(project);
        this.myConfigurationGenerationDirs = this.getConfigurationGenerationDirs();
        Pair<PsiFile, List<CMakeNewFileTarget>> result = this.readTargetsAndFiles(project, this.myCMakeWorkspace);
        this.myTargets = (List)result.second;
        this.myBestCMakeList = (PsiFile)result.first;
    }

    @TestOnly
    public CMakeNewFileHandler(@Nullable File configurationGenerationDir, @NotNull Project project) {
        if (project == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(1);
        }
        this.myWorkspace = OCWorkspace.getInstance((Project)project);
        this.myCMakeWorkspace = CMakeWorkspace.getInstance(project);
        this.myConfigurationGenerationDirs = Collections.singletonList(configurationGenerationDir);
        Pair<PsiFile, List<CMakeNewFileTarget>> result = this.readTargetsAndFiles(project, this.myCMakeWorkspace);
        this.myTargets = (List)result.second;
        this.myBestCMakeList = (PsiFile)result.first;
    }

    @NotNull
    private Pair<PsiFile, List<CMakeNewFileTarget>> readTargetsAndFiles(@NotNull Project project, @NotNull CMakeWorkspace workspace) {
        if (project == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(2);
        }
        if (workspace == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(3);
        }
        String projectPath = project.getBasePath();
        ArrayList<CMakeNewFileTarget> targets = new ArrayList<CMakeNewFileTarget>();
        PsiFile bestFile = null;
        int bestScore = -1;
        for (File file : workspace.getCMakeDependencyFiles()) {
            int score;
            PsiFile psiFile;
            VirtualFile vf = LocalFileSystem.getInstance().findFileByIoFile(file);
            if (projectPath != null && !PathsKt.getInvariantSeparatorsPathString((Path)file.toPath()).startsWith(projectPath) || vf == null || !FileIndexFacade.getInstance((Project)project).isInContent(vf) || this.isInConfigurationGenerationDir(file) || !((psiFile = PsiManager.getInstance((Project)project).findFile(vf)) instanceof CMakeFile)) continue;
            Path depFilePath = psiFile.getVirtualFile().toNioPath();
            int n = score = Objects.equals(depFilePath.getRoot(), workspace.getProjectPath().getRoot()) ? depFilePath.relativize(workspace.getProjectPath()).normalize().getNameCount() : depFilePath.normalize().getNameCount() + workspace.getProjectPath().normalize().getNameCount();
            if (bestScore == -1 || bestScore > score) {
                bestFile = psiFile;
                bestScore = score;
            }
            CMakeNewFileHandler.collectTargets(targets, (PsiElement)psiFile);
        }
        CMakeNewFileHandler.sortTargets(targets);
        return new Pair(bestFile, Collections.unmodifiableList(targets));
    }

    public static void collectTargets(@NotNull List<CMakeNewFileTarget> targets, @NotNull PsiElement cf) {
        if (targets == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(4);
        }
        if (cf == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(5);
        }
        PsiDocumentManager.getInstance((Project)cf.getProject()).commitAllDocuments();
        final VarDependencies varDependencies = new VarDependencies();
        final Stack branchVarDependenciesStack = new Stack();
        final Stack controlVarDependenciesStack = new Stack();
        final MultiMap commands2Targets = MultiMap.createSet();
        final HashSet targetSet = new HashSet();
        CMakeInterpreter.interpret(cf, new CMakeInterpreter.Listener(){

            @Override
            public void beforeCommand(@NotNull CMakeCommand cmd, @NotNull CMakeScope scope) {
                String firstArg;
                String cmdName;
                if (cmd == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (scope == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((1.isTargetCommand(cmdName = cmd.getName().toLowerCase(Locale.getDefault())) || 1.isTargetCommand(cmdName, "cuda_") || 1.isTargetCommand(cmdName, "qt_") || 1.isTargetCommand(cmdName, "qt6_")) && cmd.canAppendArguments() && !CMakeTargetUtils.isTargetAlias(cmd)) {
                    final String targetName = CMakeNewFileHandler.getEffectiveFirstArg(cmd, scope);
                    if (targetName != null) {
                        targetSet.add(new CMakeNewFileTarget(cmd, Collections.singletonList(targetName), targetName, 1));
                        CMakeNewFileHandler.processCommandDependencies(cmd, varDependencies, new CommandDependencyHandler(){

                            @Override
                            public void handleDependency(@NotNull CommandInfo commandInfo) {
                                if (commandInfo == null) {
                                    1.$$$reportNull$$$0(0);
                                }
                                commands2Targets.putValue((Object)commandInfo, (Object)targetName);
                            }

                            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandInfo", "com/jetbrains/cidr/cpp/cmake/actions/newFile/CMakeNewFileHandler$1$1", "handleDependency"));
                            }
                        });
                    }
                } else if ("set".equals(cmdName) && (firstArg = CMakeNewFileHandler.getEffectiveFirstArg(cmd, scope)) != null) {
                    String varRef = "${" + firstArg + "}";
                    ArrayList<CommandInfo> deps = new ArrayList<CommandInfo>();
                    deps.add(new CommandInfo(varRef, cmd));
                    CMakeNewFileHandler.processCommandDependencies(cmd, varDependencies, deps::add);
                    varDependencies.set(varRef, deps);
                }
            }

            private static boolean isTargetCommand(@NotNull @NlsSafe String command) {
                if (command == null) {
                    1.$$$reportNull$$$0(2);
                }
                return 1.isTargetCommand(command, "");
            }

            private static boolean isTargetCommand(@NotNull @NlsSafe String command, @NotNull @NlsSafe String prefix) {
                if (command == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (prefix == null) {
                    1.$$$reportNull$$$0(4);
                }
                return command.equals(prefix + "add_executable") || command.equals(prefix + "add_library");
            }

            @Override
            public void onEnterIf() {
                this.beforeControlStructure();
            }

            @Override
            public void onExitIf() {
                this.afterControlStructure();
            }

            @Override
            public void onEnterWhile() {
                this.beforeControlStructure();
            }

            @Override
            public void onExitWhile() {
                this.afterControlStructure();
            }

            @Override
            public void onEnterForeach() {
                this.beforeControlStructure();
            }

            @Override
            public void onExitForeach() {
                this.afterControlStructure();
            }

            private void afterControlStructure() {
                varDependencies.setAll((VarDependencies)controlVarDependenciesStack.pop());
            }

            private void beforeControlStructure() {
                controlVarDependenciesStack.push((Object)new VarDependencies(varDependencies));
            }

            @Override
            public boolean onEnterLoop(int iteration) {
                return true;
            }

            @Override
            public void onExitLoop() {
                ((VarDependencies)controlVarDependenciesStack.peek()).addAll(varDependencies);
            }

            @Override
            public void onEnterFunction() {
                this.beforeControlStructure();
            }

            @Override
            public void onExitFunction() {
                this.afterControlStructure();
            }

            @Override
            public void onEnterMacro() {
                this.beforeControlStructure();
            }

            @Override
            public void onExitMacro() {
                this.afterControlStructure();
            }

            @Override
            public void onEnterBlock() {
                this.beforeControlStructure();
            }

            @Override
            public void onExitBlock() {
                this.afterControlStructure();
            }

            @Override
            public boolean onEnterBranch(int branch) {
                branchVarDependenciesStack.push((Object)new VarDependencies(varDependencies));
                return true;
            }

            @Override
            public void onExitBranch() {
                ((VarDependencies)controlVarDependenciesStack.peek()).addAll(varDependencies);
                varDependencies.setAll((VarDependencies)branchVarDependenciesStack.pop());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "cmd";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "scope";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "command";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "prefix";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/actions/newFile/CMakeNewFileHandler$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "beforeCommand";
                        break;
                    }
                    case 2: 
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "isTargetCommand";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        targets.addAll(targetSet);
        for (Map.Entry c2ts : commands2Targets.entrySet()) {
            CommandInfo info = (CommandInfo)c2ts.getKey();
            String varRef = info.varRef;
            CMakeCommand command = info.command;
            ArrayList<String> targetNames = new ArrayList<String>((Collection)c2ts.getValue());
            targetNames.sort(String.CASE_INSENSITIVE_ORDER);
            String targetsString = StringUtil.join(targetNames, (String)", ");
            String name = targetsString + " <- " + varRef;
            int selectionPriority = targetNames.size() > 1 ? 0 : 2;
            targets.add(new CMakeNewFileTarget(command, targetNames, name, selectionPriority));
        }
    }

    private boolean isInConfigurationGenerationDir(@NotNull File file) {
        if (file == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(6);
        }
        return ContainerUtil.exists(this.myConfigurationGenerationDirs, dir -> FileUtil.isAncestor((File)dir, (File)file, (boolean)true));
    }

    @NotNull
    private List<File> getConfigurationGenerationDirs() {
        List list2 = ContainerUtil.map(this.myCMakeWorkspace.getProfileInfos(), info -> info.getGenerationDir());
        if (list2 == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(7);
        }
        return list2;
    }

    private static void processCommandDependencies(@NotNull CMakeCommand cmd, @NotNull VarDependencies varDependencies, @NotNull CommandDependencyHandler handler2) {
        List<CMakeArgument> argumentList;
        if (cmd == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(8);
        }
        if (varDependencies == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(9);
        }
        if (handler2 == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(10);
        }
        if ((argumentList = cmd.getCMakeArgumentList()) != null) {
            for (int i = 1; i < argumentList.size(); ++i) {
                CMakeArgument arg = argumentList.get(i);
                String varRef = arg.getValue();
                Collection<CommandInfo> dependencies = varDependencies.get(varRef);
                for (CommandInfo dependency : dependencies) {
                    handler2.handleDependency(dependency);
                }
            }
        }
    }

    @Nullable
    private static String getEffectiveFirstArg(@NotNull CMakeCommand cmd, @NotNull CMakeScope scope) {
        List<CMakeArgument> args;
        CMakeArgument firstArg;
        if (cmd == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(11);
        }
        if (scope == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(12);
        }
        if ((firstArg = (CMakeArgument)ContainerUtil.getFirstItem(args = cmd.getCMakeArgumentList())) != null) {
            ArrayList<String> firstArgExpanded = new ArrayList<String>();
            CMakeInterpreter.expandArguments(Collections.singletonList(firstArg), scope, firstArgExpanded);
            String result = null;
            if (!firstArgExpanded.isEmpty()) {
                ArrayList<String> effectiveArgs = new ArrayList<String>();
                CMakeInterpreter.expandArguments(args, scope, effectiveArgs);
                result = (String)ContainerUtil.getFirstItem(effectiveArgs);
            }
            return result == null ? firstArg.getValue() : result;
        }
        return null;
    }

    @Override
    @NotNull
    public List<CMakeNewFileTarget> getTargets() {
        List<CMakeNewFileTarget> list2 = this.myTargets;
        if (list2 == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(13);
        }
        return list2;
    }

    @Override
    @Nullable
    public JComponent createPreviewComponent() {
        if (this.myBestCMakeList == null) {
            return null;
        }
        Project project = this.myCMakeWorkspace.getProject();
        MyEditorTextField field2 = new MyEditorTextField(project);
        if (!this.myTargets.isEmpty()) {
            field2.setTarget(this.myTargets.get(0));
        }
        return field2;
    }

    @Override
    @Nullable
    public JComponent createNewTargetComponent(Disposable parentDisposable) {
        if (this.myBestCMakeList == null) {
            return null;
        }
        NewTargetField field2 = new NewTargetField(this.myBestCMakeList, this.myCMakeWorkspace.getProject(), this, this.myCMakeWorkspace, parentDisposable);
        NewTargetField.NewTargetFieldListener listener2 = new NewTargetField.NewTargetFieldListener(){

            @Override
            public void focused(@NotNull NewTargetField.NewTargetFieldInfo info) {
                CMakeNewFileNewTarget target;
                if (info == null) {
                    2.$$$reportNull$$$0(0);
                }
                if ((target = info.getTarget()) != null && CMakeNewFileHandler.this.myNewTargetListener != null) {
                    CMakeNewFileHandler.this.myNewTargetListener.focused(target);
                }
            }

            @Override
            public void infoChanged(@NotNull NewTargetField.NewTargetFieldInfo info) {
                CMakeNewFileNewTarget target;
                if (info == null) {
                    2.$$$reportNull$$$0(1);
                }
                if ((target = info.getTarget()) != null && CMakeNewFileHandler.this.myNewTargetListener != null) {
                    CMakeNewFileHandler.this.myNewTargetListener.changed(target);
                }
            }

            @Override
            public void targetAdded(@NotNull NewTargetField.NewTargetFieldInfo info) {
                CMakeNewFileNewTarget target;
                if (info == null) {
                    2.$$$reportNull$$$0(2);
                }
                if ((target = info.getTarget()) != null && CMakeNewFileHandler.this.myNewTargetListener != null) {
                    CMakeNewFileHandler.this.myNewTargetListener.added(target);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "info";
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/actions/newFile/CMakeNewFileHandler$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "focused";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "infoChanged";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "targetAdded";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        field2.setDelegateListener(listener2);
        return field2;
    }

    @Override
    public void setNewTargetListener(@NotNull NewFileHandler.NewTargetFieldListener<? super CMakeNewFileTarget> listener2) {
        if (listener2 == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(14);
        }
        this.myNewTargetListener = listener2;
    }

    @Override
    public void updatePreviewComponent(@NotNull JComponent previewComponent, @Nullable CMakeNewFileTarget selectedTarget) {
        if (previewComponent == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(15);
        }
        previewComponent.setVisible(selectedTarget != null);
        if (selectedTarget != null) {
            MyEditorTextField etf = (MyEditorTextField)((Object)previewComponent);
            etf.setTarget(selectedTarget);
        }
    }

    @Override
    public void handleNewFiles(@NotNull List<Integer> selectedIndices, @NotNull List<VirtualFile> addedFiles) {
        if (selectedIndices == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(16);
        }
        if (addedFiles == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(17);
        }
        this.handleNewTargetFiles(ContainerUtil.map(selectedIndices, i -> this.myTargets.get((int)i)), addedFiles);
    }

    @Override
    public void handleNewTargetFiles(@NotNull List<CMakeNewFileTarget> selectedTargets, @NotNull List<VirtualFile> addedFiles) {
        if (selectedTargets == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(18);
        }
        if (addedFiles == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(19);
        }
        boolean changed = false;
        for (CMakeNewFileTarget target : selectedTargets) {
            changed |= target.addFiles(addedFiles);
        }
        if (changed) {
            this.myCMakeWorkspace.scheduleReload(new CMakeWorkspaceReloadTask());
        }
    }

    @Override
    @NotNull
    public List<CMakeNewFileTarget> bestTargets(@Nullable PsiFile sampleFile, @Nullable String currentPath) {
        List<CMakeNewFileTarget> targets = this.myTargets;
        if (sampleFile != null) {
            ArrayList<CMakeNewFileTarget> result = new ArrayList<CMakeNewFileTarget>();
            VirtualFile vf = OCNewFileLangBackendHandlerProvider.getHandler().getVirtualFile(sampleFile);
            OCWorkspace workspace = OCWorkspace.getInstance((Project)sampleFile.getProject());
            CMakeWorkspace cmakeWorkspace = CMakeWorkspace.getInstance(sampleFile.getProject());
            for (CMakeTarget ct : CMakeNewFileHandler.collectUniqueTargets(workspace, cmakeWorkspace, vf)) {
                CMakeNewFileTarget t = CMakeNewFileHandler.bestTargetByCMakeTarget(targets, ct);
                if (t == null) continue;
                result.add(t);
            }
            if (!result.isEmpty()) {
                CMakeNewFileHandler.sortTargets(result);
                ArrayList<CMakeNewFileTarget> arrayList = result;
                if (arrayList == null) {
                    CMakeNewFileHandler.$$$reportNull$$$0(20);
                }
                return arrayList;
            }
        }
        Pair best = null;
        if (currentPath != null) {
            List<CMakeNewFileTarget> bestByPath = this.bestTargetsByCurrentDirFiles(targets, currentPath);
            if (bestByPath.isEmpty()) {
                bestByPath = targets;
            }
            List ts = ContainerUtil.map(bestByPath, target -> Pair.create((Object)target, (Object)Utils.getRelativePath(target.myPointer.getContainingFile(), currentPath)));
            for (Pair t : ts) {
                if (!CMakeNewFileHandler.isBetterTarget((Pair<CMakeNewFileTarget, String>)t, best)) continue;
                best = t;
            }
        }
        List<CMakeNewFileTarget> list2 = best == null ? Collections.emptyList() : Collections.singletonList((CMakeNewFileTarget)best.first);
        if (list2 == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(21);
        }
        return list2;
    }

    @NotNull
    private List<CMakeNewFileTarget> bestTargetsByCurrentDirFiles(@NotNull List<CMakeNewFileTarget> fileTargets, @NotNull String currentPath) {
        if (fileTargets == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(22);
        }
        if (currentPath == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(23);
        }
        Object2IntOpenCustomHashMap targetToFileCount = new Object2IntOpenCustomHashMap(FastUtilHashingStrategies.adaptAsNotNull((HashingStrategy)HashingStrategy.identity()));
        VirtualFile currentDir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(currentPath));
        if (currentDir != null && currentDir.isDirectory()) {
            for (VirtualFile file : currentDir.getChildren()) {
                if (file.isDirectory()) continue;
                for (CMakeTarget t2 : CMakeNewFileHandler.collectUniqueTargets(this.myWorkspace, this.myCMakeWorkspace, file)) {
                    int i = targetToFileCount.getInt((Object)t2);
                    targetToFileCount.put((Object)t2, i + 1);
                }
            }
        }
        ArrayList cts = new ArrayList();
        targetToFileCount.forEach((t, count) -> cts.add(Pair.create((Object)t, (Object)count)));
        if (cts.isEmpty()) {
            List<CMakeNewFileTarget> list2 = Collections.emptyList();
            if (list2 == null) {
                CMakeNewFileHandler.$$$reportNull$$$0(24);
            }
            return list2;
        }
        cts.sort((o1, o2) -> Comparing.compare((Comparable)((Integer)o2.second), (Comparable)((Integer)o1.second)));
        ArrayList<CMakeNewFileTarget> result = new ArrayList<CMakeNewFileTarget>();
        int maxCount = (Integer)((Pair)cts.get((int)0)).second;
        for (Pair ct : cts) {
            if ((Integer)ct.second < maxCount) break;
            CMakeNewFileTarget target = CMakeNewFileHandler.bestTargetByCMakeTarget(fileTargets, (CidrBuildTarget<CMakeConfiguration>)((CidrBuildTarget)ct.first));
            if (target == null) continue;
            result.add(target);
        }
        CMakeNewFileHandler.sortTargets(result);
        ArrayList<CMakeNewFileTarget> arrayList = result;
        if (arrayList == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(25);
        }
        return arrayList;
    }

    @Nullable
    private static CMakeNewFileTarget bestTargetByCMakeTarget(@NotNull List<CMakeNewFileTarget> targets, @NotNull CidrBuildTarget<CMakeConfiguration> cMakeTarget) {
        if (targets == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(26);
        }
        if (cMakeTarget == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(27);
        }
        String tName = cMakeTarget.getName();
        CMakeNewFileTarget best = null;
        for (CMakeNewFileTarget candidate : targets) {
            List<String> names = candidate.getTargetNames();
            if (names.size() != 1 || !names.get(0).equals(tName)) continue;
            if (best == null) {
                best = candidate;
                continue;
            }
            int so = CMakeNewFileTarget.selectionOrder().compare(candidate, best);
            if (so <= 0 && (so != 0 || CMakeNewFileTarget.fileOrder().compare(candidate, best) <= 0)) continue;
            best = candidate;
        }
        return best;
    }

    @NotNull
    private static Set<CMakeTarget> collectUniqueTargets(OCWorkspace ws, @NotNull CMakeWorkspace cmake, @Nullable VirtualFile file) {
        if (cmake == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(28);
        }
        ReferenceOpenHashSet result = new ReferenceOpenHashSet();
        if (file == null) {
            ReferenceOpenHashSet referenceOpenHashSet = result;
            if (referenceOpenHashSet == null) {
                CMakeNewFileHandler.$$$reportNull$$$0(29);
            }
            return referenceOpenHashSet;
        }
        for (OCResolveConfiguration c : ws.getConfigurationsForFile(file)) {
            CMakeConfiguration cmakeConfig = cmake.getCMakeConfigurationFor(c);
            if (cmakeConfig == null) continue;
            result.add(cmakeConfig.getTarget());
        }
        ReferenceOpenHashSet referenceOpenHashSet = result;
        if (referenceOpenHashSet == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(30);
        }
        return referenceOpenHashSet;
    }

    private static boolean isBetterTarget(@NotNull Pair<CMakeNewFileTarget, String> candidate, @Nullable Pair<CMakeNewFileTarget, String> best) {
        int bLength;
        boolean bDots;
        boolean bAbs;
        if (candidate == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(31);
        }
        if (best == null) {
            return true;
        }
        String cp = (String)candidate.second;
        String bp = (String)best.second;
        if (Objects.equals(cp, bp)) {
            CMakeNewFileTarget ct = (CMakeNewFileTarget)candidate.first;
            CMakeNewFileTarget bt = (CMakeNewFileTarget)best.first;
            int so = CMakeNewFileTarget.selectionOrder().compare(ct, bt);
            if (so != 0) {
                return so > 0;
            }
            int no = CMakeNewFileTarget.nameOrder().compare(ct, bt);
            return no != 0 ? no < 0 : CMakeNewFileTarget.fileOrder().compare(ct, bt) > 0;
        }
        boolean cAbs = FileUtil.isAbsolute((String)cp);
        if (cAbs != (bAbs = FileUtil.isAbsolute((String)bp))) {
            return !cAbs;
        }
        boolean cDots = cp.startsWith("..");
        if (cDots != (bDots = bp.startsWith(".."))) {
            return !cDots;
        }
        boolean cCurrentDir = cp.isEmpty();
        boolean bCurrentDir = bp.isEmpty();
        if (cCurrentDir || bCurrentDir) {
            return !bCurrentDir;
        }
        int cLength = cp.split("/").length;
        return cLength < (bLength = bp.split("/").length);
    }

    private static void sortTargets(@NotNull List<CMakeNewFileTarget> targets) {
        if (targets == null) {
            CMakeNewFileHandler.$$$reportNull$$$0(32);
        }
        targets.sort(CMakeNewFileTarget.visualOrder());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 13, 20, 21, 24, 25, 29, 30 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workspace";
                break;
            }
            case 4: 
            case 26: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targets";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cf";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: 
            case 13: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/actions/newFile/CMakeNewFileHandler";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmd";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varDependencies";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "previewComponent";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedIndices";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedFiles";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedTargets";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileTargets";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentPath";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cMakeTarget";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmake";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/actions/newFile/CMakeNewFileHandler";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationGenerationDirs";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargets";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "bestTargets";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "bestTargetsByCurrentDirFiles";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "collectUniqueTargets";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readTargetsAndFiles";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectTargets";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isInConfigurationGenerationDir";
                break;
            }
            case 7: 
            case 13: 
            case 20: 
            case 21: 
            case 24: 
            case 25: 
            case 29: 
            case 30: {
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processCommandDependencies";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getEffectiveFirstArg";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setNewTargetListener";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "updatePreviewComponent";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "handleNewFiles";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "handleNewTargetFiles";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "bestTargetsByCurrentDirFiles";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "bestTargetByCMakeTarget";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "collectUniqueTargets";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "isBetterTarget";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "sortTargets";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 13, 20, 21, 24, 25, 29, 30 -> new IllegalStateException(string);
        };
    }

    private static class VarDependencies {
        final MultiMap<String, CommandInfo> myMap;

        VarDependencies() {
            this.myMap = MultiMap.createSet();
        }

        VarDependencies(@NotNull VarDependencies original) {
            if (original == null) {
                VarDependencies.$$$reportNull$$$0(0);
            }
            this();
            this.myMap.putAllValues(original.myMap);
        }

        @NotNull
        public Collection<CommandInfo> get(@NotNull String varRef) {
            if (varRef == null) {
                VarDependencies.$$$reportNull$$$0(1);
            }
            Collection collection = this.myMap.get((Object)varRef);
            if (collection == null) {
                VarDependencies.$$$reportNull$$$0(2);
            }
            return collection;
        }

        public void set(@NotNull String varRef, @NotNull Collection<CommandInfo> deps) {
            if (varRef == null) {
                VarDependencies.$$$reportNull$$$0(3);
            }
            if (deps == null) {
                VarDependencies.$$$reportNull$$$0(4);
            }
            this.myMap.remove((Object)varRef);
            this.myMap.put((Object)varRef, deps);
        }

        public void setAll(@NotNull VarDependencies original) {
            if (original == null) {
                VarDependencies.$$$reportNull$$$0(5);
            }
            this.myMap.clear();
            this.addAll(original);
        }

        public void addAll(@NotNull VarDependencies original) {
            if (original == null) {
                VarDependencies.$$$reportNull$$$0(6);
            }
            this.myMap.putAllValues(original.myMap);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "varRef";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/actions/newFile/CMakeNewFileHandler$VarDependencies";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deps";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/actions/newFile/CMakeNewFileHandler$VarDependencies";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "get";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "set";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "setAll";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "addAll";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static final class CommandInfo {
        @NotNull
        final String varRef;
        @NotNull
        final CMakeCommand command;

        private CommandInfo(@NotNull String name, @NotNull CMakeCommand command) {
            if (name == null) {
                CommandInfo.$$$reportNull$$$0(0);
            }
            if (command == null) {
                CommandInfo.$$$reportNull$$$0(1);
            }
            this.varRef = name;
            this.command = command;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CommandInfo that = (CommandInfo)o;
            if (!this.varRef.equals(that.varRef)) {
                return false;
            }
            return this.command.equals(that.command);
        }

        public int hashCode() {
            int result = this.varRef.hashCode();
            result = 31 * result + this.command.hashCode();
            return result;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "name";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "command";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/cpp/cmake/actions/newFile/CMakeNewFileHandler$CommandInfo";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class CMakeNewFileTarget
    implements NewFileTarget {
        @NotNull
        private final SmartPsiElementPointer<CMakeCommand> myPointer;
        @NotNull
        private final List<String> myTargetNames;
        @NotNull
        @NlsSafe
        private final String myName;
        @NotNull
        @NlsSafe
        private final String myAdditionalInfo;
        private final int mySelectionPriority;
        private static final Comparator<CMakeNewFileTarget> FILE_ORDER = (o1, o2) -> {
            CMakeCommand c1 = o1.getCommand();
            CMakeCommand c2 = o2.getCommand();
            if (c1 == null) {
                return c2 == null ? 0 : 1;
            }
            if (c2 == null) {
                return -1;
            }
            return Integer.compare(c1.getTextOffset(), c2.getTextOffset());
        };
        private static final Comparator<CMakeNewFileTarget> NAME_ORDER = (o1, o2) -> String.CASE_INSENSITIVE_ORDER.compare(o1.getSingleTargetNameOrFullName(), o2.getSingleTargetNameOrFullName());
        private static final Comparator<CMakeNewFileTarget> SELECTION_ORDER = Comparator.comparingInt(CMakeNewFileTarget::getSelectionPriority);
        private static final Comparator<CMakeNewFileTarget> VISUAL_ORDER = (o1, o2) -> {
            int compare = NAME_ORDER.compare((CMakeNewFileTarget)o1, (CMakeNewFileTarget)o2);
            return compare != 0 ? compare : FILE_ORDER.compare((CMakeNewFileTarget)o1, (CMakeNewFileTarget)o2);
        };

        public CMakeNewFileTarget(@NotNull CMakeCommand command, @NotNull List<String> targetNames, @NotNull String name, int selectionPriority) {
            if (command == null) {
                CMakeNewFileTarget.$$$reportNull$$$0(0);
            }
            if (targetNames == null) {
                CMakeNewFileTarget.$$$reportNull$$$0(1);
            }
            if (name == null) {
                CMakeNewFileTarget.$$$reportNull$$$0(2);
            }
            this(command, targetNames, name, selectionPriority, CMakeFileLocationUtil.getLocationInFile(command, true));
        }

        public CMakeNewFileTarget(@NotNull CMakeCommand command, @NotNull List<String> targetNames, @NotNull String name, int selectionPriority, @NotNull String additionalInfo) {
            if (command == null) {
                CMakeNewFileTarget.$$$reportNull$$$0(3);
            }
            if (targetNames == null) {
                CMakeNewFileTarget.$$$reportNull$$$0(4);
            }
            if (name == null) {
                CMakeNewFileTarget.$$$reportNull$$$0(5);
            }
            if (additionalInfo == null) {
                CMakeNewFileTarget.$$$reportNull$$$0(6);
            }
            this.mySelectionPriority = selectionPriority;
            this.myTargetNames = new ArrayList<String>(targetNames);
            this.myName = name;
            this.myPointer = SmartPointerManager.getInstance((Project)command.getProject()).createSmartPsiElementPointer((PsiElement)command);
            this.myAdditionalInfo = additionalInfo;
        }

        @Override
        public boolean addFiles(@NotNull List<VirtualFile> addedFiles) {
            if (addedFiles == null) {
                CMakeNewFileTarget.$$$reportNull$$$0(7);
            }
            VirtualFile virtualFile = this.myPointer.getVirtualFile();
            virtualFile.refresh(false, false);
            if (!virtualFile.isWritable()) {
                throw new OCNewFileCreationException(CoreBundle.message((String)"cannot.modify.a.read.only.file", (Object[])new Object[]{virtualFile.getPresentableUrl()}), CLionCMakeBundle.message("file.is.read.only.error.title", virtualFile.getPresentableName()));
            }
            CMakeCommand command = this.getCommand();
            if (command == null) {
                return false;
            }
            PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)command.getProject());
            Document document = psiDocumentManager.getDocument(command.getContainingFile());
            if (document != null && psiDocumentManager.isUncommited(document)) {
                psiDocumentManager.commitDocument(document);
            }
            boolean changed = false;
            for (VirtualFile file : addedFiles) {
                String fp = file.getPath();
                String resultPath = Utils.getRelativePath(command.getContainingFile(), fp);
                command.appendArgument(resultPath, true);
                changed = true;
            }
            if (changed && document != null) {
                psiDocumentManager.commitDocument(document);
                psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
            }
            return changed;
        }

        public int getSelectionPriority() {
            return this.mySelectionPriority;
        }

        @NotNull
        public List<String> getTargetNames() {
            List<String> list2 = this.myTargetNames;
            if (list2 == null) {
                CMakeNewFileTarget.$$$reportNull$$$0(8);
            }
            return list2;
        }

        @Override
        @NotNull
        @NlsSafe
        public String getName() {
            String string = this.myName;
            if (string == null) {
                CMakeNewFileTarget.$$$reportNull$$$0(9);
            }
            return string;
        }

        @Override
        @NotNull
        @Nls
        public String getAdditionalInfo() {
            String string = this.myAdditionalInfo;
            if (string == null) {
                CMakeNewFileTarget.$$$reportNull$$$0(10);
            }
            return string;
        }

        @Nullable
        private CMakeCommand getCommand() {
            CMakeCommand command = (CMakeCommand)this.myPointer.getElement();
            return command != null && command.isValid() ? command : null;
        }

        @NlsSafe
        public String toString() {
            return this.getName();
        }

        @NotNull
        public static Comparator<CMakeNewFileTarget> visualOrder() {
            Comparator<CMakeNewFileTarget> comparator = VISUAL_ORDER;
            if (comparator == null) {
                CMakeNewFileTarget.$$$reportNull$$$0(11);
            }
            return comparator;
        }

        @NotNull
        public static Comparator<CMakeNewFileTarget> nameOrder() {
            Comparator<CMakeNewFileTarget> comparator = NAME_ORDER;
            if (comparator == null) {
                CMakeNewFileTarget.$$$reportNull$$$0(12);
            }
            return comparator;
        }

        @NotNull
        public static Comparator<CMakeNewFileTarget> selectionOrder() {
            Comparator<CMakeNewFileTarget> comparator = SELECTION_ORDER;
            if (comparator == null) {
                CMakeNewFileTarget.$$$reportNull$$$0(13);
            }
            return comparator;
        }

        @NotNull
        public static Comparator<CMakeNewFileTarget> fileOrder() {
            Comparator<CMakeNewFileTarget> comparator = FILE_ORDER;
            if (comparator == null) {
                CMakeNewFileTarget.$$$reportNull$$$0(14);
            }
            return comparator;
        }

        @NotNull
        private String getSingleTargetNameOrFullName() {
            String string = this.myTargetNames.size() == 1 ? this.myTargetNames.get(0) : this.myName;
            if (string == null) {
                CMakeNewFileTarget.$$$reportNull$$$0(15);
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CMakeNewFileTarget target = (CMakeNewFileTarget)o;
            return this.myPointer.equals(target.myPointer);
        }

        public int hashCode() {
            return this.myPointer.hashCode();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 8, 9, 10, 11, 12, 13, 14, 15 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "command";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetNames";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "additionalInfo";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "addedFiles";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/actions/newFile/CMakeNewFileHandler$CMakeNewFileTarget";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/actions/newFile/CMakeNewFileHandler$CMakeNewFileTarget";
                    break;
                }
                case 8: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTargetNames";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 10: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getAdditionalInfo";
                    break;
                }
                case 11: {
                    objectArray = objectArray2;
                    objectArray2[1] = "visualOrder";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "nameOrder";
                    break;
                }
                case 13: {
                    objectArray = objectArray2;
                    objectArray2[1] = "selectionOrder";
                    break;
                }
                case 14: {
                    objectArray = objectArray2;
                    objectArray2[1] = "fileOrder";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSingleTargetNameOrFullName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "addFiles";
                    break;
                }
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 8, 9, 10, 11, 12, 13, 14, 15 -> new IllegalStateException(string);
            };
        }
    }

    private static interface CommandDependencyHandler {
        public void handleDependency(@NotNull CommandInfo var1);
    }

    private static class MyEditorTextField
    extends EditorTextField {
        private CMakeNewFileTarget myTarget;

        MyEditorTextField(Project project) {
            super(null, project, CMakeListsFileType.INSTANCE, true, false);
            this.setFont(EditorFontType.getGlobalPlainFont());
            this.setPreferredSize(new Dimension(500, 130));
            this.setMinimumSize(new Dimension(500, 130));
            this.setFocusable(false);
            this.setFocusTraversalPolicyProvider(false);
        }

        @NotNull
        protected EditorEx createEditor() {
            CMakeNewFileTarget target = this.myTarget;
            if (target != null) {
                this.initDocument(target);
            }
            EditorEx editorEx = MyEditorTextField.configureNewEditor(target, super.createEditor());
            if (editorEx == null) {
                MyEditorTextField.$$$reportNull$$$0(0);
            }
            return editorEx;
        }

        private static EditorEx configureNewEditor(CMakeNewFileTarget target, @NotNull EditorEx editor) {
            if (editor == null) {
                MyEditorTextField.$$$reportNull$$$0(1);
            }
            editor.setBackgroundColor(EditorFragmentComponent.getBackgroundColor((Editor)editor));
            editor.setVerticalScrollbarVisible(true);
            editor.setHorizontalScrollbarVisible(true);
            if (target != null) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (!editor.isDisposed()) {
                        MyEditorTextField.updateWithTarget((Editor)editor, target);
                    }
                });
            }
            return editor;
        }

        public void setTarget(@NotNull CMakeNewFileTarget target) {
            if (target == null) {
                MyEditorTextField.$$$reportNull$$$0(2);
            }
            this.myTarget = target;
            this.initDocument(target);
            MyEditorTextField.updateWithTarget(this.getEditor(), target);
        }

        private static void updateWithTarget(@Nullable Editor editor, @NotNull CMakeNewFileTarget target) {
            if (target == null) {
                MyEditorTextField.$$$reportNull$$$0(3);
            }
            if (editor == null) {
                return;
            }
            CMakeCommand element = target.getCommand();
            if (element == null) {
                return;
            }
            int startOffset = element.getTextOffset();
            editor.getCaretModel().moveToOffset(startOffset);
            ScrollingModel scrollingModel = editor.getScrollingModel();
            scrollingModel.disableAnimation();
            scrollingModel.scrollToCaret(ScrollType.CENTER);
            scrollingModel.enableAnimation();
            MarkupModel model = editor.getMarkupModel();
            model.removeAllHighlighters();
            TextRange range = element.getTextRange();
            model.addRangeHighlighter(EditorColors.SEARCH_RESULT_ATTRIBUTES, range.getStartOffset(), range.getEndOffset(), 5500, HighlighterTargetArea.EXACT_RANGE);
        }

        private void initDocument(@NotNull CMakeNewFileTarget target) {
            PsiFile file;
            if (target == null) {
                MyEditorTextField.$$$reportNull$$$0(4);
            }
            CPPLog.LOG.assertTrue((file = target.myPointer.getContainingFile()) != null);
            Project project = file.getProject();
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(file);
            if (document != this.getDocument()) {
                this.setDocument(document);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 4 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/actions/newFile/CMakeNewFileHandler$MyEditorTextField";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "target";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createEditor";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/actions/newFile/CMakeNewFileHandler$MyEditorTextField";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "configureNewEditor";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setTarget";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "updateWithTarget";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "initDocument";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 4 -> new IllegalArgumentException(string);
            };
        }
    }

    private static class NewTargetField
    extends JPanel {
        @NotNull
        private final Set<String> myExistingTargetNames;
        @Nullable
        private final CallSite myDefaultCMakeLists;
        @NotNull
        private final Project myProject;
        private boolean shouldNotify;
        @NotNull
        private final NewTargetFieldListener myListener;
        @Nullable
        private NewTargetFieldListener myDelegateListener;
        @NotNull
        public NewTargetFieldInfo currentInfo;

        private NewTargetField(@NotNull PsiFile defaultCMakeLists, @NotNull Project project, @NotNull CMakeNewFileHandler handler2, @NotNull CMakeWorkspace workspace, @NotNull Disposable parentDisposable) {
            if (defaultCMakeLists == null) {
                NewTargetField.$$$reportNull$$$0(0);
            }
            if (project == null) {
                NewTargetField.$$$reportNull$$$0(1);
            }
            if (handler2 == null) {
                NewTargetField.$$$reportNull$$$0(2);
            }
            if (workspace == null) {
                NewTargetField.$$$reportNull$$$0(3);
            }
            if (parentDisposable == null) {
                NewTargetField.$$$reportNull$$$0(4);
            }
            this.myDelegateListener = null;
            this.myProject = project;
            this.myExistingTargetNames = new HashSet<String>(ContainerUtil.map(handler2.myTargets, target -> target.getName()));
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument(defaultCMakeLists);
            this.myDefaultCMakeLists = document == null ? null : new CallSite(defaultCMakeLists, document.getLineCount());
            this.shouldNotify = true;
            this.currentInfo = new NewTargetFieldInfo(CMakeActionsUtilKt.generateCMakeTargetName(this.myExistingTargetNames), TargetType.values()[0], this.myDefaultCMakeLists);
            this.myListener = new NewTargetFieldListener(){

                @Override
                public void focused(@NotNull NewTargetFieldInfo info) {
                    if (info == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (myDelegateListener != null && shouldNotify) {
                        myDelegateListener.focused(currentInfo);
                    }
                }

                @Override
                public void infoChanged(@NotNull NewTargetFieldInfo info) {
                    if (info == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (myDelegateListener != null && shouldNotify) {
                        myDelegateListener.infoChanged(currentInfo);
                    }
                }

                @Override
                public void targetAdded(@NotNull NewTargetFieldInfo info) {
                    if (info == null) {
                        1.$$$reportNull$$$0(2);
                    }
                    if (!shouldNotify) {
                        return;
                    }
                    myExistingTargetNames.add(currentInfo.myName);
                    if (myDelegateListener != null) {
                        myDelegateListener.targetAdded(currentInfo);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    objectArray2[0] = "info";
                    objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/actions/newFile/CMakeNewFileHandler$NewTargetField$1";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "focused";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "infoChanged";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "targetAdded";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            this.setLayout(new BoxLayout(this, 0));
            FocusListener focusListener = new FocusListener(){

                @Override
                public void focusGained(FocusEvent e) {
                    myListener.focused(currentInfo);
                }

                @Override
                public void focusLost(FocusEvent e) {
                }
            };
            ComboBox typeCombo = new ComboBox(new DefaultComboBoxModel<String>((String[])Arrays.stream(TargetType.values()).map(type -> type.commandName).toArray(String[]::new)));
            typeCombo.addItemListener(e -> {
                this.currentInfo.myType = TargetType.values()[typeCombo.getSelectedIndex()];
                this.myListener.infoChanged(this.currentInfo);
            });
            typeCombo.addFocusListener(focusListener);
            final TextFieldWithBrowseButton fileField = new TextFieldWithBrowseButton();
            FileChooserDescriptor descriptor2 = FileChooserDescriptorFactory.createSingleFileNoJarsDescriptor().withTitle(CLionCMakeBundle.message("cmake.addFileToProject.newTargets.action.chooser.title", new Object[0])).withDescription(CLionCMakeBundle.message("cmake.addFileToProject.newTargets.action.chooser.description", new Object[0])).withExtensionFilter(CLionCMakeBundle.message("cmake.addFileToProject.newTargets.action.chooser.filter", new Object[0]), CMakeListsFileType.getAllExtensions()).withFileFilter(file -> CMakeListsFileType.isCMakeFileByName(file.getName()) && ContainerUtil.exists(workspace.getCMakeDependencyFiles(), dep -> file.toNioPath().equals(dep.toPath())));
            fileField.addBrowseFolderListener(this.myProject, descriptor2);
            fileField.setEditable(false);
            fileField.getTextField().setText(defaultCMakeLists.getVirtualFile().getPath());
            fileField.setMinimumSize(new Dimension(120, fileField.getMinimumSize().height));
            fileField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(@NotNull DocumentEvent e) {
                    PsiFile psiFile;
                    if (e == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    if ((psiFile = this.findPsiFile()) != null) {
                        Document document = PsiDocumentManager.getInstance((Project)myProject).getDocument(psiFile);
                        currentInfo.myCallSite = new CallSite(psiFile, document != null ? document.getLineCount() : 0);
                    } else {
                        currentInfo.myCallSite = null;
                    }
                    myListener.infoChanged(currentInfo);
                }

                @Nullable
                private PsiFile findPsiFile() {
                    VirtualFile file = LocalFileSystem.getInstance().findFileByNioFile(Path.of(fileField.getText(), new String[0]));
                    if (file == null) {
                        return null;
                    }
                    return PsiManager.getInstance((Project)myProject).findFile(file);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/cidr/cpp/cmake/actions/newFile/CMakeNewFileHandler$NewTargetField$3", "textChanged"));
                }
            });
            fileField.getTextField().addFocusListener(focusListener);
            final JBTextField targetName = new JBTextField("");
            targetName.getEmptyText().setText(this.currentInfo.myName);
            targetName.setMinimumSize(new Dimension(100, targetName.getMinimumSize().height));
            targetName.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    currentInfo.myName = targetName.getText().isEmpty() ? targetName.getEmptyText().getText() : targetName.getText();
                    myListener.infoChanged(currentInfo);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    currentInfo.myName = targetName.getText().isEmpty() ? targetName.getEmptyText().getText() : targetName.getText();
                    myListener.infoChanged(currentInfo);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            });
            targetName.addFocusListener(focusListener);
            Pattern validator = Pattern.compile("^[a-z0-9.+_-]+$", 2);
            Supplier<ValidationInfo> validate = () -> {
                String newTargetName = this.currentInfo.myName;
                if (!newTargetName.isEmpty() && !validator.matcher(newTargetName).find()) {
                    return new ValidationInfo(CLionCMakeBundle.message("cmake.addFileToProject.newTargets.invalidName", new Object[0]), (JComponent)targetName);
                }
                if (this.myExistingTargetNames.contains(newTargetName)) {
                    return new ValidationInfo(CLionCMakeBundle.message("cmake.addFileToProject.newTargets.duplicatingName", newTargetName), (JComponent)targetName);
                }
                return null;
            };
            new ComponentValidator(parentDisposable).withValidator(validate).withFocusValidator(validate).installOn((JComponent)targetName);
            JButton addButton = new JButton(CLionCMakeBundle.message("cmake.addFileToProject.newTargets.action.addButton", new Object[0]));
            addButton.addActionListener(e -> ComponentValidator.getInstance((JComponent)targetName).ifPresent(v -> {
                v.enableValidation();
                v.revalidate();
                if (v.getValidationInfo() == null) {
                    this.myListener.targetAdded(this.currentInfo);
                    this.shouldNotify = false;
                    typeCombo.setSelectedIndex(0);
                    fileField.getTextField().setText(defaultCMakeLists.getVirtualFile().getPath());
                    String newName = CMakeActionsUtilKt.generateCMakeTargetName(this.myExistingTargetNames);
                    targetName.getEmptyText().setText(newName);
                    targetName.setText("");
                    this.shouldNotify = true;
                    this.currentInfo = new NewTargetFieldInfo(newName, TargetType.values()[typeCombo.getSelectedIndex()], this.myDefaultCMakeLists);
                }
            }));
            this.add((Component)typeCombo);
            this.add((Component)targetName);
            this.add((Component)fileField);
            this.add(addButton);
        }

        public void setDelegateListener(@Nullable NewTargetFieldListener delegateListener) {
            this.myDelegateListener = delegateListener;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "defaultCMakeLists";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "handler";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[0] = "workspace";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[0] = "parentDisposable";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/cpp/cmake/actions/newFile/CMakeNewFileHandler$NewTargetField";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static interface NewTargetFieldListener {
            public void focused(@NotNull NewTargetFieldInfo var1);

            public void infoChanged(@NotNull NewTargetFieldInfo var1);

            public void targetAdded(@NotNull NewTargetFieldInfo var1);
        }

        private static class NewTargetFieldInfo {
            @NotNull
            @NlsSafe
            public String myName;
            @NotNull
            public TargetType myType;
            @Nullable
            public CallSite myCallSite;

            private NewTargetFieldInfo(@NotNull String name, @NotNull TargetType type, @Nullable CallSite callSite) {
                if (name == null) {
                    NewTargetFieldInfo.$$$reportNull$$$0(0);
                }
                if (type == null) {
                    NewTargetFieldInfo.$$$reportNull$$$0(1);
                }
                this.myName = name;
                this.myType = type;
                this.myCallSite = callSite;
            }

            @Nullable
            public CMakeNewFileNewTarget getTarget() {
                if (this.myCallSite == null) {
                    return null;
                }
                return new CMakeNewFileNewTarget(this.myName, this.myType, this.myCallSite);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "name";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "type";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/cidr/cpp/cmake/actions/newFile/CMakeNewFileHandler$NewTargetField$NewTargetFieldInfo";
                objectArray[2] = "<init>";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }
    }

    private static final class Utils {
        private Utils() {
        }

        @NotNull
        public static String getRelativePath(PsiFile baseFile, @NotNull String otherFilePath) {
            if (otherFilePath == null) {
                Utils.$$$reportNull$$$0(0);
            }
            String root = baseFile == null ? null : baseFile.getVirtualFile().getParent().getPath();
            String relativePath = root == null ? null : FileUtil.getRelativePath((File)new File(root), (File)new File(otherFilePath));
            String string = FileUtil.toCanonicalPath((String)(relativePath == null ? otherFilePath : relativePath));
            if (string == null) {
                Utils.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "otherFilePath";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/actions/newFile/CMakeNewFileHandler$Utils";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/actions/newFile/CMakeNewFileHandler$Utils";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRelativePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getRelativePath";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static final class CallSite {
        @NotNull
        private final PsiFile myFile;
        private final int myLine;

        private CallSite(@NotNull PsiFile file, int line) {
            if (file == null) {
                CallSite.$$$reportNull$$$0(0);
            }
            this.myFile = file;
            this.myLine = line;
        }

        @NotNull
        @NlsSafe
        public String toText() {
            String string = CMakeFileLocationUtil.getLocationInFile((PsiElement)this.myFile, false) + ":" + this.myLine;
            if (string == null) {
                CallSite.$$$reportNull$$$0(1);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/actions/newFile/CMakeNewFileHandler$CallSite";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/actions/newFile/CMakeNewFileHandler$CallSite";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toText";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private static enum TargetType {
        ADD_EXECUTABLE("add_executable"),
        ADD_LIBRARY("add_library"),
        CUDA_ADD_EXECUTABLE("cuda_add_executable"),
        CUDA_ADD_LIBRARY("cuda_add_library"),
        QT_ADD_EXECUTABLE("qt_add_executable"),
        QT_ADD_LIBRARY("qt_add_library"),
        QT6_ADD_EXECUTABLE("qt6_add_executable"),
        QT6_ADD_LIBRARY("qt6_add_library");

        @NotNull
        @NlsSafe
        public final String commandName;

        private TargetType(String commandName) {
            if (commandName == null) {
                TargetType.$$$reportNull$$$0(0);
            }
            this.commandName = commandName;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandName", "com/jetbrains/cidr/cpp/cmake/actions/newFile/CMakeNewFileHandler$TargetType", "<init>"));
        }
    }

    public static class CMakeNewFileNewTarget
    extends CMakeNewFileTarget {
        @NotNull
        private final CallSite myCallSite;
        @NotNull
        private final TargetType myType;

        private CMakeNewFileNewTarget(@NotNull String name, @NotNull TargetType type, @NotNull CallSite callSite) {
            if (name == null) {
                CMakeNewFileNewTarget.$$$reportNull$$$0(0);
            }
            if (type == null) {
                CMakeNewFileNewTarget.$$$reportNull$$$0(1);
            }
            if (callSite == null) {
                CMakeNewFileNewTarget.$$$reportNull$$$0(2);
            }
            super(CMakeNewFileNewTarget.createCopyAndGetCommand(type, callSite, name), List.of(name), name, 2, callSite.toText());
            this.myCallSite = callSite;
            this.myType = type;
        }

        @Override
        public boolean addFiles(@NotNull List<VirtualFile> addedFiles) {
            if (addedFiles == null) {
                CMakeNewFileNewTarget.$$$reportNull$$$0(3);
            }
            Stream<String> addFileParams = addedFiles.stream().map(file -> Utils.getRelativePath(this.myCallSite.myFile, file.getPath()));
            try {
                CMakeNewFileNewTarget.writeToFile(this.myType, this.myCallSite.myFile, Stream.concat(Stream.of(this.getName()), addFileParams).toList());
                return true;
            }
            catch (Throwable e) {
                return false;
            }
        }

        @NotNull
        private static CMakeCommand writeToFile(@NotNull TargetType type, @NotNull PsiFile file, @NotNull List<String> args) {
            CMakeCommand cMakeCommand;
            if (type == null) {
                CMakeNewFileNewTarget.$$$reportNull$$$0(4);
            }
            if (file == null) {
                CMakeNewFileNewTarget.$$$reportNull$$$0(5);
            }
            if (args == null) {
                CMakeNewFileNewTarget.$$$reportNull$$$0(6);
            }
            try {
                CMakeCommand result = (CMakeCommand)WriteCommandAction.writeCommandAction((Project)file.getProject()).withName(CidrLangBundle.message((String)"action.new.file.creation", (Object[])new Object[0])).withUndoConfirmationPolicy(UndoConfirmationPolicy.REQUEST_CONFIRMATION).compute(() -> (CMakeCommand)file.getOriginalElement().add((PsiElement)CMakeElementFactory.createCommand(file.getProject(), type.commandName, args)));
                PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)result.getProject());
                Document document = psiDocumentManager.getDocument(result.getContainingFile());
                if (document != null) {
                    psiDocumentManager.doPostponedOperationsAndUnblockDocument(document);
                }
                cMakeCommand = result;
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
            if (cMakeCommand == null) {
                CMakeNewFileNewTarget.$$$reportNull$$$0(7);
            }
            return cMakeCommand;
        }

        private static CMakeCommand createCopyAndGetCommand(@NotNull TargetType type, @NotNull CallSite callSite, @NotNull String name) {
            if (type == null) {
                CMakeNewFileNewTarget.$$$reportNull$$$0(8);
            }
            if (callSite == null) {
                CMakeNewFileNewTarget.$$$reportNull$$$0(9);
            }
            if (name == null) {
                CMakeNewFileNewTarget.$$$reportNull$$$0(10);
            }
            long stamp = LocalTimeCounter.currentTime();
            PsiFile myPreviewFile = PsiFileFactory.getInstance((Project)callSite.myFile.getProject()).createFileFromText(callSite.myFile.getName() + callSite.myFile.getFileType().getDefaultExtension(), callSite.myFile.getFileType(), (CharSequence)callSite.myFile.getText(), stamp, true, false);
            try {
                return CMakeNewFileNewTarget.writeToFile(type, myPreviewFile, List.of(name));
            }
            catch (Throwable e) {
                throw new RuntimeException(e);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 7 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 1: 
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: 
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callSite";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "addedFiles";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "args";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/actions/newFile/CMakeNewFileHandler$CMakeNewFileNewTarget";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/actions/newFile/CMakeNewFileHandler$CMakeNewFileNewTarget";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "writeToFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addFiles";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "writeToFile";
                    break;
                }
                case 7: {
                    break;
                }
                case 8: 
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "createCopyAndGetCommand";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 7 -> new IllegalStateException(string);
            };
        }
    }
}

