/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake.actions;

import com.intellij.ide.actions.cache.AsyncRecoveryResult;
import com.intellij.ide.actions.cache.ProjectRecoveryScope;
import com.intellij.ide.actions.cache.RecoveryAction;
import com.intellij.ide.actions.cache.RecoveryScope;
import com.intellij.openapi.project.Project;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.jetbrains.cidr.cpp.CLionCMakeBundle;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspace;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspaceListener;
import com.jetbrains.cidr.cpp.cmake.workspace.CMakeWorkspaceReloadTask;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u00132\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/cidr/cpp/cmake/actions/ClearCMakeCacheRecoveryAction;", "Lcom/intellij/ide/actions/cache/RecoveryAction;", "<init>", "()V", "performanceRate", "", "getPerformanceRate", "()I", "presentableName", "", "getPresentableName", "()Ljava/lang/String;", "actionKey", "getActionKey", "canBeApplied", "", "recoveryScope", "Lcom/intellij/ide/actions/cache/RecoveryScope;", "perform", "Ljava/util/concurrent/CompletableFuture;", "Lcom/intellij/ide/actions/cache/AsyncRecoveryResult;", "intellij.clion.cmake"})
public final class ClearCMakeCacheRecoveryAction
implements RecoveryAction {
    private final int performanceRate;

    public ClearCMakeCacheRecoveryAction() {
        this.performanceRate = 10000;
    }

    public int getPerformanceRate() {
        return this.performanceRate;
    }

    @NotNull
    public String getPresentableName() {
        String string = CLionCMakeBundle.message("cmake.recovery.action.dropCacheAndReload", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getActionKey() {
        return "clear-cmake-cache-and-reload";
    }

    public boolean canBeApplied(@NotNull RecoveryScope recoveryScope) {
        Intrinsics.checkNotNullParameter((Object)recoveryScope, (String)"recoveryScope");
        return recoveryScope instanceof ProjectRecoveryScope && CMakeWorkspace.Companion.getInstance(((ProjectRecoveryScope)recoveryScope).getProject()).isInitialized();
    }

    @NotNull
    public CompletableFuture<AsyncRecoveryResult> perform(@NotNull RecoveryScope recoveryScope) {
        Intrinsics.checkNotNullParameter((Object)recoveryScope, (String)"recoveryScope");
        Project project = recoveryScope.getProject();
        CompletableFuture<AsyncRecoveryResult> result = new CompletableFuture<AsyncRecoveryResult>();
        CMakeWorkspace workspace = CMakeWorkspace.Companion.getInstance(project);
        if (!workspace.isInitialized()) {
            result.completeExceptionally(new IllegalStateException("CMakeWorkspace isn't initialized"));
            return result;
        }
        MessageBusConnection connection = project.getMessageBus().connect();
        Topic<CMakeWorkspaceListener> topic = CMakeWorkspaceListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        connection.subscribe(topic, (Object)new CMakeWorkspaceListener(connection, result, recoveryScope){
            final /* synthetic */ MessageBusConnection $connection;
            final /* synthetic */ CompletableFuture<AsyncRecoveryResult> $result;
            final /* synthetic */ RecoveryScope $recoveryScope;
            {
                this.$connection = $connection;
                this.$result = $result;
                this.$recoveryScope = $recoveryScope;
            }

            public void reloadingFinished(boolean canceled) {
                this.$connection.disconnect();
                this.$result.complete(new AsyncRecoveryResult(this.$recoveryScope, CollectionsKt.emptyList()));
            }
        });
        workspace.scheduleReload(CMakeWorkspaceReloadTask.Companion.clearCache().withExplicit(true));
        return result;
    }
}

