/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.cpp.cmake;

import com.intellij.execution.CommandLineUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.CapturingProcessHandler;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.DigestUtil;
import com.intellij.util.system.OS;
import com.jetbrains.cidr.cpp.CLionCMakeBundle;
import com.jetbrains.cidr.cpp.cmake.CMakeException;
import com.jetbrains.cidr.cpp.cmake.CMakeRunnerStep;
import com.jetbrains.cidr.cpp.cmake.stats.CMakeExitCodeCollector;
import com.jetbrains.cidr.cpp.toolchains.CMakeExecutableTool;
import com.jetbrains.cidr.cpp.toolchains.CPPBuildUtil;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSet;
import com.jetbrains.cidr.cpp.toolchains.CPPToolSetWithHome;
import com.jetbrains.cidr.cpp.toolchains.Cygwin;
import com.jetbrains.cidr.execution.CidrRunProcessUtil;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.system.HostMachine;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class CMakeRunner {
    private static final Logger LOG = Logger.getInstance(CMakeRunner.class);
    private static final String FIX_CYGWIN_PERMISSIONS_KEY = "cidr.cygwin.cmakePermissionsFix";
    private static final boolean FIX_CYGWIN_PERMISSIONS = Registry.is((String)"cidr.cygwin.cmakePermissionsFix");
    private static final Pattern CYGWIN_ERROR_PATTERN = Pattern.compile(".+directory \\W/cygdrive/.+ does not exist.*", 32);
    private static final Pattern MINGW_ANTIVIRUS_ERROR_PATTERN = Pattern.compile(".*file STRINGS.*a\\.exe.*cannot be read.*", 40);
    private static final Semaphore ourCygwinCopyLock = new Semaphore(1);
    private static volatile boolean ourCygwinPermissionsFixed = false;
    private static volatile boolean ourEmulateCMakeExecutionErrorInTests = false;

    @TestOnly
    public static void setEmulateCMakeExecutionErrorInTests(boolean emulate) {
        ourEmulateCMakeExecutionErrorInTests = emulate;
    }

    @TestOnly
    public static boolean getEmulateCMakeExecutionErrorInTests() {
        return ourEmulateCMakeExecutionErrorInTests;
    }

    @NotNull
    public static CMakeOutput runCMake(@NotNull CMakeRunnerStep.Parameters parameters2) throws CMakeException {
        if (parameters2 == null) {
            CMakeRunner.$$$reportNull$$$0(0);
        }
        GeneralCommandLine cl = CMakeRunner.buildCommandLine(parameters2.getEnvironment(), parameters2.getOutputDir(), parameters2.getParameters(), parameters2.isPassSystemEnvironment(), parameters2.getAdditionalEnvironment(), false);
        CPPEnvironment environment = parameters2.getEnvironment();
        if (parameters2.isUseSBSyntax()) {
            cl.addParameters(new String[]{"-S", environment.toEnvPath(parameters2.getProjectDir().toString()), "-B", environment.toEnvPath(parameters2.getOutputDir().toString())});
        } else {
            cl.addParameter(environment.toEnvPath(parameters2.getProjectDir().toString()));
        }
        return CMakeRunner.runCMakeBasedTool(parameters2, cl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static CMakeOutput runCMakeBasedTool(@NotNull CMakeRunnerStep.Parameters parameters2, @NotNull GeneralCommandLine cl) throws CMakeException {
        CPPEnvironment environment;
        if (parameters2 == null) {
            CMakeRunner.$$$reportNull$$$0(1);
        }
        if (cl == null) {
            CMakeRunner.$$$reportNull$$$0(2);
        }
        if ((environment = parameters2.getEnvironment()).getHostMachine().getOS() == OS.Windows) {
            cl.setCharset(StandardCharsets.UTF_8);
        }
        if (Registry.is((String)"cmake.color.diagnostics.environment", (boolean)true)) {
            cl.withEnvironment("CMAKE_COLOR_DIAGNOSTICS", "ON");
        }
        cl.setRedirectErrorStream(true);
        ProcessOutput output2 = null;
        final StringBuilder cmakeDiagnostics = new StringBuilder();
        final HostMachine host = environment.getHostMachine();
        final AtomicReference<Object> processReference = new AtomicReference<Object>(null);
        try {
            if (ourEmulateCMakeExecutionErrorInTests) {
                throw new CMakeException("Emulated CMake error");
            }
            Runnable shutdownHook = new Runnable(){

                @Override
                public void run() {
                    BaseProcessHandler process2 = (BaseProcessHandler)processReference.get();
                    if (process2 != null) {
                        LOG.info("Killing CMake process tree on exit");
                        host.killProcessTree(process2);
                    }
                }
            };
            ShutDownTracker.getInstance().registerShutdownTask(shutdownHook);
            LOG.info("Executing CMake: " + cl.getCommandLineString());
            try {
                processReference.set(host.createProcess(cl, true, false));
                Object var9_8 = processReference.get();
                if (var9_8 instanceof KillableProcessHandler) {
                    KillableProcessHandler killableProcessHandler = var9_8;
                    killableProcessHandler.setShouldKillProcessSoftly(true);
                }
            }
            catch (ExecutionException e) {
                throw new CMakeException(e);
            }
            ((BaseProcessHandler)processReference.get()).addProcessListener((ProcessListener)new ProcessAdapter(){
                private final CPPToolSet toolset;
                private final boolean shouldScan;
                private volatile StringBuffer buffer;
                {
                    this.toolset = environment.getToolSet();
                    this.shouldScan = this.toolset.isCygwin() || this.toolset.isMinGW();
                    this.buffer = this.shouldScan ? new StringBuffer() : null;
                }

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    StringBuffer buffer;
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    if ((buffer = this.buffer) == null) {
                        return;
                    }
                    buffer.append(event.getText());
                }

                public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                    StringBuffer buffer;
                    if (event == null) {
                        2.$$$reportNull$$$0(2);
                    }
                    if ((buffer = this.buffer) == null) {
                        return;
                    }
                    this.buffer = null;
                    for (String diagnostic : CMakeRunner.analyzeCMakeOutput(buffer, this.toolset)) {
                        cmakeDiagnostics.append(diagnostic);
                        String[] lines = StringUtil.splitByLines((String)diagnostic);
                        int len = Arrays.stream(lines).map(line -> line.length()).max(Integer::compareTo).orElse(0);
                        String header = StringUtil.repeat((String)"-", (int)len);
                        String indent = "  ";
                        StringBuilder cmakeErrorText = new StringBuilder();
                        cmakeErrorText.append("\n");
                        cmakeErrorText.append(CLionCMakeBundle.message("cmake.console.error.title", new Object[0]));
                        cmakeErrorText.append("\n");
                        cmakeErrorText.append("  ").append(header).append("\n");
                        for (String each : lines) {
                            cmakeErrorText.append("  ").append(each).append("\n");
                        }
                        cmakeErrorText.append("  ").append(header).append("\n");
                        ((BaseProcessHandler)processReference.get()).notifyTextAvailable(cmakeErrorText.toString(), ProcessOutputTypes.SYSTEM);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "outputType";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/CMakeRunner$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "onTextAvailable";
                            break;
                        }
                        case 2: {
                            objectArray = objectArray2;
                            objectArray2[2] = "processWillTerminate";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            try {
                parameters2.getListener().processStarted(processReference.get());
                output2 = CidrRunProcessUtil.runWithProgress((BaseProcessHandler)processReference.get(), (int)0);
                if (output2.isCancelled()) {
                    throw new ProcessCanceledException();
                }
            }
            finally {
                ShutDownTracker.getInstance().unregisterShutdownTask(shutdownHook);
                shutdownHook.run();
            }
            LOG.info((String)(output2 != null ? "CMake exit code: " + output2.getExitCode() : "No output") + " for command: " + cl.getCommandLineString());
        }
        catch (Throwable throwable) {
            LOG.info((String)(output2 != null ? "CMake exit code: " + output2.getExitCode() : "No output") + " for command: " + cl.getCommandLineString());
            if (output2 != null) {
                CMakeExitCodeCollector.logConfigureExitCode(output2.getExitCode());
            }
            throw throwable;
        }
        if (output2 != null) {
            CMakeExitCodeCollector.logConfigureExitCode(output2.getExitCode());
        }
        return new CMakeOutput(output2.getExitCode(), output2.getStdout(), cmakeDiagnostics);
    }

    private static List<@NlsContexts.DetailedDescription String> analyzeCMakeOutput(StringBuffer output2, @Nullable CPPToolSet toolSet) {
        String diagnostic = null;
        if (toolSet != null) {
            if (toolSet.isCygwin() && CYGWIN_ERROR_PATTERN.matcher(output2).matches()) {
                diagnostic = CLionCMakeBundle.message("text.selected.cmake.might.be.incompatible.with.cygwin.environment", ApplicationNamesInfo.getInstance().getProductName());
            } else if (toolSet.isMinGW() && MINGW_ANTIVIRUS_ERROR_PATTERN.matcher(output2).matches()) {
                diagnostic = CLionCMakeBundle.message("text.antivirus.software.workaround", ((CPPToolSetWithHome)toolSet).getHomePath());
            }
        }
        return ContainerUtil.createMaybeSingletonList(diagnostic);
    }

    @NotNull
    public static GeneralCommandLine buildCommandLine(@NotNull CPPEnvironment environment, @NotNull Path outputDir, @NotNull List<String> parameters2, boolean passSystemEnvironment, @NotNull Map<String, String> additionalEnvironment) throws CMakeException {
        if (environment == null) {
            CMakeRunner.$$$reportNull$$$0(3);
        }
        if (outputDir == null) {
            CMakeRunner.$$$reportNull$$$0(4);
        }
        if (parameters2 == null) {
            CMakeRunner.$$$reportNull$$$0(5);
        }
        if (additionalEnvironment == null) {
            CMakeRunner.$$$reportNull$$$0(6);
        }
        return CMakeRunner.buildCommandLine(environment, outputDir, parameters2, passSystemEnvironment, additionalEnvironment, false);
    }

    @NotNull
    public static GeneralCommandLine buildCommandLine(@NotNull CPPEnvironment environment, @NotNull File outputDir, @NotNull List<String> parameters2, boolean passSystemEnvironment, @NotNull Map<String, String> additionalEnvironment) throws CMakeException {
        if (environment == null) {
            CMakeRunner.$$$reportNull$$$0(7);
        }
        if (outputDir == null) {
            CMakeRunner.$$$reportNull$$$0(8);
        }
        if (parameters2 == null) {
            CMakeRunner.$$$reportNull$$$0(9);
        }
        if (additionalEnvironment == null) {
            CMakeRunner.$$$reportNull$$$0(10);
        }
        return CMakeRunner.buildCommandLine(environment, outputDir.toPath(), parameters2, passSystemEnvironment, additionalEnvironment, false);
    }

    @NotNull
    public static GeneralCommandLine buildCommandLine(@NotNull CPPEnvironment environment, @NotNull Path outputDir, @NotNull List<String> parameters2, boolean passSystemEnvironment, @NotNull Map<String, String> additionalEnvironment, boolean usePty) throws CMakeException {
        GeneralCommandLine generalCommandLine;
        if (environment == null) {
            CMakeRunner.$$$reportNull$$$0(11);
        }
        if (outputDir == null) {
            CMakeRunner.$$$reportNull$$$0(12);
        }
        if (parameters2 == null) {
            CMakeRunner.$$$reportNull$$$0(13);
        }
        if (additionalEnvironment == null) {
            CMakeRunner.$$$reportNull$$$0(14);
        }
        String executablePath = CMakeRunner.getCMakeExecutableWithFixedCygwinPermissions(environment).getExecutablePath();
        try {
            generalCommandLine = CPPBuildUtil.buildCommandLine(environment, executablePath, outputDir, parameters2, passSystemEnvironment, additionalEnvironment, usePty);
        }
        catch (ExecutionException ex) {
            throw new CMakeException(ex);
        }
        if (generalCommandLine == null) {
            CMakeRunner.$$$reportNull$$$0(15);
        }
        return generalCommandLine;
    }

    /*
     * Exception decompiling
     */
    @NotNull
    private static CMakeExecutableTool getCMakeExecutableWithFixedCygwinPermissions(@NotNull CPPEnvironment environment) throws CMakeException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[DOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @NotNull
    private static CMakeExecutableTool doGetCMakeExecutableWithFixedCygwinPermissions(@NotNull CPPEnvironment environment) throws CMakeException {
        CMakeExecutableTool cmakeCopy;
        block25: {
            String bundledCMakeVersion;
            CMakeExecutableTool cmake;
            if (environment == null) {
                CMakeRunner.$$$reportNull$$$0(18);
            }
            if ((cmake = environment.getCMake()) == null) {
                throw new CMakeException(CLionCMakeBundle.message("cmake.is.not.available", new Object[0]));
            }
            CPPToolSet toolset = environment.getToolSet();
            if (!toolset.isCygwin() || !FIX_CYGWIN_PERMISSIONS) {
                CMakeExecutableTool cMakeExecutableTool = cmake;
                if (cMakeExecutableTool == null) {
                    CMakeRunner.$$$reportNull$$$0(19);
                }
                return cMakeExecutableTool;
            }
            Cygwin cygwin = (Cygwin)toolset;
            File cmakeExecutable = cmake.getExecutable();
            boolean isBundledCygwinCMake = FileUtil.filesEqual((File)cmakeExecutable, (File)CMakeExecutableTool.getBundledCMakeBinary(true));
            if (!isBundledCygwinCMake) {
                CMakeExecutableTool cMakeExecutableTool = cmake;
                if (cMakeExecutableTool == null) {
                    CMakeRunner.$$$reportNull$$$0(20);
                }
                return cMakeExecutableTool;
            }
            File cmakeCopyHome = new File(PathManager.getSystemPath(), "cygwin_cmake");
            cmakeCopy = new CMakeExecutableTool(new File(cmakeCopyHome, "bin/" + cmakeExecutable.getName()), environment);
            if (ourCygwinPermissionsFixed) {
                CMakeExecutableTool cMakeExecutableTool = cmakeCopy;
                if (cMakeExecutableTool == null) {
                    CMakeRunner.$$$reportNull$$$0(21);
                }
                return cMakeExecutableTool;
            }
            try {
                bundledCMakeVersion = cmake.readVersion();
            }
            catch (ExecutionException e) {
                CMakeExecutableTool cMakeExecutableTool = cmake;
                if (cMakeExecutableTool == null) {
                    CMakeRunner.$$$reportNull$$$0(22);
                }
                return cMakeExecutableTool;
            }
            if (bundledCMakeVersion == null) {
                CMakeExecutableTool cMakeExecutableTool = cmake;
                if (cMakeExecutableTool == null) {
                    CMakeRunner.$$$reportNull$$$0(23);
                }
                return cMakeExecutableTool;
            }
            File flagFile = new File(cmakeCopyHome, "copied_flag_and_version.txt");
            String copyVersion = null;
            String copyDigest = null;
            try {
                List lines = FileUtil.loadLines((File)flagFile);
                if (lines.size() > 0) {
                    copyVersion = (String)lines.get(0);
                }
                if (lines.size() > 1) {
                    copyDigest = (String)lines.get(1);
                }
            }
            catch (IOException lines) {
                // empty catch block
            }
            final File bundledCMakeHome = cmake.getExecutable().getParentFile().getParentFile();
            ThrowableComputable<String, IOException> lazyCMakeDigest = new ThrowableComputable<String, IOException>(){
                String result;

                public String compute() throws IOException {
                    if (this.result != null) {
                        return this.result;
                    }
                    this.result = CMakeRunner.calculateDigest(new File(bundledCMakeHome, "bin"));
                    return this.result;
                }
            };
            try {
                if (bundledCMakeVersion.equals(copyVersion) && copyDigest != null && copyDigest.equals(lazyCMakeDigest.compute())) break block25;
                LOG.info("Updating Cygwin CMake in " + cmakeCopyHome);
                if (!FileUtil.delete((File)cmakeCopyHome)) {
                    throw new IOException("Cannot delete directory " + cmakeCopyHome);
                }
                FileUtil.copyDir((File)bundledCMakeHome, (File)cmakeCopyHome, pathname -> {
                    ProgressManager.checkCanceled();
                    return true;
                });
                try {
                    copyVersion = cmakeCopy.readVersion();
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
                copyDigest = (String)lazyCMakeDigest.compute();
                if (!bundledCMakeVersion.equals(copyVersion)) {
                    throw new IOException("Cannot execute CMake: " + cmakeCopy.getExecutable());
                }
                FileUtil.writeToFile((File)flagFile, (String)"");
                CMakeRunner.updateCMakePermissions(environment, cygwin, cmakeCopyHome);
                String flagFileContent = copyVersion + "\n" + copyDigest;
                FileUtil.writeToFile((File)flagFile, (String)flagFileContent);
                if (!flagFileContent.equals(FileUtil.loadFile((File)flagFile))) {
                    throw new IOException("Cannot write " + flagFile);
                }
            }
            catch (ExecutionException | IOException e) {
                throw CMakeRunner.newPermissionsException(cmakeCopyHome, bundledCMakeHome, (Exception)e);
            }
        }
        ourCygwinPermissionsFixed = true;
        CMakeExecutableTool cMakeExecutableTool = cmakeCopy;
        if (cMakeExecutableTool == null) {
            CMakeRunner.$$$reportNull$$$0(24);
        }
        return cMakeExecutableTool;
    }

    @NotNull
    private static String calculateDigest(@NotNull File dir) throws IOException {
        if (dir == null) {
            CMakeRunner.$$$reportNull$$$0(25);
        }
        if (!dir.isDirectory()) {
            throw new IOException("Cannot find directory " + dir);
        }
        File[] files = dir.listFiles();
        if (files == null) {
            throw new IOException("Cannot access directory " + dir);
        }
        MessageDigest digest = DigestUtil.md5();
        byte[] buffer = new byte[0x100000];
        for (File file : files) {
            try (FileInputStream is = new FileInputStream(file);){
                int len;
                while ((len = ((InputStream)is).read(buffer)) != -1) {
                    ProgressManager.checkCanceled();
                    digest.update(buffer, 0, len);
                }
            }
        }
        String string = StringUtil.toUpperCase((String)StringUtil.toHexString((byte[])digest.digest()));
        if (string == null) {
            CMakeRunner.$$$reportNull$$$0(26);
        }
        return string;
    }

    private static void updateCMakePermissions(@NotNull CPPEnvironment environment, @NotNull Cygwin toolset, @NotNull File cmakeHome) throws ExecutionException {
        if (environment == null) {
            CMakeRunner.$$$reportNull$$$0(27);
        }
        if (toolset == null) {
            CMakeRunner.$$$reportNull$$$0(28);
        }
        if (cmakeHome == null) {
            CMakeRunner.$$$reportNull$$$0(29);
        }
        GeneralCommandLine cl = new GeneralCommandLine();
        environment.prepare(cl, CidrToolEnvironment.PrepareFor.BUILD);
        cl.setExePath(toolset.getSubFilePath("bin/chmod.exe"));
        cl.addParameters(new String[]{"-R", "u+rwx", environment.toEnvPath(cmakeHome.getPath())});
        LOG.info("Fixing CMake permissions for Cygwin: " + cl.getCommandLineString());
        ProcessOutput output2 = CidrRunProcessUtil.runWithProgress((CapturingProcessHandler)new CapturingProcessHandler(cl));
        if (output2.getExitCode() != 0) {
            throw new ExecutionException(CLionCMakeBundle.message("dialog.message.process.exited.with.code", output2.getStderr(), output2.getExitCode()));
        }
    }

    private static CMakeException newPermissionsException(@NotNull File cmakeHome, @NotNull File originalCMakeHome, @NotNull Exception cause) throws CMakeException {
        if (cmakeHome == null) {
            CMakeRunner.$$$reportNull$$$0(30);
        }
        if (originalCMakeHome == null) {
            CMakeRunner.$$$reportNull$$$0(31);
        }
        if (cause == null) {
            CMakeRunner.$$$reportNull$$$0(32);
        }
        @NlsSafe String moreInfoUrl = "http://trentm.com/2005/03/cygwin-ntfs-permissions-badness.html";
        @NlsSafe String chmodCommand = "chmod -R u+rwx " + CommandLineUtil.posixQuote((String)cmakeHome.getAbsolutePath());
        return new CMakeException(CLionCMakeBundle.message("cmake.cygwin.permission.fixup.exception.message", cmakeHome, originalCMakeHome, cmakeHome.getAbsolutePath(), chmodCommand, moreInfoUrl, FIX_CYGWIN_PERMISSIONS_KEY, cause.getMessage()), cause);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 15, 17, 19, 20, 21, 22, 23, 24, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cl";
                break;
            }
            case 3: 
            case 7: 
            case 11: 
            case 16: 
            case 18: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 4: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDir";
                break;
            }
            case 6: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalEnvironment";
                break;
            }
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/CMakeRunner";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolset";
                break;
            }
            case 29: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmakeHome";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "originalCMakeHome";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cause";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/CMakeRunner";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "buildCommandLine";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getCMakeExecutableWithFixedCygwinPermissions";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "doGetCMakeExecutableWithFixedCygwinPermissions";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateDigest";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "runCMake";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "runCMakeBasedTool";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "buildCommandLine";
                break;
            }
            case 15: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 26: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCMakeExecutableWithFixedCygwinPermissions";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "doGetCMakeExecutableWithFixedCygwinPermissions";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "calculateDigest";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "updateCMakePermissions";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "newPermissionsException";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 15, 17, 19, 20, 21, 22, 23, 24, 26 -> new IllegalStateException(string);
        };
    }

    public static class CMakeOutput {
        private final int myExitCode;
        @NotNull
        private final CharSequence myOutput;
        @NotNull
        private final CharSequence myDiagnostics;

        public CMakeOutput(int exitCode, @NotNull CharSequence output2, @NotNull CharSequence diagnostics) {
            if (output2 == null) {
                CMakeOutput.$$$reportNull$$$0(0);
            }
            if (diagnostics == null) {
                CMakeOutput.$$$reportNull$$$0(1);
            }
            this.myExitCode = exitCode;
            this.myOutput = output2;
            this.myDiagnostics = diagnostics;
        }

        public int getExitCode() {
            return this.myExitCode;
        }

        @NotNull
        public CharSequence getOutput() {
            CharSequence charSequence = this.myOutput;
            if (charSequence == null) {
                CMakeOutput.$$$reportNull$$$0(2);
            }
            return charSequence;
        }

        @NotNull
        public CharSequence getDiagnostics() {
            CharSequence charSequence = this.myDiagnostics;
            if (charSequence == null) {
                CMakeOutput.$$$reportNull$$$0(3);
            }
            return charSequence;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "output";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "diagnostics";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/cpp/cmake/CMakeRunner$CMakeOutput";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/cpp/cmake/CMakeRunner$CMakeOutput";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOutput";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDiagnostics";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    @FunctionalInterface
    public static interface Listener {
        public void processStarted(@NotNull ProcessHandler var1);
    }
}

