/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.clion.perf;

import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.CallTreeBuilder;
import com.intellij.profiler.DummyCallTreeBuilder;
import com.intellij.profiler.FileBasedProfilerProcess;
import com.intellij.profiler.LegacyBridgeProfilerConfiguration;
import com.intellij.profiler.ParserUtilKt;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.api.CollapsedProfilerDumpWriter;
import com.intellij.profiler.api.DataReady;
import com.intellij.profiler.api.NewCallTreeOnlyProfilerData;
import com.intellij.profiler.api.ProfilerData;
import com.intellij.profiler.api.ProfilerDumpWriter;
import com.intellij.profiler.api.ProfilerError;
import com.intellij.profiler.api.ProfilerState;
import com.intellij.profiler.api.ProfilerTargetProcess;
import com.intellij.profiler.clion.CPPProfilerBundleKt;
import com.intellij.profiler.clion.NativeTargetProcess;
import com.intellij.profiler.clion.ProfilerEnvironmentHost;
import com.intellij.profiler.clion.perf.NavigatableNativeCall;
import com.intellij.profiler.clion.perf.PerfFrame;
import com.intellij.profiler.clion.perf.PerfProfilerSettings;
import com.intellij.profiler.clion.perf.PerfSample;
import com.intellij.profiler.clion.perf.PerfScriptProcess;
import com.intellij.profiler.model.NativeThread;
import com.intellij.profiler.model.ThreadInfo;
import com.intellij.profiler.ui.BaseCallStackElementRenderer;
import com.intellij.profiler.ui.NativeCallStackElementRenderer;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0090\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u0000 ;2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001;B;\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001e\u0010\u001e\u001a\u00020\u001f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!2\u0006\u0010#\u001a\u00020$H\u0002J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010)\u001a\u00020\b2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010*\u001a\u00020\b2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010+\u001a\u00020\u001f2\u0006\u0010,\u001a\u00020\u0006H\u0002J\b\u00104\u001a\u000205H\u0016J\b\u00106\u001a\u000205H\u0014J\b\u00107\u001a\u000205H\u0002J\u000f\u00108\u001a\u0004\u0018\u000109H\u0002\u00a2\u0006\u0002\u0010:R\u0012\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010-\u001a\u00020.X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0014\u00101\u001a\u00020\bX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103\u00a8\u0006<"}, d2={"Lcom/intellij/profiler/clion/perf/PerfProfilerProcess;", "Lcom/intellij/profiler/FileBasedProfilerProcess;", "Lcom/intellij/profiler/clion/NativeTargetProcess;", "perfProcessHandler", "Lcom/intellij/execution/process/BaseProcessHandler;", "outputPerfDataFile", "Ljava/nio/file/Path;", "processName", "", "attachedTimestamp", "", "environmentHost", "Lcom/intellij/profiler/clion/ProfilerEnvironmentHost;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/execution/process/BaseProcessHandler;Ljava/nio/file/Path;Ljava/lang/String;JLcom/intellij/profiler/clion/ProfilerEnvironmentHost;Lcom/intellij/openapi/project/Project;)V", "getAttachedTimestamp", "()J", "readPreparedDump", "Lcom/intellij/profiler/api/ProfilerState;", "dump", "Ljava/io/File;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "processPerfData", "createDumpWriter", "Lcom/intellij/profiler/api/ProfilerDumpWriter;", "data", "Lcom/intellij/profiler/api/NewCallTreeOnlyProfilerData;", "addStackToChart", "", "chartBuilder", "Lcom/intellij/profiler/DummyCallTreeBuilder;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "sample", "Lcom/intellij/profiler/clion/perf/PerfSample;", "createNavigatableNativeCall", "Lcom/intellij/profiler/clion/perf/NavigatableNativeCall;", "frame", "Lcom/intellij/profiler/clion/perf/PerfFrame;", "getBinaryName", "getNormalizedFunctionName", "tryDeletePerfData", "dumpPath", "profilerConfiguration", "Lcom/intellij/profiler/LegacyBridgeProfilerConfiguration;", "getProfilerConfiguration", "()Lcom/intellij/profiler/LegacyBridgeProfilerConfiguration;", "helpId", "getHelpId", "()Ljava/lang/String;", "canBeStopped", "", "doStop", "trySendSigtermSignal", "findPid", "", "()Ljava/lang/Integer;", "Companion", "intellij.profiler.clion"})
@SourceDebugExtension(value={"SMAP\nPerfProfilerProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerfProfilerProcess.kt\ncom/intellij/profiler/clion/perf/PerfProfilerProcess\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,146:1\n1557#2:147\n1628#2,3:148\n295#2,2:151\n14#3:153\n*S KotlinDebug\n*F\n+ 1 PerfProfilerProcess.kt\ncom/intellij/profiler/clion/perf/PerfProfilerProcess\n*L\n70#1:147\n70#1:148,3\n135#1:151,2\n143#1:153\n*E\n"})
public final class PerfProfilerProcess
extends FileBasedProfilerProcess<NativeTargetProcess> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BaseProcessHandler<?> perfProcessHandler;
    @NotNull
    private final Path outputPerfDataFile;
    private final long attachedTimestamp;
    @NotNull
    private final ProfilerEnvironmentHost environmentHost;
    @NotNull
    private final LegacyBridgeProfilerConfiguration profilerConfiguration;
    @NotNull
    private final String helpId;
    @NotNull
    private static final Logger staticLogger;

    public PerfProfilerProcess(@NotNull BaseProcessHandler<?> perfProcessHandler, @NotNull Path outputPerfDataFile, @NotNull String processName, long attachedTimestamp, @NotNull ProfilerEnvironmentHost environmentHost, @NotNull Project project) {
        Intrinsics.checkNotNullParameter(perfProcessHandler, (String)"perfProcessHandler");
        Intrinsics.checkNotNullParameter((Object)outputPerfDataFile, (String)"outputPerfDataFile");
        Intrinsics.checkNotNullParameter((Object)processName, (String)"processName");
        Intrinsics.checkNotNullParameter((Object)environmentHost, (String)"environmentHost");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, (ProfilerTargetProcess)new NativeTargetProcess((int)perfProcessHandler.getProcess().pid(), processName), new File(((Object)outputPerfDataFile).toString()));
        this.perfProcessHandler = perfProcessHandler;
        this.outputPerfDataFile = outputPerfDataFile;
        this.attachedTimestamp = attachedTimestamp;
        this.environmentHost = environmentHost;
        this.initTargetProcessLifecycleListener((ProcessHandler)this.perfProcessHandler);
        this.profilerConfiguration = new LegacyBridgeProfilerConfiguration("legacy.perf", "Perf");
        this.helpId = "procedures.profiler";
    }

    public long getAttachedTimestamp() {
        return this.attachedTimestamp;
    }

    @NotNull
    protected ProfilerState readPreparedDump(@NotNull File dump, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)dump, (String)"dump");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        String string = dump.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        Path dumpPath = this.environmentHost.getPath(string, this.getProject());
        try {
            return this.processPerfData(dumpPath, indicator);
        }
        catch (Throwable e) {
            this.tryDeletePerfData(dumpPath);
            if (e instanceof ProcessCanceledException) {
                throw e;
            }
            staticLogger.warn("Error while reading dump from " + dump.getPath(), e);
            String string2 = e.getMessage();
            if (string2 == null) {
                string2 = "";
            }
            return (ProfilerState)new ProfilerError(string2);
        }
    }

    private final ProfilerState processPerfData(Path dump, ProgressIndicator indicator) {
        DummyCallTreeBuilder chartBuilder = new DummyCallTreeBuilder(null, null, 3, null);
        PerfScriptProcess.Companion.execute(dump, (Function1<? super PerfSample, Unit>)((Function1)arg_0 -> PerfProfilerProcess.processPerfData$lambda$0(this, chartBuilder, arg_0)), (Function0<Unit>)((Function0)() -> PerfProfilerProcess.processPerfData$lambda$1(this, dump)), this.getProject(), indicator, this.environmentHost);
        NewCallTreeOnlyProfilerData data = new NewCallTreeOnlyProfilerData((CallTreeBuilder)chartBuilder, (BaseCallStackElementRenderer)NativeCallStackElementRenderer.Companion.getINSTANCE());
        return (ProfilerState)new DataReady((ProfilerData)data, this.createDumpWriter(data));
    }

    private final ProfilerDumpWriter createDumpWriter(NewCallTreeOnlyProfilerData data) {
        return (ProfilerDumpWriter)new CollapsedProfilerDumpWriter(data.getBuilder(), ((NativeTargetProcess)this.getTargetProcess()).getFullName(), this.getAttachedTimestamp(), PerfProfilerProcess::createDumpWriter$lambda$2, PerfProfilerProcess::createDumpWriter$lambda$3);
    }

    /*
     * WARNING - void declaration
     */
    private final void addStackToChart(DummyCallTreeBuilder<BaseCallStackElement> chartBuilder, PerfSample sample) {
        Collection<NavigatableNativeCall> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = CollectionsKt.asReversed(sample.getFrames());
        ThreadInfo threadInfo = (ThreadInfo)new NativeThread(sample.getThreadId(), sample.getThreadName());
        DummyCallTreeBuilder<BaseCallStackElement> dummyCallTreeBuilder = chartBuilder;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            PerfFrame perfFrame = (PerfFrame)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.createNavigatableNativeCall((PerfFrame)it));
        }
        collection = (List)destination$iv$iv;
        dummyCallTreeBuilder.addStack(threadInfo, (List)collection, 1L);
    }

    private final NavigatableNativeCall createNavigatableNativeCall(PerfFrame frame) {
        String binaryName = this.getBinaryName(frame);
        String functionName = this.getNormalizedFunctionName(frame);
        return new NavigatableNativeCall(binaryName, functionName);
    }

    private final String getBinaryName(PerfFrame frame) {
        String string = new File(frame.getBinary()).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    private final String getNormalizedFunctionName(PerfFrame frame) {
        return ParserUtilKt.fastRemoveCppFunctionArgs((String)frame.getFunction(), (boolean)true);
    }

    private final void tryDeletePerfData(Path dumpPath) {
        if (PerfProfilerSettings.Companion.getInstance().getState().getDeleteOutputOnExit()) {
            Files.deleteIfExists(dumpPath);
        }
    }

    @NotNull
    public LegacyBridgeProfilerConfiguration getProfilerConfiguration() {
        return this.profilerConfiguration;
    }

    @NotNull
    public String getHelpId() {
        return this.helpId;
    }

    public boolean canBeStopped() {
        return true;
    }

    protected boolean doStop() {
        if (this.perfProcessHandler instanceof KillableProcessHandler && ((KillableProcessHandler)this.perfProcessHandler).shouldKillProcessSoftly()) {
            this.perfProcessHandler.destroyProcess();
        } else if (!this.trySendSigtermSignal()) {
            this.perfProcessHandler.destroyProcess();
        }
        return true;
    }

    private final boolean trySendSigtermSignal() {
        try {
            Object object = ProgressManager.getInstance().runProcessWithProgressSynchronously(() -> PerfProfilerProcess.trySendSigtermSignal$lambda$5(this), CPPProfilerBundleKt.profilerMessage("perf.profiler.stop.process.progress", new Object[0]), true, this.getProject());
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"runProcessWithProgressSynchronously(...)");
            return (Boolean)object;
        }
        catch (Exception e) {
            staticLogger.warn("Failed to stop perf profiler gracefully", (Throwable)e);
            return false;
        }
    }

    /*
     * Unable to fully structure code
     */
    private final Integer findPid() {
        block4: {
            if (!this.environmentHost.isRemote(this.getProject())) {
                return Math.toIntExact(this.perfProcessHandler.getProcess().pid());
            }
            processList = this.environmentHost.getProcessList(this.getProject());
            $this$firstOrNull$iv = processList;
            $i$f$firstOrNull = false;
            for (T element$iv : $this$firstOrNull$iv) {
                processInfo = (ProcessInfo)element$iv;
                $i$a$-firstOrNull-PerfProfilerProcess$findPid$targetPerfProcess$1 = false;
                if (!Intrinsics.areEqual((Object)processInfo.getExecutableName(), (Object)"perf")) ** GOTO lbl-1000
                v0 = processInfo.getArgs();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getArgs(...)");
                if (StringsKt.contains$default((CharSequence)v0, (CharSequence)this.environmentHost.getEnvPath(this.outputPerfDataFile.toString(), this.getProject()), (boolean)false, (int)2, null)) {
                    v1 = true;
                } else lbl-1000:
                // 2 sources

                {
                    v1 = false;
                }
                if (!v1) continue;
                v2 = element$iv;
                break block4;
            }
            v2 = null;
        }
        v3 = targetPerfProcess = (ProcessInfo)v2;
        return v3 != null ? Integer.valueOf(v3.getPid()) : null;
    }

    private static final Unit processPerfData$lambda$0(PerfProfilerProcess this$0, DummyCallTreeBuilder $chartBuilder, PerfSample sample) {
        Intrinsics.checkNotNullParameter((Object)sample, (String)"sample");
        this$0.addStackToChart((DummyCallTreeBuilder<BaseCallStackElement>)$chartBuilder, sample);
        return Unit.INSTANCE;
    }

    private static final Unit processPerfData$lambda$1(PerfProfilerProcess this$0, Path $dump) {
        this$0.tryDeletePerfData($dump);
        return Unit.INSTANCE;
    }

    private static final String createDumpWriter$lambda$2(BaseCallStackElement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.fullName();
    }

    private static final String createDumpWriter$lambda$3(ThreadInfo it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getName();
    }

    private static final Boolean trySendSigtermSignal$lambda$5(PerfProfilerProcess this$0) {
        Integer pid = this$0.findPid();
        if (pid == null) {
            staticLogger.warn("Cannot find perf PID");
            return false;
        }
        return this$0.environmentHost.sendSignal(pid, "TERM", this$0.getProject()) == 0;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(PerfProfilerProcess.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        staticLogger = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/profiler/clion/perf/PerfProfilerProcess$Companion;", "", "<init>", "()V", "staticLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.profiler.clion"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

