/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.clion.perf;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.KillableProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.profiler.MisConfiguredException;
import com.intellij.profiler.ProfilerToolWindowManager;
import com.intellij.profiler.api.ProfilerProcess;
import com.intellij.profiler.clion.CPPProfilerBundleKt;
import com.intellij.profiler.clion.ProfilerConfigurationExtension;
import com.intellij.profiler.clion.ProfilerEnvironmentHost;
import com.intellij.profiler.clion.ProfilerRunChecker;
import com.intellij.profiler.clion.perf.PerfProfilerProcess;
import com.intellij.profiler.clion.perf.PerfProfilerSettings;
import com.intellij.profiler.clion.perf.PerfUtils;
import com.intellij.profiler.dtrace.SimpleProfilerSettingsState;
import com.intellij.profiler.statistics.ProfilerUsageTriggerCollector;
import com.intellij.util.text.StringKt;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.SpreadBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\"\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J:\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J:\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016R!\u0010\u0004\u001a\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/profiler/clion/perf/PerfProfilerConfigurationExtension;", "Lcom/intellij/profiler/clion/ProfilerConfigurationExtension;", "<init>", "()V", "PERF_OUTPUT_FILE_KEY", "Lcom/intellij/openapi/util/Key;", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "isApplicableFor", "", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "isEnabledFor", "environmentHost", "Lcom/intellij/profiler/clion/ProfilerEnvironmentHost;", "runnerSettings", "Lcom/intellij/execution/configurations/RunnerSettings;", "patchCommandLine", "", "cmdLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "runnerId", "", "holder", "Lcom/intellij/openapi/util/UserDataHolder;", "attachToProcess", "handler", "Lcom/intellij/execution/process/ProcessHandler;", "Companion", "intellij.profiler.clion"})
@SourceDebugExtension(value={"SMAP\nPerfProfilerConfigurationExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerfProfilerConfigurationExtension.kt\ncom/intellij/profiler/clion/perf/PerfProfilerConfigurationExtension\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,102:1\n1#2:103\n*E\n"})
public final class PerfProfilerConfigurationExtension
implements ProfilerConfigurationExtension {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Key<Path> PERF_OUTPUT_FILE_KEY;

    public PerfProfilerConfigurationExtension() {
        Key key = Key.create((String)"perf.output");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        this.PERF_OUTPUT_FILE_KEY = key;
    }

    @Override
    public boolean isApplicableFor(@NotNull RunConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        return true;
    }

    @Override
    public boolean isEnabledFor(@NotNull RunConfiguration configuration, @NotNull ProfilerEnvironmentHost environmentHost, @Nullable RunnerSettings runnerSettings) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environmentHost, (String)"environmentHost");
        if (!ProfilerRunChecker.Companion.isProfilerCompatible((RunProfile)configuration) || !ProfilerRunChecker.Companion.isPerfProfilerCanBeUsed()) {
            return false;
        }
        if (SystemInfo.isMac) {
            Project project = configuration.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            if (!environmentHost.isRemote(project)) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void patchCommandLine(@NotNull RunConfiguration configuration, @NotNull ProfilerEnvironmentHost environmentHost, @Nullable RunnerSettings runnerSettings, @NotNull GeneralCommandLine cmdLine, @NotNull String runnerId, @NotNull UserDataHolder holder) {
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)environmentHost, (String)"environmentHost");
        Intrinsics.checkNotNullParameter((Object)cmdLine, (String)"cmdLine");
        Intrinsics.checkNotNullParameter((Object)runnerId, (String)"runnerId");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!Intrinsics.areEqual((Object)"ProfilerRunner", (Object)runnerId)) {
            return;
        }
        Project project = configuration.getProject();
        Intrinsics.checkNotNull((Object)project);
        if (PerfProfilerConfigurationExtension.Companion.isUnsupportedWSL(environmentHost, project)) {
            throw new ExecutionException(CPPProfilerBundleKt.profilerMessage("perf.profiler.wsl.not.support", new Object[0]));
        }
        if (PerfProfilerConfigurationExtension.Companion.isUnsupportedToolchain(environmentHost, project)) {
            throw new ExecutionException(CPPProfilerBundleKt.profilerMessage("perf.profiler.windows.selected.toolchain.not.support", new Object[0]));
        }
        SimpleProfilerSettingsState settings = PerfProfilerSettings.Companion.getInstance().getState();
        MisConfiguredException misConfiguredException = PerfUtils.Companion.validatePerfSettings(environmentHost, project);
        if (misConfiguredException != null) {
            MisConfiguredException it = misConfiguredException;
            boolean bl = false;
            throw it;
        }
        misConfiguredException = PerfUtils.Companion.validateKernelVariables(environmentHost, project);
        if (misConfiguredException != null) {
            MisConfiguredException it = misConfiguredException;
            boolean bl = false;
            throw it;
        }
        Path outputFilePath = PerfUtils.Companion.createOutputFilePath(StringKt.nullize$default((String)settings.getOutputDirectory(), (boolean)false, (int)1, null), environmentHost, project);
        String string = settings.getExecutablePath();
        if (string == null) {
            string = "";
        }
        PerfProfilerConfigurationExtension.Companion.addPerfStarter(cmdLine, string, settings.getSamplingFrequency(), settings.getDefaultCmdArgs(), outputFilePath, environmentHost, project);
        holder.putUserData(this.PERF_OUTPUT_FILE_KEY, (Object)outputFilePath);
    }

    @Override
    public void attachToProcess(@NotNull RunConfiguration configuration, @NotNull ProcessHandler handler2, @NotNull ProfilerEnvironmentHost environmentHost, @Nullable RunnerSettings runnerSettings, @NotNull String runnerId, @NotNull UserDataHolder holder) {
        Path outputFile;
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)handler2, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)environmentHost, (String)"environmentHost");
        Intrinsics.checkNotNullParameter((Object)runnerId, (String)"runnerId");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!Intrinsics.areEqual((Object)"ProfilerRunner", (Object)runnerId)) {
            return;
        }
        Project project = configuration.getProject();
        Intrinsics.checkNotNull((Object)project);
        if (PerfProfilerConfigurationExtension.Companion.isUnsupportedWSL(environmentHost, project) || PerfProfilerConfigurationExtension.Companion.isUnsupportedToolchain(environmentHost, project)) {
            return;
        }
        if (!(handler2 instanceof BaseProcessHandler)) {
            throw new ExecutionException(CPPProfilerBundleKt.profilerMessage("profiler.exception.cannot.detect.target.process", new Object[0]));
        }
        if (handler2 instanceof KillableProcessHandler) {
            ((KillableProcessHandler)handler2).setShouldKillProcessSoftly(true);
        }
        if ((outputFile = (Path)holder.getUserData(this.PERF_OUTPUT_FILE_KEY)) == null) {
            throw new ExecutionException(CPPProfilerBundleKt.profilerMessage("profiler.exception.cannot.get.output.file", new Object[0]));
        }
        BaseProcessHandler baseProcessHandler = (BaseProcessHandler)handler2;
        String string = configuration.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        PerfProfilerProcess profilerProcess = new PerfProfilerProcess(baseProcessHandler, outputFile, string, System.currentTimeMillis(), environmentHost, project);
        String string2 = profilerProcess.getProfilerConfiguration().getConfigurationTypeId();
        String string3 = configuration.getType().getId();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getId(...)");
        ProfilerUsageTriggerCollector.logRecordingStarted((Project)project, (String)string2, (String)string3);
        ProfilerToolWindowManager.addProfilerProcessTab$default((ProfilerToolWindowManager)ProfilerToolWindowManager.Companion.getInstance(project), (ProfilerProcess)((ProfilerProcess)profilerProcess), (boolean)false, (int)2, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002JB\u0010\u000b\u001a\u00020\f*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/profiler/clion/perf/PerfProfilerConfigurationExtension$Companion;", "", "<init>", "()V", "isUnsupportedWSL", "", "environmentHost", "Lcom/intellij/profiler/clion/ProfilerEnvironmentHost;", "project", "Lcom/intellij/openapi/project/Project;", "isUnsupportedToolchain", "addPerfStarter", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "perfPath", "", "samplingFrequency", "", "defaultArgs", "", "outputPath", "Ljava/nio/file/Path;", "intellij.profiler.clion"})
    @SourceDebugExtension(value={"SMAP\nPerfProfilerConfigurationExtension.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PerfProfilerConfigurationExtension.kt\ncom/intellij/profiler/clion/perf/PerfProfilerConfigurationExtension$Companion\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,102:1\n37#2,2:103\n*S KotlinDebug\n*F\n+ 1 PerfProfilerConfigurationExtension.kt\ncom/intellij/profiler/clion/perf/PerfProfilerConfigurationExtension$Companion\n*L\n95#1:103,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isUnsupportedWSL(ProfilerEnvironmentHost environmentHost, Project project) {
            return environmentHost.isWSL(project) && environmentHost.getWSLVersion(project) < 2;
        }

        private final boolean isUnsupportedToolchain(ProfilerEnvironmentHost environmentHost, Project project) {
            return SystemInfo.isWindows && !environmentHost.isRemote(project);
        }

        private final GeneralCommandLine addPerfStarter(GeneralCommandLine $this$addPerfStarter, String perfPath, int samplingFrequency, List<String> defaultArgs, Path outputPath, ProfilerEnvironmentHost environmentHost, Project project) {
            GeneralCommandLine generalCommandLine;
            GeneralCommandLine $this$addPerfStarter_u24lambda_u240 = generalCommandLine = $this$addPerfStarter;
            boolean bl = false;
            ParametersList parametersList = $this$addPerfStarter_u24lambda_u240.getParametersList();
            SpreadBuilder spreadBuilder = new SpreadBuilder(6);
            spreadBuilder.add((Object)"record");
            spreadBuilder.add((Object)("--freq=" + samplingFrequency));
            Collection $this$toTypedArray$iv = defaultArgs;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            spreadBuilder.addSpread((Object)thisCollection$iv.toArray(new String[0]));
            spreadBuilder.add((Object)"-o");
            spreadBuilder.add((Object)environmentHost.getEnvPath(((Object)outputPath).toString(), project));
            spreadBuilder.add((Object)environmentHost.getEnvPath($this$addPerfStarter_u24lambda_u240.getExePath(), project));
            parametersList.prependAll((String[])spreadBuilder.toArray((Object[])new String[spreadBuilder.size()]));
            $this$addPerfStarter_u24lambda_u240.setExePath(environmentHost.getEnvPath(perfPath, project));
            return generalCommandLine;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

