/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.clion;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.profiler.api.BaseCallStackElement;
import com.intellij.profiler.clion.NavigatableSymbolSearcher;
import com.intellij.profiler.model.NativeCall;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.util.containers.Interner;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0006\u0010\b\u001a\u00020\u0007J\u001d\u0010\f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010\u0011J\t\u0010\u0012\u001a\u00020\u0003H\u00c2\u0003J\u0013\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0007H\u00d6\u0001R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000b\u00a8\u0006\u001b"}, d2={"Lcom/intellij/profiler/clion/DTraceNavigatableNativeCall;", "Lcom/intellij/profiler/api/BaseCallStackElement;", "nativeCall", "Lcom/intellij/profiler/model/NativeCall;", "<init>", "(Lcom/intellij/profiler/model/NativeCall;)V", "fullName", "", "methodWithClassOrFunction", "isNavigatable", "", "()Z", "calcNavigatables", "", "Lcom/intellij/psi/NavigatablePsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)[Lcom/intellij/psi/NavigatablePsiElement;", "component1", "copy", "equals", "other", "", "hashCode", "", "toString", "Companion", "intellij.profiler.clion"})
@SourceDebugExtension(value={"SMAP\nDTraceNavigatableNativeCall.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DTraceNavigatableNativeCall.kt\ncom/intellij/profiler/clion/DTraceNavigatableNativeCall\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,37:1\n14#2:38\n*S KotlinDebug\n*F\n+ 1 DTraceNavigatableNativeCall.kt\ncom/intellij/profiler/clion/DTraceNavigatableNativeCall\n*L\n31#1:38\n*E\n"})
public final class DTraceNavigatableNativeCall
extends BaseCallStackElement {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NativeCall nativeCall;
    @NotNull
    private static final Logger LOG;

    public DTraceNavigatableNativeCall(@NotNull NativeCall nativeCall) {
        Intrinsics.checkNotNullParameter((Object)nativeCall, (String)"nativeCall");
        this.nativeCall = nativeCall;
    }

    @NotNull
    public String fullName() {
        return this.nativeCall.fullName();
    }

    @NotNull
    public final String methodWithClassOrFunction() {
        return this.nativeCall.methodWithClassOrFunction();
    }

    public boolean isNavigatable() {
        return true;
    }

    @NotNull
    public NavigatablePsiElement[] calcNavigatables(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        NavigatablePsiElement[] navigatables = NavigatableSymbolSearcher.findNavigatableSymbols(this.nativeCall.methodWithClassOrFunction(), project);
        Intrinsics.checkNotNull((Object)navigatables);
        if (navigatables.length == 0) {
            LOG.warn("Failed to navigate: " + this.nativeCall.methodWithClassOrFunction());
        }
        return navigatables;
    }

    private final NativeCall component1() {
        return this.nativeCall;
    }

    @NotNull
    public final DTraceNavigatableNativeCall copy(@NotNull NativeCall nativeCall) {
        Intrinsics.checkNotNullParameter((Object)nativeCall, (String)"nativeCall");
        return new DTraceNavigatableNativeCall(nativeCall);
    }

    public static /* synthetic */ DTraceNavigatableNativeCall copy$default(DTraceNavigatableNativeCall dTraceNavigatableNativeCall, NativeCall nativeCall, int n, Object object) {
        if ((n & 1) != 0) {
            nativeCall = dTraceNavigatableNativeCall.nativeCall;
        }
        return dTraceNavigatableNativeCall.copy(nativeCall);
    }

    @NotNull
    public String toString() {
        return "DTraceNavigatableNativeCall(nativeCall=" + this.nativeCall + ")";
    }

    public int hashCode() {
        return this.nativeCall.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DTraceNavigatableNativeCall)) {
            return false;
        }
        DTraceNavigatableNativeCall dTraceNavigatableNativeCall = (DTraceNavigatableNativeCall)((Object)other);
        return Intrinsics.areEqual((Object)this.nativeCall, (Object)dTraceNavigatableNativeCall.nativeCall);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(DTraceNavigatableNativeCall.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/profiler/clion/DTraceNavigatableNativeCall$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "read", "Lcom/intellij/profiler/clion/DTraceNavigatableNativeCall;", "string", "", "interner", "Lcom/intellij/util/containers/Interner;", "intellij.profiler.clion"})
    @SourceDebugExtension(value={"SMAP\nDTraceNavigatableNativeCall.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DTraceNavigatableNativeCall.kt\ncom/intellij/profiler/clion/DTraceNavigatableNativeCall$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,37:1\n1#2:38\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final DTraceNavigatableNativeCall read(@NotNull String string, @Nullable Interner<String> interner) {
            DTraceNavigatableNativeCall dTraceNavigatableNativeCall;
            Intrinsics.checkNotNullParameter((Object)string, (String)"string");
            NativeCall nativeCall = NativeCall.Companion.read$default((NativeCall.Companion)NativeCall.Companion, (String)string, interner, null, (int)4, null);
            if (nativeCall != null) {
                NativeCall p0 = nativeCall;
                boolean $i$f$read$stub_for_inlining = false;
                boolean bl = false;
                dTraceNavigatableNativeCall = new DTraceNavigatableNativeCall(p0);
            } else {
                dTraceNavigatableNativeCall = null;
            }
            return dTraceNavigatableNativeCall;
        }

        public static /* synthetic */ DTraceNavigatableNativeCall read$default(Companion companion, String string, Interner interner, int n, Object object) {
            if ((n & 2) != 0) {
                interner = null;
            }
            return companion.read(string, (Interner<String>)interner);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

