/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.profiling.sanitizers;

import com.intellij.cidr.profiling.memory.MemoryProfileConsoleViewWrapper;
import com.intellij.cidr.profiling.memory.MemoryProfileFileReader;
import com.intellij.cidr.profiling.memory.MemoryProfileFileWatcher;
import com.intellij.cidr.profiling.memory.MemoryProfileTreeDataModel;
import com.intellij.cidr.profiling.memory.MemoryProfileUtil;
import com.intellij.cidr.profiling.memory.error.MemoryProfileError;
import com.intellij.cidr.profiling.memory.error.MemoryProfileProblemDescription;
import com.intellij.cidr.profiling.memory.tree.MemoryProfileTree;
import com.intellij.cidr.profiling.memory.ui.MemoryProfileOutputPanel;
import com.intellij.clion.profiling.CLionProfilingBundle;
import com.intellij.clion.profiling.sanitizers.EditSanitizersSettingsAction;
import com.intellij.clion.profiling.sanitizers.ResetDetectLeaksAction;
import com.intellij.clion.profiling.sanitizers.SanitizerFatalErrorKind;
import com.intellij.clion.profiling.sanitizers.SanitizerOutputConsumer;
import com.intellij.clion.profiling.sanitizers.SanitizersKind;
import com.intellij.clion.profiling.sanitizers.SanitizersOptionsBuilder;
import com.intellij.clion.profiling.sanitizers.SanitizersOutputConsumerFactory;
import com.intellij.clion.profiling.sanitizers.SanitizersSettings;
import com.intellij.clion.profiling.sanitizers.SanitizersUsageTriggerCollector;
import com.intellij.clion.profiling.sanitizers.SanitizersUtil;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.cpp.execution.CMakeAppRunConfiguration;
import com.jetbrains.cidr.cpp.execution.CidrExecutionUtil;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.execution.CidrConsoleBuilder;
import com.jetbrains.cidr.execution.CidrCoroutineHelper;
import com.jetbrains.cidr.execution.CidrRunConfigurationExtensionBase;
import com.jetbrains.cidr.execution.ConfigurationExtensionContext;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.toolchains.CidrToolEnvironment;
import com.jetbrains.cidr.lang.workspace.OCCompilerSettings;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCRunConfiguration;
import com.jetbrains.cidr.lang.workspace.compiler.AppleClangCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.ClangClCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.ClangCompilerKind;
import com.jetbrains.cidr.lang.workspace.compiler.OCCompilerKind;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SanitizersConfigurationExtension
extends CidrRunConfigurationExtensionBase {
    private static final Key<String> BINARY_EXE_PATH = Key.create((String)"sanitizers.binary.exe.path");
    private static final Key<Path> OUTPUT_DIRECTORY = Key.create((String)"sanitizers.output_directory");
    private static final Key<MemoryProfileTreeDataModel> DATA_MODEL_KEY = Key.create((String)"sanitizers.data_model");
    private static final Key<MemoryProfileOutputPanel> OUTPUT_PANEL_KEY = Key.create((String)"sanitizers.output_panel");
    private static final Key<Boolean> COMPILER_SUPPORTED_KEY = Key.create((String)"sanitizers.compiler_supported");
    @NlsSafe
    private static final String LLVM_SYMBOLIZER_BINARY_NAME = "llvm-symbolizer";

    public boolean isApplicableFor(@NotNull OCRunConfiguration configuration) {
        if (configuration == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(0);
        }
        return true;
    }

    public boolean isEnabledFor(@NotNull OCRunConfiguration applicableConfiguration, @NotNull CidrToolEnvironment environment, @Nullable RunnerSettings runnerSettings) {
        if (applicableConfiguration == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(1);
        }
        if (environment == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(2);
        }
        return SanitizersUtil.compiledWithSanitizeSwitch(applicableConfiguration);
    }

    public void patchCommandLine(@NotNull OCRunConfiguration configuration, @Nullable RunnerSettings runnerSettings, @NotNull CidrToolEnvironment environment, @NotNull GeneralCommandLine cmdLine, @NotNull String runnerId, @NotNull ConfigurationExtensionContext context) {
        Path outputDirectory;
        if (configuration == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(3);
        }
        if (environment == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(4);
        }
        if (cmdLine == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(5);
        }
        if (runnerId == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(6);
        }
        if (context == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(7);
        }
        try {
            outputDirectory = SanitizersConfigurationExtension.createTempDirectory(environment);
        }
        catch (IOException e) {
            this.LOG.error("Failed to create output directory", (Throwable)e);
            return;
        }
        String outputFilePathPrefix = FileUtil.join((String[])new String[]{outputDirectory.toString(), UUID.randomUUID().toString()});
        boolean useVisualRepresentation = SanitizersConfigurationExtension.useVisualRepresentation(configuration, context);
        SanitizersUsageTriggerCollector.trigger(useVisualRepresentation);
        SanitizersOptionsBuilder optionsBuilder = new SanitizersOptionsBuilder(SanitizersSettings.getInstance().getSanitizersFlags(), useVisualRepresentation);
        Map<SanitizersKind, String> options = optionsBuilder.getOptions(environment.toEnvPath(outputFilePathPrefix));
        for (Map.Entry<SanitizersKind, String> entry : options.entrySet()) {
            cmdLine.withEnvironment(entry.getKey().getOptionsName(), entry.getValue());
        }
        context.putUserData(BINARY_EXE_PATH, (Object)environment.toEnvPath(cmdLine.getExePath()));
        context.putUserData(OUTPUT_DIRECTORY, (Object)outputDirectory);
    }

    public void patchCommandLineState(@NotNull OCRunConfiguration configuration, @Nullable RunnerSettings runnerSettings, @NotNull CidrToolEnvironment environment, @Nullable File projectBaseDir, @NotNull CommandLineState state, @NotNull String runnerId, @NotNull ConfigurationExtensionContext context) {
        if (configuration == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(8);
        }
        if (environment == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(9);
        }
        if (state == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(10);
        }
        if (runnerId == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(11);
        }
        if (context == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(12);
        }
        if (!SanitizersConfigurationExtension.isCLionRunner(runnerId) || !SanitizersConfigurationExtension.useVisualRepresentation(configuration, context)) {
            return;
        }
        final String tabTitle = CLionProfilingBundle.message("sanitizers.tabTitle", new Object[0]);
        final Project project = configuration.getProject();
        MemoryProfileTreeDataModel dataModel = new MemoryProfileTreeDataModel(tabTitle, project);
        context.putUserData(DATA_MODEL_KEY, (Object)dataModel);
        final MemoryProfileOutputPanel outputPanel = new MemoryProfileOutputPanel(dataModel, new EditSanitizersSettingsAction(), "SanitizersToolWindow.TreePopup", project);
        context.putUserData(OUTPUT_PANEL_KEY, (Object)outputPanel);
        final Icon icon = AllIcons.Actions.StartMemoryProfile;
        CidrCoroutineHelper.runOnEDT(() -> {
            final ConsoleView console = state.getConsoleBuilder().getConsole();
            state.setConsoleBuilder((TextConsoleBuilder)new CidrConsoleBuilder(project, environment, projectBaseDir == null ? null : projectBaseDir.toPath()){

                @NotNull
                protected ConsoleView createConsole() {
                    return new MemoryProfileConsoleViewWrapper(tabTitle, console, outputPanel, project, icon);
                }
            });
            return null;
        });
    }

    public void attachToProcess(@NotNull OCRunConfiguration configuration, @NotNull ProcessHandler handler2, @NotNull CidrToolEnvironment environment, @Nullable RunnerSettings runnerSettings, @NotNull String runnerId, @NotNull ConfigurationExtensionContext context) {
        Path outputDirectory;
        if (configuration == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(13);
        }
        if (handler2 == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(14);
        }
        if (environment == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(15);
        }
        if (runnerId == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(16);
        }
        if (context == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(17);
        }
        this.LOG.assertTrue((outputDirectory = (Path)context.getUserData(OUTPUT_DIRECTORY)) != null, (Object)"outputDirectory is null");
        if (!SanitizersConfigurationExtension.isCLionRunner(runnerId) || !SanitizersConfigurationExtension.useVisualRepresentation(configuration, context)) {
            handler2.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void processTerminated(@NotNull ProcessEvent event) {
                    if (event == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    MemoryProfileUtil.deleteDirectorySilently(outputDirectory, SanitizersConfigurationExtension.this.LOG);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/clion/profiling/sanitizers/SanitizersConfigurationExtension$2", "processTerminated"));
                }
            });
            return;
        }
        MemoryProfileTreeDataModel dataModel = (MemoryProfileTreeDataModel)context.getUserData(DATA_MODEL_KEY);
        this.LOG.assertTrue(dataModel != null, (Object)"dataModel is null");
        MemoryProfileOutputPanel outputPanel = (MemoryProfileOutputPanel)context.getUserData(OUTPUT_PANEL_KEY);
        this.LOG.assertTrue(outputPanel != null, (Object)"outputPanel is null");
        final MemoryProfileTree tree = outputPanel.getTree();
        handler2.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                MemoryProfileUtil.setTreeBusy(tree, CLionProfilingBundle.message("sanitizers.progress", new Object[0]));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/clion/profiling/sanitizers/SanitizersConfigurationExtension$3", "startNotified"));
            }
        });
        Project project = configuration.getProject();
        File workingDirectory = this.getWorkingDirectory(project);
        if (environment.getHostMachine().isRemote()) {
            this.processOutputFromRemote(tree, dataModel, outputDirectory, workingDirectory, configuration, handler2, environment, project);
        } else {
            this.processLocalOutput(tree, dataModel, outputDirectory, workingDirectory, configuration, handler2, environment, project);
        }
    }

    private void processOutputFromRemote(final @NotNull MemoryProfileTree tree, final @NotNull MemoryProfileTreeDataModel dataModel, final @NotNull Path outputDirectory, final @Nullable File workingDirectory, final @NotNull OCRunConfiguration configuration, @NotNull ProcessHandler handler2, final @NotNull CidrToolEnvironment environment, final Project project) {
        if (tree == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(18);
        }
        if (dataModel == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(19);
        }
        if (outputDirectory == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(20);
        }
        if (configuration == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(21);
        }
        if (handler2 == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(22);
        }
        if (environment == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(23);
        }
        handler2.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (project.isDisposed()) {
                    return;
                }
                MemoryProfileUtil.processOutputFromRemote(CLionProfilingBundle.message("sanitizers.tabTitle", new Object[0]), () -> {
                    try {
                        List<Path> outputFiles = MemoryProfileUtil.getFiles(outputDirectory);
                        SanitizersOutputConsumerFactory factory = new SanitizersOutputConsumerFactory(dataModel, environment, workingDirectory, project);
                        for (Path outputFile : outputFiles) {
                            SanitizerOutputConsumer consumer = factory.get();
                            MemoryProfileFileReader reader = new MemoryProfileFileReader(outputFile, (Consumer<String>)consumer, CLionProfilingBundle.message("sanitizers.tabTitle", new Object[0]));
                            reader.stop();
                        }
                        SanitizersConfigurationExtension.checkFatalErrors(configuration, factory.getConsumers(), project);
                    }
                    catch (Exception e) {
                        SanitizersConfigurationExtension.this.LOG.error("Cannot process Sanitizers output", (Throwable)e);
                    }
                    finally {
                        SanitizersConfigurationExtension.this.dataIsReady(tree, dataModel, configuration, environment);
                        MemoryProfileUtil.deleteDirectorySilently(outputDirectory, SanitizersConfigurationExtension.this.LOG);
                    }
                }, project);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/clion/profiling/sanitizers/SanitizersConfigurationExtension$4", "processTerminated"));
            }
        });
    }

    private void processLocalOutput(final @NotNull MemoryProfileTree tree, final @NotNull MemoryProfileTreeDataModel dataModel, @NotNull Path outputDirectory, @Nullable File workingDirectory, final @NotNull OCRunConfiguration configuration, @NotNull ProcessHandler handler2, final @NotNull CidrToolEnvironment environment, final @NotNull Project project) {
        if (tree == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(24);
        }
        if (dataModel == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(25);
        }
        if (outputDirectory == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(26);
        }
        if (configuration == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(27);
        }
        if (handler2 == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(28);
        }
        if (environment == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(29);
        }
        if (project == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(30);
        }
        final Disposable disposableMarker = Disposer.newDisposable();
        Disposer.register((Disposable)project, (Disposable)disposableMarker);
        final SanitizersOutputConsumerFactory factory = new SanitizersOutputConsumerFactory(dataModel, environment, workingDirectory, project);
        final VirtualFile localOutputDirectory = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(outputDirectory.toFile());
        this.LOG.assertTrue(localOutputDirectory != null && localOutputDirectory.exists(), (Object)"outputDirectory is null or not found");
        final MemoryProfileFileWatcher watcher = new MemoryProfileFileWatcher(localOutputDirectory, factory, CLionProfilingBundle.message("sanitizers.tabTitle", new Object[0]), project, disposableMarker);
        handler2.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    5.$$$reportNull$$$0(0);
                }
                if (project.isDisposed()) {
                    return;
                }
                try {
                    watcher.stop();
                    SanitizersConfigurationExtension.checkFatalErrors(configuration, factory.getConsumers(), project);
                }
                finally {
                    SanitizersConfigurationExtension.this.dataIsReady(tree, dataModel, configuration, environment);
                    Disposer.dispose((Disposable)disposableMarker);
                    MemoryProfileUtil.deleteDirectorySilently(Path.of(localOutputDirectory.getPath(), new String[0]), SanitizersConfigurationExtension.this.LOG);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/clion/profiling/sanitizers/SanitizersConfigurationExtension$5", "processTerminated"));
            }
        });
    }

    private static void checkFatalErrors(@NotNull OCRunConfiguration configuration, @NotNull List<SanitizerOutputConsumer> consumers, @NotNull Project project) {
        String compilerSwitch;
        if (configuration == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(31);
        }
        if (consumers == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(32);
        }
        if (project == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(33);
        }
        SanitizersKind sanitizersKind = (compilerSwitch = CidrExecutionUtil.getCompilerSwitch(configuration, List.of("-fsanitize="))) != null ? SanitizersUtil.getSanitizerKindFromSwitch(compilerSwitch) : null;
        for (SanitizerOutputConsumer consumer : consumers) {
            if (!consumer.hasFatalError()) continue;
            SanitizerFatalErrorKind fatalErrorKind = consumer.getFatalErrorKind();
            assert (fatalErrorKind != null);
            SanitizersConfigurationExtension.showFatalErrorNotification(fatalErrorKind, sanitizersKind, project);
            return;
        }
    }

    private static void showFatalErrorNotification(@NotNull SanitizerFatalErrorKind errorKind, @Nullable SanitizersKind sanitizersKind, @NotNull Project project) {
        if (errorKind == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(34);
        }
        if (project == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(35);
        }
        if (errorKind == SanitizerFatalErrorKind.LEAK_SANITIZER_DEBUG_NOT_SUPPORTED && sanitizersKind != null) {
            MemoryProfileUtil.showNotification(SanitizersUtil.NOTIFICATION_GROUP, CLionProfilingBundle.message("sanitizers.llvmSymbolizer.notification.title", new Object[0]), CLionProfilingBundle.message("sanitizers.fatal.error.during.debug", new Object[0]), NotificationType.ERROR, (AnAction)new ResetDetectLeaksAction(sanitizersKind, project), project);
            return;
        }
        MemoryProfileUtil.showNotification(SanitizersUtil.NOTIFICATION_GROUP, CLionProfilingBundle.message("sanitizers.llvmSymbolizer.notification.title", new Object[0]), CLionProfilingBundle.message("sanitizer.fatal.error.title", new Object[0]), NotificationType.ERROR, null, project);
    }

    private void dataIsReady(@NotNull MemoryProfileTree tree, @NotNull MemoryProfileTreeDataModel dataModel, @NotNull OCRunConfiguration configuration, @NotNull CidrToolEnvironment environment) {
        if (tree == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(36);
        }
        if (dataModel == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(37);
        }
        if (configuration == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(38);
        }
        if (environment == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(39);
        }
        MemoryProfileUtil.setTreeDataReady(tree);
        ApplicationManager.getApplication().invokeLater(() -> this.showLLVMSymbolizerHint(dataModel, configuration, environment));
    }

    private static Path createTempDirectory(@NotNull CidrToolEnvironment environment) throws IOException {
        if (environment == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(40);
        }
        @NlsSafe String sanitizersOutputDirPrefix = "clion-sanitizers";
        return environment.getHostMachine().createTempDirectory("clion-sanitizers", UUID.randomUUID().toString());
    }

    @Nullable
    private File getWorkingDirectory(@NotNull Project project) {
        CMakeAppRunConfiguration.BuildAndRunConfigurations buildAndRunConfigurations;
        if (project == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(41);
        }
        if ((buildAndRunConfigurations = CMakeAppRunConfiguration.getSelectedBuildAndRunConfigurations(project)) == null) {
            this.LOG.warn("Cannot set working directory, since buildAndRunConfigurations not found");
            return null;
        }
        return buildAndRunConfigurations.getRunConfiguration().getConfigurationGenerationDir();
    }

    private void showLLVMSymbolizerHint(MemoryProfileTreeDataModel model, @NotNull OCRunConfiguration configuration, @NotNull CidrToolEnvironment environment) {
        boolean isClangCompiler;
        if (configuration == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(42);
        }
        if (environment == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(43);
        }
        List<MemoryProfileError> errors = model.getErrors();
        boolean bl = isClangCompiler = CidrExecutionUtil.compilerUsed(configuration, new OCCompilerKind[]{ClangCompilerKind.INSTANCE}) || CidrExecutionUtil.compilerUsed(configuration, new OCCompilerKind[]{AppleClangCompilerKind.INSTANCE}) || CidrExecutionUtil.compilerUsed(configuration, new OCCompilerKind[]{ClangClCompilerKind.INSTANCE});
        if (isClangCompiler && SanitizersConfigurationExtension.isNoNavigation(errors) && !this.isLLVMSymbolizerFound(environment)) {
            MemoryProfileUtil.showNotification(SanitizersUtil.NOTIFICATION_GROUP, CLionProfilingBundle.message("sanitizers.llvmSymbolizer.notification.title", new Object[0]), CLionProfilingBundle.message("sanitizers.llvmSymbolizer.notification.text", new Object[0]), NotificationType.INFORMATION, configuration.getProject());
        }
    }

    private static boolean isCLionRunner(@NotNull String runnerId) {
        if (runnerId == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(44);
        }
        return "CPPAppRunner".equals(runnerId);
    }

    private static boolean useVisualRepresentation(@NotNull OCRunConfiguration configuration, @NotNull ConfigurationExtensionContext context) {
        Boolean compilerSupported;
        if (configuration == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(45);
        }
        if (context == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(46);
        }
        if ((compilerSupported = (Boolean)context.getUserData(COMPILER_SUPPORTED_KEY)) == null) {
            compilerSupported = SanitizersConfigurationExtension.compilerSupported(configuration);
            context.putUserData(COMPILER_SUPPORTED_KEY, (Object)compilerSupported);
        }
        return SanitizersSettings.getInstance().isUseVisualRepresentation() && compilerSupported == Boolean.TRUE;
    }

    private static boolean compilerSupported(@NotNull OCRunConfiguration applicableConfiguration) {
        ExecutionTarget target;
        OCResolveConfiguration resolveConfiguration;
        if (applicableConfiguration == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(47);
        }
        if ((resolveConfiguration = applicableConfiguration.getResolveConfiguration(target = ExecutionTargetManager.getInstance((Project)applicableConfiguration.getProject()).getActiveTarget())) != null) {
            for (CLanguageKind languageKind : CLanguageKind.values()) {
                OCCompilerKind compilerKind;
                OCCompilerSettings compilerSettings = resolveConfiguration.getCompilerSettings((OCLanguageKind)languageKind);
                if (compilerSettings.getCompilerSwitches() == null || (compilerKind = compilerSettings.getCompilerKind()) == null) continue;
                return SanitizersUtil.compilerSupported(resolveConfiguration, (OCLanguageKind)languageKind, compilerKind);
            }
        }
        return false;
    }

    private boolean isLLVMSymbolizerFound(@NotNull CidrToolEnvironment environment) {
        if (environment == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(48);
        }
        if (environment.getHostMachine().isRemote()) {
            return true;
        }
        boolean hasEnvironmentVariableWithLLVMSymbolizerPath = EnvironmentUtil.getEnvironmentMap().entrySet().stream().filter(entry -> StringUtil.containsIgnoreCase((String)((String)entry.getKey()), (String)"SAN_SYMBOLIZER_PATH")).anyMatch(entry -> {
            String environmentValue = (String)entry.getValue();
            if (StringUtil.isEmpty((String)environmentValue)) {
                return false;
            }
            File file = new File(environmentValue);
            return file.exists() && file.canExecute() && StringUtil.containsIgnoreCase((String)file.getName(), (String)LLVM_SYMBOLIZER_BINARY_NAME);
        });
        if (hasEnvironmentVariableWithLLVMSymbolizerPath) {
            return true;
        }
        if (!(environment instanceof CPPEnvironment)) {
            return true;
        }
        try {
            CPPEnvironment.ExecutablePathResult pathResult = ((CPPEnvironment)environment).resolveEnvPathToLocalExecutable((Path)null, LLVM_SYMBOLIZER_BINARY_NAME);
            return StringUtil.isNotEmpty((String)pathResult.path) && pathResult.isResolvedToExecutable;
        }
        catch (ExecutionException e) {
            this.LOG.warn("Failed to resolve llvm-symbolizer path: " + e);
            return true;
        }
    }

    private static boolean isNoNavigation(@NotNull Collection<MemoryProfileError> errors) {
        if (errors == null) {
            SanitizersConfigurationExtension.$$$reportNull$$$0(49);
        }
        return !errors.isEmpty() && ContainerUtil.and(errors, error -> {
            List<MemoryProfileProblemDescription> descriptions = error.getProblemDescriptions();
            return ContainerUtil.and(descriptions, d -> ContainerUtil.and(d.getStack().getFrames(), frame -> MemoryProfileUtil.getNavigationData(frame) == null));
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 1: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "applicableConfiguration";
                break;
            }
            case 2: 
            case 4: 
            case 9: 
            case 15: 
            case 23: 
            case 29: 
            case 39: 
            case 40: 
            case 43: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cmdLine";
                break;
            }
            case 6: 
            case 11: 
            case 16: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnerId";
                break;
            }
            case 7: 
            case 12: 
            case 17: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 14: 
            case 22: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 18: 
            case 24: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 19: 
            case 25: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataModel";
                break;
            }
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDirectory";
                break;
            }
            case 30: 
            case 33: 
            case 35: 
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumers";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorKind";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
        }
        objectArray2[1] = "com/intellij/clion/profiling/sanitizers/SanitizersConfigurationExtension";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicableFor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isEnabledFor";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "patchCommandLine";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "patchCommandLineState";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "attachToProcess";
                break;
            }
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[2] = "processOutputFromRemote";
                break;
            }
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray2;
                objectArray2[2] = "processLocalOutput";
                break;
            }
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray2;
                objectArray2[2] = "checkFatalErrors";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[2] = "showFatalErrorNotification";
                break;
            }
            case 36: 
            case 37: 
            case 38: 
            case 39: {
                objectArray = objectArray2;
                objectArray2[2] = "dataIsReady";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[2] = "createTempDirectory";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[2] = "getWorkingDirectory";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray2;
                objectArray2[2] = "showLLVMSymbolizerHint";
                break;
            }
            case 44: {
                objectArray = objectArray2;
                objectArray2[2] = "isCLionRunner";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray2;
                objectArray2[2] = "useVisualRepresentation";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[2] = "compilerSupported";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[2] = "isLLVMSymbolizerFound";
                break;
            }
            case 49: {
                objectArray = objectArray2;
                objectArray2[2] = "isNoNavigation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

