/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.featuresTrainer.lesson.navigation;

import com.intellij.clion.featuresTrainer.lesson.CLionLessonUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import training.dsl.LessonSample;
import training.dsl.LessonSampleKt;
import training.learn.lesson.general.navigation.OccurrencesLesson;
import training.util.LessonEndInfo;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\nH\u0016R\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/clion/featuresTrainer/lesson/navigation/CLionOccurrencesLesson;", "Ltraining/learn/lesson/general/navigation/OccurrencesLesson;", "<init>", "()V", "prepare", "", "project", "Lcom/intellij/openapi/project/Project;", "onLessonEnd", "lessonEndInfo", "Ltraining/util/LessonEndInfo;", "sample", "Ltraining/dsl/LessonSample;", "getSample", "()Ltraining/dsl/LessonSample;", "intellij.clion.featuresTrainer"})
public final class CLionOccurrencesLesson
extends OccurrencesLesson {
    @NotNull
    private final LessonSample sample = LessonSampleKt.parseLessonSample((String)"#include <string>\n\nclass DataEntry {\npublic:\n  virtual ~DataEntry() = default;\n  virtual std::string getCellphone() = 0;\n  virtual std::string getName() = 0;\n};\n\nclass Person final : public DataEntry {\n  std::string name;\n  int age;\n  std::string cellphone;\n\npublic:\n  Person(std::string name, int age, std::string cellphone)\n      : name(std::move(name)), age(age), cellphone(std::move(cellphone)) {}\n\n  std::string getCellphone() override { return cellphone; }\n\n  std::string getName() override { return name; }\n};\n\nclass OccurrencesDemo {\npublic:\n  OccurrencesDemo(std::string name, const int age, const std::string &<select>cellphone</select>)\n      : DATABASE_(\"MyDataBase\") {\n    myPerson_ = new Person(std::move(name), age, \"Cellphone: \" + cellphone);\n  }\n\n  ~OccurrencesDemo() { delete myPerson_; }\n\nprivate:\n  const std::string DATABASE_;\n  DataEntry *myPerson_;\n};");

    public void prepare(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super.prepare(project);
        CLionLessonUtil.INSTANCE.loadCMakeWorkspace(project);
    }

    public void onLessonEnd(@NotNull Project project, @NotNull LessonEndInfo lessonEndInfo) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lessonEndInfo, (String)"lessonEndInfo");
        super.onLessonEnd(project, lessonEndInfo);
        ApplicationManager.getApplication().invokeLater(CLionOccurrencesLesson::onLessonEnd$lambda$0, ModalityState.nonModal());
    }

    @NotNull
    public LessonSample getSample() {
        return this.sample;
    }

    private static final void onLessonEnd$lambda$0() {
        FileDocumentManager.getInstance().saveAllDocuments();
    }
}

