/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.profiling.valgrind.actions;

import com.intellij.cidr.profiling.memory.MemoryProfileEnvironment;
import com.intellij.cidr.profiling.memory.MemoryProfileTreeDataModel;
import com.intellij.cidr.profiling.memory.actions.MemoryProfileImportAction;
import com.intellij.cidr.profiling.valgrind.ValgrindExecutor;
import com.intellij.cidr.profiling.valgrind.ValgrindHandler;
import com.intellij.cidr.profiling.valgrind.ValgrindOutputConsumer;
import com.intellij.cidr.profiling.valgrind.ValgrindUtil;
import com.intellij.cidr.profiling.valgrind.actions.EditValgrindSettingsAction;
import com.intellij.execution.Executor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class ValgrindImportAction
extends MemoryProfileImportAction {
    @Override
    @NlsSafe
    protected String getProfilerName() {
        return "Valgrind";
    }

    @Override
    protected AnAction getEditSettingsAction() {
        return new EditValgrindSettingsAction();
    }

    @Override
    protected String getTreePopupId() {
        return "ValgrindToolWindow.TreePopup";
    }

    @Override
    protected Executor getExecutor() {
        return ValgrindExecutor.getExecutorInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean tryParse(@NotNull AnActionEvent e, @NotNull MemoryProfileEnvironment environment, @NotNull String filePath, @NotNull ProgressIndicator indicator, @NotNull MemoryProfileTreeDataModel dataModel) {
        if (e == null) {
            ValgrindImportAction.$$$reportNull$$$0(0);
        }
        if (environment == null) {
            ValgrindImportAction.$$$reportNull$$$0(1);
        }
        if (filePath == null) {
            ValgrindImportAction.$$$reportNull$$$0(2);
        }
        if (indicator == null) {
            ValgrindImportAction.$$$reportNull$$$0(3);
        }
        if (dataModel == null) {
            ValgrindImportAction.$$$reportNull$$$0(4);
        }
        ValgrindHandler handler2 = new ValgrindHandler(dataModel, environment);
        ValgrindOutputConsumer consumer = new ValgrindOutputConsumer(handler2, null);
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(filePath));
            String line = reader.readLine();
            while (line != null) {
                if (indicator.isCanceled()) {
                    boolean bl = false;
                    return bl;
                }
                consumer.consume(line);
                line = reader.readLine();
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException exc) {
            LOG.warn(ValgrindImportAction.getLogMessage("exception: " + exc.toString()));
            boolean bl = false;
            return bl;
        }
        finally {
            Disposer.dispose((Disposable)consumer);
            if (reader != null) {
                ValgrindUtil.tryClose(reader);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "e";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "environment";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "filePath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "indicator";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "dataModel";
                break;
            }
        }
        objectArray[1] = "com/intellij/cidr/profiling/valgrind/actions/ValgrindImportAction";
        objectArray[2] = "tryParse";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

