/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.profiling.valgrind;

import com.intellij.cidr.profiling.valgrind.ValgrindHandler;
import com.intellij.cidr.profiling.valgrind.ValgrindUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Consumer;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ValgrindOutputConsumer
implements Consumer<String>,
Disposable {
    private static final Logger LOG = Logger.getInstance((String)ValgrindOutputConsumer.class.getName());
    private PipedOutputStream myPipedOutputStream;
    private PipedInputStream myPipedInputStream;
    private SAXParser myParser;
    private Future<?> myParseTask;

    public ValgrindOutputConsumer(@NotNull ValgrindHandler handler2, @Nullable Disposable parentDisposable) {
        if (handler2 == null) {
            ValgrindOutputConsumer.$$$reportNull$$$0(0);
        }
        try {
            if (parentDisposable != null) {
                Disposer.register((Disposable)parentDisposable, (Disposable)this);
            }
            this.myPipedOutputStream = new PipedOutputStream();
            this.myPipedInputStream = new PipedInputStream(this.myPipedOutputStream);
            this.myParser = SAXParserFactory.newDefaultInstance().newSAXParser();
            this.myParseTask = ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    this.myParser.parse((InputStream)this.myPipedInputStream, (DefaultHandler)handler2);
                }
                catch (IOException | SAXException e) {
                    LOG.warn((Throwable)e);
                }
            });
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOG.warn((Throwable)e);
        }
    }

    public void consume(String s) {
        try {
            this.myPipedOutputStream.write(s.getBytes(StandardCharsets.UTF_8));
            this.myPipedOutputStream.flush();
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    public void dispose() {
        if (!ValgrindUtil.tryClose(this.myPipedOutputStream)) {
            LOG.warn("Failed to close myPipedOutputStream");
        }
        ValgrindOutputConsumer.tryStop(this.myParseTask);
        if (!ValgrindUtil.tryClose(this.myPipedInputStream)) {
            LOG.warn("Failed to close myPipedInputStream");
        }
    }

    private static void tryStop(@Nullable Future<?> task2) {
        try {
            if (task2 != null) {
                task2.get();
            }
        }
        catch (InterruptedException | ExecutionException e) {
            LOG.warn((Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/cidr/profiling/valgrind/ValgrindOutputConsumer", "<init>"));
    }
}

