/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.profiling.memory.ui;

import com.intellij.cidr.profiling.memory.MemoryProfileDataKeys;
import com.intellij.cidr.profiling.memory.MemoryProfileTreeDataModel;
import com.intellij.cidr.profiling.memory.actions.MemoryProfileExportAction;
import com.intellij.cidr.profiling.memory.actions.MemoryProfileGroupByDirectoryAction;
import com.intellij.cidr.profiling.memory.error.MemoryProfileFrame;
import com.intellij.cidr.profiling.memory.tree.MemoryProfileStackFrameTreeNode;
import com.intellij.cidr.profiling.memory.tree.MemoryProfileTree;
import com.intellij.cidr.profiling.memory.tree.MemoryProfileTreeNode;
import com.intellij.cidr.profiling.memory.ui.MemoryProfileAutoScrollToSourceHandler;
import com.intellij.cidr.profiling.memory.ui.MemoryProfileExclusionHandler;
import com.intellij.cidr.profiling.memory.ui.MemoryProfileNoPreviewPanel;
import com.intellij.cidr.profiling.memory.ui.MemoryProfileOccurenceNavigator;
import com.intellij.cidr.profiling.memory.ui.MemoryProfileStackFramePreviewPanel;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.exclusion.ExclusionHandler;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.OpenSourceUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MemoryProfileOutputPanel
extends JPanel
implements UiDataProvider,
Disposable {
    @NotNull
    private final MemoryProfileTreeDataModel myTreeDataModel;
    @NotNull
    private final AnAction myEditSettingsAction;
    @NotNull
    private final String myTreePopupId;
    @NotNull
    private final Project myProject;
    @NotNull
    private final MemoryProfileTree myTree;
    @NotNull
    private final MemoryProfileNoPreviewPanel myNoPreviewPanel;
    @NotNull
    private final Splitter mySplitter;
    @NotNull
    private final MemoryProfileOccurenceNavigator myOccurenceNavigator;
    @NotNull
    private final MemoryProfileAutoScrollToSourceHandler myAutoScrollToSourceHandler;
    @NotNull
    private final MemoryProfileExclusionHandler myExclusionHandler;
    @NotNull
    private final MemoryProfileExportAction myExportAction;
    @NotNull
    private final List<ActionToolbar> myToolbars;
    @NotNull
    private final Map<MemoryProfileFrame, MemoryProfileStackFramePreviewPanel> myPreviewCache;

    public MemoryProfileOutputPanel(@NotNull MemoryProfileTreeDataModel treeDataModel, @NotNull AnAction editSettingsAction, @NonNls @NotNull String treePopupId, @NotNull Project project) {
        if (treeDataModel == null) {
            MemoryProfileOutputPanel.$$$reportNull$$$0(0);
        }
        if (editSettingsAction == null) {
            MemoryProfileOutputPanel.$$$reportNull$$$0(1);
        }
        if (treePopupId == null) {
            MemoryProfileOutputPanel.$$$reportNull$$$0(2);
        }
        if (project == null) {
            MemoryProfileOutputPanel.$$$reportNull$$$0(3);
        }
        this.myToolbars = new ArrayList<ActionToolbar>();
        this.myPreviewCache = new HashMap<MemoryProfileFrame, MemoryProfileStackFramePreviewPanel>();
        this.myTreeDataModel = treeDataModel;
        this.myEditSettingsAction = editSettingsAction;
        this.myTreePopupId = treePopupId;
        this.myProject = project;
        this.myTree = new MemoryProfileTree(treeDataModel);
        this.myNoPreviewPanel = new MemoryProfileNoPreviewPanel();
        this.mySplitter = new OnePixelSplitter(false, 0.5f);
        this.mySplitter.setFirstComponent((JComponent)ScrollPaneFactory.createScrollPane((Component)((Object)this.myTree), (int)1));
        this.mySplitter.setHonorComponentsMinimumSize(false);
        this.mySplitter.setSecondComponent((JComponent)this.myNoPreviewPanel);
        this.myOccurenceNavigator = new MemoryProfileOccurenceNavigator(this.myTree);
        this.myAutoScrollToSourceHandler = new MemoryProfileAutoScrollToSourceHandler();
        this.myExclusionHandler = new MemoryProfileExclusionHandler(this.myTree);
        this.myExportAction = new MemoryProfileExportAction(null);
        this.setLayout(new BorderLayout());
        this.add((Component)this.mySplitter, "Center");
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            this.addActionToolbars();
            this.configureTreeListeners();
        }
        this.updatePreviewPanel();
        Disposer.register((Disposable)project, (Disposable)this);
    }

    private void configureTreeListeners() {
        this.myTree.getSelectionModel().addTreeSelectionListener(event -> {
            this.updatePreviewPanel();
            if (this.myAutoScrollToSourceHandler.isAutoScrollMode()) {
                OpenSourceUtil.openSourcesFrom((DataContext)DataManager.getInstance().getDataContext((Component)this), (boolean)false);
            }
        });
        EditSourceOnDoubleClickHandler.install((JTree)((Object)this.myTree));
        EditSourceOnEnterKeyHandler.install((JTree)((Object)this.myTree));
        PopupHandler.installPopupMenu((JComponent)((Object)this.myTree), (String)this.myTreePopupId, (String)"CodeInspection");
    }

    private void updatePreviewPanel() {
        MemoryProfileTreeNode selectedNode = this.getSelectedNode();
        if (selectedNode instanceof MemoryProfileStackFrameTreeNode) {
            MemoryProfileFrame frameToPreview = ((MemoryProfileStackFrameTreeNode)selectedNode).getFrame();
            MemoryProfileStackFramePreviewPanel cachedPreview = this.myPreviewCache.get(frameToPreview);
            if (cachedPreview != null) {
                this.mySplitter.setSecondComponent((JComponent)cachedPreview);
            } else {
                MemoryProfileStackFramePreviewPanel previewPanel = new MemoryProfileStackFramePreviewPanel(frameToPreview, this.myProject);
                this.myPreviewCache.put(frameToPreview, previewPanel);
                this.mySplitter.setSecondComponent((JComponent)previewPanel);
            }
        } else {
            this.mySplitter.setSecondComponent((JComponent)this.myNoPreviewPanel);
        }
    }

    private void addActionToolbars() {
        JPanel actionPanel = new JPanel(new BorderLayout());
        actionPanel.add((Component)this.createLeftActionsToolbar(), "West");
        actionPanel.add((Component)this.createRightActionsToolbar(), "East");
        this.add((Component)actionPanel, "West");
    }

    private JComponent createLeftActionsToolbar() {
        CommonActionsManager actionsManager = CommonActionsManager.getInstance();
        DefaultActionGroup actionGroup2 = new DefaultActionGroup();
        DefaultTreeExpander treeExpander = new DefaultTreeExpander((JTree)((Object)this.myTree));
        actionGroup2.add(actionsManager.createExpandAllAction((TreeExpander)treeExpander, (JComponent)((Object)this.myTree)));
        actionGroup2.add(actionsManager.createCollapseAllAction((TreeExpander)treeExpander, (JComponent)((Object)this.myTree)));
        actionGroup2.add(actionsManager.createPrevOccurenceAction((OccurenceNavigator)this.myOccurenceNavigator));
        actionGroup2.add(actionsManager.createNextOccurenceAction((OccurenceNavigator)this.myOccurenceNavigator));
        return this.createToolbar(actionGroup2);
    }

    private JComponent createRightActionsToolbar() {
        DefaultActionGroup actionGroup2 = new DefaultActionGroup();
        actionGroup2.add((AnAction)new MemoryProfileGroupByDirectoryAction(this.myTree, this.myTreeDataModel));
        actionGroup2.add((AnAction)this.myAutoScrollToSourceHandler.createToggleAction());
        actionGroup2.add((AnAction)this.myExportAction);
        actionGroup2.add(this.myEditSettingsAction);
        return this.createToolbar(actionGroup2);
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            MemoryProfileOutputPanel.$$$reportNull$$$0(4);
        }
        MemoryProfileTreeNode selectedNode = this.getSelectedNode();
        sink.set(ExclusionHandler.EXCLUSION_HANDLER, (Object)this.myExclusionHandler);
        sink.set(MemoryProfileDataKeys.TREE, (Object)this.myTree);
        sink.set(MemoryProfileDataKeys.TREE_MODEL, (Object)this.myTreeDataModel);
        sink.set(MemoryProfileDataKeys.SELECTED_NODE, (Object)selectedNode);
        if (selectedNode == null) {
            return;
        }
        sink.lazy(CommonDataKeys.NAVIGATABLE, () -> selectedNode.getNavigatable());
    }

    public void dispose() {
        for (MemoryProfileStackFramePreviewPanel previewPanel : this.myPreviewCache.values()) {
            Disposer.dispose((Disposable)previewPanel);
        }
    }

    private MemoryProfileTreeNode getSelectedNode() {
        int selectionCount = this.myTree.getSelectionModel().getSelectionCount();
        if (selectionCount != 1) {
            return null;
        }
        TreePath selectionPath = this.myTree.getSelectionModel().getSelectionPath();
        return selectionPath != null ? (MemoryProfileTreeNode)selectionPath.getLastPathComponent() : null;
    }

    private JComponent createToolbar(DefaultActionGroup actionGroup2) {
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("CodeInspection", (ActionGroup)actionGroup2, false);
        toolbar.setTargetComponent((JComponent)((Object)this.myTree));
        this.myToolbars.add(toolbar);
        return toolbar.getComponent();
    }

    @NotNull
    public MemoryProfileTree getTree() {
        MemoryProfileTree memoryProfileTree = this.myTree;
        if (memoryProfileTree == null) {
            MemoryProfileOutputPanel.$$$reportNull$$$0(5);
        }
        return memoryProfileTree;
    }

    @NotNull
    public MemoryProfileTreeDataModel getTreeDataModel() {
        MemoryProfileTreeDataModel memoryProfileTreeDataModel = this.myTreeDataModel;
        if (memoryProfileTreeDataModel == null) {
            MemoryProfileOutputPanel.$$$reportNull$$$0(6);
        }
        return memoryProfileTreeDataModel;
    }

    public void setExportContent(@NotNull String exportContent) {
        if (exportContent == null) {
            MemoryProfileOutputPanel.$$$reportNull$$$0(7);
        }
        this.myExportAction.setContentToExport(exportContent);
        this.updateActionsImmediately();
    }

    private void updateActionsImmediately() {
        this.myToolbars.forEach(toolbar -> toolbar.updateActionsImmediately());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treeDataModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editSettingsAction";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "treePopupId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cidr/profiling/memory/ui/MemoryProfileOutputPanel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exportContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cidr/profiling/memory/ui/MemoryProfileOutputPanel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeDataModel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setExportContent";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6 -> new IllegalStateException(string);
        };
    }
}

