/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.profiling.memory.actions;

import com.intellij.cidr.profiling.CidrProfilingBundle;
import com.intellij.cidr.profiling.memory.MemoryProfileEnvironment;
import com.intellij.cidr.profiling.memory.MemoryProfileEnvironmentProvider;
import com.intellij.cidr.profiling.memory.MemoryProfileTreeDataModel;
import com.intellij.cidr.profiling.memory.ui.MemoryProfileOutputPanel;
import com.intellij.execution.Executor;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.impl.BackgroundableProcessIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class MemoryProfileImportAction
extends AnAction {
    protected static final Logger LOG = Logger.getInstance(MemoryProfileImportAction.class);

    public MemoryProfileImportAction() {
        super(AllIcons.ToolbarDecorator.Import);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            MemoryProfileImportAction.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(final @NotNull AnActionEvent e) {
        Project project;
        if (e == null) {
            MemoryProfileImportAction.$$$reportNull$$$0(1);
        }
        if ((project = (Project)e.getData(CommonDataKeys.PROJECT)) == null) {
            LOG.warn(MemoryProfileImportAction.getLogMessage("project is null"));
            return;
        }
        FileChooserDescriptor fileDescriptor = FileChooserDescriptorFactory.createSingleFileDescriptor((String)"xml");
        FileChooser.chooseFile((FileChooserDescriptor)fileDescriptor, (Project)project, null, file -> {
            final MemoryProfileEnvironment environment = MemoryProfileEnvironmentProvider.getEnvironment(project);
            if (environment == null) {
                return;
            }
            final String filePath = file.getPath();
            if (!FileUtil.exists((String)filePath)) {
                LOG.warn(MemoryProfileImportAction.getLogMessage("filePath doesn't exist"));
                return;
            }
            Task.Backgroundable task2 = new Task.Backgroundable(project, CidrProfilingBundle.message("memory.profile.import.title", this.getProfilerName())){

                public void run(@NotNull ProgressIndicator indicator) {
                    MemoryProfileTreeDataModel dataModel;
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (!MemoryProfileImportAction.this.tryParse(e, environment, filePath, indicator, dataModel = new MemoryProfileTreeDataModel(MemoryProfileImportAction.this.getProfilerName(), project))) {
                        if (!indicator.isCanceled()) {
                            LOG.warn(MemoryProfileImportAction.getLogMessage("file content is invalid"));
                        }
                        return;
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        MemoryProfileOutputPanel panel2 = new MemoryProfileOutputPanel(dataModel, MemoryProfileImportAction.this.getEditSettingsAction(), MemoryProfileImportAction.this.getTreePopupId(), project);
                        RunContentDescriptor contentDescriptor = new RunContentDescriptor(null, null, (JComponent)panel2, MemoryProfileImportAction.this.getProfilerName());
                        RunContentManager.getInstance((Project)project).showRunContent(MemoryProfileImportAction.this.getExecutor(), contentDescriptor);
                    }, value -> indicator.isCanceled());
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/cidr/profiling/memory/actions/MemoryProfileImportAction$1", "run"));
                }
            };
            ProgressManager.getInstance().runProcessWithProgressAsynchronously(task2, (ProgressIndicator)new BackgroundableProcessIndicator(task2));
        });
    }

    @Nls
    protected abstract String getProfilerName();

    protected abstract AnAction getEditSettingsAction();

    protected abstract String getTreePopupId();

    protected abstract Executor getExecutor();

    protected abstract boolean tryParse(@NotNull AnActionEvent var1, @NotNull MemoryProfileEnvironment var2, @NotNull String var3, @NotNull ProgressIndicator var4, @NotNull MemoryProfileTreeDataModel var5);

    @NonNls
    protected static String getLogMessage(@NonNls @NotNull String reason) {
        if (reason == null) {
            MemoryProfileImportAction.$$$reportNull$$$0(2);
        }
        return "Failed to perform Import action, because " + reason;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cidr/profiling/memory/actions/MemoryProfileImportAction";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reason";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cidr/profiling/memory/actions/MemoryProfileImportAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLogMessage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }
}

