/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cidr.profiling.memory;

import com.intellij.cidr.profiling.CidrProfilingBundle;
import com.intellij.cidr.profiling.memory.MemoryProfileNavigationData;
import com.intellij.cidr.profiling.memory.MemoryProfileTreeDataModel;
import com.intellij.cidr.profiling.memory.error.MemoryProfileError;
import com.intellij.cidr.profiling.memory.error.MemoryProfileFrame;
import com.intellij.cidr.profiling.memory.error.MemoryProfileProblemDescription;
import com.intellij.cidr.profiling.memory.error.MemoryProfileStack;
import com.intellij.cidr.profiling.memory.tree.MemoryProfileErrorCaptionTreeNode;
import com.intellij.cidr.profiling.memory.tree.MemoryProfileTree;
import com.intellij.cidr.profiling.memory.tree.MemoryProfileTreeNode;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.PathKt;
import com.intellij.util.ui.StatusText;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MemoryProfileUtil {
    private MemoryProfileUtil() {
    }

    @NlsSafe
    @NotNull
    public static String dump(@NotNull MemoryProfileError error, int stackTraceIndent) {
        if (error == null) {
            MemoryProfileUtil.$$$reportNull$$$0(0);
        }
        return MemoryProfileUtil.dump(error, stackTraceIndent, System.lineSeparator());
    }

    @NlsSafe
    @NotNull
    public static String dump(@NotNull MemoryProfileError error, int stackTraceIndent, @NotNull @NlsSafe String newLineSeparator) {
        if (error == null) {
            MemoryProfileUtil.$$$reportNull$$$0(1);
        }
        if (newLineSeparator == null) {
            MemoryProfileUtil.$$$reportNull$$$0(2);
        }
        StringBuilder dump = new StringBuilder();
        if (StringUtil.isNotEmpty((String)error.getCaption())) {
            dump.append(error.getCaption()).append(newLineSeparator);
        }
        for (MemoryProfileProblemDescription description : error.getProblemDescriptions()) {
            if (StringUtil.isNotEmpty((String)description.getText())) {
                dump.append(description.getText()).append(newLineSeparator);
            }
            for (MemoryProfileFrame frame : description.getStack().getFrames()) {
                dump.append(StringUtil.repeat((String)" ", (int)stackTraceIndent)).append("at ");
                if (StringUtil.isNotEmpty((String)frame.getInstructionPointer())) {
                    dump.append(frame.getInstructionPointer());
                }
                if (StringUtil.isNotEmpty((String)frame.getFunction())) {
                    dump.append(" ").append(frame.getFunction());
                }
                if (StringUtil.isNotEmpty((String)frame.getFile())) {
                    String fileName = new File(frame.getFile()).getName();
                    dump.append(" (").append(fileName);
                    if (StringUtil.isNotEmpty((String)frame.getLine())) {
                        dump.append(":").append(frame.getLine());
                    }
                    dump.append(")");
                }
                dump.append(newLineSeparator);
            }
        }
        String string = dump.toString();
        if (string == null) {
            MemoryProfileUtil.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public static MemoryProfileError findNearestErrorInTheParent(@NotNull TreeNode node) {
        if (node == null) {
            MemoryProfileUtil.$$$reportNull$$$0(4);
        }
        while (node != null && !(node instanceof MemoryProfileErrorCaptionTreeNode)) {
            node = node.getParent();
        }
        return node != null ? ((MemoryProfileErrorCaptionTreeNode)node).getError() : null;
    }

    public static void deleteDirectorySilently(@NotNull Path directory, Logger logger) {
        if (directory == null) {
            MemoryProfileUtil.$$$reportNull$$$0(5);
        }
        try {
            if (!Files.exists(directory, new LinkOption[0])) {
                return;
            }
            PathKt.delete((Path)directory, (boolean)true);
        }
        catch (Exception e) {
            logger.warn("Cannot delete directory: " + directory, (Throwable)e);
        }
    }

    @NotNull
    public static List<Path> getFiles(@NotNull Path outputDirectory) throws IOException {
        if (outputDirectory == null) {
            MemoryProfileUtil.$$$reportNull$$$0(6);
        }
        Stream<Path> stream = Files.list(outputDirectory);
        List<Path> list2 = stream.collect(Collectors.toList());
        List<Path> list3 = list2;
        if (list3 == null) {
            MemoryProfileUtil.$$$reportNull$$$0(7);
        }
        return list3;
        finally {
            if (stream != null) {
                stream.close();
            }
        }
    }

    public static boolean isModelNavigatable(@NotNull MemoryProfileTreeDataModel model) {
        if (model == null) {
            MemoryProfileUtil.$$$reportNull$$$0(8);
        }
        for (MemoryProfileError error : model.getErrors()) {
            if (MemoryProfileUtil.getInnermostNavigatableStackFrame(error) == null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static MemoryProfileFrame getInnermostNavigatableStackFrame(@NotNull MemoryProfileError error) {
        if (error == null) {
            MemoryProfileUtil.$$$reportNull$$$0(9);
        }
        for (MemoryProfileProblemDescription description : error.getProblemDescriptions()) {
            MemoryProfileFrame frame;
            if (description.getStack().isEmpty() || (frame = MemoryProfileUtil.getInnermostNavigatableStackFrame(description.getStack())) == null) continue;
            return frame;
        }
        return null;
    }

    @Nullable
    public static MemoryProfileFrame getInnermostNavigatableStackFrame(@NotNull MemoryProfileStack stack) {
        if (stack == null) {
            MemoryProfileUtil.$$$reportNull$$$0(10);
        }
        return (MemoryProfileFrame)ContainerUtil.find(stack.getFrames(), frame -> StringUtil.isNotEmpty((String)frame.getDirectory()) && StringUtil.isNotEmpty((String)frame.getFile()));
    }

    public static void removeNode(@NotNull MemoryProfileTreeNode node, @NotNull MemoryProfileTreeDataModel dataModel) {
        MemoryProfileTreeNode parentNode;
        if (node == null) {
            MemoryProfileUtil.$$$reportNull$$$0(11);
        }
        if (dataModel == null) {
            MemoryProfileUtil.$$$reportNull$$$0(12);
        }
        MemoryProfileTreeNode nodeToRemove = node;
        for (parentNode = (MemoryProfileTreeNode)node.getParent(); parentNode != null && parentNode != dataModel.getRoot() && parentNode.getChildCount() == 1; parentNode = (MemoryProfileTreeNode)parentNode.getParent()) {
            nodeToRemove = parentNode;
        }
        dataModel.removeNodeFromParent(nodeToRemove);
        dataModel.nodeChanged(parentNode);
    }

    @Nullable
    public static MemoryProfileNavigationData getNavigationData(@NotNull MemoryProfileFrame frame) {
        if (frame == null) {
            MemoryProfileUtil.$$$reportNull$$$0(13);
        }
        String directory = StringUtil.notNullize((String)frame.getResolvedLocalDirectory());
        String fileName = StringUtil.notNullize((String)frame.getFile());
        String filePath = FileUtil.join((String[])new String[]{directory, fileName});
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(filePath);
        if (virtualFile == null) {
            return null;
        }
        Document document = (Document)ReadAction.compute(() -> FileDocumentManager.getInstance().getDocument(virtualFile));
        if (document == null) {
            return null;
        }
        int lineNumber = StringUtil.parseInt((String)frame.getLine(), (int)-1) - 1;
        return new MemoryProfileNavigationData(virtualFile, document, lineNumber);
    }

    public static void showNotification(@NotNull NotificationGroup notificationGroup, @NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String message, @NotNull NotificationType notificationType, @NotNull Project project) {
        if (notificationGroup == null) {
            MemoryProfileUtil.$$$reportNull$$$0(14);
        }
        if (title == null) {
            MemoryProfileUtil.$$$reportNull$$$0(15);
        }
        if (message == null) {
            MemoryProfileUtil.$$$reportNull$$$0(16);
        }
        if (notificationType == null) {
            MemoryProfileUtil.$$$reportNull$$$0(17);
        }
        if (project == null) {
            MemoryProfileUtil.$$$reportNull$$$0(18);
        }
        MemoryProfileUtil.showNotification(notificationGroup, title, message, notificationType, null, project);
    }

    public static void showNotification(@NotNull NotificationGroup notificationGroup, @NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.NotificationContent @NotNull String message, @NotNull NotificationType notificationType, @Nullable AnAction action2, @NotNull Project project) {
        if (notificationGroup == null) {
            MemoryProfileUtil.$$$reportNull$$$0(19);
        }
        if (title == null) {
            MemoryProfileUtil.$$$reportNull$$$0(20);
        }
        if (message == null) {
            MemoryProfileUtil.$$$reportNull$$$0(21);
        }
        if (notificationType == null) {
            MemoryProfileUtil.$$$reportNull$$$0(22);
        }
        if (project == null) {
            MemoryProfileUtil.$$$reportNull$$$0(23);
        }
        final Notification notification = notificationGroup.createNotification(title, message, notificationType);
        if (action2 != null) {
            notification.addAction((AnAction)new AnActionWrapper(action2){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.actionPerformed(e);
                    notification.expire();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/cidr/profiling/memory/MemoryProfileUtil$1", "actionPerformed"));
                }
            });
        }
        notification.notify(project);
    }

    public static void processOutputFromRemote(@NotNull @NlsSafe String toolName, final Runnable outputProcessor, @NotNull Project project) {
        if (toolName == null) {
            MemoryProfileUtil.$$$reportNull$$$0(24);
        }
        if (project == null) {
            MemoryProfileUtil.$$$reportNull$$$0(25);
        }
        Task.Backgroundable task2 = new Task.Backgroundable(project, CidrProfilingBundle.message("memory.profile.process.output.from.remote", toolName), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                outputProcessor.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/cidr/profiling/memory/MemoryProfileUtil$2", "run"));
            }
        };
        task2.queue();
    }

    public static void setTreeDataReady(@NotNull MemoryProfileTree tree) {
        if (tree == null) {
            MemoryProfileUtil.$$$reportNull$$$0(26);
        }
        MemoryProfileUtil.changeTreeStatus(tree, false, StatusText.getDefaultEmptyText());
    }

    public static void setTreeBusy(@NotNull MemoryProfileTree tree, @NotNull @Nls String emptyText) {
        if (tree == null) {
            MemoryProfileUtil.$$$reportNull$$$0(27);
        }
        if (emptyText == null) {
            MemoryProfileUtil.$$$reportNull$$$0(28);
        }
        MemoryProfileUtil.changeTreeStatus(tree, true, emptyText);
    }

    private static void changeTreeStatus(@NotNull MemoryProfileTree tree, boolean isBusy, @NotNull @Nls String emptyText) {
        if (tree == null) {
            MemoryProfileUtil.$$$reportNull$$$0(29);
        }
        if (emptyText == null) {
            MemoryProfileUtil.$$$reportNull$$$0(30);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            tree.setPaintBusy(isBusy);
            tree.getEmptyText().setText(emptyText);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newLineSeparator";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/cidr/profiling/memory/MemoryProfileUtil";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputDirectory";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stack";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataModel";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "frame";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationGroup";
                break;
            }
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 16: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 17: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationType";
                break;
            }
            case 18: 
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolName";
                break;
            }
            case 26: 
            case 27: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/cidr/profiling/memory/MemoryProfileUtil";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "dump";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "dump";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findNearestErrorInTheParent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "deleteDirectorySilently";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getFiles";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isModelNavigatable";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getInnermostNavigatableStackFrame";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "removeNode";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getNavigationData";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "showNotification";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processOutputFromRemote";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "setTreeDataReady";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "setTreeBusy";
                break;
            }
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "changeTreeStatus";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7 -> new IllegalStateException(string);
        };
    }
}

