/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.west.ui;

import com.intellij.clion.west.CLionWestBundle;
import com.intellij.clion.west.WestRunner;
import com.intellij.clion.west.settings.WestSettingsKt;
import com.intellij.clion.west.ui.WestExternalToolConfigurable;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.observable.properties.ObservableMutableProperty;
import com.intellij.openapi.observable.properties.ObservableProperty;
import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.cpp.toolchains.CPPEnvironment;
import com.jetbrains.cidr.cpp.toolchains.CPPToolchains;
import com.jetbrains.clion.ui.externaltool.ExecutableDetectPathContributor;
import com.jetbrains.clion.ui.externaltool.ExecutableVersionDetector;
import com.jetbrains.clion.ui.externaltool.ExecutableVersionResult;
import com.jetbrains.clion.ui.externaltool.ExternalToolConfigurable;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001:\u0003\u0018\u0019\u001aB?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b\u0012\u0011\u0010\n\u001a\r\u0012\t\u0012\u00070\u0005\u00a2\u0006\u0002\b\u00060\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0016R\u0014\u0010\u000e\u001a\u00020\u000fX\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u001b"}, d2={"Lcom/intellij/clion/west/ui/WestExternalToolConfigurable;", "Lcom/jetbrains/clion/ui/externaltool/ExternalToolConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "name", "", "Lcom/intellij/openapi/util/NlsSafe;", "toolchainProperty", "Lcom/intellij/openapi/observable/properties/ObservableProperty;", "Lcom/jetbrains/cidr/cpp/toolchains/CPPToolchains$Toolchain;", "exePathNormalized", "Lcom/intellij/openapi/observable/properties/ObservableMutableProperty;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Lcom/intellij/openapi/observable/properties/ObservableProperty;Lcom/intellij/openapi/observable/properties/ObservableMutableProperty;)V", "versionDetector", "Lcom/jetbrains/clion/ui/externaltool/ExecutableVersionDetector;", "getVersionDetector", "()Lcom/jetbrains/clion/ui/externaltool/ExecutableVersionDetector;", "pathContributor", "Lcom/jetbrains/clion/ui/externaltool/ExecutableDetectPathContributor;", "getPathContributor", "()Lcom/jetbrains/clion/ui/externaltool/ExecutableDetectPathContributor;", "getLinkFromHyperlinkText", "text", "VersionDetectionResult", "VersionDetector", "WestExternalToolExecutableDetectPathContributor", "intellij.clion.west"})
public final class WestExternalToolConfigurable
extends ExternalToolConfigurable {
    @NotNull
    private final ExecutableVersionDetector versionDetector;
    @NotNull
    private final ExecutableDetectPathContributor pathContributor;

    public WestExternalToolConfigurable(@NotNull Project project, @NotNull String name, @NotNull ObservableProperty<CPPToolchains.Toolchain> toolchainProperty, @NotNull ObservableMutableProperty<String> exePathNormalized) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(toolchainProperty, (String)"toolchainProperty");
        Intrinsics.checkNotNullParameter(exePathNormalized, (String)"exePathNormalized");
        super(project, name, toolchainProperty, exePathNormalized);
        this.versionDetector = VersionDetector.INSTANCE;
        this.pathContributor = WestExternalToolExecutableDetectPathContributor.INSTANCE;
    }

    @NotNull
    protected ExecutableVersionDetector getVersionDetector() {
        return this.versionDetector;
    }

    @NotNull
    protected ExecutableDetectPathContributor getPathContributor() {
        return this.pathContributor;
    }

    @NotNull
    public String getLinkFromHyperlinkText(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        return "https://jb.gg/1gnj7u";
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0003\u0007\b\t\u00a8\u0006\n"}, d2={"Lcom/intellij/clion/west/ui/WestExternalToolConfigurable$VersionDetectionResult;", "Lcom/jetbrains/clion/ui/externaltool/ExecutableVersionResult;", "<init>", "()V", "Version", "DetectFailedResult", "ExecutionFailedResult", "Lcom/intellij/clion/west/ui/WestExternalToolConfigurable$VersionDetectionResult$DetectFailedResult;", "Lcom/intellij/clion/west/ui/WestExternalToolConfigurable$VersionDetectionResult$ExecutionFailedResult;", "Lcom/intellij/clion/west/ui/WestExternalToolConfigurable$VersionDetectionResult$Version;", "intellij.clion.west"})
    public static abstract class VersionDetectionResult
    implements ExecutableVersionResult {
        private VersionDetectionResult() {
        }

        public /* synthetic */ VersionDetectionResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0005H\u00d6\u0001\u00a8\u0006\u0010"}, d2={"Lcom/intellij/clion/west/ui/WestExternalToolConfigurable$VersionDetectionResult$DetectFailedResult;", "Lcom/intellij/clion/west/ui/WestExternalToolConfigurable$VersionDetectionResult;", "<init>", "()V", "getEmptyText", "", "getCommentText", "getIcon", "Ljavax/swing/Icon;", "equals", "", "other", "", "hashCode", "", "toString", "intellij.clion.west"})
        public static final class DetectFailedResult
        extends VersionDetectionResult {
            @NotNull
            public static final DetectFailedResult INSTANCE = new DetectFailedResult();

            private DetectFailedResult() {
                super(null);
            }

            @NotNull
            public String getEmptyText() {
                return CLionWestBundle.message("settings.west.executable.empty.text.cant.detect", new Object[0]);
            }

            @NotNull
            public String getCommentText() {
                return CLionWestBundle.message("settings.west.executable.comment.cant.detect", new Object[0]);
            }

            @NotNull
            public Icon getIcon() {
                Icon icon = AllIcons.General.Error;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Error");
                return icon;
            }

            @NotNull
            public String toString() {
                return "DetectFailedResult";
            }

            public int hashCode() {
                return 1715126738;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof DetectFailedResult)) {
                    return false;
                }
                DetectFailedResult cfr_ignored_0 = (DetectFailedResult)other;
                return true;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0005H\u00d6\u0001\u00a8\u0006\u0010"}, d2={"Lcom/intellij/clion/west/ui/WestExternalToolConfigurable$VersionDetectionResult$ExecutionFailedResult;", "Lcom/intellij/clion/west/ui/WestExternalToolConfigurable$VersionDetectionResult;", "<init>", "()V", "getEmptyText", "", "getCommentText", "getIcon", "Ljavax/swing/Icon;", "equals", "", "other", "", "hashCode", "", "toString", "intellij.clion.west"})
        public static final class ExecutionFailedResult
        extends VersionDetectionResult {
            @NotNull
            public static final ExecutionFailedResult INSTANCE = new ExecutionFailedResult();

            private ExecutionFailedResult() {
                super(null);
            }

            @NotNull
            public String getEmptyText() {
                return CLionWestBundle.message("settings.west.executable.empty.text.cant.detect", new Object[0]);
            }

            @NotNull
            public String getCommentText() {
                return CLionWestBundle.message("settings.west.executable.comment.not.zero.code", new Object[0]);
            }

            @NotNull
            public Icon getIcon() {
                Icon icon = AllIcons.General.Error;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Error");
                return icon;
            }

            @NotNull
            public String toString() {
                return "ExecutionFailedResult";
            }

            public int hashCode() {
                return 899119357;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof ExecutionFailedResult)) {
                    return false;
                }
                ExecutionFailedResult cfr_ignored_0 = (ExecutionFailedResult)other;
                return true;
            }
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B&\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\n\u001a\u00020\u0003H\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\u0006H\u0016J\u000e\u0010\r\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u00c2\u0003J\t\u0010\u000e\u001a\u00020\u0006H\u00c2\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0003H\u00c2\u0003J.\u0010\u0010\u001a\u00020\u00002\r\b\u0002\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/intellij/clion/west/ui/WestExternalToolConfigurable$VersionDetectionResult$Version;", "Lcom/intellij/clion/west/ui/WestExternalToolConfigurable$VersionDetectionResult;", "version", "", "Lcom/intellij/openapi/util/NlsSafe;", "icon", "Ljavax/swing/Icon;", "fullPath", "<init>", "(Ljava/lang/String;Ljavax/swing/Icon;Ljava/lang/String;)V", "getEmptyText", "getCommentText", "getIcon", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "toString", "intellij.clion.west"})
        public static final class Version
        extends VersionDetectionResult {
            @NotNull
            private final String version;
            @NotNull
            private final Icon icon;
            @Nullable
            private final String fullPath;

            public Version(@NotNull String version, @NotNull Icon icon, @Nullable String fullPath) {
                Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
                super(null);
                this.version = version;
                this.icon = icon;
                this.fullPath = fullPath;
            }

            @NotNull
            public String getEmptyText() {
                Object[] objectArray = new Object[1];
                String string = this.fullPath;
                if (string == null) {
                    string = "west";
                }
                objectArray[0] = string;
                return CLionWestBundle.message("settings.west.executable.empty.text.detected", objectArray);
            }

            @NotNull
            public String getCommentText() {
                Object[] objectArray = new Object[]{this.version};
                return CLionWestBundle.message("settings.west.executable.comment.detected", objectArray);
            }

            @NotNull
            public Icon getIcon() {
                Icon icon = AllIcons.General.InspectionsOK;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"InspectionsOK");
                return icon;
            }

            private final String component1() {
                return this.version;
            }

            private final Icon component2() {
                return this.icon;
            }

            private final String component3() {
                return this.fullPath;
            }

            @NotNull
            public final Version copy(@NotNull String version, @NotNull Icon icon, @Nullable String fullPath) {
                Intrinsics.checkNotNullParameter((Object)version, (String)"version");
                Intrinsics.checkNotNullParameter((Object)icon, (String)"icon");
                return new Version(version, icon, fullPath);
            }

            public static /* synthetic */ Version copy$default(Version version, String string, Icon icon, String string2, int n, Object object) {
                if ((n & 1) != 0) {
                    string = version.version;
                }
                if ((n & 2) != 0) {
                    icon = version.icon;
                }
                if ((n & 4) != 0) {
                    string2 = version.fullPath;
                }
                return version.copy(string, icon, string2);
            }

            @NotNull
            public String toString() {
                return "Version(version=" + this.version + ", icon=" + this.icon + ", fullPath=" + this.fullPath + ")";
            }

            public int hashCode() {
                int result = this.version.hashCode();
                result = result * 31 + this.icon.hashCode();
                result = result * 31 + (this.fullPath == null ? 0 : this.fullPath.hashCode());
                return result;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Version)) {
                    return false;
                }
                Version version = (Version)other;
                if (!Intrinsics.areEqual((Object)this.version, (Object)version.version)) {
                    return false;
                }
                if (!Intrinsics.areEqual((Object)this.icon, (Object)version.icon)) {
                    return false;
                }
                return Intrinsics.areEqual((Object)this.fullPath, (Object)version.fullPath);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0096@\u00a2\u0006\u0002\u0010\u000fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/clion/west/ui/WestExternalToolConfigurable$VersionDetector;", "Lcom/jetbrains/clion/ui/externaltool/ExecutableVersionDetector;", "<init>", "()V", "VERSION_REGEX", "Lkotlin/text/Regex;", "detect", "Lcom/jetbrains/clion/ui/externaltool/ExecutableVersionResult;", "project", "Lcom/intellij/openapi/project/Project;", "cppEnvironment", "Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;", "executable", "", "fullPath", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/cidr/cpp/toolchains/CPPEnvironment;Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.clion.west"})
    @SourceDebugExtension(value={"SMAP\nWestExternalToolConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WestExternalToolConfigurable.kt\ncom/intellij/clion/west/ui/WestExternalToolConfigurable$VersionDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,101:1\n1#2:102\n*E\n"})
    public static final class VersionDetector
    implements ExecutableVersionDetector {
        @NotNull
        public static final VersionDetector INSTANCE = new VersionDetector();
        @NotNull
        private static final Regex VERSION_REGEX = new Regex("West version: (\\S+)");

        private VersionDetector() {
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public Object detect(@NotNull Project var1_1, @NotNull CPPEnvironment var2_2, @NotNull String var3_3, @Nullable String var4_4, @NotNull Continuation<? super ExecutableVersionResult> $completion) {
            if (!($completion instanceof detect.1)) ** GOTO lbl-1000
            var10_6 = $completion;
            if ((var10_6.label & -2147483648) != 0) {
                var10_6.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ VersionDetector this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.detect(null, null, null, null, (Continuation<? super ExecutableVersionResult>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var11_8 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $i$a$-runCatching-WestExternalToolConfigurable$VersionDetector$detect$westRun$1 = false;
                    v0 = fullPath;
                    if (v0 == null) {
                        v0 = var3_3;
                    }
                    $continuation.L$0 = fullPath;
                    $continuation.label = 1;
                    v1 = WestRunner.INSTANCE.runWestVersion$intellij_clion_west((Project)project, (CPPEnvironment)cppEnvironment, v0, (Continuation<? super ProcessOutput>)$continuation);
                    ** if (v1 != var11_8) goto lbl24
lbl23:
                    // 1 sources

                    return var11_8;
lbl24:
                    // 1 sources

                    ** GOTO lbl32
                }
                case 1: {
                    $i$a$-runCatching-WestExternalToolConfigurable$VersionDetector$detect$westRun$1 = false;
                    fullPath = (String)$continuation.L$0;
                    try {
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl32:
                        // 2 sources

                        $i$a$-runCatching-WestExternalToolConfigurable$VersionDetector$detect$westRun$1 = Result.constructor-impl((Object)((ProcessOutput)v1));
                    }
                    catch (Throwable var8_11) {
                        $i$a$-runCatching-WestExternalToolConfigurable$VersionDetector$detect$westRun$1 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)var8_11));
                    }
                    westRun = (ProcessOutput)(Result.isFailure-impl((Object)$i$a$-runCatching-WestExternalToolConfigurable$VersionDetector$detect$westRun$1) != false ? null : $i$a$-runCatching-WestExternalToolConfigurable$VersionDetector$detect$westRun$1);
                    if (westRun == null) {
                        return VersionDetectionResult.ExecutionFailedResult.INSTANCE;
                    }
                    v2 = westRun.getStdout();
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"getStdout(...)");
                    match = Regex.find$default((Regex)VersionDetector.VERSION_REGEX, (CharSequence)v2, (int)0, (int)2, null);
                    if (match == null) {
                        return VersionDetectionResult.DetectFailedResult.INSTANCE;
                    }
                    v3 = (String)match.getGroupValues().get(1);
                    v4 = AllIcons.General.InspectionsOK;
                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"InspectionsOK");
                    return new VersionDetectionResult.Version(v3, v4, fullPath);
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/clion/west/ui/WestExternalToolConfigurable$WestExternalToolExecutableDetectPathContributor;", "Lcom/jetbrains/clion/ui/externaltool/ExecutableDetectPathContributor;", "<init>", "()V", "getExecutablePath", "", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.clion.west"})
    public static final class WestExternalToolExecutableDetectPathContributor
    implements ExecutableDetectPathContributor {
        @NotNull
        public static final WestExternalToolExecutableDetectPathContributor INSTANCE = new WestExternalToolExecutableDetectPathContributor();

        private WestExternalToolExecutableDetectPathContributor() {
        }

        @NotNull
        public List<String> getExecutablePath(@NotNull Project project) {
            String string;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            String path = WestSettingsKt.calculateWestExecutablePath$default(project, null, 1, null);
            try {
                Path path2 = Path.of(path, new String[0]).getParent();
                string = path2 != null ? ((Object)path2.toAbsolutePath()).toString() : null;
            }
            catch (InvalidPathException invalidPathException) {
                string = null;
            }
            String parent = string;
            return CollectionsKt.listOfNotNull(parent);
        }
    }
}

