/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.clion.west.config;

import com.intellij.clion.west.config.WestConfigListener;
import com.intellij.internal.statistic.eventLog.events.EventId;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J`\u0010\u0007\u001a\u00020\b2&\u0010\t\u001a\"\u0012\u0004\u0012\u00020\u0003\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\nj\u0002`\u000b0\nj\u0002`\f2&\u0010\r\u001a\"\u0012\u0004\u0012\u00020\u0003\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\nj\u0002`\u000b0\nj\u0002`\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J$\u0010\u0016\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u00032\b\u0010\r\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0016\u0010\u0014\u001a\u0004\u0018\u00010\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013\u00a8\u0006\u0017"}, d2={"Lcom/intellij/clion/west/config/WestConfigKeyListener;", "Lcom/intellij/clion/west/config/WestConfigListener;", "section", "", "key", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "configChanged", "", "oldState", "", "Lcom/intellij/clion/west/config/WestConfigSection;", "Lcom/intellij/clion/west/config/WestConfigState;", "newState", "changeType", "Lcom/intellij/clion/west/config/WestConfigListener$ChangeType;", "keyPresentOnConfigChangeEvent", "Lcom/intellij/internal/statistic/eventLog/events/EventId;", "getKeyPresentOnConfigChangeEvent", "()Lcom/intellij/internal/statistic/eventLog/events/EventId;", "keyChangedEvent", "getKeyChangedEvent", "keyChanged", "intellij.clion.west.config"})
public abstract class WestConfigKeyListener
implements WestConfigListener {
    @NotNull
    private final String section;
    @NotNull
    private final String key;
    @Nullable
    private final EventId keyPresentOnConfigChangeEvent;
    @Nullable
    private final EventId keyChangedEvent;

    public WestConfigKeyListener(@NotNull String section, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)section, (String)"section");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.section = section;
        this.key = key;
    }

    @Override
    public void configChanged(@NotNull Map<String, ? extends Map<String, String>> oldState, @NotNull Map<String, ? extends Map<String, String>> newState, @NotNull WestConfigListener.ChangeType changeType) {
        Intrinsics.checkNotNullParameter(oldState, (String)"oldState");
        Intrinsics.checkNotNullParameter(newState, (String)"newState");
        Intrinsics.checkNotNullParameter((Object)((Object)changeType), (String)"changeType");
        Map<String, String> map = newState.get(this.section);
        if ((map != null ? map.get(this.key) : null) != null && changeType == WestConfigListener.ChangeType.ON_SAVE) {
            EventId eventId = this.getKeyPresentOnConfigChangeEvent();
            if (eventId != null) {
                eventId.log();
            }
        }
        Map<String, String> map2 = oldState.get(this.section);
        Map<String, String> map3 = newState.get(this.section);
        if (!Intrinsics.areEqual((Object)(map2 != null ? map2.get(this.key) : null), map3 != null ? map3.get(this.key) : null)) {
            Map<String, String> map4 = newState.get(this.section);
            if ((map4 != null ? map4.get(this.key) : null) != null && changeType == WestConfigListener.ChangeType.ON_SAVE) {
                EventId eventId = this.getKeyChangedEvent();
                if (eventId != null) {
                    eventId.log();
                }
            }
            Map<String, String> map5 = oldState.get(this.section);
            Map<String, String> map6 = newState.get(this.section);
            this.keyChanged(map5 != null ? map5.get(this.key) : null, map6 != null ? map6.get(this.key) : null, changeType);
        }
    }

    @Nullable
    public EventId getKeyPresentOnConfigChangeEvent() {
        return this.keyPresentOnConfigChangeEvent;
    }

    @Nullable
    public EventId getKeyChangedEvent() {
        return this.keyChangedEvent;
    }

    public void keyChanged(@Nullable String oldState, @Nullable String newState, @NotNull WestConfigListener.ChangeType changeType) {
        Intrinsics.checkNotNullParameter((Object)((Object)changeType), (String)"changeType");
    }
}

