/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.modules;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.javascript.frameworks.amd.JSAmdUtil;
import com.intellij.lang.javascript.modules.ImportJSModuleBaseFix;
import com.intellij.lang.javascript.modules.JSImportModuleFix;
import com.intellij.lang.javascript.psi.JSArrayLiteralExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterList;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.inspectjs.InspectionJSBundle;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class AddRequiredAmdModuleToModulesListFix
implements ImportJSModuleBaseFix,
LocalQuickFix,
HintAction,
HighPriorityAction {
    @NotNull
    private final JSAmdUtil.AmdLoaderCallOnPointers myAmdLoaderCallOnPointers;
    private final String myPath;
    private final String myReferenceName;
    private final boolean myIsSingleQuotes;

    public AddRequiredAmdModuleToModulesListFix(@NotNull JSAmdUtil.AmdLoaderCallOnPointers pointers, String path2, String referenceName, boolean isSingleQuotes) {
        if (pointers == null) {
            AddRequiredAmdModuleToModulesListFix.$$$reportNull$$$0(0);
        }
        this.myAmdLoaderCallOnPointers = pointers;
        this.myPath = path2;
        this.myReferenceName = referenceName;
        this.myIsSingleQuotes = isSingleQuotes;
    }

    public boolean showHint(@NotNull Editor editor) {
        if (editor == null) {
            AddRequiredAmdModuleToModulesListFix.$$$reportNull$$$0(1);
        }
        return false;
    }

    @Nls
    @NotNull
    public String getText() {
        char q = this.myIsSingleQuotes ? (char)'\'' : '\"';
        String string = InspectionJSBundle.message("add.require.amd.module.fix", q + this.myPath + q);
        if (string == null) {
            AddRequiredAmdModuleToModulesListFix.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            AddRequiredAmdModuleToModulesListFix.$$$reportNull$$$0(3);
        }
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            AddRequiredAmdModuleToModulesListFix.$$$reportNull$$$0(4);
        }
        this.invokeImpl();
    }

    private void invokeImpl() {
        JSAmdUtil.AmdLoaderCall amdLoaderCall = this.myAmdLoaderCallOnPointers.toCall();
        if (!amdLoaderCall.isValid()) {
            return;
        }
        JSArrayLiteralExpression modulesArray = amdLoaderCall.getModulesArray();
        JSFunctionExpression callback = amdLoaderCall.getCallBackExpression();
        Project project = callback.getProject();
        String q = this.myIsSingleQuotes ? "'" : "\"";
        PsiFile arrayFile = JSImportModuleFix.createDummyFile(project, "[" + q + this.myPath + q + "]");
        PsiElement comma = AddRequiredAmdModuleToModulesListFix.createComma(project);
        if (comma == null) {
            return;
        }
        if (modulesArray == null) {
            PsiElement added = callback.getParent().addBefore(comma, (PsiElement)callback);
            callback.getParent().addBefore(arrayFile.getFirstChild(), added);
        } else {
            JSParameterList parameterList = callback.getParameterList();
            if (parameterList != null && parameterList.getParameters().length > modulesArray.getExpressions().length) {
                return;
            }
            int previousParams = modulesArray.getExpressions().length - (parameterList == null ? 0 : parameterList.getParameters().length);
            PsiElement child = arrayFile.getFirstChild();
            JSArrayLiteralExpression arrayLiteralExpression = (JSArrayLiteralExpression)child.getFirstChild();
            JSExpression literal = arrayLiteralExpression.getExpressions()[0];
            if (literal == null) {
                return;
            }
            if (modulesArray.getExpressions().length == 0) {
                modulesArray.addAfter((PsiElement)literal, modulesArray.getFirstChild());
            } else {
                JSExpression[] expressions = modulesArray.getExpressions();
                PsiElement added = modulesArray.addAfter(comma, (PsiElement)expressions[expressions.length - 1]);
                modulesArray.addAfter((PsiElement)literal, added);
            }
            if (previousParams > 0) {
                ParameterNamesGenerator generator = new ParameterNamesGenerator(parameterList == null ? JSParameter.EMPTY_ARRAY : parameterList.getParameterVariables());
                for (int i = 0; i < previousParams; ++i) {
                    AddRequiredAmdModuleToModulesListFix.addNewParameter(callback, generator.generate());
                }
            }
        }
        AddRequiredAmdModuleToModulesListFix.addNewParameter(callback, this.myReferenceName);
        DaemonCodeAnalyzer.getInstance((Project)callback.getProject()).restart(callback.getContainingFile());
    }

    private static void addNewParameter(JSFunctionExpression callback, @NotNull String name) {
        if (name == null) {
            AddRequiredAmdModuleToModulesListFix.$$$reportNull$$$0(5);
        }
        JSParameterList list = callback.getParameterList();
        PsiFile file = JSImportModuleFix.createDummyFile(callback.getProject(), "function(" + name + "){}");
        JSParameter parameter = (JSParameter)PsiTreeUtil.findChildOfType((PsiElement)file, JSParameter.class);
        if (parameter == null) {
            return;
        }
        if (list.getParameters().length == 0) {
            list.addAfter((PsiElement)parameter, list.getFirstChild());
        } else {
            PsiElement comma = AddRequiredAmdModuleToModulesListFix.createComma(callback.getProject());
            if (comma == null) {
                return;
            }
            JSParameterListElement[] parameters = list.getParameters();
            PsiElement added = list.addAfter(comma, (PsiElement)parameters[parameters.length - 1]);
            list.addAfter((PsiElement)parameter, added);
        }
    }

    private static PsiElement createComma(Project project) {
        PsiElement[] children;
        PsiFile file = JSImportModuleFix.createDummyFile(project, ",");
        for (PsiElement child : children = file.getChildren()) {
            if (!(child instanceof LeafPsiElement) || !",".equals(child.getText())) continue;
            return child;
        }
        return null;
    }

    public boolean startInWriteAction() {
        return true;
    }

    @Nls
    @NotNull
    public String getFamilyName() {
        String string = InspectionJSBundle.message("add.require.amd.module.group.name", new Object[0]);
        if (string == null) {
            AddRequiredAmdModuleToModulesListFix.$$$reportNull$$$0(6);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            AddRequiredAmdModuleToModulesListFix.$$$reportNull$$$0(7);
        }
        if (descriptor == null) {
            AddRequiredAmdModuleToModulesListFix.$$$reportNull$$$0(8);
        }
        this.invokeImpl();
    }

    @NotNull
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            AddRequiredAmdModuleToModulesListFix.$$$reportNull$$$0(9);
        }
        if (editor == null) {
            AddRequiredAmdModuleToModulesListFix.$$$reportNull$$$0(10);
        }
        if (file == null) {
            AddRequiredAmdModuleToModulesListFix.$$$reportNull$$$0(11);
        }
        IntentionPreviewInfo intentionPreviewInfo = IntentionPreviewInfo.EMPTY;
        if (intentionPreviewInfo == null) {
            AddRequiredAmdModuleToModulesListFix.$$$reportNull$$$0(12);
        }
        return intentionPreviewInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointers";
                break;
            }
            case 1: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/modules/AddRequiredAmdModuleToModulesListFix";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/modules/AddRequiredAmdModuleToModulesListFix";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "generatePreview";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "showHint";
                break;
            }
            case 2: 
            case 6: 
            case 12: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addNewParameter";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "generatePreview";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6, 12 -> new IllegalStateException(string);
        };
    }

    private static class ParameterNamesGenerator {
        private final Set<String> myAlreadyUsed = new HashSet<String>();
        private int myCnt = 1;

        ParameterNamesGenerator(JSParameter[] parameters) {
            for (JSParameter parameter : parameters) {
                this.myAlreadyUsed.add(parameter.getName());
            }
        }

        public String generate() {
            String current;
            while (this.myAlreadyUsed.contains(current = "mod" + this.myCnt++)) {
            }
            return current;
        }
    }
}

