/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.config.graph;

import com.intellij.concurrency.ConcurrentCollectionFactory;
import com.intellij.javascript.nodejs.library.node_modules.workspaceModel.NodeModulesDirectoryExcludeEntity;
import com.intellij.javascript.nodejs.library.node_modules.workspaceModel.NodeModulesDirectoryLibraryEntity;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.TypeScriptFileType;
import com.intellij.lang.javascript.config.JSFileImports;
import com.intellij.lang.javascript.config.graph.JSImportGraph;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsFactory;
import com.intellij.lang.typescript.tsconfig.TypeScriptImportsResolverProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AdditionalLibraryRootsListener;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.util.LowMemoryWatcher;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileSet;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.platform.backend.workspace.WorkspaceModelChangeListener;
import com.intellij.platform.backend.workspace.WorkspaceModelTopics;
import com.intellij.platform.workspace.jps.entities.ContentRootEntity;
import com.intellij.platform.workspace.jps.entities.LibraryEntity;
import com.intellij.platform.workspace.storage.VersionedStorageChange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@ApiStatus.Internal
public final class JSConfigGraphCache
implements Disposable {
    public static final Logger LOG = Logger.getInstance(JSConfigGraphCache.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final ConcurrentIntObjectMap<JSImportGraph> myCache;
    @NotNull
    private final ConcurrentIntObjectMap<JSImportGraph> myDetachedFilesCache;
    @NotNull
    private final Set<VirtualFile> myFilesToRecalculate;
    private final ConcurrentMap<VirtualFile, Set<VirtualFile>> myTypesFiles;

    @NotNull
    public static JSConfigGraphCache getService(@NotNull Project project) {
        if (project == null) {
            JSConfigGraphCache.$$$reportNull$$$0(0);
        }
        JSConfigGraphCache jSConfigGraphCache = (JSConfigGraphCache)project.getService(JSConfigGraphCache.class);
        if (jSConfigGraphCache == null) {
            JSConfigGraphCache.$$$reportNull$$$0(1);
        }
        return jSConfigGraphCache;
    }

    public JSConfigGraphCache(@NotNull Project project) {
        if (project == null) {
            JSConfigGraphCache.$$$reportNull$$$0(2);
        }
        this.myCache = ConcurrentCollectionFactory.createConcurrentIntObjectMap();
        this.myDetachedFilesCache = ConcurrentCollectionFactory.createConcurrentIntObjectSoftValueMap();
        this.myFilesToRecalculate = ConcurrentCollectionFactory.createConcurrentSet();
        this.myTypesFiles = CollectionFactory.createConcurrentSoftMap();
        this.myProject = project;
        MessageBusConnection connection = project.getMessageBus().connect((Disposable)this);
        connection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (JSConfigGraphCache.this.myCache.isEmpty() && JSConfigGraphCache.this.myDetachedFilesCache.isEmpty()) {
                    return;
                }
                for (VFileEvent vFileEvent : events) {
                    boolean isFileContentChange;
                    if (!JSConfigGraphCache.isAcceptableEvent(vFileEvent)) continue;
                    boolean bl = isFileContentChange = vFileEvent instanceof VFileContentChangeEvent || vFileEvent instanceof VFilePropertyChangeEvent && !JSConfigGraphCache.isFileNameChange((VFilePropertyChangeEvent)vFileEvent);
                    if (!isFileContentChange) {
                        JSConfigGraphCache.this.reset();
                        break;
                    }
                    JSConfigGraphCache.this.addToRecalculateQueue(vFileEvent.getFile());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/lang/javascript/config/graph/JSConfigGraphCache$1", "after"));
            }
        });
        connection.subscribe(WorkspaceModelTopics.CHANGED, (Object)new WorkspaceModelChangeListener(){

            public void changed(@NotNull VersionedStorageChange event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                List rootChanges = event.getChanges(ContentRootEntity.class);
                List libraryChanges = event.getChanges(LibraryEntity.class);
                List nodeChanges = event.getChanges(NodeModulesDirectoryLibraryEntity.class);
                List nodeExcChanges = event.getChanges(NodeModulesDirectoryExcludeEntity.class);
                if (!(rootChanges.isEmpty() && libraryChanges.isEmpty() && nodeChanges.isEmpty() && nodeExcChanges.isEmpty())) {
                    JSConfigGraphCache.this.reset();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/config/graph/JSConfigGraphCache$2", "changed"));
            }
        });
        connection.subscribe(ModuleRootListener.TOPIC, (Object)new ModuleRootListener(){

            public void rootsChanged(@NotNull ModuleRootEvent event) {
                if (event == null) {
                    3.$$$reportNull$$$0(0);
                }
                if (event.isCausedByWorkspaceModelChangesOnly()) {
                    return;
                }
                JSConfigGraphCache.this.reset();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/lang/javascript/config/graph/JSConfigGraphCache$3", "rootsChanged"));
            }
        });
        connection.subscribe(AdditionalLibraryRootsListener.TOPIC, (presentableLibraryName, oldRoots, newRoots, libraryNameForDebug) -> this.reset());
        LowMemoryWatcher.register(this::reset, (Disposable)this);
    }

    private static boolean isFileNameChange(@NotNull VFilePropertyChangeEvent event) {
        if (event == null) {
            JSConfigGraphCache.$$$reportNull$$$0(3);
        }
        return "name".equals(event.getPropertyName());
    }

    private static boolean isAcceptableEvent(@NotNull VFileEvent event) {
        VirtualFile file;
        if (event == null) {
            JSConfigGraphCache.$$$reportNull$$$0(4);
        }
        if ((file = event.getFile()) == null) {
            return false;
        }
        if (file.isDirectory()) {
            return true;
        }
        String[] extensions = TypeScriptImportsResolverProvider.getAllFileExtensionsWithDot();
        String extension = JSFileReferencesUtil.findExtension(file.getName(), extensions);
        return extension != null;
    }

    @NotNull
    public JSImportGraph getGraph(@NotNull TypeScriptConfig config) {
        if (config == null) {
            JSConfigGraphCache.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!this.myFilesToRecalculate.isEmpty()) {
            this.processFilesToRecalculate();
        }
        VirtualFile configFile = config.getConfigFile();
        int id = JSImportGraph.getFileId(configFile);
        JSFileImports references = config.getConfigImportResolveStructure();
        JSImportGraph graph = (JSImportGraph)this.myCache.get(id);
        if (graph != null && !graph.getFileImports().equals(references)) {
            JSImportGraph value = JSConfigGraphCache.createValue(configFile, references, true);
            if (!this.myCache.replace(id, (Object)graph, (Object)value)) {
                value = (JSImportGraph)this.myCache.get(id);
            }
            JSImportGraph jSImportGraph = value;
            if (jSImportGraph == null) {
                JSConfigGraphCache.$$$reportNull$$$0(6);
            }
            return jSImportGraph;
        }
        if (graph == null) {
            return this.createOrUseGraph(configFile, id, references);
        }
        JSImportGraph jSImportGraph = graph;
        if (jSImportGraph == null) {
            JSConfigGraphCache.$$$reportNull$$$0(7);
        }
        return jSImportGraph;
    }

    @NotNull
    private JSImportGraph createOrUseGraph(VirtualFile configFile, int id, JSFileImports references) {
        ProgressManager.checkCanceled();
        JSImportGraph value = JSConfigGraphCache.createValue(configFile, references, false);
        JSImportGraph existingGraph = (JSImportGraph)this.myCache.putIfAbsent(id, (Object)value);
        if (existingGraph != null) {
            value = existingGraph;
        }
        JSImportGraph jSImportGraph = value;
        if (jSImportGraph == null) {
            JSConfigGraphCache.$$$reportNull$$$0(8);
        }
        return jSImportGraph;
    }

    @NotNull
    public JSImportGraph getGraph(@NotNull VirtualFile detachedFile) {
        int id;
        JSImportGraph graph;
        if (detachedFile == null) {
            JSConfigGraphCache.$$$reportNull$$$0(9);
        }
        if (!this.myFilesToRecalculate.isEmpty()) {
            this.processFilesToRecalculate();
        }
        if ((graph = (JSImportGraph)this.myDetachedFilesCache.get(id = JSImportGraph.getFileId(detachedFile))) != null) {
            JSImportGraph jSImportGraph = graph;
            if (jSImportGraph == null) {
                JSConfigGraphCache.$$$reportNull$$$0(10);
            }
            return jSImportGraph;
        }
        JSImportGraph result2 = JSConfigGraphCache.createValue(detachedFile, TypeScriptFileImportsFactory.createFileImports(this.myProject, detachedFile), false);
        JSImportGraph existingValue = (JSImportGraph)this.myDetachedFilesCache.putIfAbsent(id, (Object)result2);
        JSImportGraph jSImportGraph = existingValue == null ? result2 : existingValue;
        if (jSImportGraph == null) {
            JSConfigGraphCache.$$$reportNull$$$0(11);
        }
        return jSImportGraph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void processFilesToRecalculate() {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ProgressManager.checkCanceled();
        if (this.myFilesToRecalculate.size() == 0) {
            return;
        }
        ArrayList<VirtualFile> toRemove = new ArrayList<VirtualFile>();
        try {
            for (VirtualFile file : this.myFilesToRecalculate) {
                ProgressManager.checkCanceled();
                Consumer<JSImportGraph> consumer = graph -> {
                    if (!graph.isInitialized()) {
                        return;
                    }
                    if (graph.containsFile(file)) {
                        graph.recalculateEdges(file);
                    }
                };
                this.myCache.values().forEach(consumer);
                this.myDetachedFilesCache.values().forEach(consumer);
                toRemove.add(file);
            }
        }
        catch (Throwable throwable) {
            toRemove.forEach(this.myFilesToRecalculate::remove);
            throw throwable;
        }
        toRemove.forEach(this.myFilesToRecalculate::remove);
    }

    private void addToRecalculateQueue(@Nullable VirtualFile file) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (file == null) {
            return;
        }
        for (JSImportGraph graph : this.myCache.values()) {
            if (!graph.isInitialized() || !graph.containsFile(file)) continue;
            this.myFilesToRecalculate.add(file);
            return;
        }
        for (JSImportGraph graph : this.myDetachedFilesCache.values()) {
            if (!graph.isInitialized() || !graph.containsFile(file)) continue;
            this.myFilesToRecalculate.add(file);
            return;
        }
    }

    public void addToRecalculateQueue(@NotNull PsiFile file) {
        if (file == null) {
            JSConfigGraphCache.$$$reportNull$$$0(12);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return;
        }
        this.addToRecalculateQueue(virtualFile);
    }

    public boolean isConfigInclude(@NotNull VirtualFile file, @NotNull TypeScriptConfig config) {
        if (file == null) {
            JSConfigGraphCache.$$$reportNull$$$0(13);
        }
        if (config == null) {
            JSConfigGraphCache.$$$reportNull$$$0(14);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (DumbService.isDumb((Project)this.myProject)) {
            return false;
        }
        JSImportGraph graph = this.getGraph(config);
        return graph.containsFile(file);
    }

    public void reset() {
        this.myCache.clear();
        this.myDetachedFilesCache.clear();
        this.myFilesToRecalculate.clear();
        this.myTypesFiles.clear();
    }

    @NotNull
    public Set<VirtualFile> getTypesFiles(@NotNull VirtualFile types) {
        Set files;
        if (types == null) {
            JSConfigGraphCache.$$$reportNull$$$0(15);
        }
        if ((files = (Set)this.myTypesFiles.get(types)) != null) {
            Set set = files;
            if (set == null) {
                JSConfigGraphCache.$$$reportNull$$$0(16);
            }
            return set;
        }
        Set<VirtualFile> result2 = this.calcTypes(types);
        Set<VirtualFile> prev = this.myTypesFiles.putIfAbsent(types, result2);
        Set<VirtualFile> set = prev != null ? prev : result2;
        if (set == null) {
            JSConfigGraphCache.$$$reportNull$$$0(17);
        }
        return set;
    }

    @NotNull
    public Set<VirtualFile> calcTypes(final @NotNull VirtualFile types) {
        if (types == null) {
            JSConfigGraphCache.$$$reportNull$$$0(18);
        }
        VirtualFileSet result2 = VfsUtilCore.createCompactVirtualFileSet();
        DelegatingGlobalSearchScope scope2 = new DelegatingGlobalSearchScope(GlobalSearchScope.allScope((Project)this.myProject)){

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    4.$$$reportNull$$$0(0);
                }
                return super.contains(file) && VfsUtilCore.isAncestor((VirtualFile)types, (VirtualFile)file, (boolean)true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/config/graph/JSConfigGraphCache$4", "contains"));
            }
        };
        FileTypeIndex.processFiles((FileType)TypeScriptFileType.INSTANCE, arg_0 -> JSConfigGraphCache.lambda$calcTypes$2((Set)result2, arg_0), (GlobalSearchScope)scope2);
        VirtualFileSet virtualFileSet = result2;
        if (virtualFileSet == null) {
            JSConfigGraphCache.$$$reportNull$$$0(19);
        }
        return virtualFileSet;
    }

    public void dispose() {
        this.reset();
    }

    @NotNull
    static JSImportGraph createValue(@NotNull VirtualFile configOrRoot, @NotNull JSFileImports references, boolean rebuild) {
        if (configOrRoot == null) {
            JSConfigGraphCache.$$$reportNull$$$0(20);
        }
        if (references == null) {
            JSConfigGraphCache.$$$reportNull$$$0(21);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Requested " + (rebuild ? "rebuild" : "build") + " graph for " + configOrRoot.getPath());
        }
        return new JSImportGraph(references);
    }

    private static /* synthetic */ boolean lambda$calcTypes$2(Set result2, VirtualFile el) {
        result2.add(el);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 6, 7, 8, 10, 11, 16, 17, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/config/graph/JSConfigGraphCache";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "detachedFile";
                break;
            }
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configOrRoot";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "references";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/config/graph/JSConfigGraphCache";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getService";
                break;
            }
            case 6: 
            case 7: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraph";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createOrUseGraph";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypesFiles";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "calcTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getService";
                break;
            }
            case 1: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 19: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isFileNameChange";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableEvent";
                break;
            }
            case 5: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getGraph";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addToRecalculateQueue";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "isConfigInclude";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getTypesFiles";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "calcTypes";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createValue";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 6, 7, 8, 10, 11, 16, 17, 19 -> new IllegalStateException(string);
        };
    }
}

