/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.highlighting;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.Strings;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.customization.LspCodeActionsSupport;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.highlighting.LspDiagnosticsCacheKt;
import com.intellij.platform.lsp.impl.quickFix.LspQuickFixSet;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.Range;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001:\u0002$%B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a2\u0006\u0002\b\u0014J\u001d\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0000\u00a2\u0006\u0002\b\u0018J\u001b\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\u0011\u001a\u00020\rH\u0001\u00a2\u0006\u0002\b\u001aJ\u001e\u0010\u001b\u001a\u00020\u00102\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u001d2\u0006\u0010\u001e\u001a\u00020\u000eH\u0002J\u0018\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020 2\u0006\u0010\u001e\u001a\u00020\u000eH\u0002J\r\u0010\"\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\b#R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/intellij/platform/lsp/impl/highlighting/LspDiagnosticsCache;", "", "LspDiagnosticsCache", "()V", "uriToDiagnostics", "", "", "", "Lcom/intellij/platform/lsp/impl/highlighting/LspDiagnosticsCache$DiagnosticAndLazyQuickFixes;", "filePathToUri", "Lcom/intellij/util/containers/BidirectionalMap;", "fileToPendingDocEdits", "Lcom/intellij/util/containers/MultiMap;", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/platform/lsp/impl/highlighting/LspDiagnosticsCache$DocEdit;", "diagnosticsReceived", "", "file", "params", "Lorg/eclipse/lsp4j/PublishDiagnosticsParams;", "diagnosticsReceived$intellij_platform_lsp_impl", "fileEdited", "e", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "fileEdited$intellij_platform_lsp_impl", "getDiagnostics", "getDiagnostics$intellij_platform_lsp_impl", "Y", "diagnostics", "", "docEdit", "Y", "Lorg/eclipse/lsp4j/Diagnostic;", "diagnostic", "clearCache", "clearCache$intellij_platform_lsp_impl", "DocEdit", "DiagnosticAndLazyQuickFixes", "intellij.platform.lsp.impl"})
@SourceDebugExtension(value={"SMAP\nLspDiagnosticsCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspDiagnosticsCache.kt\ncom/intellij/platform/lsp/impl/highlighting/LspDiagnosticsCache\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,171:1\n1#2:172\n1557#3:173\n1628#3,3:174\n24#4:177\n*S KotlinDebug\n*F\n+ 1 LspDiagnosticsCache.kt\ncom/intellij/platform/lsp/impl/highlighting/LspDiagnosticsCache\n*L\n65#1:173\n65#1:174,3\n75#1:177\n*E\n"})
public final class LspDiagnosticsCache {
    @NotNull
    private final Map<String, List<DiagnosticAndLazyQuickFixes>> uriToDiagnostics;
    @NotNull
    private final BidirectionalMap<String, String> filePathToUri;
    @NotNull
    private final MultiMap<VirtualFile, DocEdit> fileToPendingDocEdits;

    public LspDiagnosticsCache() {
        Map map = Collections.synchronizedMap(new HashMap());
        Intrinsics.checkNotNullExpressionValue(map, (String)"synchronizedMap(...)");
        this.uriToDiagnostics = map;
        this.filePathToUri = new BidirectionalMap();
        this.fileToPendingDocEdits = new MultiMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void diagnosticsReceived$intellij_platform_lsp_impl(@Nullable VirtualFile file, @NotNull PublishDiagnosticsParams params) {
        Intrinsics.checkNotNullParameter((Object)params, (String)"params");
        LspDiagnosticsCache lspDiagnosticsCache = this;
        synchronized (lspDiagnosticsCache) {
            Collection collection;
            boolean bl = false;
            if (params.getDiagnostics().isEmpty()) {
                this.uriToDiagnostics.remove(params.getUri());
                this.filePathToUri.removeValue((Object)params.getUri());
                VirtualFile virtualFile = file;
                if (virtualFile != null) {
                    VirtualFile virtualFile2 = virtualFile;
                    boolean bl2 = false;
                    collection = this.fileToPendingDocEdits.remove((Object)file);
                } else {
                    collection = null;
                }
            } else {
                Object object = this.uriToDiagnostics;
                String string = params.getUri();
                List list = params.getDiagnostics();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getDiagnostics(...)");
                Iterable iterable = list;
                boolean bl3 = false;
                Iterable iterable2 = iterable;
                Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable, (int)10));
                boolean bl4 = false;
                for (Object t2 : iterable2) {
                    Diagnostic diagnostic = (Diagnostic)t2;
                    Collection collection3 = collection2;
                    boolean bl5 = false;
                    Intrinsics.checkNotNull((Object)diagnostic);
                    collection3.add(new DiagnosticAndLazyQuickFixes(diagnostic));
                }
                iterable = (List)collection2;
                object.put((String)string, (List<DiagnosticAndLazyQuickFixes>)iterable);
                if (file != null) {
                    ((Map)this.filePathToUri).put(file.getPath(), params.getUri());
                    collection = this.fileToPendingDocEdits.remove((Object)file);
                } else {
                    this.filePathToUri.removeValue((Object)params.getUri());
                    object = this;
                    boolean bl6 = false;
                    Logger logger = Logger.getInstance(LspDiagnosticsCache.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                    logger.warn("Could not find file with diagnostics: " + params.getUri());
                    collection = Unit.INSTANCE;
                }
            }
            Collection collection4 = collection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void fileEdited$intellij_platform_lsp_impl(@NotNull VirtualFile file, @NotNull DocumentEvent e2) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e");
        LspDiagnosticsCache lspDiagnosticsCache = this;
        synchronized (lspDiagnosticsCache) {
            boolean bl = false;
            if (this.filePathToUri.get((Object)file.getPath()) != null) {
                int n10;
                int n11 = e2.getDocument().getLineNumber(e2.getOffset());
                int n12 = e2.getOffset() - e2.getDocument().getLineStartOffset(n11);
                int n13 = e2.getDocument().getLineNumber(e2.getOffset() + e2.getOldLength());
                int n14 = e2.getOffset() + e2.getOldLength() - e2.getDocument().getLineStartOffset(n13);
                int n15 = Strings.countChars((CharSequence)e2.getOldFragment(), (char)'\n');
                int n16 = Strings.countChars((CharSequence)e2.getNewFragment(), (char)'\n');
                int n17 = n16 - n15;
                int n18 = n13 + n17;
                if (n16 == 0) {
                    n10 = n12 + e2.getNewLength();
                } else {
                    int n19 = e2.getNewLength();
                    CharSequence charSequence = e2.getNewFragment();
                    Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"getNewFragment(...)");
                    n10 = n19 - StringsKt.lastIndexOf$default((CharSequence)charSequence, (char)'\n', (int)0, (boolean)false, (int)6, null) - 1;
                }
                int n20 = n10;
                this.fileToPendingDocEdits.putValue((Object)file, (Object)new DocEdit(new Position(n11, n12), new Position(n13, n14), new Position(n18, n20)));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresBackgroundThread
    @NotNull
    public final List<DiagnosticAndLazyQuickFixes> getDiagnostics$intellij_platform_lsp_impl(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        LspDiagnosticsCache lspDiagnosticsCache = this;
        synchronized (lspDiagnosticsCache) {
            Collection collection;
            List list;
            String string;
            block8: {
                String string2;
                block7: {
                    boolean bl = false;
                    if ((String)this.filePathToUri.get((Object)file.getPath()) != null) break block7;
                    List list2 = CollectionsKt.emptyList();
                    return list2;
                }
                string = string2;
                List list3 = this.uriToDiagnostics.get(string);
                if (list3 == null) {
                    list3 = CollectionsKt.emptyList();
                }
                list = list3;
                Collection collection2 = this.fileToPendingDocEdits.get((Object)file);
                Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"get(...)");
                collection = collection2;
                if (!list.isEmpty() && !collection.isEmpty()) break block8;
                List list4 = list;
                return list4;
            }
            List list5 = CollectionsKt.toMutableList((Collection)list);
            for (DocEdit docEdit : collection) {
                ProgressManager.checkCanceled();
                Intrinsics.checkNotNull((Object)docEdit);
                this.Y(list5, docEdit);
            }
            this.uriToDiagnostics.put(string, list5);
            this.fileToPendingDocEdits.remove((Object)file);
            List list6 = list5;
            return list6;
        }
    }

    private final void Y(List<DiagnosticAndLazyQuickFixes> list, DocEdit docEdit) {
        ListIterator<DiagnosticAndLazyQuickFixes> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            Diagnostic diagnostic = listIterator.next().getDiagnostic();
            Position position = docEdit.getStart();
            Position position2 = diagnostic.getRange().getEnd();
            Intrinsics.checkNotNullExpressionValue((Object)position2, (String)"getEnd(...)");
            if (LspDiagnosticsCacheKt.access$compareTo(position, position2) > 0) continue;
            Position position3 = docEdit.getEndOld();
            Position position4 = diagnostic.getRange().getStart();
            Intrinsics.checkNotNullExpressionValue((Object)position4, (String)"getStart(...)");
            if (LspDiagnosticsCacheKt.access$compareTo(position3, position4) < 0) {
                listIterator.set(new DiagnosticAndLazyQuickFixes(this.Y(diagnostic, docEdit)));
                continue;
            }
            listIterator.remove();
        }
    }

    private final Diagnostic Y(Diagnostic diagnostic, DocEdit docEdit) {
        Diagnostic diagnostic2;
        int n10 = docEdit.getEndNew().getLine() - docEdit.getEndOld().getLine();
        int n11 = diagnostic.getRange().getStart().getLine() + n10;
        int n12 = diagnostic.getRange().getEnd().getLine() + n10;
        int n13 = n11 == docEdit.getEndNew().getLine() ? diagnostic.getRange().getStart().getCharacter() + docEdit.getEndNew().getCharacter() - docEdit.getEndOld().getCharacter() : diagnostic.getRange().getStart().getCharacter();
        int n14 = diagnostic.getRange().getEnd().getLine() == diagnostic.getRange().getStart().getLine() ? diagnostic.getRange().getEnd().getCharacter() + n13 - diagnostic.getRange().getStart().getCharacter() : diagnostic.getRange().getEnd().getCharacter();
        Diagnostic diagnostic3 = diagnostic2 = new Diagnostic();
        boolean bl = false;
        diagnostic3.setRange(new Range(new Position(n11, n13), new Position(n12, n14)));
        diagnostic3.setSeverity(diagnostic.getSeverity());
        diagnostic3.setCode(diagnostic.getCode());
        diagnostic3.setCodeDescription(diagnostic.getCodeDescription());
        diagnostic3.setSource(diagnostic.getSource());
        diagnostic3.setMessage(diagnostic.getMessage());
        diagnostic3.setTags(diagnostic.getTags());
        diagnostic3.setRelatedInformation(diagnostic.getRelatedInformation());
        diagnostic3.setData(diagnostic.getData());
        return diagnostic2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void clearCache$intellij_platform_lsp_impl() {
        LspDiagnosticsCache lspDiagnosticsCache = this;
        synchronized (lspDiagnosticsCache) {
            boolean bl = false;
            this.uriToDiagnostics.clear();
            this.filePathToUri.clear();
            this.fileToPendingDocEdits.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/platform/lsp/impl/highlighting/LspDiagnosticsCache$DiagnosticAndLazyQuickFixes;", "", "diagnostic", "Lorg/eclipse/lsp4j/Diagnostic;", "LspDiagnosticsCache$DiagnosticAndLazyQuickFixes", "(Lorg/eclipse/lsp4j/Diagnostic;)V", "getDiagnostic", "()Lorg/eclipse/lsp4j/Diagnostic;", "quickFixes", "", "Lcom/intellij/codeInsight/intention/IntentionAction;", "getQuickFixes", "lspServer", "Lcom/intellij/platform/lsp/impl/LspServerImpl;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.platform.lsp.impl"})
    @SourceDebugExtension(value={"SMAP\nLspDiagnosticsCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspDiagnosticsCache.kt\ncom/intellij/platform/lsp/impl/highlighting/LspDiagnosticsCache$DiagnosticAndLazyQuickFixes\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,171:1\n1#2:172\n1755#3,3:173\n*S KotlinDebug\n*F\n+ 1 LspDiagnosticsCache.kt\ncom/intellij/platform/lsp/impl/highlighting/LspDiagnosticsCache$DiagnosticAndLazyQuickFixes\n*L\n27#1:173,3\n*E\n"})
    public static final class DiagnosticAndLazyQuickFixes {
        @NotNull
        private final Diagnostic diagnostic;
        @Nullable
        private List<? extends IntentionAction> quickFixes;

        public DiagnosticAndLazyQuickFixes(@NotNull Diagnostic diagnostic) {
            Intrinsics.checkNotNullParameter((Object)diagnostic, (String)"diagnostic");
            this.diagnostic = diagnostic;
        }

        @NotNull
        public final Diagnostic getDiagnostic() {
            return this.diagnostic;
        }

        @NotNull
        public final List<IntentionAction> getQuickFixes(@NotNull LspServerImpl lspServer, @NotNull VirtualFile file) {
            Object object;
            block6: {
                block5: {
                    Intrinsics.checkNotNullParameter((Object)lspServer, (String)"lspServer");
                    Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                    List<IntentionAction> list = this.quickFixes;
                    if (list != null) {
                        List<IntentionAction> list2 = list;
                        boolean bl = false;
                        return list2;
                    }
                    Object object2 = lspServer.getDescriptor().getLspCodeActionsSupport();
                    if (object2 == null) break block5;
                    object = object2;
                    LspCodeActionsSupport lspCodeActionsSupport = object;
                    boolean bl = false;
                    object2 = lspCodeActionsSupport.getQuickFixesSupport() ? object : null;
                    if (object2 != null) break block6;
                }
                return CollectionsKt.emptyList();
            }
            boolean bl = lspServer.supportsCodeActions$intellij_platform_lsp_impl((Function1<? super List<String>, Boolean>)((Function1)DiagnosticAndLazyQuickFixes::Y));
            if (!bl) {
                return CollectionsKt.emptyList();
            }
            object = new LspQuickFixSet(lspServer, file, this.diagnostic).getQuickFixes();
            boolean bl2 = false;
            this.quickFixes = object;
            return object;
        }

        private static final boolean Y(List list) {
            boolean bl;
            block3: {
                Intrinsics.checkNotNullParameter((Object)list, (String)"kinds");
                Iterable iterable = list;
                boolean bl2 = false;
                if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
                    bl = false;
                } else {
                    for (Object t2 : iterable) {
                        String string = (String)t2;
                        boolean bl3 = false;
                        if (!StringsKt.startsWith$default((String)string, (String)"quickfix", (boolean)false, (int)2, null)) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0017"}, d2={"Lcom/intellij/platform/lsp/impl/highlighting/LspDiagnosticsCache$DocEdit;", "", "start", "Lorg/eclipse/lsp4j/Position;", "endOld", "endNew", "LspDiagnosticsCache$DocEdit", "(Lorg/eclipse/lsp4j/Position;Lorg/eclipse/lsp4j/Position;Lorg/eclipse/lsp4j/Position;)V", "getStart", "()Lorg/eclipse/lsp4j/Position;", "getEndOld", "getEndNew", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.platform.lsp.impl"})
    private static final class DocEdit {
        @NotNull
        private final Position start;
        @NotNull
        private final Position endOld;
        @NotNull
        private final Position endNew;

        public DocEdit(@NotNull Position start, @NotNull Position endOld, @NotNull Position endNew) {
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            Intrinsics.checkNotNullParameter((Object)endOld, (String)"endOld");
            Intrinsics.checkNotNullParameter((Object)endNew, (String)"endNew");
            this.start = start;
            this.endOld = endOld;
            this.endNew = endNew;
        }

        @NotNull
        public final Position getStart() {
            return this.start;
        }

        @NotNull
        public final Position getEndOld() {
            return this.endOld;
        }

        @NotNull
        public final Position getEndNew() {
            return this.endNew;
        }

        @NotNull
        public final Position component1() {
            return this.start;
        }

        @NotNull
        public final Position component2() {
            return this.endOld;
        }

        @NotNull
        public final Position component3() {
            return this.endNew;
        }

        @NotNull
        public final DocEdit copy(@NotNull Position start, @NotNull Position endOld, @NotNull Position endNew) {
            Intrinsics.checkNotNullParameter((Object)start, (String)"start");
            Intrinsics.checkNotNullParameter((Object)endOld, (String)"endOld");
            Intrinsics.checkNotNullParameter((Object)endNew, (String)"endNew");
            return new DocEdit(start, endOld, endNew);
        }

        public static /* synthetic */ DocEdit copy$default(DocEdit docEdit, Position position, Position position2, Position position3, int n10, Object object) {
            if ((n10 & 1) != 0) {
                position = docEdit.start;
            }
            if ((n10 & 2) != 0) {
                position2 = docEdit.endOld;
            }
            if ((n10 & 4) != 0) {
                position3 = docEdit.endNew;
            }
            return docEdit.copy(position, position2, position3);
        }

        @NotNull
        public String toString() {
            return "DocEdit(start=" + this.start + ", endOld=" + this.endOld + ", endNew=" + this.endNew + ")";
        }

        public int hashCode() {
            int n10 = this.start.hashCode();
            n10 = n10 * 31 + this.endOld.hashCode();
            n10 = n10 * 31 + this.endNew.hashCode();
            return n10;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DocEdit)) {
                return false;
            }
            DocEdit docEdit = (DocEdit)other;
            if (!Intrinsics.areEqual((Object)this.start, (Object)docEdit.start)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.endOld, (Object)docEdit.endOld)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.endNew, (Object)docEdit.endNew);
        }
    }
}

