/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.lsp.impl.highlighting;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.lsp.api.customization.LspDiagnosticsSupport;
import com.intellij.platform.lsp.api.customization.LspSemanticTokensSupport;
import com.intellij.platform.lsp.impl.LspServerImpl;
import com.intellij.platform.lsp.impl.LspServerManagerImpl;
import com.intellij.platform.lsp.impl.highlighting.DiagnosticAndQuickFixes;
import com.intellij.platform.lsp.impl.highlighting.LspAnnotatorKt;
import com.intellij.platform.lsp.impl.highlighting.LspDiagnosticInfo;
import com.intellij.platform.lsp.impl.highlighting.LspHighlightingInfo;
import com.intellij.platform.lsp.impl.highlighting.LspSemanticToken;
import com.intellij.platform.lsp.impl.highlighting.LspSemanticTokenInfo;
import com.intellij.platform.lsp.impl.highlightingCommon.LspCachedHighlighting;
import com.intellij.platform.lsp.util.Lsp4jUtilKt;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.eclipse.lsp4j.Range;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\nH\u0002J(\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0002J<\u0010\u0011\u001a\u00020\u0006\"\b\b\u0000\u0010\u0012*\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00120\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0012\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u0002H\u0012\u0012\u0004\u0012\u00020\u00060\u0019H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/intellij/platform/lsp/impl/highlighting/LspAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "Lcom/intellij/openapi/project/DumbAware;", "LspAnnotator", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "Y", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "Y", "document", "Lcom/intellij/openapi/editor/Document;", "Y", "T", "Lcom/intellij/platform/lsp/impl/highlighting/LspHighlightingInfo;", "highlightingInfos", "", "elementRange", "Lcom/intellij/openapi/util/TextRange;", "processor", "Lkotlin/Function1;", "intellij.platform.lsp.impl"})
@SourceDebugExtension(value={"SMAP\nLspAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LspAnnotator.kt\ncom/intellij/platform/lsp/impl/highlighting/LspAnnotator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n1368#2:140\n1454#2,2:141\n1557#2:143\n1628#2,3:144\n1456#2,3:147\n1053#2:150\n1368#2:151\n1454#2,2:152\n1611#2,9:154\n1863#2:163\n1864#2:165\n1620#2:166\n1456#2,3:167\n1053#2:170\n1#3:164\n*S KotlinDebug\n*F\n+ 1 LspAnnotator.kt\ncom/intellij/platform/lsp/impl/highlighting/LspAnnotator\n*L\n66#1:140\n66#1:141,2\n68#1:143\n68#1:144,3\n66#1:147,3\n72#1:150\n93#1:151\n93#1:152,2\n95#1:154,9\n95#1:163\n95#1:165\n95#1:166\n93#1:167,3\n100#1:170\n95#1:164\n*E\n"})
public final class LspAnnotator
implements Annotator,
DumbAware {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        VirtualFile virtualFile = element.getContainingFile().getVirtualFile();
        if (virtualFile == null || virtualFile instanceof VirtualFileWindow) {
            return;
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        if (document == null) {
            return;
        }
        Document document2 = document;
        this.Y(element, virtualFile, holder);
        this.Y(element, virtualFile, document2, holder);
    }

    private final void Y(PsiElement psiElement, VirtualFile virtualFile, AnnotationHolder annotationHolder) {
        List list = (List)annotationHolder.getCurrentAnnotationSession().getUserData(LspAnnotatorKt.access$getLSP_SEMANTIC_TOKEN_INFOS$p());
        if (list == null) {
            Project project = psiElement.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Iterable iterable = LspServerManagerImpl.Companion.getInstanceImpl(project).getServersWithThisFileOpen$intellij_platform_lsp_impl(virtualFile);
            boolean bl = false;
            Iterable iterable2 = iterable;
            Collection collection = new ArrayList();
            boolean bl2 = false;
            for (Object t2 : iterable2) {
                Iterable iterable3;
                Object object = (LspServerImpl)t2;
                boolean bl3 = false;
                if (((LspServerImpl)object).getDescriptor().getLspSemanticTokensSupport() == null) {
                    iterable3 = CollectionsKt.emptyList();
                } else {
                    Iterable iterable4 = ((LspServerImpl)object).getSemanticTokens$intellij_platform_lsp_impl(virtualFile);
                    boolean bl4 = false;
                    Iterable iterable5 = iterable4;
                    Collection collection2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)iterable4, (int)10));
                    boolean bl5 = false;
                    for (Object t3 : iterable5) {
                        LspSemanticTokensSupport lspSemanticTokensSupport;
                        LspCachedHighlighting lspCachedHighlighting = (LspCachedHighlighting)t3;
                        Collection collection3 = collection2;
                        boolean bl6 = false;
                        collection3.add(new LspSemanticTokenInfo(lspCachedHighlighting.getTextRange(), lspSemanticTokensSupport, ((LspSemanticToken)lspCachedHighlighting.getHighlightingInfo()).getTokenType(), ((LspSemanticToken)lspCachedHighlighting.getHighlightingInfo()).getTokenModifiers()));
                    }
                    iterable3 = (List)collection2;
                }
                object = iterable3;
                CollectionsKt.addAll((Collection)collection, (Iterable)object);
            }
            iterable = (List)collection;
            bl = false;
            list = CollectionsKt.toMutableList((Collection)CollectionsKt.sortedWith((Iterable)iterable, (Comparator)new Comparator(){

                public final int compare(T a2, T b2) {
                    LspSemanticTokenInfo lspSemanticTokenInfo = (LspSemanticTokenInfo)a2;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(lspSemanticTokenInfo.getTextRange().getStartOffset());
                    lspSemanticTokenInfo = (LspSemanticTokenInfo)b2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(lspSemanticTokenInfo.getTextRange().getStartOffset()));
                }
            }));
            annotationHolder.getCurrentAnnotationSession().putUserData(LspAnnotatorKt.access$getLSP_SEMANTIC_TOKEN_INFOS$p(), (Object)list);
        }
        TextRange textRange = psiElement.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        this.Y(list, textRange, arg_0 -> LspAnnotator.Y(annotationHolder, arg_0));
    }

    private final void Y(PsiElement psiElement, VirtualFile virtualFile, Document document, AnnotationHolder annotationHolder) {
        List list = (List)annotationHolder.getCurrentAnnotationSession().getUserData(LspAnnotatorKt.access$getLSP_DIAGNOSTIC_INFOS$p());
        if (list == null) {
            Project project = psiElement.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            Iterable iterable = LspServerManagerImpl.Companion.getInstanceImpl(project).getServersWithThisFileOpen$intellij_platform_lsp_impl(virtualFile);
            boolean bl = false;
            Iterable iterable2 = iterable;
            Collection collection = new ArrayList();
            boolean bl2 = false;
            for (Object t2 : iterable2) {
                Iterable iterable3;
                Object object = (LspServerImpl)t2;
                boolean bl3 = false;
                if (((LspServerImpl)object).getDescriptor().getLspDiagnosticsSupport() == null) {
                    iterable3 = CollectionsKt.emptyList();
                } else {
                    Iterable iterable4 = ((LspServerImpl)object).getDiagnosticsAndQuickFixes(virtualFile);
                    boolean bl4 = false;
                    Iterable iterable5 = iterable4;
                    Collection collection2 = new ArrayList();
                    boolean bl5 = false;
                    Iterable iterable6 = iterable5;
                    boolean bl6 = false;
                    Iterator iterator = iterable6.iterator();
                    while (iterator.hasNext()) {
                        LspDiagnosticInfo lspDiagnosticInfo;
                        LspDiagnosticsSupport lspDiagnosticsSupport;
                        TextRange textRange;
                        Object t3;
                        Object t4 = t3 = iterator.next();
                        boolean bl7 = false;
                        DiagnosticAndQuickFixes diagnosticAndQuickFixes = (DiagnosticAndQuickFixes)t4;
                        boolean bl8 = false;
                        Range range = diagnosticAndQuickFixes.getDiagnostic().getRange();
                        Intrinsics.checkNotNullExpressionValue((Object)range, (String)"getRange(...)");
                        if ((Lsp4jUtilKt.getRangeInDocument(document, range) == null ? null : new LspDiagnosticInfo(textRange, lspDiagnosticsSupport, diagnosticAndQuickFixes.getDiagnostic(), diagnosticAndQuickFixes.getQuickFixes())) == null) continue;
                        lspDiagnosticInfo = lspDiagnosticInfo;
                        boolean bl9 = false;
                        collection2.add(lspDiagnosticInfo);
                    }
                    iterable3 = (List)collection2;
                }
                object = iterable3;
                CollectionsKt.addAll((Collection)collection, (Iterable)object);
            }
            iterable = (List)collection;
            bl = false;
            list = CollectionsKt.toMutableList((Collection)CollectionsKt.sortedWith((Iterable)iterable, (Comparator)new Comparator(){

                public final int compare(T a2, T b2) {
                    LspDiagnosticInfo lspDiagnosticInfo = (LspDiagnosticInfo)a2;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(lspDiagnosticInfo.getTextRange().getStartOffset());
                    lspDiagnosticInfo = (LspDiagnosticInfo)b2;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(lspDiagnosticInfo.getTextRange().getStartOffset()));
                }
            }));
            annotationHolder.getCurrentAnnotationSession().putUserData(LspAnnotatorKt.access$getLSP_DIAGNOSTIC_INFOS$p(), (Object)list);
        }
        TextRange textRange = psiElement.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getTextRange(...)");
        this.Y(list, textRange, arg_0 -> LspAnnotator.Y(annotationHolder, arg_0));
    }

    private final <T extends LspHighlightingInfo> void Y(List<T> list, TextRange textRange, Function1<? super T, Unit> function1) {
        if (list.isEmpty()) {
            return;
        }
        int n10 = CollectionsKt.binarySearch$default(list, (int)0, (int)0, arg_0 -> LspAnnotator.Y(textRange, arg_0), (int)3, null);
        if ((n10 = Math.max(0, -n10 - 1)) >= list.size()) {
            return;
        }
        LspHighlightingInfo lspHighlightingInfo = (LspHighlightingInfo)list.get(n10);
        while (lspHighlightingInfo != null && lspHighlightingInfo.getTextRange().getStartOffset() < textRange.getEndOffset()) {
            ProgressManager.checkCanceled();
            if (textRange.contains(lspHighlightingInfo.getTextRange())) {
                list.remove(n10);
                function1.invoke((Object)lspHighlightingInfo);
            } else {
                ++n10;
            }
            lspHighlightingInfo = n10 < list.size() ? (LspHighlightingInfo)list.get(n10) : null;
        }
    }

    private static final Unit Y(AnnotationHolder annotationHolder, LspSemanticTokenInfo lspSemanticTokenInfo) {
        Intrinsics.checkNotNullParameter((Object)lspSemanticTokenInfo, (String)"tokenInfo");
        TextAttributesKey textAttributesKey = lspSemanticTokenInfo.getSemanticTokensSupport().getTextAttributesKey(lspSemanticTokenInfo.getTokenType(), lspSemanticTokenInfo.getTokenModifiers());
        if (textAttributesKey == null) {
            return Unit.INSTANCE;
        }
        TextAttributesKey textAttributesKey2 = textAttributesKey;
        annotationHolder.newSilentAnnotation(HighlightSeverity.TEXT_ATTRIBUTES).range(lspSemanticTokenInfo.getTextRange()).textAttributes(textAttributesKey2).create();
        return Unit.INSTANCE;
    }

    private static final Unit Y(AnnotationHolder annotationHolder, LspDiagnosticInfo lspDiagnosticInfo) {
        Intrinsics.checkNotNullParameter((Object)lspDiagnosticInfo, (String)"diagnosticInfo");
        lspDiagnosticInfo.getDiagnosticsSupport().createAnnotation(annotationHolder, lspDiagnosticInfo.getDiagnostic(), lspDiagnosticInfo.getTextRange(), lspDiagnosticInfo.getQuickFixes());
        return Unit.INSTANCE;
    }

    private static final int Y(TextRange textRange, LspHighlightingInfo lspHighlightingInfo) {
        Intrinsics.checkNotNullParameter((Object)lspHighlightingInfo, (String)"it");
        return lspHighlightingInfo.getTextRange().getStartOffset() < textRange.getStartOffset() ? -1 : 1;
    }
}

