/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.url;

import com.intellij.microservices.url.MultiPathBestMatcher;
import com.intellij.microservices.url.UrlConstants;
import com.intellij.microservices.url.UrlPath;
import com.intellij.microservices.url.UrlTargetInfo;
import com.intellij.psi.util.PartiallyKnownString;
import com.intellij.psi.util.StringEntry;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u001a\"\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0007\u001a(\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007\u001a\u000e\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u0011\u00a8\u0006\u0012"}, d2={"getDeclaredHttpMethods", "", "", "methodString", "compatibleSchemes", "", "aSchemes", "", "bSchemes", "filterBestUrlPathMatches", "Lcom/intellij/microservices/url/UrlTargetInfo;", "all", "", "original", "Lcom/intellij/microservices/url/UrlPath;", "getEndpointUrlPresentation", "path", "Lcom/intellij/psi/util/PartiallyKnownString;", "intellij.microservices"})
@SourceDebugExtension(value={"SMAP\nUrlPathModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlPathModel.kt\ncom/intellij/microservices/url/UrlPathModelKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,337:1\n1755#2,3:338\n*S KotlinDebug\n*F\n+ 1 UrlPathModel.kt\ncom/intellij/microservices/url/UrlPathModelKt\n*L\n78#1:338,3\n*E\n"})
public final class UrlPathModelKt {
    @NotNull
    public static final Set<String> getDeclaredHttpMethods(@Nullable String methodString) {
        Set set;
        String string = methodString;
        if (string != null) {
            String string2 = string.toUpperCase();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
            set = SetsKt.setOf((Object)string2);
        } else {
            set = SetsKt.emptySet();
        }
        return set;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean compatibleSchemes(@NotNull Collection<String> aSchemes, @NotNull Collection<String> bSchemes) {
        boolean bl;
        Intrinsics.checkNotNullParameter(aSchemes, (String)"aSchemes");
        Intrinsics.checkNotNullParameter(bSchemes, (String)"bSchemes");
        if (aSchemes.isEmpty()) return true;
        if (bSchemes.isEmpty()) return true;
        if (!((Collection)CollectionsKt.intersect((Iterable)aSchemes, (Iterable)bSchemes)).isEmpty()) {
            return true;
        }
        boolean bl2 = false;
        if (bl2) return true;
        Iterable iterable = UrlConstants.KNOWN_SCHEMES_GROUPS;
        boolean bl3 = false;
        if (iterable instanceof Collection && ((Collection)iterable).isEmpty()) {
            return false;
        }
        Iterator iterator = iterable.iterator();
        do {
            boolean bl4;
            String string;
            boolean bl5;
            boolean bl6;
            Iterable iterable2;
            List list;
            block11: {
                if (!iterator.hasNext()) return false;
                Object t2 = iterator.next();
                list = (List)t2;
                boolean bl7 = false;
                iterable2 = aSchemes;
                bl6 = false;
                if (((Collection)iterable2).isEmpty()) {
                    bl5 = false;
                } else {
                    for (Object t3 : iterable2) {
                        string = (String)t3;
                        bl4 = false;
                        if (!list.contains(string)) continue;
                        bl5 = true;
                        break block11;
                    }
                    bl5 = false;
                }
            }
            if (bl5) {
                boolean bl8;
                iterable2 = bSchemes;
                bl6 = false;
                if (((Collection)iterable2).isEmpty()) {
                    bl8 = false;
                } else {
                    for (Object t3 : iterable2) {
                        string = (String)t3;
                        bl4 = false;
                        if (!list.contains(string)) continue;
                        return true;
                    }
                    bl8 = false;
                }
                if (bl8) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    @JvmOverloads
    @NotNull
    public static final Set<UrlTargetInfo> filterBestUrlPathMatches(@NotNull Iterable<? extends UrlTargetInfo> all, @Nullable UrlPath original) {
        Intrinsics.checkNotNullParameter(all, (String)"all");
        return new MultiPathBestMatcher().addBestMatching(all, original).getResult();
    }

    public static /* synthetic */ Set filterBestUrlPathMatches$default(Iterable iterable, UrlPath urlPath, int n10, Object object) {
        if ((n10 & 2) != 0) {
            urlPath = null;
        }
        return UrlPathModelKt.filterBestUrlPathMatches(iterable, urlPath);
    }

    @NotNull
    public static final String getEndpointUrlPresentation(@NotNull PartiallyKnownString path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return CollectionsKt.joinToString$default((Iterable)path.getSegments(), null, null, null, (int)0, null, UrlPathModelKt::Y, (int)31, null);
    }

    @JvmOverloads
    @NotNull
    public static final Set<UrlTargetInfo> filterBestUrlPathMatches(@NotNull Iterable<? extends UrlTargetInfo> all) {
        Intrinsics.checkNotNullParameter(all, (String)"all");
        return UrlPathModelKt.filterBestUrlPathMatches$default(all, null, 2, null);
    }

    private static final CharSequence Y(StringEntry stringEntry) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)stringEntry, (String)"segment");
        StringEntry stringEntry2 = stringEntry;
        if (stringEntry2 instanceof StringEntry.Known) {
            charSequence = ((StringEntry.Known)stringEntry).getValue();
        } else if (stringEntry2 instanceof StringEntry.Unknown) {
            charSequence = "${..}";
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return charSequence;
    }
}

