/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.oas.serialization;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ContainerNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import com.intellij.microservices.oas.OasArrayValue;
import com.intellij.microservices.oas.OasBooleanValue;
import com.intellij.microservices.oas.OasComponents;
import com.intellij.microservices.oas.OasEndpointPath;
import com.intellij.microservices.oas.OasExample;
import com.intellij.microservices.oas.OasExampleValue;
import com.intellij.microservices.oas.OasHeader;
import com.intellij.microservices.oas.OasMediaTypeObject;
import com.intellij.microservices.oas.OasNullValue;
import com.intellij.microservices.oas.OasNumberValue;
import com.intellij.microservices.oas.OasObjectValue;
import com.intellij.microservices.oas.OasOperation;
import com.intellij.microservices.oas.OasParameter;
import com.intellij.microservices.oas.OasProperty;
import com.intellij.microservices.oas.OasRequestBody;
import com.intellij.microservices.oas.OasResponse;
import com.intellij.microservices.oas.OasSchema;
import com.intellij.microservices.oas.OasSchemaFormat;
import com.intellij.microservices.oas.OasSchemaType;
import com.intellij.microservices.oas.OasStringValue;
import com.intellij.microservices.oas.OasTag;
import com.intellij.microservices.oas.OpenApiSpecification;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000v\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u0018\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0003H\u0007\u001a\"\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\b\u001a\u00020\u00032\u000e\b\u0002\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\nH\u0007\u001a\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\r\u001a\u00020\u0001\u001a\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00010\nH\u0007\u001a(\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016H\u0007\u001a\u0018\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002\u001a\u0018\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002\u001a\u001e\u0010\u001e\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u000f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\nH\u0002\u001a\u001e\u0010\"\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u000f2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00010\nH\u0002\u001a$\u0010#\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u000f2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020&0%H\u0002\u001a \u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u000f2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u0001H\u0002\u001a\u0018\u0010,\u001a\u00020\u00122\u0006\u0010-\u001a\u00020.2\u0006\u0010)\u001a\u00020*H\u0002\u001a\u0018\u0010/\u001a\u00020\u00122\u0006\u00100\u001a\u00020\u000f2\u0006\u00101\u001a\u000202H\u0002\u001a\u0018\u00103\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u00104\u001a\u00020\fH\u0002\u001a\u0018\u00105\u001a\u00020\u00122\u0006\u00106\u001a\u00020\u000f2\u0006\u00104\u001a\u00020\fH\u0002\u001a\u0018\u00107\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u000f2\u0006\u00104\u001a\u00020\fH\u0002\u00a8\u00068"}, d2={"generateOasPreview", "", "openApiSpecification", "Lcom/intellij/microservices/oas/OpenApiSpecification;", "generateOasDraft", "projectName", "models", "generateOasJsonSchemaForRequestBody", "oasSpecification", "prefixes", "", "findSinglePathRequestBodyData", "Lcom/intellij/microservices/oas/OasSchema;", "contentType", "createNestedNodeWithSchemaPrefixes", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "rootNode", "generateOasContent", "", "factory", "Lcom/fasterxml/jackson/core/JsonFactory;", "writer", "Ljava/io/Writer;", "Y", "model", "Lcom/intellij/microservices/oas/OasEndpointPath;", "Y", "pathNode", "operation", "Lcom/intellij/microservices/oas/OasOperation;", "Y", "parentNode", "tags", "Lcom/intellij/microservices/oas/OasTag;", "E", "Y", "examples", "", "Lcom/intellij/microservices/oas/OasExample;", "Y", "exampleObject", "exampleValue", "Lcom/intellij/microservices/oas/OasExampleValue;", "fieldName", "Y", "arrayNode", "Lcom/fasterxml/jackson/databind/node/ArrayNode;", "Y", "componentsNode", "oasComponents", "Lcom/intellij/microservices/oas/OasComponents;", "E", "schema", "Y", "schemaNode", "n", "intellij.microservices"})
@SourceDebugExtension(value={"SMAP\nOasSerializationUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OasSerializationUtils.kt\ncom/intellij/microservices/oas/serialization/OasSerializationUtilsKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,408:1\n1872#2,3:409\n1797#2,3:412\n1863#2:415\n1863#2,2:416\n1863#2,2:418\n1864#2:420\n1863#2,2:421\n1863#2,2:423\n1863#2,2:425\n1863#2,2:427\n1863#2,2:433\n1863#2,2:437\n1863#2,2:439\n1863#2,2:441\n216#3,2:429\n216#3,2:431\n216#3,2:435\n*S KotlinDebug\n*F\n+ 1 OasSerializationUtils.kt\ncom/intellij/microservices/oas/serialization/OasSerializationUtilsKt\n*L\n24#1:409,3\n106#1:412,3\n210#1:415\n220#1:416,2\n225#1:418,2\n210#1:420\n245#1:421,2\n258#1:423,2\n270#1:425,2\n281#1:427,2\n314#1:433,2\n338#1:437,2\n364#1:439,2\n406#1:441,2\n285#1:429,2\n308#1:431,2\n332#1:435,2\n*E\n"})
public final class OasSerializationUtilsKt {
    @NlsSafe
    @NotNull
    public static final String generateOasPreview(@NotNull OpenApiSpecification openApiSpecification) {
        Intrinsics.checkNotNullParameter((Object)openApiSpecification, (String)"openApiSpecification");
        YAMLFactory yAMLFactory = new YAMLFactory().configure(YAMLGenerator.Feature.WRITE_DOC_START_MARKER, false);
        StringWriter stringWriter = new StringWriter();
        ObjectMapper objectMapper = new ObjectMapper((JsonFactory)yAMLFactory);
        Object object = openApiSpecification.getPaths();
        boolean bl = false;
        int n10 = 0;
        Object object22 = object.iterator();
        while (object22.hasNext()) {
            int n11;
            Object t2 = object22.next();
            if ((n11 = n10++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            OasEndpointPath oasEndpointPath = (OasEndpointPath)t2;
            int n12 = n11;
            boolean bl2 = false;
            if (n12 != 0) {
                stringWriter.getBuffer().append("\n---\n");
            }
            YAMLGenerator yAMLGenerator = yAMLFactory.createGenerator((Writer)stringWriter);
            ObjectNode objectNode = objectMapper.createObjectNode();
            Intrinsics.checkNotNull((Object)objectNode);
            OasSerializationUtilsKt.Y(objectNode, oasEndpointPath);
            objectMapper.writeTree((JsonGenerator)yAMLGenerator, (JsonNode)objectNode);
        }
        String string = stringWriter.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        object = string;
        StringBuilder stringBuilder = new StringBuilder();
        object22 = new String[]{"\n"};
        for (Object object22 : StringsKt.split$default((CharSequence)((CharSequence)object), (String[])object22, (boolean)false, (int)0, (int)6, null)) {
            StringBuilder stringBuilder2 = Intrinsics.areEqual((Object)object22, (Object)"---") ? stringBuilder.append((String)object22) : stringBuilder.append("  ").append((String)object22);
            stringBuilder.append("\n");
        }
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return ((Object)StringsKt.trimEnd((CharSequence)string2)).toString();
    }

    @NlsSafe
    @NotNull
    public static final String generateOasDraft(@NotNull String projectName, @NotNull OpenApiSpecification models) {
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        Intrinsics.checkNotNullParameter((Object)models, (String)"models");
        YAMLFactory yAMLFactory = new YAMLFactory().configure(YAMLGenerator.Feature.WRITE_DOC_START_MARKER, false);
        Writer writer = new StringWriter();
        Intrinsics.checkNotNull((Object)yAMLFactory);
        OasSerializationUtilsKt.generateOasContent((JsonFactory)yAMLFactory, projectName, models, writer);
        return writer.toString();
    }

    @NlsSafe
    @Nullable
    public static final String generateOasJsonSchemaForRequestBody(@NotNull OpenApiSpecification oasSpecification, @NotNull List<String> prefixes) {
        Intrinsics.checkNotNullParameter((Object)oasSpecification, (String)"oasSpecification");
        Intrinsics.checkNotNullParameter(prefixes, (String)"prefixes");
        OasSchema oasSchema = OasSerializationUtilsKt.findSinglePathRequestBodyData$default(oasSpecification, null, 2, null);
        if (oasSchema == null) {
            return null;
        }
        OasSchema oasSchema2 = oasSchema;
        ObjectMapper objectMapper = new ObjectMapper(new JsonFactory());
        ObjectNode objectNode = objectMapper.createObjectNode();
        Intrinsics.checkNotNull((Object)objectNode);
        ObjectNode objectNode2 = OasSerializationUtilsKt.createNestedNodeWithSchemaPrefixes(objectNode, prefixes);
        OasSerializationUtilsKt.E(objectNode2, oasSchema2);
        OasComponents oasComponents = oasSpecification.getComponents();
        if (oasComponents != null) {
            ObjectNode objectNode3;
            ObjectNode objectNode4 = objectNode3 = objectNode.putObject("components");
            boolean bl = false;
            Intrinsics.checkNotNull((Object)objectNode4);
            OasSerializationUtilsKt.Y(objectNode4, oasComponents);
        }
        return objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)objectNode);
    }

    public static /* synthetic */ String generateOasJsonSchemaForRequestBody$default(OpenApiSpecification openApiSpecification, List list, int n10, Object object) {
        if ((n10 & 2) != 0) {
            list = CollectionsKt.emptyList();
        }
        return OasSerializationUtilsKt.generateOasJsonSchemaForRequestBody(openApiSpecification, list);
    }

    @Nullable
    public static final OasSchema findSinglePathRequestBodyData(@NotNull OpenApiSpecification openApiSpecification, @NotNull String contentType) {
        Intrinsics.checkNotNullParameter((Object)openApiSpecification, (String)"openApiSpecification");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        return (OasSchema)SequencesKt.firstOrNull((Sequence)SequencesKt.flatMap((Sequence)CollectionsKt.asSequence((Iterable)openApiSpecification.getPaths()), arg_0 -> OasSerializationUtilsKt.Y(contentType, arg_0)));
    }

    public static /* synthetic */ OasSchema findSinglePathRequestBodyData$default(OpenApiSpecification openApiSpecification, String string, int n10, Object object) {
        if ((n10 & 2) != 0) {
            string = "application/json";
        }
        return OasSerializationUtilsKt.findSinglePathRequestBodyData(openApiSpecification, string);
    }

    @ApiStatus.Internal
    @NotNull
    public static final ObjectNode createNestedNodeWithSchemaPrefixes(@NotNull ObjectNode rootNode, @NotNull List<String> prefixes) {
        Intrinsics.checkNotNullParameter((Object)rootNode, (String)"rootNode");
        Intrinsics.checkNotNullParameter(prefixes, (String)"prefixes");
        Iterable iterable = prefixes;
        boolean bl = false;
        ObjectNode objectNode = rootNode;
        for (Object t2 : iterable) {
            String string = (String)t2;
            ObjectNode objectNode2 = objectNode;
            boolean bl2 = false;
            objectNode2.put("type", "object");
            Intrinsics.checkNotNullExpressionValue((Object)objectNode2.putObject("properties").putObject(string), (String)"putObject(...)");
        }
        return objectNode;
    }

    @NlsSafe
    public static final void generateOasContent(@NotNull JsonFactory factory, @NotNull String projectName, @NotNull OpenApiSpecification openApiSpecification, @NotNull Writer writer) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)projectName, (String)"projectName");
        Intrinsics.checkNotNullParameter((Object)openApiSpecification, (String)"openApiSpecification");
        Intrinsics.checkNotNullParameter((Object)writer, (String)"writer");
        ObjectMapper objectMapper = new ObjectMapper(factory);
        String string = FileUtil.sanitizeFileName((String)projectName);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sanitizeFileName(...)");
        String string2 = string;
        ObjectNode objectNode = objectMapper.createObjectNode();
        objectNode.put("openapi", "3.1.0");
        Object object2 = object = objectNode.putObject("info");
        boolean bl = false;
        object2.put("title", string2 + " API");
        object2.put("description", string2 + " API");
        object2.put("version", "1.0.0");
        object2 = object = objectNode.putArray("servers");
        bl = false;
        object2.addObject().put("url", "https://" + string2);
        object = openApiSpecification.getTags();
        if (!(object == null || object.isEmpty())) {
            Intrinsics.checkNotNull((Object)objectNode);
            OasSerializationUtilsKt.Y(objectNode, openApiSpecification.getTags());
        }
        object = objectNode.putObject("paths");
        for (OasEndpointPath oasEndpointPath : openApiSpecification.getPaths()) {
            Intrinsics.checkNotNull((Object)object);
            OasSerializationUtilsKt.Y((ObjectNode)object, oasEndpointPath);
        }
        if (openApiSpecification.getComponents() != null && !openApiSpecification.getComponents().getSchemas().isEmpty()) {
            object2 = objectNode.putObject("components");
            Intrinsics.checkNotNull((Object)object2);
            OasSerializationUtilsKt.Y((ObjectNode)object2, openApiSpecification.getComponents());
        }
        object2 = factory.createGenerator(writer);
        if (!(factory instanceof YAMLFactory)) {
            object2.useDefaultPrettyPrinter();
        }
        objectMapper.writeTree((JsonGenerator)object2, (JsonNode)objectNode);
    }

    private static final void Y(ObjectNode objectNode, OasEndpointPath oasEndpointPath) {
        if (Intrinsics.areEqual((Object)oasEndpointPath.getPath(), (Object)"<unknown>") && oasEndpointPath.getOperations().isEmpty()) {
            return;
        }
        ObjectNode objectNode2 = objectNode.putObject(oasEndpointPath.getAbsolutePath());
        if (oasEndpointPath.getSummary() != null) {
            objectNode2.put("summary", oasEndpointPath.getSummary());
        }
        for (OasOperation oasOperation : oasEndpointPath.getOperations()) {
            Intrinsics.checkNotNull((Object)objectNode2);
            OasSerializationUtilsKt.Y(objectNode2, oasOperation);
        }
    }

    private static final void Y(ObjectNode objectNode, OasOperation oasOperation) {
        Object object;
        Object object2;
        String string;
        Object object32;
        Object object4;
        ArrayNode arrayNode;
        ObjectNode objectNode2 = objectNode.putObject(oasOperation.getMethod().getMethodName());
        if (!((Collection)oasOperation.getTags()).isEmpty()) {
            Intrinsics.checkNotNull((Object)objectNode2);
            OasSerializationUtilsKt.E(objectNode2, oasOperation.getTags());
        }
        if (oasOperation.getSummary() != null) {
            objectNode2.put("summary", oasOperation.getSummary());
        }
        if (oasOperation.getDescription() != null) {
            objectNode2.put("description", oasOperation.getDescription());
        }
        if (oasOperation.isDeprecated()) {
            objectNode2.put("deprecated", true);
        }
        if (oasOperation.getOperationId() != null) {
            objectNode2.put("operationId", oasOperation.getOperationId());
        }
        if (!oasOperation.getParameters().isEmpty()) {
            arrayNode = objectNode2.putArray("parameters");
            for (OasParameter object5 : oasOperation.getParameters()) {
                ObjectNode objectNode3 = arrayNode.addObject();
                objectNode3.put("name", object5.getName());
                objectNode3.put("in", object5.getInPlace().getPlaceName());
                if (object5.isDeprecated()) {
                    objectNode3.put("deprecated", true);
                }
                objectNode3.put("required", object5.isRequired());
                object4 = object5.getDescription();
                if (!(object4 == null || object4.length() == 0)) {
                    objectNode3.put("description", object5.getDescription());
                }
                if ((object4 = object5.getSchema()) == null) continue;
                object32 = objectNode3.putObject("schema");
                Intrinsics.checkNotNull((Object)object32);
                OasSerializationUtilsKt.E((ObjectNode)object32, (OasSchema)object4);
                if (((OasSchema)object4).getDefault() != null) {
                    boolean bl = false;
                    object32.put("default", string);
                }
                OasSerializationUtilsKt.n((ObjectNode)object32, (OasSchema)object4);
            }
        }
        if (oasOperation.getRequestBody() != null) {
            arrayNode = objectNode2.putObject("requestBody");
            ObjectNode objectNode4 = arrayNode.putObject("content");
            Iterable iterable = oasOperation.getRequestBody().getContent().entrySet();
            boolean bl = false;
            for (Object object32 : iterable) {
                List<OasProperty> list;
                boolean bl2;
                Object object5;
                Object object6;
                Map.Entry entry = (Map.Entry)object32;
                boolean bl3 = false;
                string = (String)entry.getKey();
                OasSchema oasSchema = (OasSchema)entry.getValue();
                ObjectNode objectNode5 = objectNode4.putObject(string);
                object2 = objectNode5.putObject("schema");
                Intrinsics.checkNotNull((Object)object2);
                OasSerializationUtilsKt.E(object2, oasSchema);
                if (oasSchema.getRequired() != null) {
                    ArrayNode arrayNode2 = object2.putArray("required");
                    object = oasSchema.getRequired();
                    boolean bl4 = false;
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        object6 = iterator.next();
                        object5 = (String)object6;
                        bl2 = false;
                        arrayNode2.add((String)object5);
                    }
                }
                if (oasSchema.getProperties() == null) continue;
                boolean bl5 = false;
                object6 = object2.putObject("properties");
                object5 = list;
                bl2 = false;
                Iterator iterator = object5.iterator();
                while (iterator.hasNext()) {
                    Object t2 = iterator.next();
                    OasProperty oasProperty = (OasProperty)t2;
                    boolean bl6 = false;
                    ObjectNode objectNode6 = object6.putObject(oasProperty.getName());
                    Intrinsics.checkNotNullExpressionValue((Object)objectNode6, (String)"putObject(...)");
                    OasSerializationUtilsKt.E(objectNode6, oasProperty.getSchema());
                }
            }
            if (oasOperation.getRequestBody().getRequired()) {
                arrayNode.put("required", true);
            }
        }
        if (!oasOperation.getResponses().isEmpty()) {
            arrayNode = objectNode2.putObject("responses");
            for (OasResponse oasResponse : oasOperation.getResponses()) {
                boolean bl;
                Object object7;
                Iterator iterator;
                boolean bl7;
                ObjectNode objectNode7 = arrayNode.putObject(oasResponse.getCode());
                String string2 = oasResponse.getDescription();
                if (string2 == null) {
                    string2 = "";
                }
                objectNode7.put("description", string2);
                if (!oasResponse.getContent().isEmpty()) {
                    object4 = objectNode7.putObject("content");
                    object32 = oasResponse.getContent().entrySet();
                    bl7 = false;
                    iterator = object32.iterator();
                    while (iterator.hasNext()) {
                        string = iterator.next();
                        object7 = (Map.Entry)((Object)string);
                        bl = false;
                        object2 = (String)object7.getKey();
                        OasMediaTypeObject oasMediaTypeObject = (OasMediaTypeObject)object7.getValue();
                        object = object4.putObject((String)object2);
                        ObjectNode objectNode8 = object.putObject("schema");
                        Intrinsics.checkNotNullExpressionValue((Object)objectNode8, (String)"putObject(...)");
                        OasSerializationUtilsKt.E(objectNode8, oasMediaTypeObject.getSchema());
                        if (!(!oasMediaTypeObject.getExamples().isEmpty())) continue;
                        ObjectNode objectNode9 = object.putObject("examples");
                        Intrinsics.checkNotNullExpressionValue((Object)objectNode9, (String)"putObject(...)");
                        OasSerializationUtilsKt.Y(objectNode9, oasMediaTypeObject.getExamples());
                    }
                }
                if (!(!((Collection)oasResponse.getHeaders()).isEmpty())) continue;
                object4 = objectNode7.putObject("headers");
                object32 = oasResponse.getHeaders();
                bl7 = false;
                iterator = object32.iterator();
                while (iterator.hasNext()) {
                    string = iterator.next();
                    object7 = (OasHeader)((Object)string);
                    bl = false;
                    object2 = ((OasHeader)object7).component1();
                    boolean bl8 = ((OasHeader)object7).component2();
                    object = ((OasHeader)object7).component3();
                    ObjectNode objectNode10 = object4.putObject((String)object2);
                    objectNode10.put("required", bl8);
                    ObjectNode objectNode11 = objectNode10.putObject("schema");
                    Intrinsics.checkNotNullExpressionValue((Object)objectNode11, (String)"putObject(...)");
                    OasSerializationUtilsKt.E(objectNode11, (OasSchema)object);
                }
            }
        }
    }

    private static final void Y(ObjectNode objectNode, List<OasTag> list) {
        ArrayNode arrayNode = objectNode.putArray("tags");
        Iterable iterable = list;
        boolean bl = false;
        for (Object t2 : iterable) {
            OasTag oasTag = (OasTag)t2;
            boolean bl2 = false;
            String string = oasTag.component1();
            String string2 = oasTag.component2();
            ObjectNode objectNode2 = arrayNode.addObject();
            objectNode2.put("name", string);
            if (!(((CharSequence)string2).length() > 0)) continue;
            objectNode2.put("description", string2);
        }
    }

    private static final void E(ObjectNode objectNode, List<String> list) {
        ArrayNode arrayNode = objectNode.putArray("tags");
        Iterable iterable = list;
        boolean bl = false;
        for (Object t2 : iterable) {
            String string = (String)t2;
            boolean bl2 = false;
            arrayNode.add(string);
        }
    }

    private static final void Y(ObjectNode objectNode, Map<String, OasExample> map) {
        Map<String, OasExample> map2 = map;
        boolean bl = false;
        Iterator<Map.Entry<String, OasExample>> iterator = map2.entrySet().iterator();
        while (iterator.hasNext()) {
            String string;
            boolean bl2;
            Map.Entry<String, OasExample> entry;
            Map.Entry<String, OasExample> entry2 = entry = iterator.next();
            boolean bl3 = false;
            String string2 = entry2.getKey();
            OasExample oasExample = entry2.getValue();
            ObjectNode objectNode2 = objectNode.putObject(string2);
            if (oasExample.getSummary() != null) {
                bl2 = false;
                objectNode2.put("summary", string);
            }
            if (oasExample.getDescription() != null) {
                bl2 = false;
                objectNode2.put("description", string);
            }
            Intrinsics.checkNotNull((Object)objectNode2);
            OasSerializationUtilsKt.Y(objectNode2, oasExample.getValue(), "value");
        }
    }

    private static final void Y(ObjectNode objectNode, OasExampleValue oasExampleValue, String string) {
        OasExampleValue oasExampleValue2 = oasExampleValue;
        if (Intrinsics.areEqual((Object)oasExampleValue2, (Object)OasNullValue.INSTANCE)) {
            v0 = objectNode.put(string, "null");
        } else if (oasExampleValue2 instanceof OasBooleanValue) {
            v0 = objectNode.put(string, ((Boolean)((OasBooleanValue)oasExampleValue).getValue()).booleanValue());
        } else if (oasExampleValue2 instanceof OasNumberValue) {
            v0 = (Number)((OasNumberValue)oasExampleValue).getValue() instanceof Double ? objectNode.put(string, ((Number)((OasNumberValue)oasExampleValue).getValue()).doubleValue()) : objectNode.put(string, ((Number)((OasNumberValue)oasExampleValue).getValue()).longValue());
        } else if (oasExampleValue2 instanceof OasStringValue) {
            v0 = objectNode.put(string, (String)((OasStringValue)oasExampleValue).getValue());
        } else if (oasExampleValue2 instanceof OasObjectValue) {
            ObjectNode objectNode2 = objectNode.putObject(string);
            Map<String, OasExampleValue> map = ((OasObjectValue)oasExampleValue).getProperties();
            boolean bl = false;
            Iterator<Map.Entry<String, OasExampleValue>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, OasExampleValue> entry;
                Map.Entry<String, OasExampleValue> entry2 = entry = iterator.next();
                boolean bl2 = false;
                String string2 = entry2.getKey();
                OasExampleValue oasExampleValue3 = entry2.getValue();
                Intrinsics.checkNotNull((Object)objectNode2);
                OasSerializationUtilsKt.Y(objectNode2, oasExampleValue3, string2);
            }
            v0 = Unit.INSTANCE;
        } else if (oasExampleValue2 instanceof OasArrayValue) {
            ArrayNode arrayNode = objectNode.putArray(string);
            Iterable iterable = ((OasArrayValue)oasExampleValue).getItems();
            boolean bl = false;
            for (Object t2 : iterable) {
                OasExampleValue oasExampleValue4 = (OasExampleValue)t2;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)arrayNode);
                OasSerializationUtilsKt.Y(arrayNode, oasExampleValue4);
            }
            v0 = Unit.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final void Y(ArrayNode arrayNode, OasExampleValue oasExampleValue) {
        OasExampleValue oasExampleValue2 = oasExampleValue;
        if (Intrinsics.areEqual((Object)oasExampleValue2, (Object)OasNullValue.INSTANCE)) {
            return;
        }
        if (oasExampleValue2 instanceof OasBooleanValue) {
            v0 = arrayNode.add(((Boolean)((OasBooleanValue)oasExampleValue).getValue()).booleanValue());
        } else if (oasExampleValue2 instanceof OasNumberValue) {
            v0 = (Number)((OasNumberValue)oasExampleValue).getValue() instanceof Double ? arrayNode.add(((Number)((OasNumberValue)oasExampleValue).getValue()).doubleValue()) : arrayNode.add(((Number)((OasNumberValue)oasExampleValue).getValue()).longValue());
        } else if (oasExampleValue2 instanceof OasStringValue) {
            v0 = arrayNode.add((String)((OasStringValue)oasExampleValue).getValue());
        } else if (oasExampleValue2 instanceof OasObjectValue) {
            ObjectNode objectNode = arrayNode.addObject();
            Map<String, OasExampleValue> map = ((OasObjectValue)oasExampleValue).getProperties();
            boolean bl = false;
            Iterator<Map.Entry<String, OasExampleValue>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, OasExampleValue> entry;
                Map.Entry<String, OasExampleValue> entry2 = entry = iterator.next();
                boolean bl2 = false;
                String string = entry2.getKey();
                OasExampleValue oasExampleValue3 = entry2.getValue();
                Intrinsics.checkNotNull((Object)objectNode);
                OasSerializationUtilsKt.Y(objectNode, oasExampleValue3, string);
            }
            v0 = Unit.INSTANCE;
        } else if (oasExampleValue2 instanceof OasArrayValue) {
            ArrayNode arrayNode2 = arrayNode.addArray();
            Iterable iterable = ((OasArrayValue)oasExampleValue).getItems();
            boolean bl = false;
            for (Object t2 : iterable) {
                OasExampleValue oasExampleValue4 = (OasExampleValue)t2;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)arrayNode2);
                OasSerializationUtilsKt.Y(arrayNode2, oasExampleValue4);
            }
            v0 = Unit.INSTANCE;
        } else {
            throw new NoWhenBranchMatchedException();
        }
    }

    private static final void Y(ObjectNode objectNode, OasComponents oasComponents) {
        if (!oasComponents.getSchemas().isEmpty()) {
            ObjectNode objectNode2 = objectNode.putObject("schemas");
            for (Map.Entry<String, OasSchema> entry : oasComponents.getSchemas().entrySet()) {
                Object object;
                Object object2;
                ObjectNode objectNode3;
                boolean bl;
                String string = entry.getKey();
                OasSchema oasSchema = entry.getValue();
                ObjectNode objectNode4 = objectNode2.putObject(string);
                if (oasSchema.getType() != null) {
                    bl = false;
                    objectNode4.put("type", oasSchema.getType().getTypeName());
                }
                if (oasSchema.getProperties() != null) {
                    bl = false;
                    objectNode3 = objectNode4.putObject("properties");
                    object = object2.iterator();
                    while (object.hasNext()) {
                        OasProperty oasProperty = (OasProperty)object.next();
                        ObjectNode objectNode5 = objectNode3.putObject(oasProperty.getName());
                        Intrinsics.checkNotNullExpressionValue((Object)objectNode5, (String)"putObject(...)");
                        OasSerializationUtilsKt.E(objectNode5, oasProperty.getSchema());
                    }
                }
                if (oasSchema.getRequired() == null) continue;
                bl = false;
                objectNode3 = objectNode4.putArray("required");
                object = (Iterable)object2;
                boolean bl2 = false;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    Object t2 = iterator.next();
                    String string2 = (String)t2;
                    boolean bl3 = false;
                    objectNode3.add(string2);
                }
            }
        }
    }

    private static final void E(ObjectNode objectNode, OasSchema oasSchema) {
        block2: {
            OasSerializationUtilsKt.Y(objectNode, oasSchema);
            CharSequence charSequence = oasSchema.getReference();
            if (!(charSequence == null || charSequence.length() == 0)) {
                objectNode.put("$ref", oasSchema.getReference());
            }
            OasSerializationUtilsKt.n(objectNode, oasSchema);
            if (oasSchema.getType() != OasSchemaType.ARRAY) break block2;
            OasSchema oasSchema2 = oasSchema.getItems();
            if (oasSchema2 != null) {
                OasSchema oasSchema3 = oasSchema2;
                boolean bl = false;
                ObjectNode objectNode2 = objectNode.putObject("items");
                Intrinsics.checkNotNull((Object)objectNode2);
                OasSerializationUtilsKt.E(objectNode2, oasSchema3);
            }
        }
    }

    private static final void Y(ObjectNode objectNode, OasSchema oasSchema) {
        block4: {
            boolean bl;
            Enum enum_;
            OasSchemaType oasSchemaType = oasSchema.getType();
            if (oasSchemaType != null) {
                enum_ = oasSchemaType;
                bl = false;
                if (oasSchema.isNullable()) {
                    ArrayNode arrayNode = objectNode.putArray("type");
                    arrayNode.add(((OasSchemaType)enum_).getTypeName());
                    v1 = (ContainerNode)arrayNode.add("null");
                } else {
                    v1 = (ContainerNode)objectNode.put("type", ((OasSchemaType)enum_).getTypeName());
                }
            } else {
                v1 = null;
            }
            OasSchemaFormat oasSchemaFormat = oasSchema.getFormat();
            if (oasSchemaFormat == null) break block4;
            enum_ = oasSchemaFormat;
            bl = false;
            objectNode.put("format", ((OasSchemaFormat)enum_).getFormatName());
        }
    }

    private static final void n(ObjectNode objectNode, OasSchema oasSchema) {
        block1: {
            List<String> list = oasSchema.getEnum();
            if (list == null) break block1;
            List<String> list2 = list;
            boolean bl = false;
            ArrayNode arrayNode = objectNode.putArray("enum");
            Iterable iterable = list2;
            boolean bl2 = false;
            for (Object t2 : iterable) {
                String string = (String)t2;
                boolean bl3 = false;
                arrayNode.add(string);
            }
        }
    }

    private static final OasSchema Y(String string, OasOperation oasOperation) {
        Intrinsics.checkNotNullParameter((Object)oasOperation, (String)"it");
        Object object = oasOperation.getRequestBody();
        return object != null && (object = ((OasRequestBody)object).getContent()) != null ? (OasSchema)object.get(string) : null;
    }

    private static final Sequence Y(String string, OasEndpointPath oasEndpointPath) {
        Intrinsics.checkNotNullParameter((Object)oasEndpointPath, (String)"it");
        return SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)oasEndpointPath.getOperations()), arg_0 -> OasSerializationUtilsKt.Y(string, arg_0));
    }
}

