/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.oas;

import com.intellij.microservices.oas.OasModelUtils;
import com.intellij.microservices.oas.OasOperation;
import com.intellij.microservices.url.UrlPath;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001:\u0001\u0011B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\b\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006\u0012"}, d2={"Lcom/intellij/microservices/oas/OasEndpointPath;", "", "path", "", "summary", "operations", "", "Lcom/intellij/microservices/oas/OasOperation;", "OasEndpointPath", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/Collection;)V", "getPath", "()Ljava/lang/String;", "getSummary", "getOperations", "()Ljava/util/Collection;", "absolutePath", "getAbsolutePath", "Builder", "intellij.microservices"})
public final class OasEndpointPath {
    @NotNull
    private final String path;
    @Nullable
    private final String summary;
    @NotNull
    private final Collection<OasOperation> operations;
    @NotNull
    private final String absolutePath;

    public OasEndpointPath(@NotNull String path, @Nullable String summary, @NotNull Collection<OasOperation> operations) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(operations, (String)"operations");
        this.path = path;
        this.summary = summary;
        this.operations = operations;
        this.absolutePath = StringsKt.startsWith$default((String)this.path, (String)"/", (boolean)false, (int)2, null) ? this.path : "/" + this.path;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @Nullable
    public final String getSummary() {
        return this.summary;
    }

    @NotNull
    public final Collection<OasOperation> getOperations() {
        return this.operations;
    }

    @NotNull
    public final String getAbsolutePath() {
        return this.absolutePath;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ%\u0010\u0014\u001a\u00020\u00152\u001b\b\u0002\u0010\u0016\u001a\u0015\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020\u0018\u0018\u00010\u0017\u00a2\u0006\u0002\b\u0019H\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\u0005R \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001a"}, d2={"Lcom/intellij/microservices/oas/OasEndpointPath$Builder;", "", "path", "", "OasEndpointPath$Builder", "(Ljava/lang/String;)V", "urlPath", "Lcom/intellij/microservices/url/UrlPath;", "(Lcom/intellij/microservices/url/UrlPath;)V", "summary", "getSummary", "()Ljava/lang/String;", "setSummary", "operations", "", "Lcom/intellij/microservices/oas/OasOperation;", "getOperations", "()Ljava/util/Collection;", "setOperations", "(Ljava/util/Collection;)V", "build", "Lcom/intellij/microservices/oas/OasEndpointPath;", "block", "Lkotlin/Function1;", "", "Lkotlin/ExtensionFunctionType;", "intellij.microservices"})
    public static final class Builder {
        @NotNull
        private final String path;
        @Nullable
        private String summary;
        @NotNull
        private Collection<OasOperation> operations;

        public Builder(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            this.path = path;
            this.operations = CollectionsKt.emptyList();
        }

        public Builder(@NotNull UrlPath urlPath) {
            Intrinsics.checkNotNullParameter((Object)urlPath, (String)"urlPath");
            this(urlPath.getPresentation(OasModelUtils.getOPEN_API_PRESENTATION()));
        }

        @Nullable
        public final String getSummary() {
            return this.summary;
        }

        public final void setSummary(@Nullable String string) {
            this.summary = string;
        }

        @NotNull
        public final Collection<OasOperation> getOperations() {
            return this.operations;
        }

        public final void setOperations(@NotNull Collection<OasOperation> collection) {
            Intrinsics.checkNotNullParameter(collection, (String)"<set-?>");
            this.operations = collection;
        }

        @JvmOverloads
        @NotNull
        public final OasEndpointPath build(@Nullable Function1<? super Builder, Unit> block) {
            block0: {
                Function1<? super Builder, Unit> function1 = block;
                if (function1 == null) break block0;
                function1.invoke((Object)this);
            }
            return new OasEndpointPath(this.path, this.summary, this.operations);
        }

        public static /* synthetic */ OasEndpointPath build$default(Builder builder, Function1 function1, int n10, Object object) {
            if ((n10 & 1) != 0) {
                function1 = null;
            }
            return builder.build((Function1<? super Builder, Unit>)function1);
        }

        @JvmOverloads
        @NotNull
        public final OasEndpointPath build() {
            return Builder.build$default(this, null, 1, null);
        }
    }
}

