/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.sarif.notifications;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ComponentManagerEx;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.NioPathUtil;
import com.jetbrains.qodana.sarif.model.ArtifactLocation;
import com.jetbrains.qodana.sarif.model.Invocation;
import com.jetbrains.qodana.sarif.model.Location;
import com.jetbrains.qodana.sarif.model.Notification;
import com.jetbrains.qodana.sarif.model.Run;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaConfig;
import org.jetbrains.qodana.staticAnalysis.sarif.SarifKt;
import org.jetbrains.qodana.staticAnalysis.sarif.SarifReportContributor;
import org.jetbrains.qodana.staticAnalysis.sarif.notifications.RuntimeNotificationCollector;
import org.jetbrains.qodana.staticAnalysis.workflow.QodanaWorkflowExtension;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u0001:\u0002\u0017\u0018B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0006J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\u0006H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u000b\u001a\u0010\u0012\f\u0012\n \r*\u0004\u0018\u00010\u00060\u00060\f8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/sarif/notifications/RuntimeNotificationCollector;", "", "<init>", "()V", "_notifications", "Ljava/util/concurrent/ConcurrentLinkedDeque;", "Lcom/jetbrains/qodana/sarif/model/Notification;", "capacity", "Ljava/util/concurrent/atomic/AtomicInteger;", "projectPath", "Ljava/nio/file/Path;", "notifications", "", "kotlin.jvm.PlatformType", "getNotifications", "()Ljava/util/List;", "configure", "", "config", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;", "add", "notification", "tryRelativizeArtifactLocation", "NotificationWorkflowExtension", "NotificationReportContributor", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nRuntimeNotificationCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuntimeNotificationCollector.kt\norg/jetbrains/qodana/staticAnalysis/sarif/notifications/RuntimeNotificationCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,89:1\n1863#2,2:90\n*S KotlinDebug\n*F\n+ 1 RuntimeNotificationCollector.kt\norg/jetbrains/qodana/staticAnalysis/sarif/notifications/RuntimeNotificationCollector\n*L\n44#1:90,2\n*E\n"})
public final class RuntimeNotificationCollector {
    @NotNull
    private final ConcurrentLinkedDeque<Notification> _notifications = new ConcurrentLinkedDeque();
    @NotNull
    private final AtomicInteger capacity = new AtomicInteger(0);
    private Path projectPath;

    @NotNull
    public final List<Notification> getNotifications() {
        return CollectionsKt.toList((Iterable)this._notifications);
    }

    public final void configure(@NotNull QodanaConfig config) {
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.projectPath = config.getProjectPath();
        this._notifications.clear();
        this.capacity.set(config.getMaxRuntimeNotifications());
    }

    public final void add(@NotNull Notification notification) {
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        if (Intrinsics.areEqual((Object)SarifKt.getQodanaKind(notification), (Object)"sanityFailure") || this.capacity.getAndUpdate(add.1.INSTANCE) > 0) {
            this.tryRelativizeArtifactLocation(notification);
            ((Collection)this._notifications).add(notification);
        }
    }

    private final void tryRelativizeArtifactLocation(Notification notification) {
        block2: {
            Set set = notification.getLocations();
            if (set == null) break block2;
            Iterable $this$forEach$iv = set;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Location original = (Location)element$iv;
                boolean bl = false;
                Object object = original;
                if (object == null || (object = object.getPhysicalLocation()) == null || (object = object.getArtifactLocation()) == null || (object = object.getUri()) == null || (object = NioPathUtil.toNioPathOrNull((String)object)) == null) continue;
                Object path = object;
                boolean hasSrcRoot = Intrinsics.areEqual((Object)original.getPhysicalLocation().getArtifactLocation().getUriBaseId(), (Object)"SRCROOT");
                if (hasSrcRoot || !path.isAbsolute()) continue;
                ArtifactLocation artifactLocation = original.getPhysicalLocation().getArtifactLocation().withUriBaseId("SRCROOT");
                Path path2 = this.projectPath;
                if (path2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"projectPath");
                    path2 = null;
                }
                artifactLocation.withUri(((Object)path2.relativize((Path)path)).toString());
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0007\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/sarif/notifications/RuntimeNotificationCollector$NotificationReportContributor;", "Lorg/jetbrains/qodana/staticAnalysis/sarif/SarifReportContributor;", "<init>", "()V", "contribute", "", "run", "Lcom/jetbrains/qodana/sarif/model/Run;", "project", "Lcom/intellij/openapi/project/Project;", "config", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;", "collector", "Lorg/jetbrains/qodana/staticAnalysis/sarif/notifications/RuntimeNotificationCollector;", "Companion", "intellij.qodana"})
    @SourceDebugExtension(value={"SMAP\nRuntimeNotificationCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuntimeNotificationCollector.kt\norg/jetbrains/qodana/staticAnalysis/sarif/notifications/RuntimeNotificationCollector$NotificationReportContributor\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,89:1\n31#2,2:90\n14#3:92\n*S KotlinDebug\n*F\n+ 1 RuntimeNotificationCollector.kt\norg/jetbrains/qodana/staticAnalysis/sarif/notifications/RuntimeNotificationCollector$NotificationReportContributor\n*L\n68#1:90,2\n64#1:92\n*E\n"})
    public static final class NotificationReportContributor
    implements SarifReportContributor {
        @NotNull
        private static final Companion Companion = new Companion(null);
        @NotNull
        private static final Logger logger;

        @Override
        public void contribute(@NotNull Run run2, @NotNull Project project, @NotNull QodanaConfig config) {
            Intrinsics.checkNotNullParameter((Object)run2, (String)"run");
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<RuntimeNotificationCollector> serviceClass$iv = RuntimeNotificationCollector.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            this.contribute(run2, (RuntimeNotificationCollector)object);
        }

        @VisibleForTesting
        public final void contribute(@NotNull Run run2, @NotNull RuntimeNotificationCollector collector) {
            Intrinsics.checkNotNullParameter((Object)run2, (String)"run");
            Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
            List list2 = run2.getInvocations();
            if (list2 == null || (list2 = (Invocation)CollectionsKt.firstOrNull((List)list2)) == null) {
                NotificationReportContributor $this$contribute_u24lambda_u240 = this;
                boolean bl = false;
                logger.warn("Cannot report tool errors, because invocation node is not present");
                return;
            }
            List invocation = list2;
            Collection collection = collector.getNotifications();
            if (collection.isEmpty()) {
                boolean bl = false;
                logger.info("No tool errors to report to sarif file");
                return;
            }
            List collected = (List)collection;
            List list3 = invocation.getToolExecutionNotifications();
            if (list3 == null || (list3 = CollectionsKt.toMutableList((Collection)list3)) == null) {
                list3 = new ArrayList();
            }
            List notifications = list3;
            notifications.addAll(collected);
            invocation.setToolExecutionNotifications(notifications);
        }

        static {
            boolean $i$f$logger = false;
            Logger logger2 = Logger.getInstance(NotificationReportContributor.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger = logger2;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/sarif/notifications/RuntimeNotificationCollector$NotificationReportContributor$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.qodana"})
        private static final class Companion {
            private Companion() {
            }

            @NotNull
            public final Logger getLogger() {
                return logger;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0096@\u00a2\u0006\u0002\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/sarif/notifications/RuntimeNotificationCollector$NotificationWorkflowExtension;", "Lorg/jetbrains/qodana/staticAnalysis/workflow/QodanaWorkflowExtension;", "<init>", "()V", "afterConfiguration", "", "config", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;", "project", "Lcom/intellij/openapi/project/Project;", "(Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.qodana"})
    @SourceDebugExtension(value={"SMAP\nRuntimeNotificationCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RuntimeNotificationCollector.kt\norg/jetbrains/qodana/staticAnalysis/sarif/notifications/RuntimeNotificationCollector$NotificationWorkflowExtension\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,89:1\n72#2:90\n*S KotlinDebug\n*F\n+ 1 RuntimeNotificationCollector.kt\norg/jetbrains/qodana/staticAnalysis/sarif/notifications/RuntimeNotificationCollector$NotificationWorkflowExtension\n*L\n57#1:90\n*E\n"})
    public static final class NotificationWorkflowExtension
    implements QodanaWorkflowExtension {
        /*
         * Unable to fully structure code
         */
        @Override
        @Nullable
        public Object afterConfiguration(@NotNull QodanaConfig var1_1, @NotNull Project var2_2, @NotNull Continuation<? super Unit> $completion) {
            if (!($completion instanceof afterConfiguration.1)) ** GOTO lbl-1000
            var7_4 = $completion;
            if ((var7_4.label & -2147483648) != 0) {
                var7_4.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ NotificationWorkflowExtension this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.afterConfiguration(null, null, (Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var8_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $this$serviceAsync$iv = (ComponentManager)project;
                    $i$f$serviceAsync = false;
                    Intrinsics.checkNotNull((Object)$this$serviceAsync$iv, (String)"null cannot be cast to non-null type com.intellij.openapi.components.ComponentManagerEx");
                    $continuation.L$0 = config;
                    $continuation.label = 1;
                    v0 = ((ComponentManagerEx)$this$serviceAsync$iv).getServiceAsync(RuntimeNotificationCollector.class, (Continuation)$continuation);
                    if (v0 == var8_6) {
                        return var8_6;
                    }
                    ** GOTO lbl27
                }
                case 1: {
                    $i$f$serviceAsync = false;
                    config = (QodanaConfig)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl27:
                    // 2 sources

                    ((RuntimeNotificationCollector)v0).configure(config);
                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }
    }
}

