/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.profile;

import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.project.Project;
import com.jetbrains.qodana.sarif.model.Message;
import com.jetbrains.qodana.sarif.model.Notification;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaConfig;
import org.jetbrains.qodana.staticAnalysis.profile.ProblemCounters;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaToolRegistrar;
import org.jetbrains.qodana.staticAnalysis.sarif.SarifKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\fJ\"\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\f2\b\u0010\u0011\u001a\u0004\u0018\u00010\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\fJ\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/profile/Thresholds;", "", "project", "Lcom/intellij/openapi/project/Project;", "config", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;", "<init>", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "problemCounters", "", "", "Lorg/jetbrains/qodana/staticAnalysis/profile/ProblemCounters;", "addProblem", "", "inspectionId", "relativePath", "module", "isReached", "constructNotification", "Lcom/jetbrains/qodana/sarif/model/Notification;", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nSanityInspectionGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SanityInspectionGroup.kt\norg/jetbrains/qodana/staticAnalysis/profile/Thresholds\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,189:1\n1187#2,2:190\n1261#2,4:192\n535#3:196\n520#3,6:197\n126#4:203\n153#4,3:204\n*S KotlinDebug\n*F\n+ 1 SanityInspectionGroup.kt\norg/jetbrains/qodana/staticAnalysis/profile/Thresholds\n*L\n76#1:190,2\n76#1:192,4\n105#1:196\n105#1:197,6\n106#1:203\n106#1:204,3\n*E\n"})
final class Thresholds {
    @NotNull
    private final Project project;
    @NotNull
    private final Map<String, ProblemCounters> problemCounters;

    /*
     * WARNING - void declaration
     */
    public Thresholds(@NotNull Project project, @NotNull QodanaConfig config) {
        void $this$associateTo$iv$iv;
        void $this$associate$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.project = project;
        Iterable iterable = QodanaToolRegistrar.Companion.getInstance(this.project).createTools();
        Thresholds thresholds = this;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        void var6_7 = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map2 = destination$iv$iv;
            InspectionToolWrapper it = (InspectionToolWrapper)element$iv$iv;
            boolean bl = false;
            Pair pair = TuplesKt.to((Object)it.getShortName(), (Object)new ProblemCounters(this.project, it, config.getFileSuspendThreshold(), config.getModuleSuspendThreshold(), config.getProjectSuspendThreshold()));
            map2.put(pair.getFirst(), pair.getSecond());
        }
        thresholds.problemCounters = destination$iv$iv;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public final boolean addProblem(@NotNull String inspectionId, @Nullable String relativePath, @Nullable String module) {
        Intrinsics.checkNotNullParameter((Object)inspectionId, (String)"inspectionId");
        ProblemCounters problemCounters = this.problemCounters.get(inspectionId);
        if (problemCounters == null) {
            return false;
        }
        ProblemCounters problemCounters2 = problemCounters;
        return problemCounters2.addProblem(relativePath, module);
    }

    public final boolean isReached(@NotNull String inspectionId, @Nullable String relativePath, @Nullable String module) {
        Intrinsics.checkNotNullParameter((Object)inspectionId, (String)"inspectionId");
        ProblemCounters problemCounters = this.problemCounters.get(inspectionId);
        if (problemCounters == null) {
            return false;
        }
        ProblemCounters problemCounters2 = problemCounters;
        return problemCounters2.isThresholdReached(relativePath, module);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Notification constructNotification() {
        void $this$mapTo$iv$iv;
        Map.Entry it;
        Map $this$filterTo$iv$iv;
        Map<String, ProblemCounters> $this$filter$iv = this.problemCounters;
        boolean $i$f$filter = false;
        Map<String, ProblemCounters> map2 = $this$filter$iv;
        Object destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!(((ProblemCounters)it.getValue()).wasProjectThresholdReached() || ((ProblemCounters)it.getValue()).wasAnyModuleThresholdReached())) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        Map $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
            it = item$iv$iv;
            Object object = destination$iv$iv;
            boolean bl = false;
            object.add("\"" + ((ProblemCounters)it.getValue()).getInspectionToolWrapper().getDisplayName() + "\"");
        }
        List skippedInspections = (List)destination$iv$iv;
        if (skippedInspections.isEmpty()) {
            return null;
        }
        Object[] objectArray = new Object[]{skippedInspections.size(), CollectionsKt.joinToString$default((Iterable)skippedInspections, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null)};
        Notification notification = new Notification().withLevel(Notification.Level.ERROR).withTimeUtc(Instant.now()).withMessage(new Message().withText(QodanaBundle.message("sanity.suspend.inspection.notification.message", objectArray)));
        Intrinsics.checkNotNullExpressionValue((Object)notification, (String)"withMessage(...)");
        return SarifKt.withKind(notification, "sanityFailure");
    }
}

