/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.profile;

import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.openapi.project.Project;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiFunction;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.qodana.staticAnalysis.profile.FileAndModule;
import org.jetbrains.qodana.staticAnalysis.profile.SanityInspectionGroupKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0001\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000e\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\u0014J\u001a\u0010\u001e\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00142\b\u0010\u001d\u001a\u0004\u0018\u00010\u0014J\u0006\u0010\u001f\u001a\u00020\u001bJ\u0006\u0010 \u001a\u00020\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0019\u0010\u0004\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00070\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00070\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/profile/ProblemCounters;", "", "project", "Lcom/intellij/openapi/project/Project;", "inspectionToolWrapper", "Lcom/intellij/codeInspection/ex/InspectionToolWrapper;", "_maxPerFile", "", "_maxPerModule", "_maxPerProject", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/codeInspection/ex/InspectionToolWrapper;III)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getInspectionToolWrapper", "()Lcom/intellij/codeInspection/ex/InspectionToolWrapper;", "perFile", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/jetbrains/qodana/staticAnalysis/profile/FileAndModule;", "perModule", "", "perProject", "Ljava/util/concurrent/atomic/AtomicInteger;", "maxPerFile", "maxPerModule", "maxPerProject", "addProblem", "", "relativePath", "module", "isThresholdReached", "wasAnyModuleThresholdReached", "wasProjectThresholdReached", "intellij.qodana"})
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nSanityInspectionGroup.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SanityInspectionGroup.kt\norg/jetbrains/qodana/staticAnalysis/profile/ProblemCounters\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,189:1\n188#2,3:190\n*S KotlinDebug\n*F\n+ 1 SanityInspectionGroup.kt\norg/jetbrains/qodana/staticAnalysis/profile/ProblemCounters\n*L\n176#1:190,3\n*E\n"})
public final class ProblemCounters {
    @NotNull
    private final Project project;
    @NotNull
    private final InspectionToolWrapper<?, ?> inspectionToolWrapper;
    @NotNull
    private final ConcurrentHashMap<FileAndModule, Integer> perFile;
    @NotNull
    private final ConcurrentHashMap<String, Integer> perModule;
    @NotNull
    private final AtomicInteger perProject;
    private final int maxPerFile;
    private final int maxPerModule;
    private final int maxPerProject;

    public ProblemCounters(@NotNull Project project, @NotNull InspectionToolWrapper<?, ?> inspectionToolWrapper, int _maxPerFile, int _maxPerModule, int _maxPerProject) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(inspectionToolWrapper, (String)"inspectionToolWrapper");
        this.project = project;
        this.inspectionToolWrapper = inspectionToolWrapper;
        this.perFile = new ConcurrentHashMap();
        this.perModule = new ConcurrentHashMap();
        this.perProject = new AtomicInteger(0);
        this.maxPerFile = SanityInspectionGroupKt.access$inftyIfNotPositive(_maxPerFile);
        this.maxPerModule = SanityInspectionGroupKt.access$inftyIfNotPositive(_maxPerModule);
        this.maxPerProject = SanityInspectionGroupKt.access$inftyIfNotPositive(_maxPerProject);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final InspectionToolWrapper<?, ?> getInspectionToolWrapper() {
        return this.inspectionToolWrapper;
    }

    public final boolean addProblem(@Nullable String relativePath, @Nullable String module) {
        int currentPerModule;
        int currentPerFile;
        if (relativePath != null) {
            String string = module;
            if (string == null) {
                string = "";
            }
            Function2 function2 = ProblemCounters::addProblem$lambda$0;
            Integer n = this.perFile.compute(new FileAndModule(relativePath, string), new BiFunction(function2){
                private final /* synthetic */ Function2 function;
                {
                    Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                    this.function = function;
                }

                public final /* synthetic */ Object apply(Object p0, Object p1) {
                    return this.function.invoke(p0, p1);
                }
            });
            v2 = n != null ? n : -1;
        } else {
            v2 = currentPerFile = -1;
        }
        if (currentPerFile > this.maxPerFile) {
            return true;
        }
        if (module != null) {
            Function2 function2 = ProblemCounters::addProblem$lambda$1;
            Integer n = this.perModule.compute(module, new /* invalid duplicate definition of identical inner class */);
            v4 = n != null ? n : -1;
        } else {
            v4 = currentPerModule = -1;
        }
        if (currentPerModule > this.maxPerModule) {
            return true;
        }
        int currentPerProject = this.perProject.incrementAndGet();
        return currentPerFile >= this.maxPerFile || currentPerModule >= this.maxPerModule || currentPerProject >= this.maxPerProject;
    }

    public final boolean isThresholdReached(@Nullable String relativePath, @Nullable String module) {
        if (this.perProject.get() >= this.maxPerProject) {
            return true;
        }
        if (module != null) {
            Integer n = this.perModule.get(module);
            if ((n != null ? n : 0) >= this.maxPerModule) {
                return true;
            }
        }
        if (relativePath != null) {
            String string = module;
            if (string == null) {
                string = "";
            }
            Integer n = this.perFile.get(new FileAndModule(relativePath, string));
            if ((n != null ? n : 0) >= this.maxPerFile) {
                return true;
            }
        }
        return false;
    }

    public final boolean wasAnyModuleThresholdReached() {
        boolean bl;
        block3: {
            Map $this$any$iv = this.perModule;
            boolean $i$f$any = false;
            if ($this$any$iv.isEmpty()) {
                bl = false;
            } else {
                Iterator iterator = $this$any$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = iterator.next();
                    boolean bl2 = false;
                    if (!(((Number)it.getValue()).intValue() >= this.maxPerModule)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean wasProjectThresholdReached() {
        return this.perProject.get() >= this.maxPerProject;
    }

    private static final Integer addProblem$lambda$0(FileAndModule fileAndModule, Integer v) {
        Intrinsics.checkNotNullParameter((Object)fileAndModule, (String)"<unused var>");
        Integer n = v;
        return (n != null ? n : 0) + 1;
    }

    private static final Integer addProblem$lambda$1(String string, Integer v) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<unused var>");
        Integer n = v;
        return (n != null ? n : 0) + 1;
    }
}

