/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.runner;

import com.intellij.ide.plugins.IdeaPluginDependency;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import com.intellij.ide.plugins.ModuleDependenciesDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationStarter;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.extensions.PluginId;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaExcludedPluginsCalculatorKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\fH\u0002J\b\u0010\u0010\u001a\u00020\tH\u0002J.\u0010\u0011\u001a\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u000bH\u0002J2\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\u0016\u001a\u00020\u000e2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00132\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u0013H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaExcludedPluginsCalculator;", "Lcom/intellij/openapi/application/ApplicationStarter;", "<init>", "()V", "requiredModality", "", "getRequiredModality", "()I", "main", "", "args", "", "", "findDescriptor", "Lcom/intellij/ide/plugins/IdeaPluginDescriptor;", "id", "printHelpAndExit", "calculateActual", "Lkotlin/Pair;", "", "included", "processPlugin", "descriptor", "include", "processed", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaExcludedPluginsCalculator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaExcludedPluginsCalculator.kt\norg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaExcludedPluginsCalculator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,133:1\n1557#2:134\n1628#2,3:135\n1611#2,9:138\n1863#2:147\n1864#2:149\n1620#2:150\n1557#2:151\n1628#2,3:152\n1557#2:155\n1628#2,3:156\n1611#2,9:159\n1863#2:168\n1864#2:170\n1620#2:171\n1611#2,9:172\n1863#2:181\n1864#2:183\n1620#2:184\n1#3:148\n1#3:169\n1#3:182\n*S KotlinDebug\n*F\n+ 1 QodanaExcludedPluginsCalculator.kt\norg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaExcludedPluginsCalculator\n*L\n47#1:134\n47#1:135,3\n48#1:138,9\n48#1:147\n48#1:149\n48#1:150\n80#1:151\n80#1:152,3\n105#1:155\n105#1:156,3\n121#1:159,9\n121#1:168\n121#1:170\n121#1:171\n124#1:172,9\n124#1:181\n124#1:183\n124#1:184\n48#1:148\n121#1:169\n124#1:182\n*E\n"})
public final class QodanaExcludedPluginsCalculator
implements ApplicationStarter {
    public int getRequiredModality() {
        return 3;
    }

    /*
     * WARNING - void declaration
     */
    public void main(@NotNull List<String> args) {
        Intrinsics.checkNotNullParameter(args, (String)"args");
        if (args.size() < 3) {
            this.printHelpAndExit();
        }
        String input = args.get(1);
        String output = args.get(2);
        String disabledPluginsPath = args.size() == 4 ? args.get(3) : "";
        try {
            void $this$mapNotNullTo$iv$iv;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            List requiredIds = FilesKt.readLines$default((File)new File(input), null, (int)1, null);
            if (requiredIds.isEmpty()) {
                this.printHelpAndExit();
            }
            Pair<Set<IdeaPluginDescriptor>, List<String>> pair = this.calculateActual(requiredIds);
            Set included = (Set)pair.component1();
            List disabledIds = (List)pair.component2();
            Path dockerIgnorePath = Paths.get(output, new String[0]);
            Path baseFolder = dockerIgnorePath.getParent().toAbsolutePath();
            Iterable iterable = QodanaExcludedPluginsCalculatorKt.getKeptButDisabledPlugins();
            Set set = included;
            boolean $i$f$map = false;
            void var14_16 = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.findDescriptor((String)it));
            }
            Set keptPlugins = SetsKt.plus((Set)set, (Iterable)((List)destination$iv$iv));
            Iterable $this$mapNotNull$iv = keptPlugins;
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                IdeaPluginDescriptor it = (IdeaPluginDescriptor)element$iv$iv;
                boolean bl2 = false;
                String pathPresentation = ((Object)it.getPluginPath()).toString();
                Path path = Paths.get(pathPresentation, new String[0]).toAbsolutePath();
                Intrinsics.checkNotNull((Object)path);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if ((Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? "!" + baseFolder.relativize(path) : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List includedPaths = (List)destination$iv$iv2;
            File file = dockerIgnorePath.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"toFile(...)");
            FilesKt.appendText$default((File)file, (String)("\n" + CollectionsKt.joinToString$default((Iterable)includedPaths, (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null)), null, (int)2, null);
            if (((CharSequence)disabledPluginsPath).length() > 0) {
                Files.write(Paths.get(disabledPluginsPath, new String[0]), (Iterable<? extends CharSequence>)disabledIds, new OpenOption[0]);
            }
            ApplicationManagerEx.getApplicationEx().exit(true, true);
        }
        catch (Throwable e) {
            QodanaExcludedPluginsCalculatorKt.access$getLOG().error(e);
            System.exit(1);
            throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
        }
    }

    private final IdeaPluginDescriptor findDescriptor(String id) {
        PluginId pluginId = PluginId.findId((String)id);
        if (pluginId == null) {
            throw new IllegalArgumentException("Can't find plugin id '" + id + "'");
        }
        IdeaPluginDescriptor ideaPluginDescriptor = PluginManagerCore.getPlugin((PluginId)pluginId);
        if (ideaPluginDescriptor == null) {
            throw new IllegalArgumentException("Can't find plugin descriptor for id '" + id + "'");
        }
        return ideaPluginDescriptor;
    }

    private final void printHelpAndExit() {
        System.out.println((Object)"Expected parameters: <path to file with list of included plugins> <.dockerginore path> <disabled_plugins.txt path>");
        System.exit(1);
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }

    /*
     * WARNING - void declaration
     */
    private final Pair<Set<IdeaPluginDescriptor>, List<String>> calculateActual(List<String> included) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable;
        Object item$iv$iv2;
        void $this$mapTo$iv$iv2;
        List plugins = PluginManagerCore.getLoadedPlugins();
        Iterable $this$map$iv2 = plugins;
        boolean $i$f$map = false;
        Iterable iterable2 = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
            void it;
            IdeaPluginDescriptor ideaPluginDescriptor = (IdeaPluginDescriptor)item$iv$iv2;
            iterable = destination$iv$iv;
            boolean bl = false;
            iterable.add(it.getPluginId().getIdString());
        }
        List pluginIds = (List)destination$iv$iv;
        Set processed = new LinkedHashSet();
        LinkedList toProcess = new LinkedList(included);
        Set include = new LinkedHashSet();
        while (!((Collection)toProcess).isEmpty()) {
            String idString = (String)toProcess.pop();
            PluginId pluginId = PluginId.findId((String)idString);
            if (pluginId == null) {
                QodanaExcludedPluginsCalculatorKt.access$getLOG().error("Can't find plugin id '" + idString + "'");
                continue;
            }
            IdeaPluginDescriptor descriptor = PluginManagerCore.getPlugin((PluginId)pluginId);
            if (descriptor == null) {
                QodanaExcludedPluginsCalculatorKt.access$getLOG().error("Can't find plugin descriptor for id '" + idString + "'");
                continue;
            }
            CollectionsKt.addAll((Collection)toProcess, (Iterable)this.processPlugin(descriptor, include, processed));
        }
        System.out.println((Object)"=====INCLUDED=======");
        System.out.println((Object)CollectionsKt.joinToString$default((Iterable)include, (CharSequence)"\n", null, null, (int)0, null, QodanaExcludedPluginsCalculator::calculateActual$lambda$3, (int)30, null));
        Iterable pluginId = include;
        iterable = pluginIds;
        boolean $i$f$map2 = false;
        item$iv$iv2 = $this$map$iv;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv3 : $this$mapTo$iv$iv) {
            void it;
            IdeaPluginDescriptor ideaPluginDescriptor = (IdeaPluginDescriptor)item$iv$iv3;
            Collection collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(it.getPluginId().getIdString());
        }
        List disabled = CollectionsKt.minus((Iterable)iterable, (Iterable)CollectionsKt.toSet((Iterable)((List)destination$iv$iv2)));
        System.out.println((Object)"=====DISABLED=======");
        System.out.println((Object)CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)disabled), (CharSequence)"\n", null, null, (int)0, null, QodanaExcludedPluginsCalculator::calculateActual$lambda$5, (int)30, null));
        return TuplesKt.to((Object)include, (Object)disabled);
    }

    private final List<String> processPlugin(IdeaPluginDescriptor descriptor, Set<IdeaPluginDescriptor> include, Set<String> processed) {
        List list2;
        boolean bl;
        String it$iv$iv;
        boolean bl2;
        Object element$iv$iv;
        Object element$iv$iv$iv;
        Iterator iterator;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        boolean $i$f$mapNotNullTo;
        Collection destination$iv$iv;
        boolean $i$f$mapNotNull;
        Iterable $this$mapNotNull$iv;
        String string = descriptor.getPluginId().getIdString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getIdString(...)");
        String idString = string;
        if (processed.contains(idString)) {
            return CollectionsKt.emptyList();
        }
        processed.add(idString);
        include.add(descriptor);
        if (descriptor instanceof IdeaPluginDescriptorImpl) {
            $this$mapNotNull$iv = ((IdeaPluginDescriptorImpl)descriptor).dependencies.plugins;
            $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            destination$iv$iv = new ArrayList();
            $i$f$mapNotNullTo = false;
            $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            $i$f$forEach = false;
            iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                element$iv$iv = element$iv$iv$iv = iterator.next();
                bl2 = false;
                ModuleDependenciesDescriptor.PluginReference reference = (ModuleDependenciesDescriptor.PluginReference)element$iv$iv;
                boolean bl3 = false;
                if ((processed.contains(reference.id.getIdString()) ? null : reference.id.getIdString()) == null) continue;
                it$iv$iv = it$iv$iv;
                bl = false;
                destination$iv$iv.add(it$iv$iv);
            }
            list2 = (List)destination$iv$iv;
        } else {
            list2 = CollectionsKt.emptyList();
        }
        List required = list2;
        List list3 = descriptor.getDependencies();
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"getDependencies(...)");
        $this$mapNotNull$iv = list3;
        $i$f$mapNotNull = false;
        $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        $i$f$mapNotNullTo = false;
        $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        $i$f$forEach = false;
        iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            element$iv$iv = element$iv$iv$iv = iterator.next();
            bl2 = false;
            IdeaPluginDependency it = (IdeaPluginDependency)element$iv$iv;
            boolean bl4 = false;
            if ((processed.contains(it.getPluginId().getIdString()) || it.isOptional() ? null : it.getPluginId().getIdString()) == null) continue;
            it$iv$iv = it$iv$iv;
            bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.plus((Collection)((List)destination$iv$iv), (Iterable)required);
    }

    private static final CharSequence calculateActual$lambda$3(IdeaPluginDescriptor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getPluginId().getIdString() + " / " + it.getPluginPath();
    }

    private static final CharSequence calculateActual$lambda$5(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it;
    }
}

