/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.coverageData;

import com.intellij.codeInsight.actions.VcsFacadeImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.staticAnalysis.inspections.coverageData.CoverageData;
import org.jetbrains.qodana.staticAnalysis.inspections.coverageData.QodanaCoverageComputationState;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u001c\b\u0002\u0010\u0006\u001a\u0016\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0018\u00010\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0014\u0010\u001c\u001a\u0010\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\n\u0018\u00010\u0007J\"\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u00072\u0006\u0010\u0004\u001a\u00020\u0005H\u0002J\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020 J\u0006\u0010\"\u001a\u00020 J\u0006\u0010#\u001a\u00020 J\u0006\u0010$\u001a\u00020 J\u0006\u0010%\u001a\u00020 J\u0016\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010&\u001a\u00020\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u00078BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u001b\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006'"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/inspections/coverageData/CoverageStatisticsData;", "", "coverageComputationState", "Lorg/jetbrains/qodana/staticAnalysis/inspections/coverageData/QodanaCoverageComputationState;", "project", "Lcom/intellij/openapi/project/Project;", "changedRanges", "", "", "", "", "<init>", "(Lorg/jetbrains/qodana/staticAnalysis/inspections/coverageData/QodanaCoverageComputationState;Lcom/intellij/openapi/project/Project;Ljava/util/Map;)V", "getCoverageComputationState", "()Lorg/jetbrains/qodana/staticAnalysis/inspections/coverageData/QodanaCoverageComputationState;", "totalLines", "Ljava/util/concurrent/atomic/AtomicInteger;", "coveredLines", "freshLines", "freshCoveredLines", "reportTotalLines", "reportCoveredLines", "isIncremental", "", "getChangedRanges", "()Ljava/util/Map;", "changedRanges$delegate", "Lkotlin/Lazy;", "computeStat", "Lorg/jetbrains/qodana/staticAnalysis/inspections/coverageData/CoverageData;", "computeChangedRanges", "incrementTotalLines", "", "incrementCoveredLines", "incrementFreshLines", "incrementFreshCoveredLines", "incrementReportTotalLines", "incrementReportCoveredLines", "virtualFileUrl", "intellij.qodana"})
public final class CoverageStatisticsData {
    @NotNull
    private final QodanaCoverageComputationState coverageComputationState;
    @NotNull
    private final AtomicInteger totalLines;
    @NotNull
    private final AtomicInteger coveredLines;
    @NotNull
    private final AtomicInteger freshLines;
    @NotNull
    private final AtomicInteger freshCoveredLines;
    @NotNull
    private final AtomicInteger reportTotalLines;
    @NotNull
    private final AtomicInteger reportCoveredLines;
    private final boolean isIncremental;
    @NotNull
    private final Lazy changedRanges$delegate;

    public CoverageStatisticsData(@NotNull QodanaCoverageComputationState coverageComputationState, @NotNull Project project, @Nullable Map<String, ? extends Set<Integer>> changedRanges) {
        Intrinsics.checkNotNullParameter((Object)((Object)coverageComputationState), (String)"coverageComputationState");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.coverageComputationState = coverageComputationState;
        this.totalLines = new AtomicInteger();
        this.coveredLines = new AtomicInteger();
        this.freshLines = new AtomicInteger();
        this.freshCoveredLines = new AtomicInteger();
        this.reportTotalLines = new AtomicInteger();
        this.reportCoveredLines = new AtomicInteger();
        this.isIncremental = this.coverageComputationState.isIncrementalAnalysis();
        this.changedRanges$delegate = LazyKt.lazy(() -> CoverageStatisticsData.changedRanges_delegate$lambda$0(changedRanges, this, project));
    }

    public /* synthetic */ CoverageStatisticsData(QodanaCoverageComputationState qodanaCoverageComputationState, Project project, Map map2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            map2 = null;
        }
        this(qodanaCoverageComputationState, project, map2);
    }

    @NotNull
    public final QodanaCoverageComputationState getCoverageComputationState() {
        return this.coverageComputationState;
    }

    private final Map<String, Set<Integer>> getChangedRanges() {
        Lazy lazy = this.changedRanges$delegate;
        return (Map)lazy.getValue();
    }

    @Nullable
    public final Map<CoverageData, Integer> computeStat() {
        if (!this.isIncremental && this.totalLines.get() == 0 || this.isIncremental && this.reportTotalLines.get() == 0) {
            return null;
        }
        if (!this.isIncremental) {
            int totalCoverage = this.coveredLines.get() * 100 / this.totalLines.get();
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)CoverageData.TOTAL_COV), (Object)totalCoverage), TuplesKt.to((Object)((Object)CoverageData.TOTAL_LINES), (Object)this.totalLines.get()), TuplesKt.to((Object)((Object)CoverageData.TOTAL_COV_LINES), (Object)this.coveredLines.get())};
            return MapsKt.mapOf((Pair[])pairArray);
        }
        int reportTotalCoverage = this.reportCoveredLines.get() * 100 / this.reportTotalLines.get();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)CoverageData.TOTAL_COV), (Object)reportTotalCoverage), TuplesKt.to((Object)((Object)CoverageData.TOTAL_LINES), (Object)this.reportTotalLines.get()), TuplesKt.to((Object)((Object)CoverageData.TOTAL_COV_LINES), (Object)this.reportCoveredLines.get())};
        Map totalCovData = MapsKt.mapOf((Pair[])pairArray);
        int freshCodeCoverage = this.freshLines.get() != 0 ? this.freshCoveredLines.get() * 100 / this.freshLines.get() : 100;
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)((Object)CoverageData.FRESH_COV), (Object)freshCodeCoverage), TuplesKt.to((Object)((Object)CoverageData.FRESH_LINES), (Object)this.freshLines.get()), TuplesKt.to((Object)((Object)CoverageData.FRESH_COV_LINES), (Object)this.freshCoveredLines.get())};
        return MapsKt.plus((Map)totalCovData, (Map)MapsKt.mapOf((Pair[])pairArray2));
    }

    private final Map<String, Set<Integer>> computeChangedRanges(Project project) {
        Map changedLinesDataMap = new LinkedHashMap();
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
        ChangeListManager changeListManager2 = changeListManager;
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psiManager2 = psiManager;
        List changedFiles2 = (List)ReadAction.compute((ThrowableComputable)new ThrowableComputable(changeListManager2, psiManager2){
            final /* synthetic */ ChangeListManager $changeListManager;
            final /* synthetic */ PsiManager $psiManager;
            {
                this.$changeListManager = $changeListManager;
                this.$psiManager = $psiManager;
            }

            /*
             * WARNING - void declaration
             */
            public final List<PsiFile> compute() {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                void $this$filterTo$iv$iv;
                Collection collection = this.$changeListManager.getAllChanges();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAllChanges(...)");
                Iterable $this$filter$iv = collection;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    Change it = (Change)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getAfterRevision() != null && it.getVirtualFile() != null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                PsiManager psiManager = this.$psiManager;
                boolean $i$f$mapNotNull = false;
                destination$iv$iv = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    PsiFile it$iv$iv;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    Change it = (Change)element$iv$iv;
                    boolean bl2 = false;
                    VirtualFile virtualFile = it.getVirtualFile();
                    Intrinsics.checkNotNull((Object)virtualFile);
                    if (psiManager.findFile(virtualFile) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                return (List)destination$iv$iv2;
            }
        });
        for (PsiFile changedFile : changedFiles2) {
            ChangedRangesInfo ranges2;
            Set lines = new LinkedHashSet();
            if ((ChangedRangesInfo)ReadAction.compute((ThrowableComputable)new ThrowableComputable(changedFile){
                final /* synthetic */ PsiFile $changedFile;
                {
                    this.$changedFile = $changedFile;
                }

                public final ChangedRangesInfo compute() {
                    return VcsFacadeImpl.getInstance().getChangedRangesInfo(this.$changedFile);
                }
            }) == null || PsiDocumentManager.getInstance((Project)project).getDocument(changedFile) == null) continue;
            block1: for (TextRange range : ranges2.allChangedRanges) {
                int endLine;
                Document document;
                int startLine = document.getLineNumber(range.getStartOffset()) + 1;
                int line = startLine;
                if (line > (endLine = document.getLineNumber(range.getEndOffset()) + 1)) continue;
                while (true) {
                    lines.add(line);
                    if (line == endLine) continue block1;
                    ++line;
                }
            }
            changedLinesDataMap.put(changedFile.getVirtualFile().getUrl(), Collections.unmodifiableSet(lines));
        }
        Map<String, Set<Integer>> map2 = Collections.unmodifiableMap(changedLinesDataMap);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"unmodifiableMap(...)");
        return map2;
    }

    public final void incrementTotalLines() {
        this.totalLines.incrementAndGet();
    }

    public final void incrementCoveredLines() {
        this.coveredLines.incrementAndGet();
    }

    public final void incrementFreshLines() {
        this.freshLines.incrementAndGet();
    }

    public final void incrementFreshCoveredLines() {
        this.freshCoveredLines.incrementAndGet();
    }

    public final void incrementReportTotalLines() {
        this.reportTotalLines.incrementAndGet();
    }

    public final void incrementReportCoveredLines() {
        this.reportCoveredLines.incrementAndGet();
    }

    @Nullable
    public final Set<Integer> getChangedRanges(@NotNull String virtualFileUrl) {
        Intrinsics.checkNotNullParameter((Object)virtualFileUrl, (String)"virtualFileUrl");
        return this.getChangedRanges().getOrDefault(virtualFileUrl, null);
    }

    private static final Map changedRanges_delegate$lambda$0(Map $changedRanges, CoverageStatisticsData this$0, Project $project) {
        Map<String, Set<Integer>> map2 = $changedRanges;
        if (map2 == null) {
            map2 = this$0.computeChangedRanges($project);
        }
        return map2;
    }
}

