/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.coverage;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.report.XMLProjectData;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.qodana.staticAnalysis.inspections.coverageData.CoverageStatisticsData;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u001a\u0010\b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\t\u001a\u00020\n\u001a\u001a\u0010\u000b\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\n\u001a\"\u0010\f\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n\u001a$\u0010\u0011\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH\u0002\u001a\u0014\u0010\u0016\u001a\u00020\u0013*\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a\u0014\u0010\u0019\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a8\u0006\u001a"}, d2={"processReportClassData", "", "Lorg/jetbrains/qodana/staticAnalysis/inspections/coverageData/CoverageStatisticsData;", "data", "Lcom/intellij/rt/coverage/data/ClassData;", "processReportXmlData", "fileInfo", "Lcom/intellij/rt/coverage/report/XMLProjectData$FileInfo;", "loadClassData", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "loadXmlLineData", "loadMissingData", "document", "Lcom/intellij/openapi/editor/Document;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "incrementStats", "status", "", "lineNumber", "", "computeXmlLineStatus", "line", "Lcom/intellij/rt/coverage/report/XMLProjectData$LineInfo;", "incrementReportStats", "intellij.qodana.coverage"})
public final class CoverageStatisticsKt {
    public static final void processReportClassData(@NotNull CoverageStatisticsData $this$processReportClassData, @NotNull ClassData data) {
        Intrinsics.checkNotNullParameter((Object)$this$processReportClassData, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Iterator iterator = ArrayIteratorKt.iterator((Object[])data.getLines());
        while (iterator.hasNext()) {
            LineData lineData;
            Object line = iterator.next();
            if ((line instanceof LineData ? (LineData)line : null) == null) continue;
            lineData = lineData;
            CoverageStatisticsKt.incrementReportStats($this$processReportClassData, (byte)lineData.getStatus());
        }
    }

    public static final void processReportXmlData(@NotNull CoverageStatisticsData $this$processReportXmlData, @NotNull XMLProjectData.FileInfo fileInfo) {
        Intrinsics.checkNotNullParameter((Object)$this$processReportXmlData, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fileInfo, (String)"fileInfo");
        for (XMLProjectData.LineInfo line : fileInfo.lines) {
            Intrinsics.checkNotNull((Object)line);
            CoverageStatisticsKt.incrementReportStats($this$processReportXmlData, CoverageStatisticsKt.computeXmlLineStatus($this$processReportXmlData, line));
        }
    }

    public static final void loadClassData(@NotNull CoverageStatisticsData $this$loadClassData, @NotNull ClassData data, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)$this$loadClassData, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        Iterator iterator = ArrayIteratorKt.iterator((Object[])data.getLines());
        while (iterator.hasNext()) {
            LineData lineData;
            Object line = iterator.next();
            if ((line instanceof LineData ? (LineData)line : null) == null) continue;
            lineData = lineData;
            CoverageStatisticsKt.incrementStats($this$loadClassData, (byte)lineData.getStatus(), lineData.getLineNumber(), virtualFile);
        }
    }

    public static final void loadXmlLineData(@NotNull CoverageStatisticsData $this$loadXmlLineData, @NotNull XMLProjectData.FileInfo fileInfo, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)$this$loadXmlLineData, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)fileInfo, (String)"fileInfo");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        for (XMLProjectData.LineInfo line : fileInfo.lines) {
            Intrinsics.checkNotNull((Object)line);
            CoverageStatisticsKt.incrementStats($this$loadXmlLineData, CoverageStatisticsKt.computeXmlLineStatus($this$loadXmlLineData, line), line.lineNumber, virtualFile);
        }
    }

    public static final void loadMissingData(@NotNull CoverageStatisticsData $this$loadMissingData, @NotNull Document document, @NotNull TextRange textRange, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)$this$loadMissingData, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        int startOffset = textRange.getStartOffset();
        int endOffset = textRange.getEndOffset();
        int startLineNumber = document.getLineNumber(startOffset) + 1;
        int endLineNumber = document.getLineNumber(endOffset) + 1;
        int lineNumber = startLineNumber;
        if (lineNumber <= endLineNumber) {
            while (true) {
                $this$loadMissingData.incrementTotalLines();
                String string = virtualFile.getUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
                Set<Integer> changedInfo = $this$loadMissingData.getChangedRanges(string);
                if (changedInfo != null && changedInfo.contains(lineNumber)) {
                    $this$loadMissingData.incrementFreshLines();
                }
                if (lineNumber == endLineNumber) break;
                ++lineNumber;
            }
        }
    }

    private static final void incrementStats(CoverageStatisticsData $this$incrementStats, byte status2, int lineNumber, VirtualFile virtualFile) {
        boolean covered = status2 != 0;
        $this$incrementStats.incrementTotalLines();
        if (covered) {
            $this$incrementStats.incrementCoveredLines();
        }
        String string = virtualFile.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        Set<Integer> changedInfo = $this$incrementStats.getChangedRanges(string);
        if (changedInfo != null && changedInfo.contains(lineNumber)) {
            $this$incrementStats.incrementFreshLines();
            if (covered) {
                $this$incrementStats.incrementFreshCoveredLines();
            }
        }
    }

    private static final byte computeXmlLineStatus(CoverageStatisticsData $this$computeXmlLineStatus, XMLProjectData.LineInfo line) {
        int status2 = 0;
        if (line.missedBranches == 0 && line.missedInstructions == 0 && (line.coveredInstructions != 0 || line.coveredBranches != 0)) {
            status2 = 2;
        } else if (line.coveredBranches != 0 || line.coveredInstructions != 0) {
            status2 = 1;
        }
        return (byte)status2;
    }

    private static final void incrementReportStats(CoverageStatisticsData $this$incrementReportStats, byte status2) {
        boolean covered = status2 != 0;
        $this$incrementReportStats.incrementReportTotalLines();
        if (covered) {
            $this$incrementReportStats.incrementReportCoveredLines();
        }
    }
}

