/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.layout.counter;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.parser.CounterData;
import com.openhtmltopdf.css.style.CalculatedStyle;
import com.openhtmltopdf.layout.LayoutContext;
import com.openhtmltopdf.layout.counter.AbstractCounterContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CounterContext
implements AbstractCounterContext {
    private final Map<String, Integer> _counters = new HashMap<String, Integer>();
    private CounterContext _parent;

    public CounterContext(LayoutContext ctx2, CalculatedStyle style, Integer startIndex) {
        List<CounterData> increments;
        List<CounterData> resets;
        if (startIndex != null) {
            this._counters.put("list-item", startIndex);
        }
        this._parent = ctx2._counterContextMap.get(style.getParent());
        if (this._parent == null) {
            this._parent = new CounterContext();
        }
        if ((resets = style.getCounterReset()) != null) {
            resets.forEach(this._parent::resetCounter);
        }
        if ((increments = style.getCounterIncrement()) != null) {
            for (CounterData cd : increments) {
                if (this._parent.incrementCounter(cd)) continue;
                this._parent.resetCounter(new CounterData(cd.getName(), 0));
                this._parent.incrementCounter(cd);
            }
        }
        if (style.isIdent(CSSName.DISPLAY, IdentValue.LIST_ITEM)) {
            if (startIndex != null) {
                this._parent._counters.put("list-item", startIndex);
            }
            this._parent.incrementListItemCounter(1);
        }
    }

    private CounterContext() {
    }

    private boolean incrementCounter(CounterData cd) {
        if ("list-item".equals(cd.getName())) {
            this.incrementListItemCounter(cd.getValue());
            return true;
        }
        Integer currentValue = this._counters.get(cd.getName());
        if (currentValue == null) {
            if (this._parent == null) {
                return false;
            }
            return this._parent.incrementCounter(cd);
        }
        this._counters.put(cd.getName(), currentValue + cd.getValue());
        return true;
    }

    private void incrementListItemCounter(int increment) {
        Integer currentValue = this._counters.get("list-item");
        if (currentValue == null) {
            currentValue = 0;
        }
        this._counters.put("list-item", currentValue + increment);
    }

    private void resetCounter(CounterData cd) {
        this._counters.put(cd.getName(), cd.getValue());
    }

    @Override
    public int getCurrentCounterValue(String name) {
        Integer value2 = this._parent.getCounter(name);
        if (value2 == null) {
            this._parent.resetCounter(new CounterData(name, 0));
            return 0;
        }
        return value2;
    }

    private Integer getCounter(String name) {
        Integer value2 = this._counters.get(name);
        if (value2 != null) {
            return value2;
        }
        if (this._parent == null) {
            return null;
        }
        return this._parent.getCounter(name);
    }

    @Override
    public List<Integer> getCurrentCounterValues(String name) {
        ArrayList<Integer> values = new ArrayList<Integer>();
        this._parent.getCounterValues(name, values);
        if (values.size() == 0) {
            this._parent.resetCounter(new CounterData(name, 0));
            values.add(0);
        }
        return values;
    }

    private void getCounterValues(String name, List<Integer> values) {
        Integer value2;
        if (this._parent != null) {
            this._parent.getCounterValues(name, values);
        }
        if ((value2 = this._counters.get(name)) != null) {
            values.add(value2);
        }
    }
}

