import type {Connection, LanguageServerPlugin} from "@volar/language-server"
// @ts-ignore
import type {GetElementTypeArguments, GetSymbolTypeArguments, GetTypePropertiesArguments} from "tsc-ide-plugin/protocol"
import {getElementTypeVolarServer, getSymbolTypeVolarServer, getTypePropertiesVolarServer} from "./get-element-type-volar-server"

export function createIjServerPlugin(connection: Connection): LanguageServerPlugin {
  return (initOptions, modules) => {
    if (!modules.typescript) {
      console.warn('No typescript found, vue-language-server-ij will not work.');
      return {};
    }

    const ts = modules.typescript;

    return {
      onInitialized(getService, env) {
        connection.onRequest('$/ij/getElementType', async (params: GetElementTypeArguments) => {
          const languageService = await getService(params.file);
          if (languageService) {
            return getElementTypeVolarServer(ts, languageService.context, params.file, params);
          }
        });
        connection.onRequest('$/ij/getSymbolType', async (params: GetSymbolTypeArguments) => {
          const languageService = await getService(params.originalRequestUri);
          if (languageService) {
            return getSymbolTypeVolarServer(ts, languageService.context, params.originalRequestUri, params);
          }
        });
        connection.onRequest('$/ij/getTypeProperties', async (params: GetTypePropertiesArguments) => {
          const languageService = await getService(params.originalRequestUri);
          if (languageService) {
            return getTypePropertiesVolarServer(ts, languageService.context, params.originalRequestUri, params);
          }
        });
      },
    }
  }

}