/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.local;

import com.intellij.internal.statistic.local.EventCountRange;
import com.intellij.internal.statistic.local.EventGlobalStatistics;
import com.intellij.internal.statistic.local.GlobalSummaryManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0012\b&\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\u0018\u001a\u00020\u00072\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001b\u001a\u00020\u0003J\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u001b\u001a\u00020\u0003J\u001e\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e0\r2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0003H\u0002R\u001b\u0010\u0006\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e0\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0011\u0010\u000b\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0012\u001a\u00020\u00078FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u000b\u001a\u0004\b\u0013\u0010\tR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R'\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e0\r8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u000b\u001a\u0004\b\u0016\u0010\u0010\u00a8\u0006 "}, d2={"Lcom/intellij/internal/statistic/local/GlobalSummaryManager;", "", "statisticsFile", "", "updatedStatisticsFile", "(Ljava/lang/String;Ljava/lang/String;)V", "eventCountRange", "Lcom/intellij/internal/statistic/local/EventCountRange;", "getEventCountRange", "()Lcom/intellij/internal/statistic/local/EventCountRange;", "eventCountRange$delegate", "Lkotlin/Lazy;", "statisticsMap", "", "Lcom/intellij/internal/statistic/local/EventGlobalStatistics;", "getStatisticsMap", "()Ljava/util/Map;", "statisticsMap$delegate", "updatedEventCountRange", "getUpdatedEventCountRange", "updatedEventCountRange$delegate", "updatedStatisticsMap", "getUpdatedStatisticsMap", "updatedStatisticsMap$delegate", "calculateEventCountRange", "statistics", "getStatistics", "id", "getUpdatedStatistics", "loadStatistics", "filename", "Companion", "intellij.platform.statistics"})
@SourceDebugExtension(value={"SMAP\nGlobalSummaryManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GlobalSummaryManager.kt\ncom/intellij/internal/statistic/local/GlobalSummaryManager\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,121:1\n1313#2,2:122\n23#3:124\n*S KotlinDebug\n*F\n+ 1 GlobalSummaryManager.kt\ncom/intellij/internal/statistic/local/GlobalSummaryManager\n*L\n55#1:122,2\n66#1:124\n*E\n"})
public abstract class GlobalSummaryManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String statisticsFile;
    @Nullable
    private final String updatedStatisticsFile;
    @NotNull
    private final Lazy statisticsMap$delegate;
    @NotNull
    private final Lazy updatedStatisticsMap$delegate;
    @NotNull
    private final Lazy eventCountRange$delegate;
    @NotNull
    private final Lazy updatedEventCountRange$delegate;
    @NotNull
    private static final Function1<Character, Boolean> QUOTE_FILTER = Companion.QUOTE_FILTER.1.INSTANCE;
    @NotNull
    public static final String DEFAULT_SEPARATOR = ",";

    public GlobalSummaryManager(@NotNull String statisticsFile, @Nullable String updatedStatisticsFile) {
        Intrinsics.checkNotNullParameter((Object)statisticsFile, (String)"statisticsFile");
        this.statisticsFile = statisticsFile;
        this.updatedStatisticsFile = updatedStatisticsFile;
        this.statisticsMap$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<String, ? extends EventGlobalStatistics>>(this){
            final /* synthetic */ GlobalSummaryManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Map<String, EventGlobalStatistics> invoke() {
                return GlobalSummaryManager.access$loadStatistics(this.this$0, GlobalSummaryManager.access$getStatisticsFile$p(this.this$0));
            }
        }));
        this.updatedStatisticsMap$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Map<String, ? extends EventGlobalStatistics>>(this){
            final /* synthetic */ GlobalSummaryManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final Map<String, EventGlobalStatistics> invoke() {
                return GlobalSummaryManager.access$loadStatistics(this.this$0, GlobalSummaryManager.access$getUpdatedStatisticsFile$p(this.this$0));
            }
        }));
        this.eventCountRange$delegate = LazyKt.lazy((Function0)((Function0)new Function0<EventCountRange>(this){
            final /* synthetic */ GlobalSummaryManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EventCountRange invoke() {
                return GlobalSummaryManager.access$calculateEventCountRange(this.this$0, GlobalSummaryManager.access$getStatisticsMap(this.this$0));
            }
        }));
        this.updatedEventCountRange$delegate = LazyKt.lazy((Function0)((Function0)new Function0<EventCountRange>(this){
            final /* synthetic */ GlobalSummaryManager this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final EventCountRange invoke() {
                return GlobalSummaryManager.access$calculateEventCountRange(this.this$0, GlobalSummaryManager.access$getUpdatedStatisticsMap(this.this$0));
            }
        }));
    }

    public /* synthetic */ GlobalSummaryManager(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        this(string, string2);
    }

    @Nullable
    public final EventGlobalStatistics getStatistics(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.getStatisticsMap().get(id);
    }

    @Nullable
    public final EventGlobalStatistics getUpdatedStatistics(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.getUpdatedStatisticsMap().get(id);
    }

    private final Map<String, EventGlobalStatistics> getStatisticsMap() {
        Lazy lazy = this.statisticsMap$delegate;
        return (Map)lazy.getValue();
    }

    private final Map<String, EventGlobalStatistics> getUpdatedStatisticsMap() {
        Lazy lazy = this.updatedStatisticsMap$delegate;
        return (Map)lazy.getValue();
    }

    @NotNull
    public final EventCountRange getEventCountRange() {
        Lazy lazy = this.eventCountRange$delegate;
        return (EventCountRange)lazy.getValue();
    }

    @NotNull
    public final EventCountRange getUpdatedEventCountRange() {
        Lazy lazy = this.updatedEventCountRange$delegate;
        return (EventCountRange)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, EventGlobalStatistics> loadStatistics(String filename) {
        HashMap res;
        block9: {
            res = new HashMap();
            if (filename == null) {
                return res;
            }
            try {
                InputStream inputStream = this.getClass().getResourceAsStream(filename);
                if (inputStream == null) break block9;
                Closeable closeable = inputStream;
                Charset charset = StandardCharsets.UTF_8;
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                Object object = charset;
                Reader reader = new InputStreamReader((InputStream)closeable, (Charset)object);
                int n = 8192;
                closeable = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n);
                object = null;
                try {
                    BufferedReader reader2 = (BufferedReader)closeable;
                    boolean bl = false;
                    Sequence $this$forEach$iv = TextStreamsKt.lineSequence((BufferedReader)reader2);
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        String id;
                        String line = (String)element$iv;
                        boolean bl2 = false;
                        String[] stringArray = new String[]{DEFAULT_SEPARATOR};
                        List items = StringsKt.split$default((CharSequence)line, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                        Intrinsics.checkNotNullExpressionValue((Object)StringUtil.trim((String)((String)items.get(0)), arg_0 -> GlobalSummaryManager.loadStatistics$lambda$5$lambda$4$lambda$0(QUOTE_FILTER, arg_0)), (String)"trim(...)");
                        String string = StringUtil.trim((String)((String)items.get(3)), arg_0 -> GlobalSummaryManager.loadStatistics$lambda$5$lambda$4$lambda$1(QUOTE_FILTER, arg_0));
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"trim(...)");
                        long users = Long.parseLong(string);
                        String string2 = StringUtil.trim((String)((String)items.get(5)), arg_0 -> GlobalSummaryManager.loadStatistics$lambda$5$lambda$4$lambda$2(QUOTE_FILTER, arg_0));
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"trim(...)");
                        long allUsers = Long.parseLong(string2);
                        String string3 = StringUtil.trim((String)((String)items.get(4)), arg_0 -> GlobalSummaryManager.loadStatistics$lambda$5$lambda$4$lambda$3(QUOTE_FILTER, arg_0));
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"trim(...)");
                        long events = Long.parseLong(string3);
                        ((Map)res).put(id, new EventGlobalStatistics(users, allUsers, events));
                    }
                    reader = Unit.INSTANCE;
                }
                catch (Throwable throwable) {
                    object = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
                }
            }
            catch (IOException e) {
                GlobalSummaryManager $this$thisLogger$iv = this;
                boolean $i$f$thisLogger = false;
                Logger logger = Logger.getInstance(GlobalSummaryManager.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
                logger.error("Cannot parse statistics file", (Throwable)e);
            }
        }
        return res;
    }

    private final EventCountRange calculateEventCountRange(Map<String, EventGlobalStatistics> statistics) {
        long maxCount = 0L;
        long minCount = Long.MAX_VALUE;
        Iterator<Map.Entry<String, EventGlobalStatistics>> iterator = statistics.entrySet().iterator();
        while (iterator.hasNext()) {
            EventGlobalStatistics value = iterator.next().getValue();
            long frequency = value.getEventCount();
            maxCount = Math.max(frequency, maxCount);
            minCount = Math.min(frequency, minCount);
        }
        return new EventCountRange(maxCount, minCount);
    }

    private static final boolean loadStatistics$lambda$5$lambda$4$lambda$0(Function1 $tmp0, char p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke((Object)Character.valueOf(p0));
    }

    private static final boolean loadStatistics$lambda$5$lambda$4$lambda$1(Function1 $tmp0, char p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke((Object)Character.valueOf(p0));
    }

    private static final boolean loadStatistics$lambda$5$lambda$4$lambda$2(Function1 $tmp0, char p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke((Object)Character.valueOf(p0));
    }

    private static final boolean loadStatistics$lambda$5$lambda$4$lambda$3(Function1 $tmp0, char p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke((Object)Character.valueOf(p0));
    }

    public static final /* synthetic */ Map access$loadStatistics(GlobalSummaryManager $this, String filename) {
        return $this.loadStatistics(filename);
    }

    public static final /* synthetic */ String access$getStatisticsFile$p(GlobalSummaryManager $this) {
        return $this.statisticsFile;
    }

    public static final /* synthetic */ String access$getUpdatedStatisticsFile$p(GlobalSummaryManager $this) {
        return $this.updatedStatisticsFile;
    }

    public static final /* synthetic */ EventCountRange access$calculateEventCountRange(GlobalSummaryManager $this, Map statistics) {
        return $this.calculateEventCountRange(statistics);
    }

    public static final /* synthetic */ Map access$getStatisticsMap(GlobalSummaryManager $this) {
        return $this.getStatisticsMap();
    }

    public static final /* synthetic */ Map access$getUpdatedStatisticsMap(GlobalSummaryManager $this) {
        return $this.getUpdatedStatisticsMap();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\f\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/intellij/internal/statistic/local/GlobalSummaryManager$Companion;", "", "()V", "DEFAULT_SEPARATOR", "", "QUOTE_FILTER", "Lkotlin/Function1;", "", "", "intellij.platform.statistics"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

