/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clangFormat;

import com.intellij.application.options.CodeStyle;
import com.intellij.application.options.codeStyle.CodeStyleSchemesModel;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleScheme;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.modifier.TransientCodeStyleSettings;
import com.intellij.psi.impl.PsiManagerEx;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.jetbrains.cidr.lang.OCLanguageUtilsBase;
import com.jetbrains.cidr.lang.daemon.clang.format.ClangDaemonFormatProvider;
import com.jetbrains.cidr.lang.daemon.clang.format.ClangFormatChangeSettingsProvider;
import com.jetbrains.cidr.lang.daemon.clang.format.ClangFormatFileUtils;
import com.jetbrains.cidr.lang.ui.OCLongActionUtil;
import com.jetbrains.cidr.project.workspace.CidrWorkspace;
import com.jetbrains.clangFormat.components.ClangFormatModificationTracker;
import com.jetbrains.clangFormat.fus.ClangFormatUsageCollector;
import com.jetbrains.clangFormat.messages.ClangConfigBundle;
import com.jetbrains.clangFormat.messages.ClangFormatBundle;
import com.jetbrains.clangFormat.settings.ClangFormatSettings;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.yaml.YAMLFileType;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YamlRecursivePsiElementVisitor;

public final class ClangFormatUtils {
    private static final NotNullLazyKey<CachedValue<String>, PsiFile> CLANG_FORMAT_CONTENT = NotNullLazyKey.createLazyKey((String)"CLANG_FORMAT_CONTENT", source -> {
        Project project = source.getProject();
        return CachedValuesManager.getManager((Project)project).createCachedValue(() -> {
            VirtualFile vfCodeFile = source.getVirtualFile();
            ClangFormatChangeSettingsProvider provider = ClangFormatUtils.findApplicableClangFormatProvider(source);
            return CachedValueProvider.Result.create((Object)(provider == null ? "# Error: ClangFormat: Has no provider for " + vfCodeFile : (provider.isActive(source.getProject(), source.getFileType()) ? provider.findClangFormatContent(project, vfCodeFile) : "# Error: ClangFormat: Provider isn't active for " + vfCodeFile)), (Object[])new Object[]{ClangFormatModificationTracker.getInstance()});
        }, false);
    });
    private static boolean ourFindClangFormatProviderInTest = false;

    @NotNull
    public static String getContent(@NotNull PsiFile codeFile) {
        PsiFile file;
        if (codeFile == null) {
            ClangFormatUtils.$$$reportNull$$$0(0);
        }
        if ((file = ClangFormatUtils.getAnchorFile(codeFile)) != null) {
            String optionsOrErrorAsYAML = (String)((CachedValue)CLANG_FORMAT_CONTENT.getValue((UserDataHolder)file)).getValue();
            if (ClangDaemonFormatProvider.isClangdCommunicationError(optionsOrErrorAsYAML)) {
                file.putUserData(CLANG_FORMAT_CONTENT, null);
            }
            String string = optionsOrErrorAsYAML;
            if (string == null) {
                ClangFormatUtils.$$$reportNull$$$0(1);
            }
            return string;
        }
        VirtualFile vfClangFormat = ClangFormatUtils.getProjectClangFormatFile(codeFile.getProject());
        if (vfClangFormat != null) {
            String string;
            String sourceCommentWithNewLine = ClangDaemonFormatProvider.getCFSourceCommentLine(vfClangFormat);
            try {
                string = sourceCommentWithNewLine + VfsUtilCore.loadText((VirtualFile)vfClangFormat);
            }
            catch (IOException e) {
                String string2 = sourceCommentWithNewLine + ClangFormatFileUtils.getErrorStyleFor(e.getMessage());
                if (string2 == null) {
                    ClangFormatUtils.$$$reportNull$$$0(3);
                }
                return string2;
            }
            if (string == null) {
                ClangFormatUtils.$$$reportNull$$$0(2);
            }
            return string;
        }
        return "# The default implementation for the project without .clang-format\nBasedOnStyle: LLVM\n";
    }

    @Nullable
    public static VirtualFile getProjectClangFormatFile(@NotNull Project project) {
        VirtualFile contentRootDir;
        if (project == null) {
            ClangFormatUtils.$$$reportNull$$$0(4);
        }
        if ((contentRootDir = ClangFormatUtils.getClangFormatRootDir(project)) == null) {
            return null;
        }
        VirtualFile vfClangFormat = contentRootDir.findChild(".clang-format");
        if (vfClangFormat == null) {
            vfClangFormat = contentRootDir.findChild("_clang-format");
        }
        return vfClangFormat;
    }

    @Contract(pure=true)
    public static boolean isErrorContent(@NotNull String clangFormatConfigurationContentAsYaml) {
        if (clangFormatConfigurationContentAsYaml == null) {
            ClangFormatUtils.$$$reportNull$$$0(5);
        }
        return clangFormatConfigurationContentAsYaml.startsWith("# Error:");
    }

    @NotNull
    public static LightVirtualFile getActualClangFormatOptionsFile(@NotNull String clangFormatConfigurationContentAsYaml, @NotNull String clangFormatOptionsTitle) {
        if (clangFormatConfigurationContentAsYaml == null) {
            ClangFormatUtils.$$$reportNull$$$0(6);
        }
        if (clangFormatOptionsTitle == null) {
            ClangFormatUtils.$$$reportNull$$$0(7);
        }
        LightVirtualFile cfOptions = new LightVirtualFile(ClangConfigBundle.message((String)"cf.title.actual.clang.format", (Object[])new Object[]{clangFormatOptionsTitle}), (FileType)YAMLFileType.YML, (CharSequence)clangFormatConfigurationContentAsYaml);
        cfOptions.setWritable(false);
        LightVirtualFile lightVirtualFile = cfOptions;
        if (lightVirtualFile == null) {
            ClangFormatUtils.$$$reportNull$$$0(8);
        }
        return lightVirtualFile;
    }

    @Nullable
    public static ClangFormatChangeSettingsProvider findApplicableClangFormatProvider(@NotNull PsiFile source) {
        if (source == null) {
            ClangFormatUtils.$$$reportNull$$$0(9);
        }
        if (source.getProject().isDisposed() || ApplicationManager.getApplication().isUnitTestMode() && !ClangFormatUtils.canFindClangFormatProviderInTest()) {
            return null;
        }
        return ClangFormatChangeSettingsProvider.findApplicableFormatProvider(source.getProject(), source.getFileType());
    }

    @Nullable
    public static ClangFormatChangeSettingsProvider findActiveClangFormatProvider(@NotNull PsiFile source) {
        ClangFormatChangeSettingsProvider provider;
        if (source == null) {
            ClangFormatUtils.$$$reportNull$$$0(10);
        }
        return (provider = ClangFormatUtils.findApplicableClangFormatProvider(source)) != null && provider.isActive(source.getProject(), source.getFileType()) ? provider : null;
    }

    @Contract(pure=true)
    private static boolean canFindClangFormatProviderInTest() {
        return ourFindClangFormatProviderInTest;
    }

    @TestOnly
    public static void setFindClangFormatProviderInTest(boolean canFind) {
        ourFindClangFormatProviderInTest = canFind;
    }

    public static void fireClangFormatChanged(@NotNull Project project) {
        if (project == null) {
            ClangFormatUtils.$$$reportNull$$$0(11);
        }
        ThreadingAssertions.assertEventDispatchThread();
        ClangFormatModificationTracker.getInstance().incModificationCount();
        ClangFormatChangeSettingsProvider.syncCurrentClangFormatSettings(project, CodeStyle.getSettings((Project)project), true);
        CodeStyleSettingsManager.getInstance((Project)project).notifyCodeStyleSettingsChanged();
    }

    public static boolean applySettings(@NotNull ClangFormatChangeSettingsProvider changeSettingsProvider, @NotNull TransientCodeStyleSettings settings, @NotNull PsiFile codeFile, @NotNull String clangFormatConfigurationContentAsYaml, @NotNull String fileName) {
        if (changeSettingsProvider == null) {
            ClangFormatUtils.$$$reportNull$$$0(12);
        }
        if (settings == null) {
            ClangFormatUtils.$$$reportNull$$$0(13);
        }
        if (codeFile == null) {
            ClangFormatUtils.$$$reportNull$$$0(14);
        }
        if (clangFormatConfigurationContentAsYaml == null) {
            ClangFormatUtils.$$$reportNull$$$0(15);
        }
        if (fileName == null) {
            ClangFormatUtils.$$$reportNull$$$0(16);
        }
        PsiFile clangFormat = ((PsiManagerEx)codeFile.getManager()).getFileManager().findFile((VirtualFile)ClangFormatUtils.getActualClangFormatOptionsFile(clangFormatConfigurationContentAsYaml, fileName));
        boolean isModified = false;
        if (clangFormat != null) {
            VirtualFile vfClangFormatMaybeWrong;
            ClangFormatSettings cf = (ClangFormatSettings)settings.getCustomSettings(ClangFormatSettings.class);
            ClangFormatUsageCollector.clangFormatActionWithCF.log(codeFile.getProject(), (Object)cf.ENABLED);
            if (cf.ENABLED) {
                final HashMap<String, Object> map = new HashMap<String, Object>();
                clangFormat.accept((PsiElementVisitor)new YamlRecursivePsiElementVisitor(){

                    public void visitKeyValue(@NotNull YAMLKeyValue keyValue) {
                        if (keyValue == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        map.put(keyValue.getKeyText(), keyValue.getValueText());
                        super.visitKeyValue(keyValue);
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyValue", "com/jetbrains/clangFormat/ClangFormatUtils$1", "visitKeyValue"));
                    }
                });
                isModified |= changeSettingsProvider.applyCollectedSettings(settings, codeFile, map);
            }
            if ((vfClangFormatMaybeWrong = changeSettingsProvider.extractClangFormatFile(clangFormatConfigurationContentAsYaml)) != null) {
                String clangFormatFileURL = ClangFormatFileUtils.getClangFormatFileURL(vfClangFormatMaybeWrong);
                isModified |= cf.SOURCE_URL.equals(clangFormatFileURL);
                cf.SOURCE_URL = clangFormatFileURL;
            }
        }
        return isModified;
    }

    public static boolean setClangFormatEnabled(@NotNull Project project, boolean clangFormatOn, boolean perProject) {
        if (project == null) {
            ClangFormatUtils.$$$reportNull$$$0(17);
        }
        CodeStyleSettings settings = CodeStyle.getSettings((Project)project);
        ClangFormatSettings cfSettings = (ClangFormatSettings)settings.getCustomSettings(ClangFormatSettings.class);
        if (cfSettings.ENABLED != clangFormatOn) {
            if (clangFormatOn && !ApplicationManager.getApplication().isHeadlessEnvironment() && !project.isDefault() && ClangFormatUtils.activeFileIsValidAndDoesntHaveClangFormatConfig(project)) {
                AtomicBoolean fileCreationIsCancelled = new AtomicBoolean(false);
                ApplicationManager.getApplication().invokeAndWait(() -> {
                    int dialogResult = MessageDialogBuilder.yesNoCancel((String)ClangFormatBundle.message("cf.create.cf.file.title", new Object[0]), (String)ClangFormatBundle.message("cf.create.cf.file.message", new Object[0])).show(project);
                    if (dialogResult == 2) {
                        fileCreationIsCancelled.set(true);
                        return;
                    }
                    if (dialogResult == 0) {
                        ClangFormatUtils.exportSettingsToClangFormatFileAndUpdateSettingsFromIt(project);
                    }
                });
                if (fileCreationIsCancelled.get()) {
                    return false;
                }
            }
            if (perProject && ClangFormatUtils.switchToProjectSchemeIfNeeded(project)) {
                settings = CodeStyle.getSettings((Project)project);
                cfSettings = (ClangFormatSettings)settings.getCustomSettings(ClangFormatSettings.class);
            }
            cfSettings.ENABLED = clangFormatOn;
            ClangFormatUtils.fireClangFormatChanged(project);
            ApplicationManager.getApplication().invokeLater(() -> ClangFormatUtils.fireClangFormatChanged(project), project.getDisposed());
        }
        return true;
    }

    public static boolean switchToProjectSchemeIfNeeded(@NotNull Project project) {
        CodeStyleScheme scheme;
        CodeStyleSchemesModel codeStyleSchemesModel;
        if (project == null) {
            ClangFormatUtils.$$$reportNull$$$0(18);
        }
        if (!(codeStyleSchemesModel = new CodeStyleSchemesModel(project)).isProjectScheme(scheme = codeStyleSchemesModel.getSelectedScheme())) {
            codeStyleSchemesModel.copyToProject(scheme);
            codeStyleSchemesModel.apply();
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiFile getAnchorFile(@NotNull PsiFile codeFile) {
        PsiFile containerFile;
        PsiElement context;
        if (codeFile == null) {
            ClangFormatUtils.$$$reportNull$$$0(19);
        }
        if ((context = codeFile.getContext()) != null && (containerFile = context.getContainingFile()) != null && containerFile != codeFile && containerFile.getFileType() == codeFile.getFileType()) {
            return ClangFormatUtils.getAnchorFile(containerFile);
        }
        VirtualFile vf = codeFile.getViewProvider().getVirtualFile();
        return vf.isInLocalFileSystem() && !ScratchUtil.isScratch((VirtualFile)vf) ? codeFile : null;
    }

    @Nullable
    public static VirtualFile getClangFormatRootDir(@NotNull Project project) {
        VirtualFile contentRoot;
        List workspaces;
        if (project == null) {
            ClangFormatUtils.$$$reportNull$$$0(20);
        }
        if (!(workspaces = CidrWorkspace.getInitializedWorkspaces((Project)project)).isEmpty() && (contentRoot = ((CidrWorkspace)workspaces.get(0)).getEffectiveContentRoot()) != null) {
            return contentRoot;
        }
        String projectPath = project.getBasePath();
        if (projectPath != null) {
            return LocalFileSystem.getInstance().findFileByPath(projectPath);
        }
        return null;
    }

    public static boolean exportSettingsToClangFormatFileAndUpdateSettingsFromIt(@NotNull Project project) {
        VirtualFile contentRootDir;
        if (project == null) {
            ClangFormatUtils.$$$reportNull$$$0(21);
        }
        return (contentRootDir = ClangFormatUtils.getClangFormatRootDir(project)) != null && ClangFormatUtils.exportSettingsToClangFormatFileInDirectoryAndUpdateSettingsFromIt(project, contentRootDir);
    }

    public static boolean exportSettingsToClangFormatFileInDirectoryAndUpdateSettingsFromIt(@NotNull Project project, @NotNull VirtualFile containerDirForClangFormatFile) {
        if (project == null) {
            ClangFormatUtils.$$$reportNull$$$0(22);
        }
        if (containerDirForClangFormatFile == null) {
            ClangFormatUtils.$$$reportNull$$$0(23);
        }
        if (ClangFormatFileUtils.exportSettingsToClangFormatFileInDirectory(project, containerDirForClangFormatFile)) {
            ClangFormatUtils.fireClangFormatChanged(project);
            return true;
        }
        return false;
    }

    @Nullable
    public static VirtualFile getDirectoryForCreationOfClangFormatFileIfPossible(@NotNull Project project, @NotNull VirtualFile vfFileOrDir) {
        VirtualFile contentRootDir;
        if (project == null) {
            ClangFormatUtils.$$$reportNull$$$0(24);
        }
        if (vfFileOrDir == null) {
            ClangFormatUtils.$$$reportNull$$$0(25);
        }
        if ((contentRootDir = ClangFormatUtils.getClangFormatRootDir(project)) != null && ProjectScope.getProjectScope((Project)project).contains(vfFileOrDir)) {
            return VfsUtilCore.getCommonAncestor((VirtualFile)vfFileOrDir, (VirtualFile)contentRootDir);
        }
        return null;
    }

    public static boolean activeFileIsValidAndDoesntHaveClangFormatConfig(@NotNull Project project) {
        FileEditor fileEditor;
        if (project == null) {
            ClangFormatUtils.$$$reportNull$$$0(26);
        }
        if ((fileEditor = FileEditorManager.getInstance((Project)project).getSelectedEditor()) == null) {
            return false;
        }
        VirtualFile virtualFile = fileEditor.getFile();
        if (virtualFile == null || ClangFormatUtils.getDirectoryForCreationOfClangFormatFileIfPossible(project, virtualFile) == null) {
            return false;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(virtualFile);
        if (psiFile == null || !OCLanguageUtilsBase.isSupported((PsiFile)psiFile)) {
            return false;
        }
        return OCLongActionUtil.execWithTimeoutProgressInDispatchOrEmptyProgressInBg((String)ClangFormatBundle.message("progressbar.long.clang.settings", new Object[0]), (Project)project, () -> ClangFormatUtils.getContent(psiFile).contains("clang-format-file://")) == Boolean.FALSE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeFile";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/clangFormat/ClangFormatUtils";
                break;
            }
            case 4: 
            case 11: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 6: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangFormatConfigurationContentAsYaml";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangFormatOptionsTitle";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeSettingsProvider";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "containerDirForClangFormatFile";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vfFileOrDir";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/clangFormat/ClangFormatUtils";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getContent";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualClangFormatOptionsFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContent";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 8: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getProjectClangFormatFile";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isErrorContent";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getActualClangFormatOptionsFile";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findApplicableClangFormatProvider";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findActiveClangFormatProvider";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fireClangFormatChanged";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "applySettings";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "setClangFormatEnabled";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "switchToProjectSchemeIfNeeded";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getAnchorFile";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getClangFormatRootDir";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "exportSettingsToClangFormatFileAndUpdateSettingsFromIt";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "exportSettingsToClangFormatFileInDirectoryAndUpdateSettingsFromIt";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getDirectoryForCreationOfClangFormatFileIfPossible";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "activeFileIsValidAndDoesntHaveClangFormatConfig";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 8 -> new IllegalStateException(string);
        };
    }
}

