/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang.format;

import com.intellij.application.options.CodeStyle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AppUIExecutor;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VirtualFileImpl;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.modifier.TransientCodeStyleSettings;
import com.intellij.util.ExceptionUtil;
import com.jetbrains.cidr.lang.daemon.ClangdBundle;
import com.jetbrains.cidr.lang.daemon.clang.format.ClangFormatChangeSettingsProvider;
import com.jetbrains.cidr.lang.daemon.clang.format.ClangFormatLog;
import com.jetbrains.cidr.project.CidrProjectWizardUtil;
import com.jetbrains.clangFormat.fus.ClangFormatUsageCollector;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClangFormatFileUtils {
    @NonNls
    public static final String CLANG_FORMAT_ID = "ClangFormat";
    @NonNls
    public static final String CLANG_FORMAT_FILE_PREFIX = "clang-format-file://";
    @NonNls
    public static final String CLANG_FORMAT_SETTINGS_ID = "clangFormatSettings";
    @NonNls
    public static final String CLANG_FORMAT1 = ".clang-format";
    @NonNls
    public static final String CLANG_FORMAT2 = "_clang-format";
    @NonNls
    public static final String CLANG_FORMAT_DEFAULT = "# The default implementation for the project without .clang-format\nBasedOnStyle: LLVM\n";
    @NonNls
    private static final String ourErrorPrefix = "# Error: ";
    @NonNls
    private static final String ourErrorSuffix = "";

    @Contract(pure=true)
    public static boolean isFileBasedClangFormatURL(@NotNull String url) {
        if (url == null) {
            ClangFormatFileUtils.$$$reportNull$$$0(0);
        }
        return url.startsWith(CLANG_FORMAT_FILE_PREFIX);
    }

    @Nullable
    public static VirtualFile getClangFormatFile(@NotNull String clangFormatURL, boolean refreshVFSIfNeeded) {
        if (clangFormatURL == null) {
            ClangFormatFileUtils.$$$reportNull$$$0(1);
        }
        String path = ClangFormatFileUtils.getClangFormatPathFromURL(clangFormatURL);
        try {
            return path == null ? null : VfsUtil.findFile((Path)Paths.get(path, new String[0]), (boolean)refreshVFSIfNeeded);
        }
        catch (Throwable e) {
            ClangFormatLog.LOG.warn(e);
            return null;
        }
    }

    public static CommonCodeStyleSettings.IndentOptions getOverriddenIndentOptions(@NotNull TransientCodeStyleSettings transientSettings) {
        PsiFile codeFile;
        if (transientSettings == null) {
            ClangFormatFileUtils.$$$reportNull$$$0(2);
        }
        if ((codeFile = transientSettings.getPsiFile()) == null) {
            return CommonCodeStyleSettings.IndentOptions.DEFAULT_INDENT_OPTIONS;
        }
        Application application = ApplicationManager.getApplication();
        if (application.isDispatchThread()) {
            if (application.isWriteAccessAllowed()) {
                ClangFormatFileUtils.saveAllClangFormatDocuments();
            } else {
                ((AppUIExecutor)AppUIExecutor.onWriteThread().later().expireWith((Disposable)codeFile.getProject())).submit(() -> ClangFormatFileUtils.saveAllClangFormatDocuments());
            }
        }
        return transientSettings.getLanguageIndentOptions(codeFile.getLanguage());
    }

    public static void saveAllClangFormatDocuments() {
        Document[] unsavedDocuments;
        Application application = ApplicationManager.getApplication();
        if (!application.isDispatchThread()) {
            application.assertReadAccessAllowed();
            return;
        }
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        for (Document document : unsavedDocuments = fileDocumentManager.getUnsavedDocuments()) {
            VirtualFile file = fileDocumentManager.getFile(document);
            if (file == null || !ClangFormatFileUtils.isClangFormatConfig(file)) continue;
            fileDocumentManager.saveDocument(document);
        }
    }

    public static boolean isClangFormatConfig(@NotNull VirtualFile file) {
        if (file == null) {
            ClangFormatFileUtils.$$$reportNull$$$0(3);
        }
        return ClangFormatFileUtils.isClangFormatName(file.getName());
    }

    public static boolean isClangFormatName(String name) {
        return CLANG_FORMAT1.equals(name) || CLANG_FORMAT2.equals(name);
    }

    @Nullable
    public static String getClangFormatPathFromURL(@NotNull String clangFormatURL) {
        if (clangFormatURL == null) {
            ClangFormatFileUtils.$$$reportNull$$$0(4);
        }
        if (!ClangFormatFileUtils.isFileBasedClangFormatURL(clangFormatURL)) {
            return null;
        }
        return clangFormatURL.substring(CLANG_FORMAT_FILE_PREFIX.length());
    }

    @NotNull
    public static String getClangFormatFileURL(@NotNull VirtualFile clangFormat) {
        if (clangFormat == null) {
            ClangFormatFileUtils.$$$reportNull$$$0(5);
        }
        String string = CLANG_FORMAT_FILE_PREFIX + clangFormat.getCanonicalPath();
        if (string == null) {
            ClangFormatFileUtils.$$$reportNull$$$0(6);
        }
        return string;
    }

    public static boolean exportSettingsToClangFormatFileInDirectory(@NotNull Project project, @NotNull VirtualFile directory) {
        if (project == null) {
            ClangFormatFileUtils.$$$reportNull$$$0(7);
        }
        if (directory == null) {
            ClangFormatFileUtils.$$$reportNull$$$0(8);
        }
        assert (directory.isDirectory());
        try {
            ClangFormatUsageCollector.clangFormatFileCreated.log(project);
            WriteCommandAction.writeCommandAction((Project)project).withName(ClangdBundle.message((String)"cf.create.cf.file.action.name", (Object[])new Object[0])).withUndoConfirmationPolicy(UndoConfirmationPolicy.REQUEST_CONFIRMATION).run(() -> {
                if (ClangFormatFileUtils.hasClangFormatFileInDirectory(directory, CLANG_FORMAT1)) {
                    throw new FileAlreadyExistsException(CLANG_FORMAT1);
                }
                VirtualFile vfClangFormat = directory.createChildData((Object)project, CLANG_FORMAT1);
                vfClangFormat.setCharset(StandardCharsets.UTF_8);
                VfsUtil.saveText((VirtualFile)vfClangFormat, (String)ClangFormatChangeSettingsProvider.convertCurrentCodeStyleToClangFormat(project, CodeStyle.getSettings((Project)project)));
                if (!ApplicationManager.getApplication().isUnitTestMode() && CidrProjectWizardUtil.NEW_PROJECT_GENERATION_IN_PROGRESS.get((UserDataHolder)project) == null) {
                    ApplicationManager.getApplication().invokeLater(() -> FileEditorManager.getInstance((Project)project).openFile(vfClangFormat, true), project.getDisposed());
                }
            });
        }
        catch (FileAlreadyExistsException e) {
            return false;
        }
        catch (Throwable e) {
            if (e.getCause() instanceof FileAlreadyExistsException) {
                return false;
            }
            ExceptionUtil.rethrow((Throwable)e);
        }
        return true;
    }

    public static boolean hasClangFormatFileInDirectory(@NotNull VirtualFile directory, @NonNls @NotNull String cfName) {
        VirtualFile vfClangFormat;
        if (directory == null) {
            ClangFormatFileUtils.$$$reportNull$$$0(9);
        }
        if (cfName == null) {
            ClangFormatFileUtils.$$$reportNull$$$0(10);
        }
        if ((vfClangFormat = directory.findChild(cfName)) instanceof VirtualFileImpl && ((VirtualFileImpl)vfClangFormat).isDirty()) {
            vfClangFormat.refresh(false, false);
            vfClangFormat = directory.findChild(cfName);
        }
        return vfClangFormat != null;
    }

    @NotNull
    public static String getErrorStyleFor(@NotNull String message) {
        if (message == null) {
            ClangFormatFileUtils.$$$reportNull$$$0(11);
        }
        String string = ourErrorPrefix + message + "\n";
        if (string == null) {
            ClangFormatFileUtils.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nullable
    public static String getErrorMessageFromYAMLine(@NotNull String lineWithError) {
        if (lineWithError == null) {
            ClangFormatFileUtils.$$$reportNull$$$0(13);
        }
        return ClangFormatFileUtils.extractSubstringBetweenPrefixAndSuffix(lineWithError, ourErrorPrefix, ourErrorSuffix);
    }

    @Nullable
    private static String extractSubstringBetweenPrefixAndSuffix(@NotNull String string, @NotNull String prefix, @NotNull String suffix) {
        if (string == null) {
            ClangFormatFileUtils.$$$reportNull$$$0(14);
        }
        if (prefix == null) {
            ClangFormatFileUtils.$$$reportNull$$$0(15);
        }
        if (suffix == null) {
            ClangFormatFileUtils.$$$reportNull$$$0(16);
        }
        if (string.length() >= prefix.length() + suffix.length() && string.startsWith(prefix) && string.endsWith(suffix)) {
            return string.substring(prefix.length(), string.length() - suffix.length());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangFormatURL";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transientSettings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clangFormat";
                break;
            }
            case 6: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/daemon/clang/format/ClangFormatFileUtils";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cfName";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineWithError";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/format/ClangFormatFileUtils";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getClangFormatFileURL";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorStyleFor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isFileBasedClangFormatURL";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getClangFormatFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getOverriddenIndentOptions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isClangFormatConfig";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getClangFormatPathFromURL";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getClangFormatFileURL";
                break;
            }
            case 6: 
            case 12: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "exportSettingsToClangFormatFileInDirectory";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasClangFormatFileInDirectory";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getErrorStyleFor";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessageFromYAMLine";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "extractSubstringBetweenPrefixAndSuffix";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 12 -> new IllegalStateException(string);
        };
    }
}

