/*
 * Decompiled with CFR 0.152.
 */
package reactor.core.publisher;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import reactor.core.CoreSubscriber;
import reactor.core.Fuseable;
import reactor.core.Scannable;
import reactor.core.publisher.InternalMonoOperator;
import reactor.core.publisher.Mono;
import reactor.core.publisher.MonoNameFuseable;
import reactor.util.annotation.Nullable;
import reactor.util.function.Tuple2;
import reactor.util.function.Tuples;

final class MonoName<T>
extends InternalMonoOperator<T, T> {
    final String name;
    final List<Tuple2<String, String>> tagsWithDuplicates;

    static <T> Mono<T> createOrAppend(Mono<T> source, String name) {
        Objects.requireNonNull(name, "name");
        if (source instanceof MonoName) {
            MonoName s = (MonoName)source;
            return new MonoName<T>(s.source, name, s.tagsWithDuplicates);
        }
        if (source instanceof MonoNameFuseable) {
            MonoNameFuseable s = (MonoNameFuseable)source;
            return new MonoNameFuseable(s.source, name, s.tagsWithDuplicates);
        }
        if (source instanceof Fuseable) {
            return new MonoNameFuseable<T>(source, name, null);
        }
        return new MonoName<T>(source, name, null);
    }

    static <T> Mono<T> createOrAppend(Mono<T> source, String tagName, String tagValue) {
        Objects.requireNonNull(tagName, "tagName");
        Objects.requireNonNull(tagValue, "tagValue");
        Tuple2<String, String> newTag = Tuples.of(tagName, tagValue);
        if (source instanceof MonoName) {
            List<Tuple2<String, String>> tags;
            MonoName s = (MonoName)source;
            if (s.tagsWithDuplicates != null) {
                tags = new LinkedList<Tuple2<String, String>>(s.tagsWithDuplicates);
                tags.add(newTag);
            } else {
                tags = Collections.singletonList(newTag);
            }
            return new MonoName<T>(s.source, s.name, tags);
        }
        if (source instanceof MonoNameFuseable) {
            List<Tuple2<String, String>> tags;
            MonoNameFuseable s = (MonoNameFuseable)source;
            if (s.tagsWithDuplicates != null) {
                tags = new LinkedList<Tuple2<String, String>>(s.tagsWithDuplicates);
                tags.add(newTag);
            } else {
                tags = Collections.singletonList(newTag);
            }
            return new MonoNameFuseable(s.source, s.name, tags);
        }
        if (source instanceof Fuseable) {
            return new MonoNameFuseable<T>(source, null, Collections.singletonList(newTag));
        }
        return new MonoName<T>(source, null, Collections.singletonList(newTag));
    }

    MonoName(Mono<? extends T> source, @Nullable String name, @Nullable List<Tuple2<String, String>> tags) {
        super(source);
        this.name = name;
        this.tagsWithDuplicates = tags;
    }

    @Override
    public CoreSubscriber<? super T> subscribeOrReturn(CoreSubscriber<? super T> actual) {
        return actual;
    }

    @Override
    @Nullable
    public Object scanUnsafe(Scannable.Attr key2) {
        if (key2 == Scannable.Attr.NAME) {
            return this.name;
        }
        if (key2 == Scannable.Attr.TAGS && this.tagsWithDuplicates != null) {
            return this.tagsWithDuplicates.stream();
        }
        if (key2 == Scannable.Attr.RUN_STYLE) {
            return Scannable.Attr.RunStyle.SYNC;
        }
        return super.scanUnsafe(key2);
    }
}

