/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.handler.codec.Headers;
import io.netty.util.AsciiString;
import java.util.Iterator;
import java.util.Map;

public interface Http2Headers
extends Headers<CharSequence, CharSequence, Http2Headers> {
    public Iterator<Map.Entry<CharSequence, CharSequence>> iterator();

    public Iterator<CharSequence> valueIterator(CharSequence var1);

    public Http2Headers method(CharSequence var1);

    public Http2Headers scheme(CharSequence var1);

    public Http2Headers authority(CharSequence var1);

    public Http2Headers path(CharSequence var1);

    public Http2Headers status(CharSequence var1);

    public CharSequence method();

    public CharSequence scheme();

    public CharSequence authority();

    public CharSequence path();

    public CharSequence status();

    public boolean contains(CharSequence var1, CharSequence var2, boolean var3);

    public static enum PseudoHeaderName {
        METHOD(":method", true),
        SCHEME(":scheme", true),
        AUTHORITY(":authority", true),
        PATH(":path", true),
        STATUS(":status", false),
        PROTOCOL(":protocol", true);

        private static final char PSEUDO_HEADER_PREFIX = ':';
        private static final byte PSEUDO_HEADER_PREFIX_BYTE = 58;
        private final AsciiString value;
        private final boolean requestOnly;

        private PseudoHeaderName(String value2, boolean requestOnly) {
            this.value = AsciiString.cached((String)value2);
            this.requestOnly = requestOnly;
        }

        public AsciiString value() {
            return this.value;
        }

        public static boolean hasPseudoHeaderFormat(CharSequence headerName) {
            if (headerName instanceof AsciiString) {
                AsciiString asciiHeaderName = (AsciiString)headerName;
                return asciiHeaderName.length() > 0 && asciiHeaderName.byteAt(0) == 58;
            }
            return headerName.length() > 0 && headerName.charAt(0) == ':';
        }

        public static boolean isPseudoHeader(CharSequence header2) {
            return PseudoHeaderName.getPseudoHeader(header2) != null;
        }

        public static boolean isPseudoHeader(AsciiString header2) {
            return PseudoHeaderName.getPseudoHeader(header2) != null;
        }

        public static boolean isPseudoHeader(String header2) {
            return PseudoHeaderName.getPseudoHeader(header2) != null;
        }

        public static PseudoHeaderName getPseudoHeader(CharSequence header2) {
            if (header2 instanceof AsciiString) {
                return PseudoHeaderName.getPseudoHeader((AsciiString)header2);
            }
            return PseudoHeaderName.getPseudoHeaderName(header2);
        }

        private static PseudoHeaderName getPseudoHeaderName(CharSequence header2) {
            int length2 = header2.length();
            if (length2 > 0 && header2.charAt(0) == ':') {
                switch (length2) {
                    case 5: {
                        return ":path".contentEquals(header2) ? PATH : null;
                    }
                    case 7: {
                        if (":method" == header2) {
                            return METHOD;
                        }
                        if (":scheme" == header2) {
                            return SCHEME;
                        }
                        if (":status" == header2) {
                            return STATUS;
                        }
                        if (":method".contentEquals(header2)) {
                            return METHOD;
                        }
                        if (":scheme".contentEquals(header2)) {
                            return SCHEME;
                        }
                        return ":status".contentEquals(header2) ? STATUS : null;
                    }
                    case 9: {
                        return ":protocol".contentEquals(header2) ? PROTOCOL : null;
                    }
                    case 10: {
                        return ":authority".contentEquals(header2) ? AUTHORITY : null;
                    }
                }
            }
            return null;
        }

        public static PseudoHeaderName getPseudoHeader(AsciiString header2) {
            int length2 = header2.length();
            if (length2 > 0 && header2.charAt(0) == ':') {
                switch (length2) {
                    case 5: {
                        return PATH.value().equals((Object)header2) ? PATH : null;
                    }
                    case 7: {
                        if (header2 == METHOD.value()) {
                            return METHOD;
                        }
                        if (header2 == SCHEME.value()) {
                            return SCHEME;
                        }
                        if (header2 == STATUS.value()) {
                            return STATUS;
                        }
                        if (METHOD.value().equals((Object)header2)) {
                            return METHOD;
                        }
                        if (SCHEME.value().equals((Object)header2)) {
                            return SCHEME;
                        }
                        return STATUS.value().equals((Object)header2) ? STATUS : null;
                    }
                    case 9: {
                        return PROTOCOL.value().equals((Object)header2) ? PROTOCOL : null;
                    }
                    case 10: {
                        return AUTHORITY.value().equals((Object)header2) ? AUTHORITY : null;
                    }
                }
            }
            return null;
        }

        public boolean isRequestOnly() {
            return this.requestOnly;
        }
    }
}

