/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.polyglot;

import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;

final class PolyglotEngineException
extends RuntimeException {
    final RuntimeException e;
    final boolean closedException;

    PolyglotEngineException(RuntimeException e) {
        this(e, false);
    }

    PolyglotEngineException(RuntimeException e, boolean closedException) {
        super(null, e);
        this.e = e;
        this.closedException = closedException;
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    static void rethrow(Throwable e) {
        if (e instanceof PolyglotEngineException) {
            throw ((PolyglotEngineException)e).e;
        }
    }

    static PolyglotEngineException illegalArgument(IllegalArgumentException e) {
        return new PolyglotEngineException(e);
    }

    static PolyglotEngineException illegalArgument(String message2) {
        return new PolyglotEngineException(new IllegalArgumentException(message2));
    }

    static PolyglotEngineException illegalState(String message2) {
        return new PolyglotEngineException(new IllegalStateException(message2));
    }

    static PolyglotEngineException closedException(String message2) {
        return new PolyglotEngineException(new IllegalStateException(message2), true);
    }

    static PolyglotEngineException nullPointer(String message2) {
        return new PolyglotEngineException(new NullPointerException(message2));
    }

    static PolyglotEngineException unsupported(String message2) {
        return new PolyglotEngineException(new UnsupportedOperationException(message2));
    }

    static PolyglotEngineException unsupported(String message2, Throwable cause) {
        return new PolyglotEngineException(new UnsupportedOperationException(message2, cause));
    }

    static PolyglotEngineException classCast(String message2) {
        return new PolyglotEngineException(new ClassCastException(message2));
    }

    static PolyglotEngineException arrayIndexOutOfBounds(String message2) {
        return new PolyglotEngineException(new ArrayIndexOutOfBoundsException(message2));
    }

    static PolyglotEngineException bufferIndexOutOfBounds(String message2) {
        return new PolyglotEngineException(new IndexOutOfBoundsException(message2));
    }

    static PolyglotEngineException noSuchElement(String message2) {
        return new PolyglotEngineException(new NoSuchElementException(message2));
    }

    static PolyglotEngineException concurrentModificationException(String message2) {
        return new PolyglotEngineException(new ConcurrentModificationException(message2));
    }
}

