/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.builtins.IteratorHelperPrototypeBuiltinsFactory;
import com.oracle.truffle.js.builtins.IteratorPrototypeBuiltins;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.nodes.access.CreateIterResultObjectNode;
import com.oracle.truffle.js.nodes.access.HasHiddenKeyCacheNode;
import com.oracle.truffle.js.nodes.access.IteratorCloseNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.access.PropertySetNode;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.function.JSBuiltinNode;
import com.oracle.truffle.js.nodes.function.JSFunctionCallNode;
import com.oracle.truffle.js.runtime.Errors;
import com.oracle.truffle.js.runtime.JSArguments;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.Strings;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.JSFunction;
import com.oracle.truffle.js.runtime.objects.IteratorRecord;
import com.oracle.truffle.js.runtime.objects.Undefined;

public class IteratorHelperPrototypeBuiltins
extends JSBuiltinsContainer.SwitchEnum<HelperIteratorPrototype> {
    public static final JSBuiltinsContainer BUILTINS = new IteratorHelperPrototypeBuiltins();
    public static final TruffleString PROTOTYPE_NAME = Strings.constant("IteratorHelper.prototype");
    public static final TruffleString CLASS_NAME = Strings.constant("IteratorHelper");
    public static final TruffleString TO_STRING_TAG = Strings.constant("Iterator Helper");
    public static final HiddenKey NEXT_ID = new HiddenKey("next");
    public static final HiddenKey ARGS_ID = new HiddenKey("target");

    protected IteratorHelperPrototypeBuiltins() {
        super(PROTOTYPE_NAME, HelperIteratorPrototype.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, HelperIteratorPrototype builtinEnum) {
        switch (builtinEnum) {
            case next: {
                return IteratorHelperPrototypeBuiltinsFactory.IteratorHelperNextNodeGen.create(context, builtin, IteratorHelperPrototypeBuiltins.args().withThis().fixedArgs(1).createArgumentNodes(context));
            }
            case return_: {
                return IteratorHelperPrototypeBuiltinsFactory.IteratorHelperReturnNodeGen.create(context, builtin, IteratorHelperPrototypeBuiltins.args().withThis().createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum HelperIteratorPrototype implements BuiltinEnum<HelperIteratorPrototype>
    {
        next(1),
        return_(0);

        private final int length;

        private HelperIteratorPrototype(int length2) {
            this.length = length2;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    public static abstract class IteratorHelperNextNode
    extends JSBuiltinNode {
        @Node.Child
        private PropertyGetNode getNextImplNode;
        @Node.Child
        private PropertyGetNode getGeneratorStateNode;
        @Node.Child
        private PropertySetNode setGeneratorStateNode;
        @Node.Child
        private HasHiddenKeyCacheNode hasNextImplNode;
        @Node.Child
        private CreateIterResultObjectNode createIterResultObjectNode;
        @Node.Child
        private JSFunctionCallNode callNode;

        protected IteratorHelperNextNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.getGeneratorStateNode = PropertyGetNode.createGetHidden(JSFunction.GENERATOR_STATE_ID, context);
            this.setGeneratorStateNode = PropertySetNode.createSetHidden(JSFunction.GENERATOR_STATE_ID, context);
            this.getNextImplNode = PropertyGetNode.createGetHidden(NEXT_ID, context);
            this.hasNextImplNode = HasHiddenKeyCacheNode.create(NEXT_ID);
            this.callNode = JSFunctionCallNode.createCall();
        }

        protected boolean hasImpl(Object thisObj) {
            return this.hasNextImplNode.executeHasHiddenKey(thisObj);
        }

        @Specialization(guards={"hasImpl(thisObj)"})
        public Object next(VirtualFrame frame, Object thisObj, @Cached InlinedBranchProfile executingProfile, @Cached InlinedBranchProfile completedProfile) {
            Object state = this.getGeneratorStateNode.getValue(thisObj);
            if (state == JSFunction.GeneratorState.Executing) {
                executingProfile.enter(this);
                throw Errors.createTypeError("generator is already executing");
            }
            if (state == JSFunction.GeneratorState.Completed) {
                completedProfile.enter(this);
                if (this.createIterResultObjectNode == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.createIterResultObjectNode = this.insert(CreateIterResultObjectNode.create(this.getContext()));
                }
                return this.createIterResultObjectNode.execute(frame, Undefined.instance, true);
            }
            this.setGeneratorStateNode.setValue(thisObj, (Object)JSFunction.GeneratorState.Executing);
            try {
                Object next = this.getNextImplNode.getValue(thisObj);
                return this.callNode.executeCall(JSArguments.createZeroArg(thisObj, next));
            }
            catch (AbstractTruffleException ex) {
                this.setGeneratorStateNode.setValue(thisObj, (Object)JSFunction.GeneratorState.Completed);
                throw ex;
            }
        }

        @Specialization(guards={"!hasImpl(thisObj)"})
        public Object unsupported(Object thisObj) {
            throw Errors.createTypeErrorIncompatibleReceiver(thisObj);
        }

        @Override
        public boolean isSplitImmediately() {
            return true;
        }
    }

    @ImportStatic(value={IteratorHelperPrototypeBuiltins.class, IteratorPrototypeBuiltins.class, JSFunction.GeneratorState.class})
    public static abstract class IteratorHelperReturnNode
    extends JSBuiltinNode {
        @Node.Child
        private PropertyGetNode getArgsNode;
        @Node.Child
        private PropertyGetNode getGeneratorStateNode;
        @Node.Child
        private PropertySetNode setGeneratorStateNode;
        @Node.Child
        private IteratorCloseNode iteratorCloseNode;
        @Node.Child
        private CreateIterResultObjectNode createIterResultObjectNode;
        @Node.Child
        private HasHiddenKeyCacheNode hasNextImplNode;

        protected IteratorHelperReturnNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
            this.getArgsNode = PropertyGetNode.create(ARGS_ID, context);
            this.getGeneratorStateNode = PropertyGetNode.createGetHidden(JSFunction.GENERATOR_STATE_ID, context);
            this.setGeneratorStateNode = PropertySetNode.createSetHidden(JSFunction.GENERATOR_STATE_ID, context);
            this.iteratorCloseNode = IteratorCloseNode.create(context);
            this.createIterResultObjectNode = CreateIterResultObjectNode.create(context);
            this.hasNextImplNode = HasHiddenKeyCacheNode.create(ARGS_ID);
        }

        protected boolean hasImpl(Object thisObj) {
            return this.hasNextImplNode.executeHasHiddenKey(thisObj);
        }

        protected JSFunction.GeneratorState getState(Object thisObject) {
            return (JSFunction.GeneratorState)((Object)this.getGeneratorStateNode.getValue(thisObject));
        }

        @Specialization(guards={"hasImpl(thisObj)", "getState(thisObj) == Executing"})
        public Object executing(Object thisObj) {
            throw Errors.createTypeError("generator is already executing");
        }

        @Specialization(guards={"hasImpl(thisObj)", "getState(thisObj) == SuspendedStart"})
        public Object suspendedStart(VirtualFrame frame, Object thisObj) {
            this.setGeneratorStateNode.setValue(thisObj, (Object)JSFunction.GeneratorState.Completed);
            return this.createIterResultObjectNode.execute(frame, Undefined.instance, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"hasImpl(thisObj)", "getState(thisObj) == SuspendedYield"})
        public Object suspendedYield(VirtualFrame frame, Object thisObj, @Cached InlinedBranchProfile aliveBranch) {
            this.setGeneratorStateNode.setValue(thisObj, (Object)JSFunction.GeneratorState.Executing);
            IteratorPrototypeBuiltins.IteratorArgs args = (IteratorPrototypeBuiltins.IteratorArgs)this.getArgsNode.getValue(thisObj);
            if (args instanceof IteratorPrototypeBuiltins.IteratorFlatMapNode.IteratorFlatMapArgs) {
                IteratorPrototypeBuiltins.IteratorFlatMapNode.IteratorFlatMapArgs flatMapArgs = (IteratorPrototypeBuiltins.IteratorFlatMapNode.IteratorFlatMapArgs)args;
                if (flatMapArgs.innerAlive) {
                    aliveBranch.enter(this);
                    this.iteratorCloseNode.executeAbrupt(flatMapArgs.innerIterator.getIterator());
                }
            }
            IteratorRecord iterated = args.iterated;
            try {
                this.iteratorCloseNode.executeVoid(iterated.getIterator());
            }
            finally {
                this.setGeneratorStateNode.setValue(thisObj, (Object)JSFunction.GeneratorState.Completed);
            }
            return this.createIterResultObjectNode.execute(frame, Undefined.instance, true);
        }

        @Specialization(guards={"!hasImpl(thisObj)"})
        public Object unsupported(Object thisObj) {
            throw Errors.createTypeErrorIncompatibleReceiver(thisObj);
        }
    }
}

