/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.jsonPath;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.impl.TextExpression;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpRequestPsiFactory;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.psi.HttpFileVariable;
import com.intellij.httpClient.http.request.psi.HttpFileVariableValue;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestBlock;
import com.intellij.httpClient.jsonPath.AddFileVariableQuickFix;
import com.intellij.modcommand.ModPsiUpdater;
import com.intellij.modcommand.ModTemplateBuilder;
import com.intellij.modcommand.PsiUpdateModCommandQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTreeUtilKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\b\u0010\u0015\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lcom/intellij/httpClient/jsonPath/AddFileVariableQuickFix;", "Lcom/intellij/modcommand/PsiUpdateModCommandQuickFix;", "varName", "", "(Ljava/lang/String;)V", "getVarName", "()Ljava/lang/String;", "addVariableAfter", "Lcom/intellij/httpClient/http/request/psi/HttpFileVariable;", "anchor", "Lcom/intellij/psi/PsiElement;", "addVariableBefore", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "element", "updater", "Lcom/intellij/modcommand/ModPsiUpdater;", "findElementToAddAfter", "findElementToAddBefore", "getFamilyName", "intellij.restClient"})
@SourceDebugExtension(value={"SMAP\nHttpClientUnresolvedVariableInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HttpClientUnresolvedVariableInspection.kt\ncom/intellij/httpClient/jsonPath/AddFileVariableQuickFix\n+ 2 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n*L\n1#1,460:1\n66#2,2:461\n*S KotlinDebug\n*F\n+ 1 HttpClientUnresolvedVariableInspection.kt\ncom/intellij/httpClient/jsonPath/AddFileVariableQuickFix\n*L\n422#1:461,2\n*E\n"})
final class AddFileVariableQuickFix
extends PsiUpdateModCommandQuickFix {
    @NotNull
    private final String varName;

    public AddFileVariableQuickFix(@NotNull String varName) {
        Intrinsics.checkNotNullParameter((Object)varName, (String)"varName");
        this.varName = varName;
    }

    @NotNull
    public final String getVarName() {
        return this.varName;
    }

    @NotNull
    public String getFamilyName() {
        Object[] objectArray = new Object[]{this.varName};
        String string = RestClientBundle.message("http.client.unresolved.variable.add.file.variable.fix", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    protected void applyFix(@NotNull Project project, @NotNull PsiElement element, @NotNull ModPsiUpdater updater) {
        HttpFileVariable httpFileVariable;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)updater, (String)"updater");
        PsiElement anchorToAddAfter = this.findElementToAddAfter(element);
        if (anchorToAddAfter != null) {
            httpFileVariable = this.addVariableAfter(anchorToAddAfter);
        } else {
            PsiElement anchorToAddBefore = this.findElementToAddBefore(element);
            if (anchorToAddBefore != null) {
                httpFileVariable = this.addVariableBefore(anchorToAddBefore);
            } else {
                throw new IllegalStateException(new Function0<String>(element){
                    final /* synthetic */ PsiElement $element;
                    {
                        this.$element = $element;
                        super(0);
                    }

                    @NotNull
                    public final String invoke() {
                        return "Unexpected element: " + this.$element.getClass().getName() + "\nParents: " + SequencesKt.joinToString$default((Sequence)SequencesKt.generateSequence((Object)this.$element, (Function1)((Function1)new Function1<PsiElement, PsiElement>(this.$element){
                            final /* synthetic */ PsiElement $element;
                            {
                                this.$element = $element;
                                super(1);
                            }

                            @Nullable
                            public final PsiElement invoke(@NotNull PsiElement it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                return this.$element.getParent();
                            }
                        })), (CharSequence)" -> ", null, null, (int)0, null, (Function1)applyFix.variable.2.INSTANCE, (int)30, null);
                    }
                }.toString());
            }
        }
        HttpFileVariable variable2 = httpFileVariable;
        ModTemplateBuilder modTemplateBuilder = updater.templateBuilder();
        HttpFileVariableValue httpFileVariableValue = variable2.getFileVariableValue();
        Intrinsics.checkNotNull((Object)httpFileVariableValue);
        modTemplateBuilder.field((PsiElement)httpFileVariableValue, (Expression)new TextExpression(" variable value"));
    }

    private final PsiElement findElementToAddAfter(PsiElement element) {
        HttpFileVariable lastVariable;
        PsiElement $this$parentOfType_u24default$iv = element;
        boolean withSelf$iv = false;
        boolean $i$f$parentOfType = false;
        HttpRequestBlock httpRequestBlock = (HttpRequestBlock)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv, HttpRequestBlock.class, (boolean)true);
        if (httpRequestBlock == null) {
            return null;
        }
        HttpRequestBlock requestBlock = httpRequestBlock;
        List<HttpFileVariable> list2 = requestBlock.getFileVariableList();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getFileVariableList(...)");
        HttpFileVariable httpFileVariable = lastVariable = (HttpFileVariable)CollectionsKt.lastOrNull(list2);
        if (httpFileVariable != null) {
            return (PsiElement)httpFileVariable;
        }
        PsiElement psiElement = requestBlock.getFirstChild();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getFirstChild(...)");
        return (PsiElement)SequencesKt.lastOrNull((Sequence)SequencesKt.filter((Sequence)PsiTreeUtilKt.siblings$default((PsiElement)psiElement, (boolean)false, (boolean)false, (int)3, null), (Function1)findElementToAddAfter.1.INSTANCE));
    }

    private final HttpFileVariable addVariableAfter(PsiElement anchor) {
        HttpRequestPsiFile httpRequestPsiFile = HttpRequestPsiFactory.createDummyFile(anchor.getProject(), StringsKt.trimIndent((String)("\n        \n        @" + this.varName + " = val\n      ")));
        Intrinsics.checkNotNullExpressionValue((Object)((Object)httpRequestPsiFile), (String)"createDummyFile(...)");
        HttpRequestPsiFile newVariableFile = httpRequestPsiFile;
        anchor.getParent().addRangeAfter(newVariableFile.getFirstChild(), newVariableFile.getLastChild(), anchor);
        PsiElement psiElement = anchor.getNextSibling().getNextSibling();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.httpClient.http.request.psi.HttpFileVariable");
        return (HttpFileVariable)psiElement;
    }

    private final PsiElement findElementToAddBefore(PsiElement element) {
        KClass[] kClassArray = new KClass[]{Reflection.getOrCreateKotlinClass(HttpRequest.class), Reflection.getOrCreateKotlinClass(HttpFileVariable.class)};
        return PsiTreeUtilKt.parentOfTypes$default((PsiElement)element, (KClass[])kClassArray, (boolean)false, (int)2, null);
    }

    private final HttpFileVariable addVariableBefore(PsiElement anchor) {
        HttpRequestPsiFile httpRequestPsiFile = HttpRequestPsiFactory.createDummyFile(anchor.getProject(), StringsKt.trimIndent((String)("\n        @" + this.varName + " = val\n        \n      ")));
        Intrinsics.checkNotNullExpressionValue((Object)((Object)httpRequestPsiFile), (String)"createDummyFile(...)");
        HttpRequestPsiFile newVariableFile = httpRequestPsiFile;
        anchor.getParent().addRangeBefore(newVariableFile.getFirstChild(), newVariableFile.getLastChild(), anchor);
        PsiElement psiElement = anchor.getPrevSibling().getPrevSibling();
        Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.httpClient.http.request.psi.HttpFileVariable");
        return (HttpFileVariable)psiElement;
    }
}

