/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.impl;

import com.intellij.httpClient.execution.HttpClientIdeSettings;
import com.intellij.httpClient.execution.RestClientRequest;
import com.intellij.httpClient.http.request.HttpRequestFileUtils;
import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.psi.HttpFilePath;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.run.HttpClientResponseHandlerExecutor;
import com.intellij.httpClient.http.request.run.HttpRequestExecutionHelperService;
import com.intellij.httpClient.http.request.run.HttpRequestNotifications;
import com.intellij.httpClient.http.request.run.HttpRequestPostProcessor;
import com.intellij.httpClient.http.request.run.HttpScratchRequestPostProcessor;
import com.intellij.httpClient.http.request.run.console.HttpClientOutputPrinter;
import com.intellij.httpClient.http.request.run.controller.HttpClientExecutionController;
import com.intellij.httpClient.http.request.run.js.HttpClientCommonJsExecutor;
import com.intellij.httpClient.http.request.run.js.JavascriptFallbackExecutionSupport;
import com.intellij.httpClient.http.request.run.js.graalvm.HttpClientGraalVmExecutor;
import com.intellij.httpClient.http.request.run.js.graalvm.HttpClientGraalVmJsResponseHandler;
import com.intellij.httpClient.http.request.run.test.HttpClientTestLocations;
import com.intellij.httpClient.http.request.run.test.HttpClientTestUtil;
import com.intellij.ide.scratch.ScratchUtil;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceUtil;
import com.intellij.util.net.HttpConfigurable;
import com.intellij.util.net.ssl.CertificateManager;
import com.intellij.util.proxy.CommonProxy;
import java.io.File;
import java.net.Proxy;
import java.net.URI;
import java.util.List;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRequestExecutionHelperServiceImpl
implements HttpRequestExecutionHelperService {
    @Override
    public void showWarning(@NotNull Project project, @NotNull @NlsSafe String title, @NotNull @NlsSafe String description) {
        if (project == null) {
            HttpRequestExecutionHelperServiceImpl.$$$reportNull$$$0(0);
        }
        if (title == null) {
            HttpRequestExecutionHelperServiceImpl.$$$reportNull$$$0(1);
        }
        if (description == null) {
            HttpRequestExecutionHelperServiceImpl.$$$reportNull$$$0(2);
        }
        HttpRequestNotifications.showWarningBalloon(project, title, description);
    }

    @Override
    @NotNull
    public HttpRequestPostProcessor getProcessor(@Nullable PsiFile file, @NotNull SmartPsiElementPointer<HttpRequest> request2) {
        if (request2 == null) {
            HttpRequestExecutionHelperServiceImpl.$$$reportNull$$$0(3);
        }
        HttpRequestPostProcessor httpRequestPostProcessor = file != null && ScratchUtil.isScratch((VirtualFile)file.getOriginalFile().getVirtualFile()) ? new HttpScratchRequestPostProcessor(request2) : HttpRequestPostProcessor.EMPTY_PROCESSOR;
        if (httpRequestPostProcessor == null) {
            HttpRequestExecutionHelperServiceImpl.$$$reportNull$$$0(4);
        }
        return httpRequestPostProcessor;
    }

    @Override
    @Nullable
    public TrustManager getDefaultTrustManager() {
        return CertificateManager.getInstance().getTrustManager();
    }

    @Override
    public boolean isTextFile(@NotNull File file) {
        if (file == null) {
            HttpRequestExecutionHelperServiceImpl.$$$reportNull$$$0(5);
        }
        FileType fileType = !file.isDirectory() ? FileTypeManager.getInstance().getFileTypeByFileName(file.getName()) : null;
        return fileType != null && !fileType.isBinary();
    }

    @Override
    public void initProxy() {
        CommonProxy.getInstance().ensureAuthenticator();
    }

    @Override
    public void showError(@NotNull Project project, @NotNull @Nls String title, @NotNull @Nls String message2) {
        if (project == null) {
            HttpRequestExecutionHelperServiceImpl.$$$reportNull$$$0(6);
        }
        if (title == null) {
            HttpRequestExecutionHelperServiceImpl.$$$reportNull$$$0(7);
        }
        if (message2 == null) {
            HttpRequestExecutionHelperServiceImpl.$$$reportNull$$$0(8);
        }
        HttpRequestNotifications.showErrorBalloon(project, title, message2);
    }

    @Override
    public String getTestLocationHint(@NotNull String fileUrl, int line) {
        if (fileUrl == null) {
            HttpRequestExecutionHelperServiceImpl.$$$reportNull$$$0(9);
        }
        return HttpClientTestLocations.getTestLocationHint(fileUrl, line);
    }

    @Override
    @NotNull
    public String getProjectNameKey(@NotNull Project project) {
        if (project == null) {
            HttpRequestExecutionHelperServiceImpl.$$$reportNull$$$0(10);
        }
        String string = ProjectUtil.getProjectCacheFileName((Project)project);
        if (string == null) {
            HttpRequestExecutionHelperServiceImpl.$$$reportNull$$$0(11);
        }
        return string;
    }

    @Override
    @Nullable
    public FileType suggestFileType(String mimeType) {
        return HttpRequestFileUtils.findFileType(mimeType);
    }

    @Override
    @NotNull
    public HttpRequestExecutionHelperService.HttpClientTestResultsPrinter provideTestResultPrinter() {
        return new HttpRequestExecutionHelperService.HttpClientTestResultsPrinter(){

            @Override
            public void printSuiteStart(@NotNull HttpClientOutputPrinter printer2, @NotNull String suite, int size) {
                if (printer2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (suite == null) {
                    1.$$$reportNull$$$0(1);
                }
                HttpClientTestUtil.printSuiteStart(printer2, suite, size);
            }

            @Override
            public void printTestStart(@NotNull HttpClientOutputPrinter printer2, @NotNull String name, @Nullable String hint) {
                if (printer2 == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (name == null) {
                    1.$$$reportNull$$$0(3);
                }
                HttpClientTestUtil.printTestStart(printer2, name, hint);
            }

            @Override
            public void printTestFailed(@NotNull HttpClientOutputPrinter printer2, @NotNull String name, @NotNull String message2) {
                if (printer2 == null) {
                    1.$$$reportNull$$$0(4);
                }
                if (name == null) {
                    1.$$$reportNull$$$0(5);
                }
                if (message2 == null) {
                    1.$$$reportNull$$$0(6);
                }
                HttpClientTestUtil.printTestFailed(printer2, name, message2);
            }

            @Override
            public void printTestEnd(@NotNull HttpClientOutputPrinter printer2, @NotNull String name, long duration) {
                if (printer2 == null) {
                    1.$$$reportNull$$$0(7);
                }
                if (name == null) {
                    1.$$$reportNull$$$0(8);
                }
                HttpClientTestUtil.printTestEnd(printer2, name, duration);
            }

            @Override
            public void printSuiteEnd(@NotNull HttpClientOutputPrinter printer2, @NotNull String suite) {
                if (printer2 == null) {
                    1.$$$reportNull$$$0(9);
                }
                if (suite == null) {
                    1.$$$reportNull$$$0(10);
                }
                HttpClientTestUtil.printSuiteEnd(printer2, suite);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "printer";
                        break;
                    }
                    case 1: 
                    case 10: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "suite";
                        break;
                    }
                    case 3: 
                    case 5: 
                    case 8: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "name";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "message";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/httpClient/http/request/run/impl/HttpRequestExecutionHelperServiceImpl$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "printSuiteStart";
                        break;
                    }
                    case 2: 
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "printTestStart";
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[2] = "printTestFailed";
                        break;
                    }
                    case 7: 
                    case 8: {
                        objectArray = objectArray2;
                        objectArray2[2] = "printTestEnd";
                        break;
                    }
                    case 9: 
                    case 10: {
                        objectArray = objectArray2;
                        objectArray2[2] = "printSuiteEnd";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    @Override
    public int getSocketTimeout() {
        return HttpClientIdeSettings.socketTimeout;
    }

    @Override
    public int getConnectionTimeout() {
        return HttpClientIdeSettings.connectionTimeout;
    }

    @Override
    @NotNull
    public List<Proxy> getProxy(@NotNull URI uri) {
        if (uri == null) {
            HttpRequestExecutionHelperServiceImpl.$$$reportNull$$$0(12);
        }
        List<Proxy> list2 = HttpConfigurable.getInstance().getOnlyBySettingsSelector().select(uri);
        if (list2 == null) {
            HttpRequestExecutionHelperServiceImpl.$$$reportNull$$$0(13);
        }
        return list2;
    }

    @Override
    @NotNull
    public SSLContext getDefaultSSLContext() {
        SSLContext sSLContext = CertificateManager.getInstance().getSslContext();
        if (sSLContext == null) {
            HttpRequestExecutionHelperServiceImpl.$$$reportNull$$$0(14);
        }
        return sSLContext;
    }

    @Override
    @Nullable
    public @Nullable Pair<KeyManager @Nullable [], @NotNull TrustManager> getDefaultSslConfiguration() {
        return Pair.create((Object)CertificateManager.getDefaultKeyManagers(), (Object)CertificateManager.getInstance().getTrustManager());
    }

    @Override
    public void loadCookieToRequest(@NotNull Project project, @NotNull RestClientRequest request2) {
        if (project == null) {
            HttpRequestExecutionHelperServiceImpl.$$$reportNull$$$0(15);
        }
        if (request2 == null) {
            HttpRequestExecutionHelperServiceImpl.$$$reportNull$$$0(16);
        }
        HttpClientExecutionController.loadCookiesFromJar(project, request2);
    }

    @Override
    public void invokeLater(@NotNull Runnable runnable) {
        if (runnable == null) {
            HttpRequestExecutionHelperServiceImpl.$$$reportNull$$$0(17);
        }
        ApplicationManager.getApplication().invokeLater(runnable);
    }

    @Override
    @Nullable
    public PsiFile resolveFilePath(@NotNull HttpFilePath filePath2) {
        if (filePath2 == null) {
            HttpRequestExecutionHelperServiceImpl.$$$reportNull$$$0(18);
        }
        return FileReferenceUtil.findFile((PsiElement)filePath2);
    }

    @Override
    @NotNull
    public String productVersion() {
        String string = ApplicationInfo.getInstance().getFullApplicationName();
        if (string == null) {
            HttpRequestExecutionHelperServiceImpl.$$$reportNull$$$0(19);
        }
        return string;
    }

    @Override
    public HttpClientCommonJsExecutor preScriptExecutor(VirtualFile sourceFile) {
        JavascriptFallbackExecutionSupport support = (JavascriptFallbackExecutionSupport)ApplicationManager.getApplication().getService(JavascriptFallbackExecutionSupport.class);
        if (support == null) {
            return new HttpClientGraalVmExecutor(sourceFile);
        }
        return support.preScriptExecutor(sourceFile);
    }

    @Override
    public HttpClientResponseHandlerExecutor responseHandler(Project project, VirtualFile sourceFile, int sourceLineOffset, HttpRequestVariableSubstitutor substitutor2, SmartPsiElementPointer<HttpRequest> pointerToOriginalElement, String requestMethod) {
        JavascriptFallbackExecutionSupport support = (JavascriptFallbackExecutionSupport)ApplicationManager.getApplication().getService(JavascriptFallbackExecutionSupport.class);
        if (support == null) {
            return HttpClientGraalVmJsResponseHandler.Companion.create(project, sourceFile, sourceLineOffset, pointerToOriginalElement, substitutor2, requestMethod);
        }
        return support.responseHandler(project, sourceFile, sourceLineOffset, substitutor2, pointerToOriginalElement, requestMethod);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 11, 13, 14, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 3: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 4: 
            case 11: 
            case 13: 
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/run/impl/HttpRequestExecutionHelperServiceImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileUrl";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uri";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/run/impl/HttpRequestExecutionHelperServiceImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectNameKey";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getProxy";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSSLContext";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "productVersion";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showWarning";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getProcessor";
                break;
            }
            case 4: 
            case 11: 
            case 13: 
            case 14: 
            case 19: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isTextFile";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "showError";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getTestLocationHint";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getProjectNameKey";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getProxy";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "loadCookieToRequest";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "invokeLater";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "resolveFilePath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 11, 13, 14, 19 -> new IllegalStateException(string);
        };
    }
}

