/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run.controller;

import com.intellij.execution.process.ProcessHandler;
import com.intellij.httpClient.examples.server.HttpClientExampleServerManager;
import com.intellij.httpClient.execution.RestClientControllerImpl;
import com.intellij.httpClient.execution.RestClientRequest;
import com.intellij.httpClient.execution.common.RequestExecutionSupport;
import com.intellij.httpClient.http.request.HttpRequestFileUtils;
import com.intellij.httpClient.http.request.HttpRequestPsiConverter;
import com.intellij.httpClient.http.request.cookies.CookieStorageInvalidFileException;
import com.intellij.httpClient.http.request.cookies.HttpRequestCookiesStorage;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestTarget;
import com.intellij.httpClient.http.request.run.HttpClientRequestProcessHandler;
import com.intellij.httpClient.http.request.run.HttpClientResponseHandler;
import com.intellij.httpClient.http.request.run.HttpRequestCompositePostProcessor;
import com.intellij.httpClient.http.request.run.HttpRequestPostProcessor;
import com.intellij.httpClient.http.request.run.HttpRequestValidationException;
import com.intellij.httpClient.http.request.run.HttpRunRequestInfo;
import com.intellij.httpClient.http.request.run.config.HttpRequestRunConfiguration;
import com.intellij.httpClient.http.request.run.console.HttpResponseConsole;
import com.intellij.httpClient.http.request.run.controller.HttpClientExecutionControllerHelper;
import com.intellij.httpClient.http.request.run.controller.HttpRequestConsolePostProcessor;
import com.intellij.httpClient.http.request.run.statistics.HttpClientExecutionUsageCollector;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpClientExecutionController
extends RestClientControllerImpl {
    private static final Logger LOG = Logger.getInstance(HttpClientExecutionController.class);
    final Project myProject;
    final String myRequestId;
    final HttpRunRequestInfo myRequestInfo;
    @NotNull
    final SmartPsiElementPointer<HttpRequest> myRequestPointer;
    final HttpResponseConsole myConsole;
    final HttpClientResponseHandler myResponseHandler;
    final HttpRequestPostProcessor myRequestPostProcessor;
    final Runnable myOnRequestFinished;
    final boolean myForceShowResponseInplace;
    @Nullable
    private final String myIgnoreMessage;

    public HttpClientExecutionController(@NotNull Project project, @NotNull HttpRunRequestInfo requestInfo, @NotNull String requestId, @NotNull SmartPsiElementPointer<HttpRequest> requestPointer, @NotNull HttpClientRequestProcessHandler processHandler, @NotNull HttpResponseConsole console2, @Nullable HttpClientResponseHandler responseHandler, @NotNull HttpRequestPostProcessor requestPostProcessor, boolean forceShowResponseInplace, @NotNull Runnable onRequestFinished, @Nullable String ignoreMessage, @NotNull HttpRequestRunConfiguration.Settings settings, boolean debugMode) {
        if (project == null) {
            HttpClientExecutionController.$$$reportNull$$$0(0);
        }
        if (requestInfo == null) {
            HttpClientExecutionController.$$$reportNull$$$0(1);
        }
        if (requestId == null) {
            HttpClientExecutionController.$$$reportNull$$$0(2);
        }
        if (requestPointer == null) {
            HttpClientExecutionController.$$$reportNull$$$0(3);
        }
        if (processHandler == null) {
            HttpClientExecutionController.$$$reportNull$$$0(4);
        }
        if (console2 == null) {
            HttpClientExecutionController.$$$reportNull$$$0(5);
        }
        if (requestPostProcessor == null) {
            HttpClientExecutionController.$$$reportNull$$$0(6);
        }
        if (onRequestFinished == null) {
            HttpClientExecutionController.$$$reportNull$$$0(7);
        }
        if (settings == null) {
            HttpClientExecutionController.$$$reportNull$$$0(8);
        }
        super(project, settings, processHandler, debugMode);
        this.myProject = project;
        this.myRequestInfo = requestInfo;
        this.myRequestId = requestId;
        this.myRequestPointer = requestPointer;
        this.myConsole = console2;
        this.myResponseHandler = responseHandler;
        this.myRequestPostProcessor = requestPostProcessor;
        this.myOnRequestFinished = new LastCallRunnable(onRequestFinished, this.myResponseHandler == null ? 1 : 2);
        this.myForceShowResponseInplace = forceShowResponseInplace;
        this.myIgnoreMessage = ignoreMessage;
    }

    @NotNull
    public static HttpClientExecutionController create(@NotNull Project project, @NotNull HttpRunRequestInfo info, @NotNull HttpClientRequestProcessHandler processHandler, @NotNull HttpResponseConsole console2, @NotNull Runnable onRequestFinished, boolean showResponseInplace, @NotNull HttpRequestRunConfiguration.Settings settings, boolean debugMode) throws HttpRequestValidationException {
        if (project == null) {
            HttpClientExecutionController.$$$reportNull$$$0(9);
        }
        if (info == null) {
            HttpClientExecutionController.$$$reportNull$$$0(10);
        }
        if (processHandler == null) {
            HttpClientExecutionController.$$$reportNull$$$0(11);
        }
        if (console2 == null) {
            HttpClientExecutionController.$$$reportNull$$$0(12);
        }
        if (onRequestFinished == null) {
            HttpClientExecutionController.$$$reportNull$$$0(13);
        }
        if (settings == null) {
            HttpClientExecutionController.$$$reportNull$$$0(14);
        }
        String id = HttpClientExecutionController.toRequestId(info, console2.showRequestMethod());
        if (LOG.isTraceEnabled()) {
            LOG.trace("Executing: " + id);
        }
        HttpClientResponseHandler handler = info.getResponseHandler();
        Runnable onFinished = () -> {
            console2.onRequestEnd(id);
            onRequestFinished.run();
        };
        return new HttpClientExecutionController(project, info, id, info.getRequestPointer(), processHandler, console2, handler, info.getPostProcessor(), showResponseInplace, onFinished, info.getIgnoreMessage(), settings, debugMode);
    }

    @Override
    public void lateInitialize() {
        this.myConsole.lateInitialize();
    }

    public static void loadCookiesFromJar(@NotNull Project project, @NotNull RestClientRequest request2) {
        if (project == null) {
            HttpClientExecutionController.$$$reportNull$$$0(15);
        }
        if (request2 == null) {
            HttpClientExecutionController.$$$reportNull$$$0(16);
        }
        try {
            if (request2.config.isSaveCookies()) {
                HttpRequestCookiesStorage.getInstance(project).saveToRequest(request2);
            }
        }
        catch (CookieStorageInvalidFileException e) {
            LOG.warn("Failed loading cookies, " + e.getMessage());
        }
    }

    @NotNull
    public static String toRequestId(@NotNull HttpRunRequestInfo requestInfo, boolean addMethod) {
        if (requestInfo == null) {
            HttpClientExecutionController.$$$reportNull$$$0(17);
        }
        String unknownRequestId = "<unknown>";
        String string = (String)(addMethod ? requestInfo.getRequestMethod() + " " : "") + StringUtil.notNullize((String)requestInfo.getRequestURL(), (String)unknownRequestId);
        if (string == null) {
            HttpClientExecutionController.$$$reportNull$$$0(18);
        }
        return string;
    }

    boolean isTrustedEnvironment() {
        VirtualFile file = this.myRequestPointer.getVirtualFile();
        if (file == null) {
            return false;
        }
        String filePath2 = file.getPath();
        return HttpRequestFileUtils.isFileFromCollections(filePath2) || TrustedProjects.isTrusted((Project)this.myProject);
    }

    public void execute() {
        if (this.myIgnoreMessage != null) {
            this.myConsole.onRequestIgnored(this.myRequestId, this.myIgnoreMessage);
            this.myOnRequestFinished.run();
            return;
        }
        HttpClientExecutionUsageCollector.REQUEST_EXECUTION_EVENT_ID.log(this.myProject, new EventPair[]{HttpClientExecutionUsageCollector.REQUEST_METHOD_FIELD.with((Object)this.myRequestInfo.getRequestMethod()), HttpClientExecutionUsageCollector.PRE_REQUEST_HANDLER_FIELD.with((Object)(this.myRequestInfo.getPreRequestHandler() != null ? 1 : 0)), HttpClientExecutionUsageCollector.RESPONSE_HANDLER_FIELD.with((Object)(this.myRequestInfo.getPreRequestHandler() != null ? 1 : 0)), HttpClientExecutionUsageCollector.SENT_TO_LOCALHOST_FIELD.with((Object)this.isLocalhost())});
        this.myConsole.setOnFinishPrintingCallback(this.myOnRequestFinished);
        HttpClientExecutionControllerHelper controllerHelper = this.createListener(this.myRequestInfo);
        controllerHelper.executeRequest(() -> {
            this.scheduleRequestToExampleServer();
            this.onGoButtonClick(this.myRequestInfo, false, controllerHelper);
        });
    }

    private boolean isLocalhost() {
        String url = this.myRequestInfo.getRequestURL();
        if (url == null) {
            return false;
        }
        for (String scheme : ContainerUtil.flatMap((Iterable)RequestExecutionSupport.All.getEP_NAME().getExtensionList(), support -> support.getSupportedSchemes())) {
            if (!url.startsWith(scheme)) continue;
            url = StringUtil.trimStart((String)url, (String)(scheme + "://"));
        }
        if (url.startsWith("localhost")) {
            url = StringUtil.trimStart((String)url, (String)"localhost");
        } else if (url.startsWith("127.0.0.1")) {
            url = StringUtil.trimStart((String)url, (String)"127.0.0.1");
        } else {
            return false;
        }
        return url.isEmpty() || url.startsWith(":") || url.startsWith("/");
    }

    private void scheduleRequestToExampleServer() {
        boolean isExamplesRequest = (Boolean)ReadAction.compute(() -> {
            HttpRequest element = (HttpRequest)this.myRequestInfo.getRequestPointer().getElement();
            if (element == null) {
                return false;
            }
            HttpRequestTarget target = element.getRequestTarget();
            if (target == null || target.getHost() == null) {
                return false;
            }
            return ContainerUtil.exists(target.getHost().getDynamicVariableList(), variable2 -> "exampleServer".equals(variable2.getName()));
        });
        if (isExamplesRequest) {
            HttpClientExampleServerManager.getInstance().scheduleRequest();
        }
    }

    @NotNull
    private HttpClientExecutionControllerHelper createListener(HttpRunRequestInfo requestInfo) {
        HttpClientExecutionControllerHelper httpClientExecutionControllerHelper = (HttpClientExecutionControllerHelper)ReadAction.compute(() -> {
            HttpRequest httpRequest = (HttpRequest)requestInfo.getRequestPointer().getElement();
            if (httpRequest == null) {
                return new HttpClientExecutionControllerHelper(this);
            }
            boolean saveCookies = HttpRequestPsiConverter.shouldSaveCookie(httpRequest);
            return new HttpClientExecutionControllerHelper(this, saveCookies);
        });
        if (httpClientExecutionControllerHelper == null) {
            HttpClientExecutionController.$$$reportNull$$$0(19);
        }
        return httpClientExecutionControllerHelper;
    }

    static void saveCookiesToJar(@NotNull Project project, Collection<? extends RestClientRequest.Biscuit> cookies) {
        if (project == null) {
            HttpClientExecutionController.$$$reportNull$$$0(20);
        }
        try {
            HttpRequestCookiesStorage.getInstance(project).setCookies(cookies);
        }
        catch (CookieStorageInvalidFileException e) {
            LOG.warn("Failed saving cookies, " + e.getMessage());
        }
    }

    @NotNull
    static HttpRequestPostProcessor createProcessor(@NotNull String requestId, @NotNull HttpResponseConsole console2, @NotNull HttpRequestPostProcessor processor) {
        if (requestId == null) {
            HttpClientExecutionController.$$$reportNull$$$0(21);
        }
        if (console2 == null) {
            HttpClientExecutionController.$$$reportNull$$$0(22);
        }
        if (processor == null) {
            HttpClientExecutionController.$$$reportNull$$$0(23);
        }
        return new HttpRequestCompositePostProcessor(processor, new HttpRequestConsolePostProcessor(requestId, console2));
    }

    static boolean isInterrupted(@NotNull ProcessHandler handler) {
        Integer code;
        if (handler == null) {
            HttpClientExecutionController.$$$reportNull$$$0(24);
        }
        return (code = handler.getExitCode()) != null && code != 0;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 18, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestInfo";
                break;
            }
            case 2: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestId";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestPointer";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 5: 
            case 12: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "console";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requestPostProcessor";
                break;
            }
            case 7: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onRequestFinished";
                break;
            }
            case 8: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/run/controller/HttpClientExecutionController";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/run/controller/HttpClientExecutionController";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "toRequestId";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createListener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "loadCookiesFromJar";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "toRequestId";
                break;
            }
            case 18: 
            case 19: {
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "saveCookiesToJar";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "createProcessor";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isInterrupted";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 18, 19 -> new IllegalStateException(string);
        };
    }

    private static class LastCallRunnable
    implements Runnable {
        private final Runnable myDelegate;
        private final int myCallerCount;
        private int callsCount;

        private LastCallRunnable(Runnable delegate, int count) {
            this.myDelegate = delegate;
            this.myCallerCount = count;
        }

        @Override
        public void run() {
            ++this.callsCount;
            if (this.myCallerCount == this.callsCount) {
                this.myDelegate.run();
            }
        }
    }
}

