/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run;

import com.intellij.httpClient.actions.HttpClientPopups;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.execution.common.RequestContext;
import com.intellij.httpClient.execution.common.RequestExecutionSupport;
import com.intellij.httpClient.http.request.debug.HttpRequestDebuggerUtils;
import com.intellij.httpClient.http.request.environment.HttpClientEnvironmentsProvider;
import com.intellij.httpClient.http.request.environment.HttpRequestEnvironment;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.run.HttpRequestExecutorExtension;
import com.intellij.httpClient.http.request.run.HttpRequestExecutorExtensionFactory;
import com.intellij.httpClient.http.request.run.RunHttpRequestAction;
import com.intellij.httpClient.http.request.run.config.HttpSingleRequestExecutionConfig;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class HttpRequestActionsProvider {
    @NotNull
    public static HttpRequestActionsProviderStrategy getActionsProvider() {
        return new ShowActionsWithSelectedEnvironmentStrategy();
    }

    @Contract(value=" -> new")
    @NotNull
    public static HttpRequestActionsProviderStrategy getRunWithEnvActionsProvider() {
        return new ShowFlattenRunActionsStrategy(false, false);
    }

    @Contract(value="_,_ -> new")
    @NotNull
    public static HttpRequestActionsProviderStrategy wrapToActionOrGroup(@NotNull HttpRequestActionsProviderStrategy strategy, @NotNull HttpRequestExecutorExtension extension) {
        if (strategy == null) {
            HttpRequestActionsProvider.$$$reportNull$$$0(0);
        }
        if (extension == null) {
            HttpRequestActionsProvider.$$$reportNull$$$0(1);
        }
        return new ActionOrGroupHttpRequestActionsProviderStrategy(strategy, extension);
    }

    @NotNull
    private static List<AnAction> createActions(@NotNull HttpRequest request2, @NotNull Collection<String> envs2, @NotNull HttpRequestExecutorExtension extension, boolean addWithoutEnv, boolean addDefaultEnv) {
        if (request2 == null) {
            HttpRequestActionsProvider.$$$reportNull$$$0(2);
        }
        if (envs2 == null) {
            HttpRequestActionsProvider.$$$reportNull$$$0(3);
        }
        if (extension == null) {
            HttpRequestActionsProvider.$$$reportNull$$$0(4);
        }
        HttpSingleRequestExecutionConfig config = new HttpSingleRequestExecutionConfig(request2);
        ArrayList<AnAction> actions2 = new ArrayList<AnAction>();
        if (addDefaultEnv && !envs2.isEmpty()) {
            actions2.add(new RunHttpRequestAction.RunRequestWithDefaultEnvAction(config, extension));
        }
        if (!envs2.isEmpty() && !actions2.isEmpty()) {
            actions2.add((AnAction)Separator.getInstance());
        }
        ArrayList<String> sortedEnvs = new ArrayList<String>(envs2);
        Collections.sort(sortedEnvs);
        for (String env : sortedEnvs) {
            actions2.add(new RunHttpRequestAction.RunRequestWithEnvAction(config, env, extension));
        }
        if (addWithoutEnv) {
            actions2.add(new RunHttpRequestAction.RunRequestWithoutEnvAction(config, extension));
        }
        ArrayList<AnAction> arrayList = actions2;
        if (arrayList == null) {
            HttpRequestActionsProvider.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @NotNull
    private static List<HttpRequestExecutorExtension> getDebugExtensions(@NotNull HttpRequest request2) {
        if (request2 == null) {
            HttpRequestActionsProvider.$$$reportNull$$$0(6);
        }
        List extensions = RequestExecutionSupport.All.forContext(new RequestContext(request2.getHttpMethod(), true, request2.getScheme())) != null ? ContainerUtil.map(HttpRequestDebuggerUtils.getAvailableDebuggerExtension(), extension -> HttpRequestExecutorExtensionFactory.getDebugExtension(extension)) : ContainerUtil.emptyList();
        List list2 = extensions;
        if (list2 == null) {
            HttpRequestActionsProvider.$$$reportNull$$$0(7);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strategy";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "request";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/run/HttpRequestActionsProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/run/HttpRequestActionsProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugExtensions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "wrapToActionOrGroup";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createActions";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDebugExtensions";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7 -> new IllegalStateException(string);
        };
    }

    static class ShowActionsWithSelectedEnvironmentStrategy
    implements HttpRequestActionsProviderStrategy {
        ShowActionsWithSelectedEnvironmentStrategy() {
        }

        @Override
        @NotNull
        public String getTooltip() {
            if (HttpRequestDebuggerUtils.isDebugEnabled()) {
                String string = RestClientBundle.message("rest.client.request.run.debug.request.tooltip", new Object[0]);
                if (string == null) {
                    ShowActionsWithSelectedEnvironmentStrategy.$$$reportNull$$$0(0);
                }
                return string;
            }
            String string = RestClientBundle.message("rest.client.request.run.request.tooltip", new Object[0]);
            if (string == null) {
                ShowActionsWithSelectedEnvironmentStrategy.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        @NotNull
        public List<AnAction> provideActions(@NotNull HttpRequest request2, @NotNull Collection<String> environments2) {
            if (request2 == null) {
                ShowActionsWithSelectedEnvironmentStrategy.$$$reportNull$$$0(2);
            }
            if (environments2 == null) {
                ShowActionsWithSelectedEnvironmentStrategy.$$$reportNull$$$0(3);
            }
            HttpSingleRequestExecutionConfig config = new HttpSingleRequestExecutionConfig(request2);
            ArrayList<AnAction> result2 = new ArrayList<AnAction>();
            Supplier<Collection> environmentsProvider = () -> HttpClientEnvironmentsProvider.INSTANCE.provideEnvironments(request2.getContainingFile()).asListOfNames();
            result2.add(new RunHttpRequestAction.RunRequestWithEnvForFileAction(request2.getProject(), config, HttpRequestExecutorExtensionFactory.getRunExtension(), new RunHttpRequestActionsGroup(HttpRequestExecutorExtensionFactory.getRunExtension(), () -> HttpRequestActionsProvider.createActions(request2, (Collection)environmentsProvider.get(), HttpRequestExecutorExtensionFactory.getRunExtension(), true, true))));
            if (HttpRequestDebuggerUtils.isDebugEnabled()) {
                for (HttpRequestExecutorExtension extension : HttpRequestActionsProvider.getDebugExtensions(request2)) {
                    result2.add(new RunHttpRequestAction.RunRequestWithEnvForFileAction(request2.getProject(), config, extension, new RunHttpRequestActionsGroup(extension, () -> HttpRequestActionsProvider.createActions(request2, (Collection)environmentsProvider.get(), HttpRequestExecutorExtensionFactory.getRunExtension(), true, true))));
                }
            }
            ArrayList<AnAction> arrayList = result2;
            if (arrayList == null) {
                ShowActionsWithSelectedEnvironmentStrategy.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 2, 3 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/httpClient/http/request/run/HttpRequestActionsProvider$ShowActionsWithSelectedEnvironmentStrategy";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environments";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTooltip";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/httpClient/http/request/run/HttpRequestActionsProvider$ShowActionsWithSelectedEnvironmentStrategy";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "provideActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "provideActions";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 2, 3 -> new IllegalArgumentException(string);
            };
        }
    }

    static final class ShowFlattenRunActionsStrategy
    implements HttpRequestActionsProviderStrategy {
        private final boolean myAddWithoutEnv;
        private final boolean myAddDefaultEnv;

        ShowFlattenRunActionsStrategy() {
            this(true, true);
        }

        private ShowFlattenRunActionsStrategy(boolean addWithoutEnv, boolean addDefaultEnv) {
            this.myAddWithoutEnv = addWithoutEnv;
            this.myAddDefaultEnv = addDefaultEnv;
        }

        @Override
        @NotNull
        public List<AnAction> provideActions(@NotNull HttpRequest request2, @NotNull Collection<String> environments2) {
            if (request2 == null) {
                ShowFlattenRunActionsStrategy.$$$reportNull$$$0(0);
            }
            if (environments2 == null) {
                ShowFlattenRunActionsStrategy.$$$reportNull$$$0(1);
            }
            List<AnAction> list2 = HttpRequestActionsProvider.createActions(request2, environments2, HttpRequestExecutorExtensionFactory.getRunExtension(), this.myAddWithoutEnv, this.myAddDefaultEnv);
            if (list2 == null) {
                ShowFlattenRunActionsStrategy.$$$reportNull$$$0(2);
            }
            return list2;
        }

        @Override
        @NotNull
        public String getTooltip() {
            String string = RestClientBundle.message("rest.client.request.run.request.tooltip", new Object[0]);
            if (string == null) {
                ShowFlattenRunActionsStrategy.$$$reportNull$$$0(3);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environments";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/httpClient/http/request/run/HttpRequestActionsProvider$ShowFlattenRunActionsStrategy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/httpClient/http/request/run/HttpRequestActionsProvider$ShowFlattenRunActionsStrategy";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "provideActions";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTooltip";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "provideActions";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    private static class ActionOrGroupHttpRequestActionsProviderStrategy
    implements HttpRequestActionsProviderStrategy {
        private final HttpRequestActionsProviderStrategy myStrategy;
        private final HttpRequestExecutorExtension myExtension;

        ActionOrGroupHttpRequestActionsProviderStrategy(@NotNull HttpRequestActionsProviderStrategy strategy, @NotNull HttpRequestExecutorExtension extension) {
            if (strategy == null) {
                ActionOrGroupHttpRequestActionsProviderStrategy.$$$reportNull$$$0(0);
            }
            if (extension == null) {
                ActionOrGroupHttpRequestActionsProviderStrategy.$$$reportNull$$$0(1);
            }
            this.myStrategy = strategy;
            this.myExtension = extension;
        }

        @Override
        @NotNull
        public String getTooltip() {
            String string = this.myStrategy.getTooltip();
            if (string == null) {
                ActionOrGroupHttpRequestActionsProviderStrategy.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Override
        @NotNull
        public List<AnAction> provideActions(@NotNull HttpRequest request2, @NotNull Collection<String> environments2) {
            List<AnAction> actions2;
            if (request2 == null) {
                ActionOrGroupHttpRequestActionsProviderStrategy.$$$reportNull$$$0(3);
            }
            if (environments2 == null) {
                ActionOrGroupHttpRequestActionsProviderStrategy.$$$reportNull$$$0(4);
            }
            if ((actions2 = this.myStrategy.provideActions(request2, environments2)).size() == 1) {
                List<AnAction> list2 = actions2;
                if (list2 == null) {
                    ActionOrGroupHttpRequestActionsProviderStrategy.$$$reportNull$$$0(5);
                }
                return list2;
            }
            List<AnAction> list3 = Collections.singletonList(new RunHttpRequestActionsGroup(this.myExtension, () -> actions2));
            if (list3 == null) {
                ActionOrGroupHttpRequestActionsProviderStrategy.$$$reportNull$$$0(6);
            }
            return list3;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "strategy";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/httpClient/http/request/run/HttpRequestActionsProvider$ActionOrGroupHttpRequestActionsProviderStrategy";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environments";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/httpClient/http/request/run/HttpRequestActionsProvider$ActionOrGroupHttpRequestActionsProviderStrategy";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTooltip";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "provideActions";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 5: 
                case 6: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "provideActions";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 5, 6 -> new IllegalStateException(string);
            };
        }
    }

    public static interface HttpRequestActionsProviderStrategy {
        @NotNull
        public String getTooltip();

        @NotNull
        public List<AnAction> provideActions(@NotNull HttpRequest var1, @NotNull Collection<String> var2);
    }

    private static final class RunHttpRequestActionsGroup
    extends AnAction {
        private final Supplier<List<AnAction>> myActions;

        private RunHttpRequestActionsGroup(@NotNull HttpRequestExecutorExtension extension, @NotNull Supplier<List<AnAction>> actions2) {
            if (extension == null) {
                RunHttpRequestActionsGroup.$$$reportNull$$$0(0);
            }
            if (actions2 == null) {
                RunHttpRequestActionsGroup.$$$reportNull$$$0(1);
            }
            this.myActions = actions2;
            Presentation presentation2 = this.getTemplatePresentation();
            presentation2.setText(RestClientBundle.messagePointer("rest.client.request.execute.with.text", extension.getActionName()));
            presentation2.setIcon(extension.getIcon());
        }

        public void actionPerformed(final @NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                RunHttpRequestActionsGroup.$$$reportNull$$$0(2);
            }
            if ((project = e.getProject()) == null) {
                return;
            }
            List<AnAction> allActions = this.myActions.get();
            ArrayList<PopupItem> actionNames = new ArrayList<PopupItem>();
            AnAction previousAction = null;
            String actionWithSeparatorAbove = null;
            for (AnAction action2 : allActions) {
                String text2;
                String string = text2 = action2 instanceof RunHttpRequestAction ? ((RunHttpRequestAction)action2).getPresentationText(project) : action2.getTemplateText();
                if (StringUtil.isNotEmpty((String)text2) && !(action2 instanceof Separator)) {
                    if (previousAction instanceof Separator) {
                        actionWithSeparatorAbove = text2;
                    }
                    actionNames.add(new PopupItem(text2, action2));
                }
                previousAction = action2;
            }
            String title = RestClientBundle.message("rest.client.request.execute.environment.popup.header", new Object[0]);
            final String finalActionWithSeparatorAbove = actionWithSeparatorAbove;
            BaseListPopupStep<PopupItem> popupStep = new BaseListPopupStep<PopupItem>(title, actionNames){

                @Nullable
                public ListSeparator getSeparatorAbove(PopupItem value2) {
                    if (finalActionWithSeparatorAbove != null && finalActionWithSeparatorAbove.equals(value2.myText)) {
                        return new ListSeparator();
                    }
                    return null;
                }

                @Nullable
                public PopupStep<?> onChosen(PopupItem selectedValue, boolean finalChoice) {
                    return this.doFinalStep(() -> selectedValue.myAction.actionPerformed(e));
                }
            };
            ListPopup popup2 = JBPopupFactory.getInstance().createListPopup((ListPopupStep)popupStep);
            InputEvent inputEvent = e.getInputEvent();
            if (inputEvent instanceof MouseEvent) {
                popup2.show(new RelativePoint((MouseEvent)inputEvent));
            } else {
                HttpClientPopups.showInBestPosition((JBPopup)popup2, project, e.getDataContext());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actions";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/httpClient/http/request/run/HttpRequestActionsProvider$RunHttpRequestActionsGroup";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }

        private static class PopupItem {
            final String myText;
            final AnAction myAction;

            private PopupItem(String text2, AnAction action2) {
                this.myText = text2;
                this.myAction = action2;
            }

            public String toString() {
                return this.myText;
            }
        }
    }

    static class ShowGroupedRunAndDebugActionsStrategy
    implements HttpRequestActionsProviderStrategy {
        ShowGroupedRunAndDebugActionsStrategy() {
        }

        @Override
        @NotNull
        public List<AnAction> provideActions(@NotNull HttpRequest request2, @NotNull Collection<String> environments2) {
            if (request2 == null) {
                ShowGroupedRunAndDebugActionsStrategy.$$$reportNull$$$0(0);
            }
            if (environments2 == null) {
                ShowGroupedRunAndDebugActionsStrategy.$$$reportNull$$$0(1);
            }
            HttpRequestExecutorExtension runExtension = HttpRequestExecutorExtensionFactory.getRunExtension();
            SmartList actions2 = new SmartList((Object)ShowGroupedRunAndDebugActionsStrategy.newDefaultRunAction(request2, environments2, runExtension));
            List<HttpRequestExecutorExtension> extensions = HttpRequestActionsProvider.getDebugExtensions(request2);
            extensions.forEach(arg_0 -> ShowGroupedRunAndDebugActionsStrategy.lambda$provideActions$0((List)actions2, request2, environments2, arg_0));
            if (!environments2.isEmpty()) {
                actions2.add(new RunHttpRequestActionsGroup(runExtension, () -> HttpRequestActionsProvider.createActions(request2, environments2, runExtension, true, true)));
                extensions.forEach(arg_0 -> ShowGroupedRunAndDebugActionsStrategy.lambda$provideActions$3((List)actions2, request2, environments2, arg_0));
            }
            SmartList smartList = actions2;
            if (smartList == null) {
                ShowGroupedRunAndDebugActionsStrategy.$$$reportNull$$$0(2);
            }
            return smartList;
        }

        @NotNull
        private static AnAction newDefaultRunAction(@NotNull HttpRequest request2, @NotNull Collection<String> environments2, @Nullable HttpRequestExecutorExtension extension) {
            String envName;
            if (request2 == null) {
                ShowGroupedRunAndDebugActionsStrategy.$$$reportNull$$$0(3);
            }
            if (environments2 == null) {
                ShowGroupedRunAndDebugActionsStrategy.$$$reportNull$$$0(4);
            }
            if (StringUtil.isEmpty((String)(envName = HttpRequestEnvironment.getDefaultEnvName(request2.getProject()))) || environments2.isEmpty()) {
                return new RunHttpRequestAction.RunRequestWithoutEnvAction(new HttpSingleRequestExecutionConfig(request2), extension);
            }
            return new RunHttpRequestAction.RunRequestWithDefaultEnvAction(new HttpSingleRequestExecutionConfig(request2), extension);
        }

        @Override
        @NotNull
        public String getTooltip() {
            String string = RestClientBundle.message("rest.client.request.run.debug.request.tooltip", new Object[0]);
            if (string == null) {
                ShowGroupedRunAndDebugActionsStrategy.$$$reportNull$$$0(5);
            }
            return string;
        }

        private static /* synthetic */ void lambda$provideActions$3(List actions2, HttpRequest request2, Collection environments2, HttpRequestExecutorExtension extension) {
            actions2.add(new RunHttpRequestActionsGroup(extension, () -> HttpRequestActionsProvider.createActions(request2, environments2, extension, true, true)));
        }

        private static /* synthetic */ void lambda$provideActions$0(List actions2, HttpRequest request2, Collection environments2, HttpRequestExecutorExtension extension) {
            actions2.add(ShowGroupedRunAndDebugActionsStrategy.newDefaultRunAction(request2, environments2, extension));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "request";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "environments";
                    break;
                }
                case 2: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/httpClient/http/request/run/HttpRequestActionsProvider$ShowGroupedRunAndDebugActionsStrategy";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/httpClient/http/request/run/HttpRequestActionsProvider$ShowGroupedRunAndDebugActionsStrategy";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "provideActions";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTooltip";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "provideActions";
                    break;
                }
                case 2: 
                case 5: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "newDefaultRunAction";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 5 -> new IllegalStateException(string);
            };
        }
    }
}

