/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.run;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.util.logging.Logger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u001a\u0010\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\n\u001a\u0006\u0010\f\u001a\u00020\r\u001a\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\n\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"logger", "Ljava/util/logging/Logger;", "kotlin.jvm.PlatformType", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "asJson", "Lcom/fasterxml/jackson/databind/JsonNode;", "obj", "", "compileJsonPathSafely", "", "path", "newObjNode", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "readTreeSafe", "value", "intellij.httpClient.executor"})
public final class HttpClientJsonVariablesHelperKt {
    private static final Logger logger = Logger.getLogger("HttpClientJsonVariablesHelper.kt");
    @NotNull
    private static final ObjectMapper objectMapper = new ObjectMapper();

    @NotNull
    public static final ObjectNode newObjNode() {
        ObjectNode objectNode = objectMapper.createObjectNode();
        Intrinsics.checkNotNullExpressionValue((Object)objectNode, (String)"createObjectNode(...)");
        return objectNode;
    }

    @Nullable
    public static final String compileJsonPathSafely(@NotNull String path2) {
        String string;
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        try {
            string = JsonPath.compile(path2, new Predicate[0]).getPath();
        }
        catch (Exception e) {
            logger.fine("Failed to compile jsonPath: " + path2);
            return null;
        }
        return string;
    }

    @Nullable
    public static final JsonNode readTreeSafe(@Nullable String value2) {
        JsonNode jsonNode;
        if (value2 == null) {
            return null;
        }
        try {
            jsonNode = new ObjectMapper().readTree(value2);
        }
        catch (Exception e) {
            logger.fine("Could not parse variable: " + e.getMessage());
            jsonNode = null;
        }
        return jsonNode;
    }

    @Nullable
    public static final JsonNode asJson(@Nullable Object obj) {
        JsonNode jsonNode;
        try {
            jsonNode = (JsonNode)objectMapper.convertValue(obj, JsonNode.class);
        }
        catch (Exception e) {
            jsonNode = null;
        }
        return jsonNode;
    }
}

