/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.psi.references;

import com.intellij.httpClient.http.request.HttpRequestVariableSubstitutor;
import com.intellij.httpClient.http.request.psi.HttpQuery;
import com.intellij.httpClient.http.request.psi.HttpRequest;
import com.intellij.httpClient.http.request.psi.HttpRequestTarget;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.paths.WebReference;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.FakePsiElement;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HttpRequestWebReference
extends WebReference {
    public HttpRequestWebReference(@NotNull PsiElement element, @Nullable String host) {
        if (element == null) {
            HttpRequestWebReference.$$$reportNull$$$0(0);
        }
        super(element, host);
    }

    public PsiElement resolve() {
        PsiElement parent = this.getElement().getParent();
        if (parent instanceof HttpRequest) {
            PsiFile contextFile = parent.getContainingFile();
            HttpRequestVariableSubstitutor substitutor2 = HttpRequestVariableSubstitutor.getDefault(parent.getProject(), contextFile);
            String url = ((HttpRequest)parent).getHttpUrl(substitutor2);
            if (StringUtil.isNotEmpty((String)url)) {
                HttpRequestTarget target = ((HttpRequest)parent).getRequestTarget();
                return new HttpRequestFakePsiElement(url + (target != null ? HttpRequestWebReference.getQueryString(target.getQuery(), substitutor2) : ""));
            }
        }
        return null;
    }

    protected TextRange calculateDefaultRangeInElement() {
        return new TextRange(0, this.getElement().getTextLength());
    }

    @NotNull
    public static String getQueryString(@Nullable HttpQuery query, @NotNull HttpRequestVariableSubstitutor substitutor2) {
        List<Object> parameters;
        if (substitutor2 == null) {
            HttpRequestWebReference.$$$reportNull$$$0(1);
        }
        List<Object> list2 = parameters = query != null ? query.getQueryParameterList() : Collections.emptyList();
        if (parameters.isEmpty()) {
            return "";
        }
        String string = "?" + StringUtil.join(parameters, parameter -> {
            String key2 = parameter.getKey(substitutor2);
            String value2 = parameter.getValue(substitutor2);
            return StringUtil.notNullize((String)key2) + "=" + StringUtil.notNullize((String)value2);
        }, (String)"&");
        if (string == null) {
            HttpRequestWebReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "substitutor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/httpClient/http/request/psi/references/HttpRequestWebReference";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/httpClient/http/request/psi/references/HttpRequestWebReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getQueryString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getQueryString";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public class HttpRequestFakePsiElement
    extends FakePsiElement {
        private final String myFullUrl;

        public HttpRequestFakePsiElement(String fullUrl) {
            this.myFullUrl = fullUrl;
        }

        public PsiElement getParent() {
            return HttpRequestWebReference.this.myElement;
        }

        public void navigate(boolean requestFocus) {
            BrowserUtil.browse((String)this.myFullUrl);
        }

        public String getPresentableText() {
            return this.myFullUrl;
        }

        public String getName() {
            return this.myFullUrl;
        }

        public TextRange getTextRange() {
            TextRange rangeInElement = HttpRequestWebReference.this.getRangeInElement();
            TextRange elementRange = HttpRequestWebReference.this.myElement.getTextRange();
            return elementRange != null ? rangeInElement.shiftRight(elementRange.getStartOffset()) : rangeInElement;
        }
    }
}

