/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.httpClient.http.request.completion.HttpRequestBodyAutoPopupHandlerKt;
import com.intellij.httpClient.http.request.psi.HttpMessageBody;
import com.intellij.json.psi.JsonFile;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0013"}, d2={"Lcom/intellij/httpClient/http/request/completion/HttpRequestBodyAutoPopupHandler;", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate;", "()V", "checkAutoPopup", "Lcom/intellij/codeInsight/editorActions/TypedHandlerDelegate$Result;", "charTyped", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "file", "Lcom/intellij/psi/PsiFile;", "isAfterPropertyOrInTheBeginningOfBody", "", "isCharOrQuoteTyped", "isHttpRequestBody", "showCompletionPopup", "", "intellij.restClient"})
public final class HttpRequestBodyAutoPopupHandler
extends TypedHandlerDelegate {
    @NotNull
    public TypedHandlerDelegate.Result checkAutoPopup(char charTyped, @NotNull Project project, @NotNull Editor editor2, @NotNull PsiFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (this.isHttpRequestBody(file, project) && this.isCharOrQuoteTyped(charTyped) && this.isAfterPropertyOrInTheBeginningOfBody(editor2)) {
            this.showCompletionPopup(editor2, project);
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    private final boolean isHttpRequestBody(PsiFile file, Project project) {
        return file instanceof JsonFile && Intrinsics.areEqual((Object)FileUtilRt.getExtension((String)((JsonFile)file).getName()), (Object)"http") && InjectedLanguageManager.getInstance((Project)project).getInjectionHost((PsiElement)file) instanceof HttpMessageBody;
    }

    private final boolean isCharOrQuoteTyped(char charTyped) {
        return HttpRequestBodyAutoPopupHandlerKt.access$getLetterOrQuoteCharacterPattern$p().matches((CharSequence)String.valueOf(charTyped));
    }

    private final boolean isAfterPropertyOrInTheBeginningOfBody(Editor editor2) {
        int offset = Math.max(editor2.getCaretModel().getOffset() - 1, 0);
        HighlighterIterator highlighterIterator = editor2.getHighlighter().createIterator(offset);
        Intrinsics.checkNotNullExpressionValue((Object)highlighterIterator, (String)"createIterator(...)");
        HighlighterIterator iterator = highlighterIterator;
        iterator.retreat();
        return HttpRequestBodyAutoPopupHandlerKt.access$getExpectedTokensToShowCompletionPopupAfter$p().contains(iterator.getTokenType());
    }

    private final void showCompletionPopup(Editor editor2, Project project) {
        AutoPopupController.getInstance((Project)project).autoPopupMemberLookup(editor2, null);
    }
}

