/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.httpClient.http.request.codeInsight;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.httpClient.execution.RestClientBundle;
import com.intellij.httpClient.http.request.HttpRequestPsiFile;
import com.intellij.httpClient.http.request.codeInsight.AddAuthToEnvironmentFix;
import com.intellij.httpClient.http.request.codeInsight.SelectEnvironment;
import com.intellij.httpClient.http.request.dynamicVariables.AuthDynamicVariables;
import com.intellij.httpClient.http.request.dynamicVariables.HttpClientDynamicVariableValue;
import com.intellij.httpClient.http.request.environment.HttpClientSelectedEnvironments;
import com.intellij.httpClient.http.request.environment.HttpRequestEnvironment;
import com.intellij.httpClient.http.request.environment.auth.HttpAuthAwareEnvironment;
import com.intellij.httpClient.http.request.psi.HttpDynamicVariable;
import com.intellij.httpClient.http.request.psi.HttpDynamicVariableArg;
import com.intellij.httpClient.http.request.psi.HttpVisitor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/httpClient/http/request/codeInsight/HttpClientUnresolvedAuthIdInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "intellij.restClient"})
public final class HttpClientUnresolvedAuthIdInspection
extends LocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!(holder.getFile() instanceof HttpRequestPsiFile)) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            Intrinsics.checkNotNullExpressionValue((Object)psiElementVisitor, (String)"EMPTY_VISITOR");
            return psiElementVisitor;
        }
        return new HttpVisitor(holder){
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.$holder = $holder;
            }

            public void visitDynamicVariable(@NotNull HttpDynamicVariable o) {
                Intrinsics.checkNotNullParameter((Object)o, (String)"o");
                if (!AuthDynamicVariables.isAuthVariable(o.getName())) {
                    return;
                }
                Object object = o.getDynamicVariableExpr();
                if (object == null || (object = object.getDynamicVariableArgs()) == null || (object = object.getDynamicVariableArgList()) == null || (object = (HttpDynamicVariableArg)CollectionsKt.singleOrNull((List)object)) == null) {
                    return;
                }
                Object idElement = object;
                HttpClientDynamicVariableValue.ParameterValue id = idElement.getValue();
                if (!(id instanceof HttpClientDynamicVariableValue.ParameterValue.Str)) {
                    return;
                }
                HttpRequestEnvironment env = HttpRequestEnvironment.getDefault(this.$holder.getProject(), o.getContainingFile());
                if (env == null) {
                    return;
                }
                Project project = this.$holder.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                HttpClientSelectedEnvironments httpClientSelectedEnvironments = HttpClientSelectedEnvironments.Companion.getInstance(project);
                VirtualFile virtualFile = this.$holder.getFile().getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                String envName = httpClientSelectedEnvironments.get(virtualFile);
                if (env instanceof HttpAuthAwareEnvironment) {
                    PsiElement configDeclaration = ((HttpAuthAwareEnvironment)((Object)env)).getConfigDeclaration(((HttpClientDynamicVariableValue.ParameterValue.Str)id).getValue());
                    if (configDeclaration == null) {
                        PsiElement psiElement = (PsiElement)idElement;
                        String string = RestClientBundle.message("http.client.auth.inspection.message", new Object[0]);
                        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[1];
                        String string2 = envName;
                        Intrinsics.checkNotNull((Object)string2);
                        localQuickFixArray[0] = new AddAuthToEnvironmentFix(string2, (PsiElement)idElement);
                        this.$holder.registerProblem(psiElement, string, localQuickFixArray);
                    }
                } else if (envName == null) {
                    LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{new SelectEnvironment((PsiElement)idElement)};
                    this.$holder.registerProblem((PsiElement)idElement, RestClientBundle.message("http.client.auth.no.environment.inspection.message", new Object[0]), localQuickFixArray);
                }
            }
        };
    }
}

